/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.nio.ByteBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"m\u0004)1bj\u0014(`\u000bbK5\u000bV#O)~3\u0015\nT#`\t\u0006#\u0016I\u0003\u0003QC&\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\tU$\u0018\u000e\u001c\u0006\n\u0005f$X-\u0011:sCfTaa[8uY&t'bF6pi2LgN\f6w[:\u0002F.\u0019;g_JlG+\u001f9f\u0015\u0019\u0019FO]5oO*9aj\u001c;Ok2d'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\fC:tw\u000e^1uS>t7OC\rhKRtuJT0F1&\u001bF+\u0012(U?\u001aKE*R0E\u0003R\u000b%b\u0006#je\u0016\u001cGo\u001c:z\u0005\u0006\u001cX\rZ*u_J\fw-Z&u\u0015!aw.\u00193GS2,'\u0002\u00024jY\u0016T1BV5siV\fGNR5mK*\u0019aOZ:e\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)1\u0001b\u0001\t\u00021\u0001Q!\u0001E\u0004\u000b\r!)\u0001C\u0002\r\u0001\u0015\u0019AQ\u0001E\u0005\u0019\u0001)\u0011\u0001c\u0003\u0006\u0005\u0011!\u0001BB\u0003\u0003\t\u0013Ai!B\u0002\u0005\u000b!)A\u0002A\u0003\u0003\t\u0007A\t!\u0002\u0002\u0005\u0003!MQa\u0001C\u0007\u0011%a\u0001!\u0002\u0002\u0005\u000e!IQA\u000b\u0003b\ta\u0001\u0011uG\u0003\u0002\u0011\tI!\"C\u0005\u0006\u0003!\u0019\u0001\u0003B\u000b\u0005\u000b\u0005A1\u0001$\u0001\u0019\u0007a\u0019\u0011BC\u0005\n\u000b\u0005A9\u0001\u0005\u0003\u0016\t\u0015\t\u0001r\u0001G\u00011\u000fA:\u0001\u0007\u0002R\u0007\u0005!Y!V\u0002\t\u000b\r!\u0001!C\u0001\t\r5\u0019AaB\u0005\u0002\u0011\u0019A6qBC\"\t\u0005A\u0002\"(\u0005\u0005\u0001!EQ\u0002B\u0003\u0002\u0011\u001da\t\u0001G\u0004Q\u0007\u0001\tS\"B\u0001\t\u0005%!\u0011bA\u0003\u0002\u0011\rA2!\u0003\u0003\n\u0007\u0015\t\u0001r\u0001M\u00041\t\t6!\u0002\u0003\t\u0013\u0005Aa!D\u0001\t\u0010a\u001by\u0001"})
public final class DirectoryBasedStorageKt {
    @NotNull
    static final Pair<byte[], String> NON_EXISTENT_FILE_DATA = Pair.create(null, (Object)SystemProperties.getLineSeparator());

    @NotNull
    public static final Pair<byte[], String> getNON_EXISTENT_FILE_DATA() {
        return NON_EXISTENT_FILE_DATA;
    }

    @NotNull
    public static final Pair<byte[], String> loadFile(@Nullable VirtualFile file) {
        if (file == null || !file.exists()) {
            Pair<byte[], String> pair = NON_EXISTENT_FILE_DATA;
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"NON_EXISTENT_FILE_DATA");
            return pair;
        }
        byte[] bytes = file.contentsToByteArray();
        String lineSeparator = file.getDetectedLineSeparator();
        if (lineSeparator == null) {
            CharSequence charSequence = CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(bytes));
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"CharsetToolkit.UTF8_CHAR\u2026e(ByteBuffer.wrap(bytes))");
            lineSeparator = FileBasedStorageKt.detectLineSeparators(charSequence, null).getSeparatorString();
        }
        Pair pair = Pair.create((Object)bytes, (Object)lineSeparator);
        Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create<ByteArray, S\u2026ng>(bytes, lineSeparator)");
        return pair;
    }
}

