/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StoragePathMacros;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import kotlin.CharIterator;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u007f\b)Q\u0001,\u0014'`!J{EjT$\u000b\u0013\tKH/Z!se\u0006L(BB6pi2LgNC\u0007hKRDV\nT0Q%>cuj\u0012\u0006\u0013\r&dWMQ1tK\u0012\u001cFo\u001c:bO\u0016\\EO\u0003\u0006eK2,G/\u001a$jY\u0016TAAZ5mK*!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'\"\u0003:fcV,7\u000f^8s\u0015\r\te.\u001f\u0006\fm&\u0014H/^1m\r&dWMC\u0006WSJ$X/\u00197GS2,'bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u0007Y47O\u0003\u0003V]&$(\u0002\u00027b]\u001eTaa\u00142kK\u000e$(\u0002\u00063fi\u0016\u001cG\u000fT5oKN+\u0007/\u0019:bi>\u00148OC\u0003dQ\u0006\u00148O\u0003\u0007DQ\u0006\u00148+Z9vK:\u001cWM\u0003\teK\u001a\fW\u000f\u001c;TKB\f'/\u0019;pe*iA*\u001b8f'\u0016\u0004\u0018M]1u_JTA!\u001e;jY*9Am\\,sSR,'bB2p]R,g\u000e\u001e\u0006\u000eY&tWmU3qCJ\fGo\u001c:\u000b!A\u0014X\r]3oIbkG\u000e\u0015:pY><'b\u0002\"p_2,\u0017M\u001c\u0006\u000fSN,\u0015/^1m\u0007>tG/\u001a8u\u0015\u0019\u0011Xm];mi*\u0019#)\u001e4gKJ,\u0005\u0010]8tS:<')\u001f;f\u0003J\u0014\u0018-_(viB,Ho\u0015;sK\u0006l'\"F5t!J|'.Z2u\u001fJlu\u000eZ;mK\u001aKG.\u001a\u0006\tM&dWm\u00159fG*11\u000b\u001e:j]\u001eT\u0011b\u001e:ji\u00164\u0015\u000e\\3\u000b\u000f\u0015dW-\\3oi*9Q\t\\3nK:$(bA8sO*!!\u000eZ8n\u0015\u0019\u0001\u0016M]3oi*IBo\u001c\"vM\u001a,'/\u0012=q_NLgn\u001a\"zi\u0016\f%O]1z9\bQ!\u0001\u0005\u0002\u000b\r!\u0001\u0001#\u0001\r\u0001\u0015\t\u0001\u0002B\u0003\u0003\t\u0005AI!B\u0002\u0005\u0004!\u001dA\u0002A\u0003\u0004\t\u0001AY\u0001\u0004\u0001\u0006\u0003!9QA\u0001\u0003\u0004\u0011\u001f)!\u0001b\u0002\t\u0011\u0015\u0011A\u0001\u0002E\t\u000b\r!I\u0001#\u0004\r\u0001\u0015\u0019A\u0001\u0001\u0005\n\u0019\u0001)!\u0001b\u0001\t\b\u0015\u0011A!\u0001E\n\u000b\t!i\u0001\u0003\u0006\u0006\u0005\u0011%\u0001RB\u0003\u0004\t\u0001A9\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001\"D\u0003\u0004\t#AI\u0002\u0004\u0001\u0006\u0005\u0011E\u0001\u0012D\u0003\u0003\t\u001bA9\"B\u0002\u0005\u0001!}A\u0002A\u0003\u0003\t\u0011AQ\"\u0002\u0002\u0005\u0017!%Qa\u0001C\f\u0011Ea\u0001!\u0002\u0002\u0005\u0018!\tRa\u0001\u0003\u0001\u0011Ka\u0001!\u0002\u0002\u0005\u000e!\u0015R!\u0001E\u0015\u000b\t!a\u0002C\u000b\u0006\u0007\u0011u\u0001\u0002\u0006\u0007\u0001\u000b\t!i\u0002\u0003\u000b\u0006\u0007\u0011u\u00012\u0006\u0007\u0001\u000b\t!i\u0002c\u000b\u0006(\u0011\tG\u0001\u0007\u0001\"\u0007\u0015\t\u0001\u0012\u0001M\u0001+\u000eQQ\u0001\u0002\u0003\u0001\u0013\t!\u0019\u0001$\u0001\u000e\t\u0011\r\u0011B\u0001C\u0002\u0019\u0003A6AAC-\t\u0005A*!h\u0004\u0005\u0001!\u0019QbA\u0003\u0002\u0011\tA\"\u0001U\u0002\u0001;\u001f!\u0001\u0001C\u0003\u000e\u0007\u0015\t\u0001R\u0001M\u0003!\u000e\u0005Q\u0014\u0003\u0003\u0001\u0011\u0019iA!B\u0001\t\u000b1\u0005\u0001$\u0002)\u0004\u0003\u0005\u001aQ!\u0001E\u00061\u0017\t6!\u0003C\u0003\u0013\u0005!\u0001!D\u0001\t\r5\t\u0001bB\u0007\u0002\u0011\u001fA6AA\u0003\"\t\rA*!h\u0004\u0005\u0001!)QbA\u0003\u0002\u0011\u000bA*\u0001U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0004\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0005\u0011eA\u0003\u0002\u0011\u0017AZ!U\u0002\b\t\u000bI\u0011\u0001\u0002\u0001\u000e\u0003!9Q\"\u0001E\b1\u000e\u0011QA\t\u0003\u00041+iz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001\u0005\t1!\u00016\u0001AO\t\t\u0001AA\"\u0004\u0003\u0006\u0003!IA\u0012\u0001\r\n!\u000e\u0005\u0011eA\u0003\u0002\u0011%A\u0012\"U\u0002\b\t+I\u0011\u0001c\u0005\u000e\u0003!QQ\"\u0001E\n1\u000e\u0011Q\u00111\u0001\u0005\u0003amQt\u0002\u0003\u0001\u0011\u0015i1!B\u0001\t\u0006a\u0015\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001bA\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u001d5\u0019Q!\u0001E\u00031\u000b\u00016!AO\b\t\u0001Ai\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0004u=A\u0001\u0001\u0005\u0010\u001b\r)\u0011\u0001#\u0006\u0019\u0016A\u001b!!I\u0002\u0006\u0003!-\u00014B)\u0004\u001b\u0011m\u0011\"\u0001\u0003\u0001\u001b\u0005Aq!D\u0001\t\u00105\t\u0001bB\u0007\u0002\u0011'i\u0011\u0001\"\u0001Y\u0007\t)a\u0007B\u0001\u0019!u=A\u0001\u0001E\u0011\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\u0001!h\u0004\u0005\u0001!uQbA\u0003\u0002\u0011%A\u0012\u0002UB\u0001;\u001f!\u0001\u0001\u0003\b\u000e\u0007\u0015\t\u0001\u0002\u0004\r\r!\u000e\tQt\u0002\u0003\u0001\u0011=i1!B\u0001\t\u0016aU\u0001ka\u0001\"\u0007\u0015\t\u0001R\u0003M\u000b#\u000eYA\u0001E\u0005\u0002\t\u0003i\u0011\u0001c\u0004\u000e\u0003!MQ\"\u0001E\r\u001b\u0005!\t\u0001W\u0002\u0003\u000b[!1\u0001g\t\u001e\u0010\u0011\u0001\u0001BE\u0007\u0004\u000b\u0005AQ\u0002G\u0007Q\u0007\u0001\t3!B\u0001\t\u0016aU\u0011kA\u0003\u0005$%\tA\u0011A\u0007\u0002\u00117A6AA\u0003N\u0002\u0011\u0019\u0001dEO\t\t\u0001A1!\u0004\u0003\u0006\u0003!\u0011A\u0012\u0001\r\u0003!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0015i1!B\u0001\t\u0006a\u0015\u0001k!\u0001\u001e\u0012\u0011\u0001\u0001BB\u0007\u0005\u000b\u0005AQ\u0001$\u0001\u0019\u000bA\u001b\u0011!h\u0004\u0005\u0001!\u001dRbA\u0003\u0002\u0011=Ar\u0002UB\u0002;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u0001\"\u0003\r\n!\u000e\u0011Qt\u0002\u0003\u0001\u0011=i1!B\u0001\t\u0016aU\u0001k!\u0002\"\u0007\u0015\t\u0001\"\u0002\r\u0006#\u000eyAaE\u0005\u0002\u0011\u001fi\u0011\u0001\u0003\u0004\u000e\u0003!9Q\"\u0001E\b\u001b\u0005Ay\"D\u0001\t\u00145\tA\u0011\u0001-\u0004\u0005\u0015eBaA\u000b\u0004\u000b\u0005A\u0001\u0003\u0007\t\u0019-u=A!\u0001E\u000f\u001b\r)\u0011\u0001C\u0007\u0019\u001bA\u001b\t!I\u0002\u0006\u0003!a\u0001\u0004D)\u0004\u000f\u00111\u0012\"\u0001E\r\u001b\u0005A\t#D\u0001\t\u001ca\u001b!\u0001"})
public final class FileBasedStorageKt {
    @NotNull
    static final byte[] XML_PROLOG = KotlinPackage.toByteArray$default((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", null, (int)1);

    @NotNull
    public static final VirtualFile writeFile(@Nullable File file, @NotNull Object requestor, @Nullable VirtualFile virtualFile, @NotNull Element element, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        if (!(file == null || virtualFile != null && virtualFile.isValid())) {
            virtualFile2 = StorageUtil.getOrCreateVirtualFile(requestor, file);
        } else {
            virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
        }
        VirtualFile result = virtualFile2;
        if (ComponentStoreImplKt.LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
            Parent parent = (Parent)element;
            String string = lineSeparator.getSeparatorString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.getSeparatorString()");
            BufferExposingByteArrayOutputStream content = FileBasedStorageKt.toBufferExposingByteArray(parent, string);
            VirtualFile virtualFile3 = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"result");
            if (FileBasedStorageKt.isEqualContent(virtualFile3, lineSeparator, content, prependXmlProlog)) {
                throw (Throwable)new IllegalStateException("Content equals, but it must be handled not on this level: " + result.getName());
            }
            if (StorageUtil.DEBUG_LOG != null && ApplicationManager.getApplication().isUnitTestMode()) {
                StorageUtil.DEBUG_LOG = result.getPath() + ":" + "\n" + content + "\n" + "Old Content:" + "\n" + LoadTextUtil.loadText(result) + "\n" + "---------";
            }
        }
        VirtualFile virtualFile4 = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"result");
        FileBasedStorageKt.doWrite(requestor, virtualFile4, element, lineSeparator, prependXmlProlog);
        VirtualFile virtualFile5 = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"result");
        return virtualFile5;
    }

    @NotNull
    public static final byte[] getXML_PROLOG() {
        return XML_PROLOG;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isEqualContent(@NotNull VirtualFile result, @NotNull LineSeparator lineSeparator, @NotNull BufferExposingByteArrayOutputStream content, boolean prependXmlProlog) {
        int headerLength;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        int n = headerLength = !prependXmlProlog ? 0 : XML_PROLOG.length + lineSeparator.getSeparatorBytes().length;
        if ((int)result.getLength() != headerLength + content.size()) {
            return false;
        }
        byte[] oldContent = result.contentsToByteArray();
        if (!(!prependXmlProlog || ArrayUtil.startsWith((byte[])oldContent, (byte[])XML_PROLOG) && ArrayUtil.startsWith((byte[])oldContent, (int)XML_PROLOG.length, (byte[])lineSeparator.getSeparatorBytes()))) {
            return false;
        }
        int n2 = headerLength;
        int n3 = oldContent.length - 1;
        if (n2 <= n3) {
            while (true) {
                void i;
                if (oldContent[i] != content.getInternalBuffer()[i - headerLength]) {
                    return false;
                }
                if (i == n3) break;
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void doWrite(@NotNull Object requestor, @NotNull VirtualFile file, @NotNull Object content, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        if (ComponentStoreImplKt.LOG.isDebugEnabled()) {
            ComponentStoreImplKt.LOG.debug("Save " + file.getPresentableUrl());
        }
        AccessToken token = WriteAction.start();
        try {
            OutputStream out = file.getOutputStream(requestor);
            try {
                if (prependXmlProlog) {
                    out.write(XML_PROLOG);
                    out.write(lineSeparator.getSeparatorBytes());
                }
                if (content instanceof Element) {
                    JDOMUtil.writeParent((Parent)((Parent)content), (OutputStream)out, (String)lineSeparator.getSeparatorString());
                } else {
                    Object object = content;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                    }
                    ((BufferExposingByteArrayOutputStream)object).writeTo(out);
                }
            }
            finally {
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream;
            if (content instanceof Element) {
                Parent parent = (Parent)content;
                String string = lineSeparator.getSeparatorString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.getSeparatorString()");
                bufferExposingByteArrayOutputStream = FileBasedStorageKt.toBufferExposingByteArray(parent, string);
            } else {
                Object object = content;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                }
                bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)object;
            }
            BufferExposingByteArrayOutputStream byteArray = bufferExposingByteArrayOutputStream;
            throw (Throwable)new ReadOnlyModificationException(file, e, new StateStorage.SaveSession(requestor, file, byteArray, lineSeparator, prependXmlProlog){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ Object $requestor;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ BufferExposingByteArrayOutputStream $byteArray;
                final /* synthetic */ LineSeparator $lineSeparator;
                final /* synthetic */ boolean $prependXmlProlog;

                static {
                    $kotlinClass = Reflection.createKotlinClass(doWrite.1.class);
                }

                public void save() {
                    FileBasedStorageKt.doWrite(this.$requestor, this.$file, this.$byteArray, this.$lineSeparator, this.$prependXmlProlog);
                }
                {
                    this.$requestor = $captured_local_variable$0;
                    this.$file = $captured_local_variable$1;
                    this.$byteArray = $captured_local_variable$2;
                    this.$lineSeparator = $captured_local_variable$3;
                    this.$prependXmlProlog = $captured_local_variable$4;
                }
            });
        }
        finally {
            token.finish();
        }
    }

    @NotNull
    public static final BufferExposingByteArrayOutputStream toBufferExposingByteArray(Parent $receiver, @NotNull String lineSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        JDOMUtil.writeParent((Parent)$receiver, (OutputStream)((OutputStream)out), (String)lineSeparator);
        return out;
    }

    @NotNull
    public static /* synthetic */ BufferExposingByteArrayOutputStream toBufferExposingByteArray$default(Parent parent, String string, int n) {
        if ((n & 1) != 0) {
            string = "\n";
        }
        return FileBasedStorageKt.toBufferExposingByteArray(parent, string);
    }

    public static final boolean isProjectOrModuleFile(@NotNull String fileSpec) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        return Intrinsics.areEqual((Object)StoragePathMacros.PROJECT_FILE, (Object)fileSpec) || KotlinPackage.startsWith$default((String)fileSpec, (String)StoragePathMacros.PROJECT_CONFIG_DIR, (boolean)false, (int)2) || Intrinsics.areEqual((Object)fileSpec, (Object)StoragePathMacros.MODULE_FILE);
    }

    @NotNull
    public static final LineSeparator detectLineSeparators(@NotNull CharSequence chars, @Nullable LineSeparator defaultSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        CharIterator charIterator = KotlinPackage.iterator((CharSequence)chars);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            if (c == '\r') {
                return LineSeparator.CRLF;
            }
            if (c != '\n') continue;
            return LineSeparator.LF;
        }
        LineSeparator lineSeparator = defaultSeparator;
        if (lineSeparator == null) {
            LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
            lineSeparator = lineSeparator2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
        }
        return lineSeparator;
    }

    public static final void deleteFile(@NotNull File file, @NotNull Object requestor, @Nullable VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        if (virtualFile == null) {
            ComponentStoreImplKt.LOG.warn("Cannot find virtual file " + file.getAbsolutePath());
        }
        if (virtualFile == null) {
            if (file.exists()) {
                FileUtil.delete((File)file);
            }
        } else if (virtualFile.exists()) {
            try {
                FileBasedStorageKt.deleteFile(requestor, virtualFile);
            }
            catch (FileNotFoundException e) {
                throw (Throwable)new ReadOnlyModificationException(virtualFile, e, new StateStorage.SaveSession(requestor, virtualFile){
                    public static final /* synthetic */ KClass $kotlinClass;
                    final /* synthetic */ Object $requestor;
                    final /* synthetic */ VirtualFile $virtualFile;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(deleteFile.1.class);
                    }

                    public void save() {
                        FileBasedStorageKt.deleteFile(this.$requestor, this.$virtualFile);
                    }
                    {
                        this.$requestor = $captured_local_variable$0;
                        this.$virtualFile = $captured_local_variable$1;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteFile(@NotNull Object requestor, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        AccessToken token = WriteAction.start();
        try {
            virtualFile.delete(requestor);
            Unit unit = Unit.INSTANCE$;
        }
        finally {
            token.finish();
        }
    }
}

