/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StoreAwareProjectManagerKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"_\f)A2\u000b^8sK\u0006;\u0018M]3Qe>TWm\u0019;NC:\fw-\u001a:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015I\u0019wN\u001c4jOV\u0014\u0018\r^5p]N#xN]3\u000b%A\u0013xN[3di6\u000bg.Y4fe&k\u0007\u000f\u001c\u0006\b_B,g.\u00199j\u0015\u001d\u0001(o\u001c6fGRTA![7qY*1A(\u001b8jizR!C^5siV\fGNR5mK6\u000bg.Y4fe*\u0011b+\u001b:uk\u0006dg)\u001b7f\u001b\u0006t\u0017mZ3s\u0015\r1hm\u001d\u0006\u0010aJ|wM]3tg6\u000bg.Y4fe*y\u0001K]8he\u0016\u001c8/T1oC\u001e,'O\u0003\u0005qe><'/Z:t\u0015]\u0019\u0007.\u00198hK\u0012\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8GS2,7OC\u0007MS:\\W\r\u001a%bg\"\u001cV\r\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'\u0002D*uCR,7\u000b^8sC\u001e,'BC2p[B|g.\u001a8ug*\t2\r[1oO\u0016$g)\u001b7fg\u0006c\u0017M]7\u000b\u0017MKgn\u001a7f\u00032\f'/\u001c\u0006\u0011e\u0016dw.\u00193CY>\u001c7nQ8v]RTQ\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014(BC2p]\u000e,(O]3oi*1\u0011\r^8nS\u000eTQE]3ti\u0006\u0014H/\u00119qY&\u001c\u0017\r^5p]>\u0013(+\u001a7pC\u0012\u0004&o\u001c6fGR$\u0016m]6\u000b\u0011I+hN\\1cY\u0016TA\u0001\\1oO*1#\r\\8dWJ+Gn\\1eS:<\u0007K]8kK\u000e$xJ\\#yi\u0016\u0014h.\u00197DQ\u0006tw-Z:\u000b\tUs\u0017\u000e\u001e\u0006\u0007W>$H.\u001b8\u000b#\u0019dWo\u001d5DQ\u0006tw-\u001a3BY\u0006\u0014XNC\tjgJ+Gn\\1e+:\u0014Gn\\2lK\u0012TqAQ8pY\u0016\fgN\u0003\fsK\u001eL7\u000f^3s\u0007\"\fgnZ3e'R|'/Y4f\u0015\u001d\u0019Ho\u001c:bO\u0016T\u0001cY8na>tWM\u001c;NC:\fw-\u001a:\u000b!\r{W\u000e]8oK:$X*\u00198bO\u0016\u0014(\"\u0004:fY>\fG\r\u0015:pU\u0016\u001cGOC\u0004Qe>TWm\u0019;\u000b-M\fg/Z\"iC:<W\r\u001a)s_*,7\r\u001e$jY\u0016TAAZ5mK*Ya+\u001b:uk\u0006dg)\u001b7f\u0015Y!(/\u001f+p%\u0016dw.\u00193BaBd\u0017nY1uS>t'\u0002K;oE2|7m\u001b*fY>\fG-\u001b8h!J|'.Z2u\u001f:,\u0005\u0010^3s]\u0006d7\t[1oO\u0016\u001c(\"C\"p[B\fg.[8o\r\u000bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0004\t\u0005A\u0001\u0001\u0004\u0001\u0006\u0005\u0011\u0005\u0001RA\u0003\u0003\t\tA1!\u0002\u0002\u0005\u0006!\u001dQa\u0001\u0003\u0004\u0011\ta\u0001!\u0002\u0002\u0005\u0005!-Qa\u0001\u0003\u0005\u0011\u0015a\u0001!\u0002\u0002\u0005\u0005!9Qa\u0001\u0003\u0006\u0011\u001ba\u0001!\u0002\u0002\u0005\t!)QA\u0001\u0003\u0006\u0011\u001b)\u0011\u0001#\u0005\u0006\u0005\u00119\u0001\"C\u0003\u0004\t\u001fA\u0001\u0002\u0004\u0001\u0006\u0005\u0011\u0011\u0001BC\u0003\u0004\t#A\u0019\u0002\u0004\u0001\u0006\u0005\u0011=\u0001\u0002C\u0003\u0003\t\u0003A\u0011\"B\u0002\u0005\u0015!YA\u0002A\u0003\u0003\t)A1\"\u0002\u0002\u0005\u0010!eQA\u0001C\f\u00115)1\u0001\u0002\u0007\t\u00191\u0001QA\u0001\u0003\r\u00111)!\u0001B\u0004\t\u001e\u0015\u0019A1\u0004\u0005\u000f\u0019\u0001)!\u0001b\u0007\t\u001d\u0015\t\u0001\u0002E\u0003\u0004\t=Ay\u0002\u0004\u0001\u0006\u0007\u0011y\u00012\u0005\u0007\u0001\u000b\r!\t\u0002c\n\r\u0001\u0015\u0011A\u0011\u0003E\n\u000b\t!\t\u0002c\n\u0006\u0007\u0011\u0015\u0001\u0012\u0006\u0007\u0001\u000b\t!)\u0001#\u000b\u0006\u0007\u0011!\u0001B\u0006\u0007\u0001\u000b\t!A\u0001\u0003\f\u0005\u00071\r\u0001sF\r\u0004\u000b\u0005A9\u0001g\u0002\u001e\u0002_i\u0013\u0003B1\u00051\u001f\t\u0003\"B\u0001\t\u0011%!\u0011bA\u0003\u0002\u0011%A\u0012\u0002\u0007\u0005V\u0007\u0011)1\u0001b\u0004\n\u0003!MQ\u0006\u0004\u0003b\taU\u0011eA\u0003\u0002\u0011+A*\"V\u0002\u0005\u000b\r!)\"C\u0001\t\u00175bA!\u0019\u0003\u0019\u0018\u0005\u001aQ!\u0001E\r13)6\u0001B\u0003\u0004\t/I\u0011\u0001C\u0007.\u0019\u0011\tG\u0001g\u0007\"\u0007\u0015\t\u0001B\u0004\r\u000f+\u000e!Qa\u0001C\u000e\u0013\u0005Ai\",\u0006\u0005\u0017ay\u0011eA\u0003\u0002\u0011?Az\"U\u0002\u0004\t=I\u0011\u0001\u0002\u0001.\u0016\u0011\u001d\u0001\u0014E\u0011\u0004\u000b\u0005Ay\u0002g\bR\u0007\r!\t#C\u0001\u0005\u00015VA!\u0001\r\u0012C\r)\u0011\u0001\u0003\t\u0019!E\u001b1\u0001B\t\n\u0003\u0011\u0005Qv\b\u0003\u00021Iiz\u0001\u0002\u0001\t&5\u0019Q!\u0001\u0005\n1%\u00016\u0001AO\b\t\u0001A1#D\u0002\u0006\u0003!\u0005\u0002\u0014\u0005)\u0004\u0002\u0005\u001aQ!\u0001E\u00101?\t6a\u0002\u0003\u0013\u0013\u0005!\u0001!D\u0001\t#5\t\u00012E\u0017\u0016\t-AB#h\u0004\u0005\u0001!\u0019QbA\u0003\u0002\u0011IA\"\u0003U\u0002\u0001C\r)\u0011\u0001c\b\u0019 E\u001bQ\u0001\u0002\u000b\n\u0003\u0011\u0001Q\"\u0001E\u0013[\u007f!1\u0002G\u000b\u001e\u0010\u0011\u0001\u00012F\u0007\u0004\u000b\u0005A1\u0003G\nQ\u0007\u0001iz\u0001\u0002\u0001\t\u00075\u0019Q!\u0001\u0005\u00131I\u00016\u0011A\u0011\u0004\u000b\u0005Ay\u0002g\bR\u0007\u001d!Q#C\u0001\u0005\u00015\t\u0001rE\u0007\u0002\u0011Ki+\u0002B\u0001\u0019.\u0005\u001aQ!\u0001\u0005\u00111A\t6a\u0001C\u0017\u0013\u0005!\t!,\u0006\u0005\u0017a9\u0012eA\u0003\u0002\u0011?Az\"U\u0002\u0004\t]I\u0011\u0001\u0002\u00016C\u0015\u0001Ca9\u0001\u0019\tu=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0001!h\u0004\u0005\u0001!1QbA\u0003\u0002\u0011\u0017AZ\u0001UB\u0001C\r)\u0011\u0001c\u0001\u0019\u0004E\u001bq\u0001\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\u0007\u001b\u0005Ai\u0001"})
public final class StoreAwareProjectManager
extends ProjectManagerImpl {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Key<MultiMap<ComponentStoreImpl, StateStorage>> CHANGED_FILES_KEY;
    private final AtomicInteger reloadBlockCount;
    private final LinkedHashSet<StateStorage> changedApplicationFiles;
    private final Runnable restartApplicationOrReloadProjectTask;
    private final SingleAlarm changedFilesAlarm;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(StoreAwareProjectManager.class);
        Companion companion = Companion = new Companion(null);
        CHANGED_FILES_KEY = Key.create((String)"CHANGED_FILES_KEY");
    }

    private final boolean isReloadUnblocked() {
        int count = this.reloadBlockCount.get();
        if (ComponentStoreImplKt.getLOG().isDebugEnabled()) {
            ComponentStoreImplKt.getLOG().debug("[RELOAD] myReloadBlockCount = " + count);
        }
        return count == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveChangedProjectFile(@NotNull VirtualFile file, @NotNull Project project) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)project);
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        StateStorageManager stateStorageManager = ((ComponentStoreImpl)iComponentStore).getStorageManager();
        if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
            stateStorageManager = null;
        }
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        if (stateStorageManagerImpl == null) {
            return;
        }
        StateStorageManagerImpl storageManager2 = stateStorageManagerImpl;
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.getPath()");
        FileBasedStorage fileBasedStorage = (FileBasedStorage)KotlinPackage.firstOrNull((Iterable)storageManager2.getCachedFileStorages(KotlinPackage.listOf((Object)storageManager2.collapseMacros(string))));
        if (fileBasedStorage != null) {
            void $receiver;
            FileBasedStorage fileBasedStorage2 = fileBasedStorage;
            FileBasedStorage it = (FileBasedStorage)$receiver;
            this.registerChangedStorage(it, (ComponentManager)project);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
        this.reloadBlockCount.incrementAndGet();
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
        KotlinPackage.assert((this.reloadBlockCount.get() > 0 ? 1 : 0) != 0);
        if (this.reloadBlockCount.decrementAndGet() == 0 && this.changedFilesAlarm.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.changedFilesAlarm.request(true);
            } else {
                ApplicationManager.getApplication().invokeLater(this.restartApplicationOrReloadProjectTask, ModalityState.NON_MODAL);
            }
        }
    }

    public final void flushChangedAlarm() {
        this.changedFilesAlarm.flush();
    }

    @Override
    public void reloadProject(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        StoreAwareProjectManager.Companion.getCHANGED_FILES_KEY().set((UserDataHolder)project, null);
        super.reloadProject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void registerChangedStorage(StateStorage storage2, ComponentManager componentManager) {
        void lock;
        Ref.ObjectRef changes;
        Project project;
        ComponentManager componentManager2;
        if (ComponentStoreImplKt.getLOG().isDebugEnabled()) {
            ComponentStoreImplKt.getLOG().debug("[RELOAD] Registering project to reload: " + storage2, (Throwable)new Exception());
        }
        Project project2 = (componentManager2 = componentManager) instanceof Project ? (Project)componentManager : (project = componentManager2 instanceof Module ? ((Module)componentManager).getProject() : (Project)null);
        if (project == null) {
            changes = this.changedApplicationFiles;
            synchronized (changes) {
                Boolean bl = changes.add(storage2);
            }
        }
        changes = new Ref.ObjectRef();
        changes.element = (MultiMap)StoreAwareProjectManager.Companion.getCHANGED_FILES_KEY().get((UserDataHolder)project);
        if ((MultiMap)changes.element == null) {
            changes.element = MultiMap.createLinkedSet();
            StoreAwareProjectManager.Companion.getCHANGED_FILES_KEY().set((UserDataHolder)project, (Object)((MultiMap)changes.element));
        }
        MultiMap multiMap = (MultiMap)changes.element;
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"changes");
        MultiMap multiMap2 = multiMap;
        synchronized (lock) {
            IComponentStore iComponentStore = ServiceKt.getStateStore(componentManager);
            if (iComponentStore == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
            }
            ((MultiMap)changes.element).putValue((Object)((ComponentStoreImpl)iComponentStore), (Object)storage2);
            Unit unit = Unit.INSTANCE$;
        }
        componentManager2 = null;
        if (storage2 instanceof StateStorageBase) {
            ((StateStorageBase)storage2).disableSaving();
        }
        if (this.isReloadUnblocked()) {
            this.changedFilesAlarm.cancelAndRequest();
        }
    }

    private final boolean tryToReloadApplication() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return false;
        }
        if (this.changedApplicationFiles.isEmpty()) {
            return true;
        }
        LinkedHashSet changes = new LinkedHashSet(this.changedApplicationFiles);
        this.changedApplicationFiles.clear();
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication());
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        ReloadComponentStoreStatus status = StoreAwareProjectManagerKt.reloadStore(changes, (ComponentStoreImpl)iComponentStore, true);
        if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.RESTART_AGREED))) {
            ApplicationManagerEx.getApplicationEx().restart(true);
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.SUCCESS)) || Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.RESTART_CANCELLED));
    }

    public StoreAwareProjectManager(@NotNull VirtualFileManager virtualFileManager, @NotNull ProgressManager progressManager) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFileManager, (String)"virtualFileManager");
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        super(progressManager);
        this.reloadBlockCount = new AtomicInteger();
        this.changedApplicationFiles = new LinkedHashSet();
        this.restartApplicationOrReloadProjectTask = new Runnable(this){
            final /* synthetic */ StoreAwareProjectManager this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void run() {
                if (StoreAwareProjectManager.access$isReloadUnblocked$1(this.this$0) && StoreAwareProjectManager.access$tryToReloadApplication$3(this.this$0)) {
                    THashSet projectsToReload = new THashSet();
                    Project[] projectArray = this.this$0.getOpenProjects();
                    for (int i = 0; i < projectArray.length; ++i) {
                        void messageBus;
                        MultiMap changes;
                        Project project = projectArray[i];
                        if (project.isDisposed()) continue;
                        if ((MultiMap)com.intellij.configurationStore.StoreAwareProjectManager$Companion.access$getCHANGED_FILES_KEY$0(StoreAwareProjectManager.Companion).get((UserDataHolder)project) == null) {
                            continue;
                        }
                        com.intellij.configurationStore.StoreAwareProjectManager$Companion.access$getCHANGED_FILES_KEY$0(StoreAwareProjectManager.Companion).set((UserDataHolder)project, null);
                        if (changes.isEmpty()) continue;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project.getMessageBus(), (String)"project.getMessageBus()");
                        BatchUpdateListener publisher = (BatchUpdateListener)messageBus.syncPublisher(BatchUpdateListener.TOPIC);
                        publisher.onBatchUpdateStarted();
                        try {
                            for (Map.Entry entry : changes.entrySet()) {
                                Unit unit;
                                StateStorageManagerImpl stateStorageManagerImpl;
                                ComponentStoreImpl store = (ComponentStoreImpl)KotlinPackage.component1((Map.Entry)entry);
                                Collection storages = (Collection)KotlinPackage.component2((Map.Entry)entry);
                                StateStorageManager stateStorageManager = store.getStorageManager();
                                if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
                                    stateStorageManager = null;
                                }
                                if ((stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager) != null && (stateStorageManagerImpl = stateStorageManagerImpl.getComponentManager()) != null ? stateStorageManagerImpl.isDisposed() : false) continue;
                                Collection collection = storages;
                                if (collection == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Set<com.intellij.openapi.components.StateStorage>");
                                }
                                Set set = (Set)collection;
                                ComponentStoreImpl componentStoreImpl = store;
                                Intrinsics.checkExpressionValueIsNotNull((Object)componentStoreImpl, (String)"store");
                                if (Intrinsics.areEqual((Object)((Object)StoreAwareProjectManagerKt.reloadStore(set, componentStoreImpl, false)), (Object)((Object)ReloadComponentStoreStatus.RESTART_AGREED))) {
                                    projectsToReload.add((Object)project);
                                    unit = Unit.INSTANCE$;
                                    continue;
                                }
                                unit = Unit.INSTANCE$;
                            }
                            Unit unit = Unit.INSTANCE$;
                            continue;
                        }
                        finally {
                            publisher.onBatchUpdateFinished();
                        }
                    }
                    for (Project project : projectsToReload) {
                        ProjectManagerImpl.doReloadProject(project);
                    }
                }
            }
            {
                this.this$0 = storeAwareProjectManager;
            }
        };
        this.changedFilesAlarm = new SingleAlarm(this.restartApplicationOrReloadProjectTask, 300, this);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(StateStorageManager.STORAGE_TOPIC, (Object)new StorageManagerListener(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(1.class);
            }

            @Override
            public void storageFileChanged(@NotNull VFileEvent event, @NotNull StateStorage storage2, @NotNull ComponentManager componentManager) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
                Intrinsics.checkParameterIsNotNull((Object)componentManager, (String)"componentManager");
                if (event instanceof VFilePropertyChangeEvent) {
                    return;
                }
                if (event.getRequestor() instanceof StateStorage.SaveSession || event.getRequestor() instanceof StateStorage || event.getRequestor() instanceof ProjectManagerImpl) {
                    return;
                }
                this.registerChangedStorage(storage2, componentManager);
            }
        });
        virtualFileManager.addVirtualFileManagerListener((VirtualFileManagerListener)new VirtualFileManagerAdapter(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(2.class);
            }

            @Override
            public void beforeRefreshStart(boolean asynchronous) {
                this.blockReloadingProjectOnExternalChanges();
            }

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                this.unblockReloadingProjectOnExternalChanges();
            }
        });
    }

    public static final /* synthetic */ boolean access$isReloadUnblocked$1(StoreAwareProjectManager $this) {
        return $this.isReloadUnblocked();
    }

    public static final /* synthetic */ boolean access$tryToReloadApplication$3(StoreAwareProjectManager $this) {
        return $this.tryToReloadApplication();
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"p\u0004)I1i\\7qC:LwN\u001c\u0006\u0019'R|'/Z!xCJ,\u0007K]8kK\u000e$X*\u00198bO\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'N\u0003\nd_:4\u0017nZ;sCRLwN\\*u_J,'bA!os*11n\u001c;mS:T\u0011c\u0011%B\u001d\u001e+Ei\u0018$J\u0019\u0016\u001bvlS#Z\u0015\rYU-\u001f\u0006\b_B,g.\u00199j\u0015\u0011)H/\u001b7\u000b\u00115+H\u000e^5NCBT!bY8oi\u0006Lg.\u001a:t\u0015I\u0019u.\u001c9p]\u0016tGo\u0015;pe\u0016LU\u000e\u001d7\u000b\u0019M#\u0018\r^3Ti>\u0014\u0018mZ3\u000b\u0015\r|W\u000e]8oK:$8OC\fl_Rd\u0017N\u001c\u0018km6t\u0003\u000b\\1uM>\u0014X\u000eV=qK*!r-\u001a;D\u0011\u0006su)\u0012#`\r&cUiU0L\u000bf\u0003(B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0007\u0011\t\u0001\u0012\u0001\u0007\u0001\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\t\u0001bA\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0005\u0011\u0005\u0001\u0012B\u0003\u0003\t\u000fAQ!B\u0002\u0005\t!!A\u0002A\u0003\u0003\t\u0003AQ!\u0002\u0002\u0005\u000b!1Qa\u0001C\u0006\u0011\u0017a\u0001!B\u0002\u0005\u0003!5A\u0002A\u0003\u0003\t\u000fAy!B\u0002\u0005\u000f!9A\u0002A\u0003\u0003\t\u0011AA\u0001Bb\u0002\u0019\tI2!B\u0001\t\u0007a\u0019Q66\u0001\u0005C\u0012A:!Id\u0001\u000b\u0005AI!\u0003\u0010\n;\u0015\t\u0001BB\u0005\u0005\u0013\r)\u0011\u0001#\u0004\u0019\u000e%!\u0011bA\u0003\u0002\u0011\u001fAz\u0001\u0005\u0005\u0016\u001d\u0015\t\u0001BB\u0005\u0005\u0013\r)\u0011\u0001#\u0004\u0019\u000e%!\u0011bA\u0003\u0002\u0011\u001fAz\u0001$\u0001\u0019\ra1\u0001\u0003C\u000b$\u000b\u0005AI!\u0003\u0010\n;\u0015\t\u0001BB\u0005\u0005\u0013\r)\u0011\u0001#\u0004\u0019\u000e%!\u0011bA\u0003\u0002\u0011\u001fAz\u0001\u0005\u0005\u0016\u001d\u0015\t\u0001BB\u0005\u0005\u0013\r)\u0011\u0001#\u0004\u0019\u000e%!\u0011bA\u0003\u0002\u0011\u001fAz\u0001$\u0001\u0019\ra1A\u0012\u0001M\u00051\u0013)6!C\u0003\u0005\t\u000fI\u0011\u0001\u0003\u0005\r\u00025\u0019A\u0011C\u0005\u0002\u0011!)\u0004\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final Key<MultiMap<ComponentStoreImpl, StateStorage>> getCHANGED_FILES_KEY() {
            return CHANGED_FILES_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

