/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={";\u0006)a\u0011m]6U_J+7\u000f^1si*)1\u000f^8sK*y\u0011jQ8na>tWM\u001c;Ti>\u0014XMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015)\u0019w.\u001c9p]\u0016tGo\u001d\u0006\u0005S6\u0004HN\u0003\u0004ti>\u0014Xm\u001d\u0006\u0018]>$(+\u001a7pC\u0012\f'\r\\3D_6\u0004xN\\3oiNT!bQ8mY\u0016\u001cG/[8o\u0015\u0019Yw\u000e\u001e7j]*11\u000b\u001e:j]\u001eTqb\u00195b]\u001e,Gm\u0015;pe\u0006<Wm\u001d\u0006\u0004'\u0016$(\u0002D*uCR,7\u000b^8sC\u001e,'\"B5t\u0003B\u0004(b\u0002\"p_2,\u0017M\u001c\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'BG*u_J,\u0017i^1sKB\u0013xN[3di6\u000bg.Y4fe.#(b\u0003:fY>\fGm\u0015;pe\u0016T!cQ8na>tWM\u001c;Ti>\u0014X-S7qY*\u00112m\u001c8gS\u001e,(/\u0019;j_:\u001cFo\u001c:f\u0015i\u0011V\r\\8bI\u000e{W\u000e]8oK:$8\u000b^8sKN#\u0018\r^;t)\u0007Q!\u0001E\u0002\u000b\t!\u0001\u0001\u0003\u0002\u0006\u0005\u0011\u0005\u0001RA\u0003\u0003\t\u0005A1!\u0002\u0002\u0005\u0004!\u001dQA\u0001\u0003\u0003\u0011\u0011)1\u0001\"\u0002\t\u00031\u0001Q!\u0001E\u0006\u000b\r!9\u0001C\u0003\r\u0001\u0015\u0019Aq\u0001\u0005\u0007\u0019\u0001)1\u0001b\u0002\t\u000f1\u0001Qa\u0001C\u0002\u0011\u001fa\u0001!B\u0002\u0005\b!EA\u0002A\u0003\u0003\t\u000bA\u0011!B\u0001\t\u0013\u0015\u0011Aa\u0002E\n\u000b\t!y\u0001C\u0003\u0006\u0005\u0011=\u0001bB\u0003\u0003\t\u0003A9\"B\u0002\u0005\u0013!YA\u0002A\u0003\u0004\t%AA\u0002\u0004\u0001\u0006\u0005\u0011I\u0001\u0002D\u0003\u0003\t%A1\"Ba\u0001\t\rA\u0002!h\u0004\u0005\u0001!\u0005QbA\u0003\u0002\u0011\rA2\u0001U\u0002\u0001;3!\u0001\u0001#\u0003\u000e\u0011\u0015\t\u0001\u0002B\u0005\u0005\u0013\r)\u0011\u0001#\u0003\u0019\na!\u0001k!\u0001\u001e\u001c\u0011\u0001\u0001RB\u0007\n\u000b\u0005AQ!\u0003\u0003\n\u0007\u0015\t\u00012\u0002M\u0006\u0019\u0003AR\u0001U\u0002\u0002;\u001f!\u0001\u0001\u0003\u0005\u000e\u0007\u0015\t\u0001B\u0002\r\u0007!\u000e\r\u0011eA\u0003\u0002\u0011\u0019Ab!U\u0002\f\t\u0001I\u0011\u0001\"\u0001\u000e\u0003!5Q\"\u0001\u0005\t\u001b\u0005A\t\"D\u0001\u0005\u0002a\u001b!\"\"\u0019\u0005\u0003aUQ\u0014\u0004\u0003\u0001\u0011\u001bi\u0001\"B\u0001\t\u000b%!\u0011bA\u0003\u0002\u0011\u0017AZ\u0001G\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\u00025\u0019Q!\u0001E\n1'\u00016\u0011AO\b\t\u0001A\u0001\"D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0003\u0005\u001aQ!\u0001\u0005\u000b1)\t6!\u0003C\u000b\u0013\u0005A)\"D\u0001\t\u00125\t\u0001bC\u0007\u0002\t\u0003A6A\u0003"})
public final class StoreAwareProjectManagerKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ReloadComponentStoreStatus reloadStore(@NotNull Set<? extends StateStorage> changedStorages, @NotNull ComponentStoreImpl store, boolean isApp) {
        Intrinsics.checkParameterIsNotNull(changedStorages, (String)"changedStorages");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        boolean willBeReloaded = false;
        try {
            Collection<String> notReloadableComponents;
            try {
                notReloadableComponents = store.reload(changedStorages);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.LOG.warn(e);
                Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                if (!willBeReloaded) {
                    for (StateStorage stateStorage : changedStorages) {
                        if (!(stateStorage instanceof StateStorageBase)) continue;
                        ((StateStorageBase)stateStorage).enableSaving();
                    }
                }
                return reloadComponentStoreStatus;
            }
            if (notReloadableComponents == null || notReloadableComponents.isEmpty()) {
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
                return reloadComponentStoreStatus;
            }
            willBeReloaded = StoreAwareProjectManagerKt.askToRestart(store, notReloadableComponents, changedStorages, isApp);
            ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
            return reloadComponentStoreStatus;
        }
        finally {
            if (!willBeReloaded) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
            }
        }
    }

    public static final boolean askToRestart(@NotNull IComponentStore store, @NotNull Collection<? extends String> notReloadableComponents, @Nullable Set<? extends StateStorage> changedStorages, boolean isApp) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull(notReloadableComponents, (String)"notReloadableComponents");
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IProjectStore ? "Project" : "Application";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(string).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (isApp) {
            message.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        } else {
            message.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (changedStorages != null) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).disableSaving();
                }
            }
            return true;
        }
        return false;
    }
}

