/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.ActionMethodFilter;
import com.intellij.debugger.engine.AnonymousClassMethodFilter;
import com.intellij.debugger.engine.ConstructorStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.sun.jdi.ObjectReference;

public class ClassInstanceMethodFilter
extends ConstructorStepMethodFilter
implements ActionMethodFilter {
    private final PsiMethod myPsiMethod;
    private final AnonymousClassMethodFilter myMethodFilter;

    public ClassInstanceMethodFilter(PsiMethod psiMethod, Range<Integer> lines) {
        super(psiMethod.getContainingClass(), lines);
        this.myPsiMethod = psiMethod;
        this.myMethodFilter = new AnonymousClassMethodFilter(this.myPsiMethod, this.getCallingExpressionLines());
    }

    @Override
    public int onReached(SuspendContextImpl context) {
        StackFrameProxyImpl proxy = context.getFrameProxy();
        if (proxy != null) {
            try {
                DebugProcessImpl debugProcess;
                BreakpointManager breakpointManager;
                StepIntoBreakpoint breakpoint;
                ObjectReference reference = proxy.thisObject();
                if (reference != null && (breakpoint = (breakpointManager = DebuggerManagerEx.getInstanceEx((debugProcess = context.getDebugProcessNoAssert()).getProject()).getBreakpointManager()).addStepIntoBreakpoint(this.myMethodFilter)) != null) {
                    breakpointManager.applyThreadFilter(debugProcess, null);
                    breakpoint.addInstanceFilter(reference.uniqueID());
                    breakpoint.setInstanceFiltersEnabled(true);
                    breakpoint.setSuspendPolicy(context.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll");
                    breakpoint.createRequest(debugProcess);
                    debugProcess.setRunToCursorBreakpoint(breakpoint);
                    return -100;
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return 0;
    }
}

