/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.compiler.server.BuildManager;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilingEvaluatorImpl
extends CompilingEvaluator {
    private final EvaluationContextImpl myEvaluationContext;

    public CompilingEvaluatorImpl(EvaluationContextImpl evaluationContext, @NotNull PsiElement context, @NotNull ExtractLightMethodObjectHandler.ExtractedData data2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "<init>"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "<init>"));
        }
        super(context, data2);
        this.myEvaluationContext = evaluationContext;
    }

    @Override
    @NotNull
    protected Collection<ClassObject> compile(@Nullable JavaSdkVersion debuggeeVersion) throws EvaluateException {
        Collection collection;
        Pair<Sdk, JavaSdkVersion> runtime;
        JavaSdkVersion buildRuntimeVersion;
        Module module = (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

            public Module compute() {
                return ModuleUtilCore.findModuleForPsiElement((PsiElement)CompilingEvaluatorImpl.this.myPsiContext);
            }
        });
        ArrayList<String> options = new ArrayList<String>();
        options.add("-proc:none");
        options.add("-encoding");
        options.add("UTF-8");
        ArrayList<File> platformClasspath = new ArrayList<File>();
        ArrayList<File> classpath = new ArrayList<File>();
        if (module != null) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            for (String s : rootManager.orderEntries().compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().getPathList()) {
                classpath.add(new File(s));
            }
            for (String s : rootManager.orderEntries().compileOnly().sdkOnly().getPathsList().getPathList()) {
                platformClasspath.add(new File(s));
            }
        }
        if ((buildRuntimeVersion = (JavaSdkVersion)(runtime = BuildManager.getBuildProcessRuntimeSdk(this.myEvaluationContext.getProject())).getSecond()) != null && debuggeeVersion != null) {
            JavaSdkVersion minVersion = buildRuntimeVersion.ordinal() > debuggeeVersion.ordinal() ? debuggeeVersion : buildRuntimeVersion;
            String sourceOption = CompilingEvaluatorImpl.getSourceOption(minVersion.getMaxLanguageLevel());
            options.add("-source");
            options.add(sourceOption);
            options.add("-target");
            options.add(sourceOption);
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myEvaluationContext.getProject());
        File sourceFile = null;
        try {
            sourceFile = this.generateTempSourceFile(compilerManager.getJavacCompilerWorkingDir());
            File srcDir = sourceFile.getParentFile();
            List sourcePath = Collections.emptyList();
            Set<File> sources = Collections.singleton(sourceFile);
            Collection collection2 = compilerManager.compileJavaCode(options, platformClasspath, classpath, sourcePath, sources, srcDir);
            collection = collection2;
        }
        catch (CompilationException e) {
            StringBuilder res = new StringBuilder("Compilation failed:\n");
            for (CompilationException.Message m : e.getMessages()) {
                if (m.getCategory() != CompilerMessageCategory.ERROR) continue;
                res.append(m.getText()).append("\n");
            }
            throw new EvaluateException(res.toString());
        }
        catch (Exception e) {
            throw new EvaluateException(e.getMessage());
        }
        finally {
            if (sourceFile != null) {
                FileUtil.delete((File)sourceFile);
            }
        }
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "compile"));
        }
        return collection;
    }

    @NotNull
    private static String getSourceOption(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "getSourceOption"));
        }
        String string = "1." + Integer.valueOf(3 + languageLevel.ordinal());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "getSourceOption"));
        }
        return string;
    }

    private File generateTempSourceFile(File workingDir) throws IOException {
        Pair fileData = (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<String, String>>(){

            public Pair<String, String> compute() {
                PsiFile file = CompilingEvaluatorImpl.this.myData.getGeneratedInnerClass().getContainingFile();
                return Pair.create((Object)file.getName(), (Object)file.getText());
            }
        });
        if (fileData.first == null) {
            throw new IOException("Class file name not specified");
        }
        if (fileData.second == null) {
            throw new IOException("Class source code not specified");
        }
        File file = new File(workingDir, "debugger/src/" + (String)fileData.first);
        FileUtil.writeToFile((File)file, (String)((String)fileData.second));
        return file;
    }
}

