/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.clipboard.SimpleTransferable;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.ComponentPasteFactory;
import com.intellij.designer.designSurface.tools.PasteTool;
import com.intellij.designer.model.IComponentCopyProvider;
import com.intellij.designer.model.IComponentDeletionParticipant;
import com.intellij.designer.model.IGroupDeleteComponent;
import com.intellij.designer.model.RadComponent;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.uiDesigner.SerializedComponentData;
import com.intellij.util.ThrowableRunnable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonEditActionsProvider
implements DeleteProvider,
CopyProvider,
PasteProvider,
CutProvider {
    private static final DataFlavor DATA_FLAVOR = FileCopyPasteUtil.createJvmDataFlavor(SerializedComponentData.class);
    public static boolean isDeleting;
    private final DesignerEditorPanel myDesigner;

    public CommonEditActionsProvider(DesignerEditorPanel designer) {
        this.myDesigner = designer;
    }

    protected EditableArea getArea(DataContext dataContext) {
        EditableArea area = (EditableArea)EditableArea.DATA_KEY.getData(dataContext);
        return area == null ? this.myDesigner.getSurfaceArea() : area;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "canDeleteElement"));
        }
        if (this.myDesigner.getInplaceEditingLayer().isEditing()) {
            return false;
        }
        List<RadComponent> selection = this.getArea(dataContext).getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        for (RadComponent component : selection) {
            if (component.canDelete()) continue;
            return false;
        }
        return true;
    }

    public void deleteElement(final @NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "deleteElement"));
        }
        this.myDesigner.getToolProvider().execute(new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                EditableArea area = CommonEditActionsProvider.this.getArea(dataContext);
                List<RadComponent> selection = area.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                CommonEditActionsProvider.this.myDesigner.getToolProvider().loadDefaultTool();
                List<RadComponent> components = RadComponent.getPureSelection(selection);
                CommonEditActionsProvider.updateSelectionBeforeDelete(area, components.get(0), selection);
                CommonEditActionsProvider.handleDeletion(components);
            }
        }, DesignerBundle.message("command.delete.selection", new Object[0]), true);
    }

    private static void handleDeletion(@NotNull List<RadComponent> components) throws Exception {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/designer/actions/CommonEditActionsProvider", "handleDeletion"));
        }
        Map<RadComponent, List<RadComponent>> siblingLists = RadComponent.groupSiblings(components);
        for (Map.Entry<RadComponent, List<RadComponent>> entry : siblingLists.entrySet()) {
            IComponentDeletionParticipant handler2;
            RadComponent parent = entry.getKey();
            List<RadComponent> children = entry.getValue();
            boolean finished = false;
            if (parent instanceof IComponentDeletionParticipant) {
                handler2 = (IComponentDeletionParticipant)((Object)parent);
                finished = handler2.deleteChildren(parent, children);
            } else if (parent != null && parent.getLayout() instanceof IComponentDeletionParticipant) {
                handler2 = (IComponentDeletionParticipant)((Object)parent.getLayout());
                finished = handler2.deleteChildren(parent, children);
            }
            if (finished) continue;
            CommonEditActionsProvider.deleteComponents(children);
        }
    }

    private static void deleteComponents(List<RadComponent> components) throws Exception {
        if (components.get(0) instanceof IGroupDeleteComponent) {
            ((IGroupDeleteComponent)((Object)components.get(0))).delete(components);
        } else {
            for (RadComponent component : components) {
                component.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSelectionBeforeDelete(EditableArea area, RadComponent component, List<RadComponent> excludes) {
        try {
            isDeleting = true;
            RadComponent newSelection = CommonEditActionsProvider.getNewSelection(component, excludes);
            if (newSelection == null) {
                area.deselectAll();
            } else {
                area.select(newSelection);
            }
        }
        finally {
            isDeleting = false;
        }
    }

    @Nullable
    private static RadComponent getNewSelection(RadComponent component, List<RadComponent> excludes) {
        RadComponent parent = component.getParent();
        if (parent == null) {
            return null;
        }
        List<RadComponent> children = parent.getChildren();
        int size = children.size();
        for (int i = children.indexOf(component) + 1; i < size; ++i) {
            RadComponent next = children.get(i);
            if (excludes.contains(next)) continue;
            return next;
        }
        return parent;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "isCopyVisible"));
        }
        return true;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "isCopyEnabled"));
        }
        if (this.myDesigner.getInplaceEditingLayer().isEditing()) {
            return false;
        }
        List<RadComponent> selection = this.getArea(dataContext).getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        RadComponent rootComponent = this.myDesigner.getRootComponent();
        if (rootComponent instanceof IComponentCopyProvider) {
            IComponentCopyProvider copyProvider = (IComponentCopyProvider)((Object)rootComponent);
            return copyProvider.isCopyEnabled(selection);
        }
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "performCopy"));
        }
        this.doCopy(dataContext);
    }

    private boolean doCopy(DataContext dataContext) {
        try {
            Element root = new Element("designer");
            root.setAttribute("target", this.myDesigner.getPlatformTarget());
            List<RadComponent> components = RadComponent.getPureSelection(this.getArea(dataContext).getSelection());
            RadComponent rootComponent = this.myDesigner.getRootComponent();
            if (rootComponent instanceof IComponentCopyProvider) {
                IComponentCopyProvider copyProvider = (IComponentCopyProvider)((Object)rootComponent);
                copyProvider.copyTo(root, components);
            } else {
                for (RadComponent component : components) {
                    component.copyTo(root);
                }
            }
            SerializedComponentData data2 = new SerializedComponentData(new XMLOutputter().outputString(root));
            CopyPasteManager.getInstance().setContents((Transferable)new SimpleTransferable(data2, DATA_FLAVOR));
            return true;
        }
        catch (Throwable e) {
            this.myDesigner.showError("Copy error", e);
            return false;
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "isPastePossible"));
        }
        return this.isPasteEnabled(dataContext);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "isPasteEnabled"));
        }
        return !this.myDesigner.getInplaceEditingLayer().isEditing() && this.getSerializedComponentData() != null;
    }

    @Nullable
    private String getSerializedComponentData() {
        try {
            SerializedComponentData data2;
            String xmlComponents;
            Object transferData = CopyPasteManager.getInstance().getContents(DATA_FLAVOR);
            if (transferData instanceof SerializedComponentData && (xmlComponents = (data2 = (SerializedComponentData)transferData).getSerializedComponents()).startsWith("<designer target=\"" + this.myDesigner.getPlatformTarget() + "\">")) {
                return xmlComponents;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "performPaste"));
        }
        ComponentPasteFactory factory = this.myDesigner.createPasteFactory(this.getSerializedComponentData());
        if (factory != null) {
            this.myDesigner.getToolProvider().setActiveTool(new PasteTool(true, factory));
        }
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "isCutVisible"));
        }
        return true;
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "isCutEnabled"));
        }
        return this.isCopyEnabled(dataContext) && this.canDeleteElement(dataContext);
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/designer/actions/CommonEditActionsProvider", "performCut"));
        }
        if (this.doCopy(dataContext)) {
            this.deleteElement(dataContext);
        }
    }
}

