/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DefaultIdeaErrorLogger;
import com.intellij.diagnostic.LogEventException;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.idea.IdeaApplication;
import com.intellij.idea.Main;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.diagnostic.ErrorLogger;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.jetbrains.annotations.NotNull;

public class DialogAppender
extends AppenderSkeleton {
    private static final ErrorLogger DEFAULT_LOGGER = new DefaultIdeaErrorLogger();
    private static final int MAX_ASYNC_LOGGING_EVENTS = 5;
    private volatile Runnable myDialogRunnable = null;
    private final AtomicInteger myPendingAppendCounts = new AtomicInteger();

    protected synchronized void append(final @NotNull LoggingEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/DialogAppender", "append"));
        }
        if (!event.getLevel().isGreaterOrEqual((Priority)Level.ERROR) || Main.isCommandLine() || !IdeaApplication.isLoaded()) {
            return;
        }
        Runnable action = new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<ErrorLogger> loggers = new ArrayList<ErrorLogger>();
                    loggers.add(DEFAULT_LOGGER);
                    Application application = ApplicationManager.getApplication();
                    if (application != null) {
                        if (application.isHeadlessEnvironment() || application.isDisposed()) {
                            return;
                        }
                        ContainerUtil.addAll(loggers, ComponentsPackage.getComponents((ComponentManager)application, ErrorLogger.class));
                    }
                    DialogAppender.this.appendToLoggers(event, loggers.toArray(new ErrorLogger[loggers.size()]));
                }
                finally {
                    DialogAppender.this.myPendingAppendCounts.decrementAndGet();
                }
            }
        };
        if (this.myPendingAppendCounts.addAndGet(1) > 5) {
            this.myPendingAppendCounts.decrementAndGet();
        } else {
            SwingUtilities.invokeLater(action);
        }
    }

    void appendToLoggers(@NotNull LoggingEvent event, @NotNull ErrorLogger[] errorLoggers) {
        IdeaLoggingEvent ideaEvent;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/DialogAppender", "appendToLoggers"));
        }
        if (errorLoggers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorLoggers", "com/intellij/diagnostic/DialogAppender", "appendToLoggers"));
        }
        if (this.myDialogRunnable != null) {
            return;
        }
        Object message = event.getMessage();
        if (message instanceof IdeaLoggingEvent) {
            ideaEvent = (IdeaLoggingEvent)message;
        } else {
            ThrowableInformation info = event.getThrowableInformation();
            if (info == null) {
                return;
            }
            ideaEvent = DialogAppender.extractLoggingEvent(message, info.getThrowable());
        }
        for (int i = errorLoggers.length - 1; i >= 0; --i) {
            final ErrorLogger logger = errorLoggers[i];
            if (!logger.canHandle(ideaEvent)) continue;
            this.myDialogRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.handle(ideaEvent);
                    }
                    finally {
                        DialogAppender.this.myDialogRunnable = null;
                    }
                }
            };
            Application app = ApplicationManager.getApplication();
            if (app == null) {
                new Thread(this.myDialogRunnable, "dialog appender logger").start();
                break;
            }
            app.executeOnPooledThread(this.myDialogRunnable);
            break;
        }
    }

    private static IdeaLoggingEvent extractLoggingEvent(Object message, Throwable throwable) {
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)throwable);
        if (rootCause instanceof LogEventException) {
            return ((LogEventException)rootCause).getLogMessage();
        }
        String strMessage = message == null ? "<null> " : message.toString();
        ExceptionWithAttachments withAttachments = (ExceptionWithAttachments)ExceptionUtil.findCause((Throwable)throwable, ExceptionWithAttachments.class);
        if (withAttachments != null) {
            return LogMessageEx.createEvent(strMessage, ExceptionUtil.getThrowableText((Throwable)throwable), withAttachments.getAttachments());
        }
        return new IdeaLoggingEvent(strMessage, throwable);
    }

    Runnable getDialogRunnable() {
        return this.myDialogRunnable;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }
}

