/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.openapi.util.text.LineTokenizer;
import java.util.Arrays;
import java.util.List;

public class Block {
    private final String[] mySource;
    private int myStart;
    private int myEnd;

    public Block(String source, int start, int end) {
        this(LineTokenizer.tokenize((char[])source.toCharArray(), (boolean)false), start, end);
    }

    public Block(String[] source, int start, int end) {
        this.mySource = source;
        this.myStart = start;
        this.myEnd = end;
    }

    public String getBlockContent() {
        StringBuffer result = new StringBuffer();
        int length = this.myEnd - this.myStart + 1;
        for (int i = 0; i < length && i + this.myStart < this.mySource.length; ++i) {
            result.append(this.mySource[i + this.myStart]);
            if (i >= length - 1) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public int hashCode() {
        return this.getSourceAsList().hashCode() ^ this.myStart ^ this.myEnd;
    }

    private List<String> getSourceAsList() {
        return Arrays.asList(this.mySource);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Block)) {
            return false;
        }
        Block other = (Block)object;
        return this.getSourceAsList().equals(other.getSourceAsList()) && this.myStart == other.myStart && this.myEnd == other.myEnd;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public void setStart(int start) {
        this.myStart = start;
    }

    public void setEnd(int end) {
        this.myEnd = end;
    }

    public String[] getSource() {
        return this.mySource;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.appendLines(result, 0, this.myStart);
        this.appendLineTo(result, "<-----------------------------");
        this.appendLines(result, this.myStart, this.myEnd + 1);
        this.appendLineTo(result, "----------------------------->");
        this.appendLines(result, this.myEnd + 1, this.mySource.length);
        return result.toString();
    }

    private void appendLines(StringBuffer result, int from, int to) {
        for (int i = from; i < to; ++i) {
            this.appendLineTo(result, this.mySource[i]);
        }
    }

    private void appendLineTo(StringBuffer result, String line) {
        result.append(line);
        result.append("\n");
    }
}

