/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeUtil {
    @NotNull
    public static String getResolveActionTitle(@NotNull MergeResult result, @NotNull MergeRequest request, @NotNull MergeContext context) {
        String message;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
        }
        Function<MergeResult, String> getter = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS);
        String string = message = getter != null ? (String)getter.fun((Object)result) : null;
        if (message != null) {
            String string2 = message;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
            }
            return string2;
        }
        switch (result) {
            case CANCEL: {
                if ("Abort" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
                }
                return "Abort";
            }
            case LEFT: {
                if ("Accept Left" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
                }
                return "Accept Left";
            }
            case RIGHT: {
                if ("Accept Right" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
                }
                return "Accept Right";
            }
            case RESOLVED: {
                if ("Apply" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "getResolveActionTitle"));
                }
                return "Apply";
            }
        }
        throw new IllegalArgumentException(result.toString());
    }

    @NotNull
    public static List<String> notNullizeContentTitles(@NotNull List<String> mergeContentTitles) {
        if (mergeContentTitles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContentTitles", "com/intellij/diff/merge/MergeUtil", "notNullizeContentTitles"));
        }
        String left = StringUtil.notNullize((String)((String)ThreeSide.LEFT.select(mergeContentTitles)), (String)"Your Version");
        String base = StringUtil.notNullize((String)((String)ThreeSide.BASE.select(mergeContentTitles)), (String)"Base Version");
        String right = StringUtil.notNullize((String)((String)ThreeSide.RIGHT.select(mergeContentTitles)), (String)"Server Version");
        List list = ContainerUtil.list((Object[])new String[]{left, base, right});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeUtil", "notNullizeContentTitles"));
        }
        return list;
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull JComponent component, @NotNull MergeRequest request, @NotNull MergeContext context) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/merge/MergeUtil", "showExitWithoutApplyingChangesDialog"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/MergeUtil", "showExitWithoutApplyingChangesDialog"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/MergeUtil", "showExitWithoutApplyingChangesDialog"));
        }
        String message = DiffBundle.message((String)"merge.dialog.exit.without.applying.changes.confirmation.message", (Object[])new Object[0]);
        String title = DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]);
        Couple<String> customMessage = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_CANCEL_MESSAGE);
        if (customMessage != null) {
            title = (String)customMessage.first;
            message = (String)customMessage.second;
        }
        return Messages.showYesNoDialog((Component)component.getRootPane(), (String)message, (String)title, (Icon)Messages.getQuestionIcon()) == 0;
    }

    public static class ProxyDiffContext
    extends DiffContext {
        @NotNull
        private final MergeContext myMergeContext;

        public ProxyDiffContext(@NotNull MergeContext mergeContext) {
            if (mergeContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "com/intellij/diff/merge/MergeUtil$ProxyDiffContext", "<init>"));
            }
            this.myMergeContext = mergeContext;
        }

        @Nullable
        public Project getProject() {
            return this.myMergeContext.getProject();
        }

        public boolean isWindowFocused() {
            return true;
        }

        public boolean isFocused() {
            return this.myMergeContext.isFocused();
        }

        public void requestFocus() {
            this.myMergeContext.requestFocus();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/merge/MergeUtil$ProxyDiffContext", "getUserData"));
            }
            return (T)this.myMergeContext.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/merge/MergeUtil$ProxyDiffContext", "putUserData"));
            }
            this.myMergeContext.putUserData(key, value);
        }
    }
}

