/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloneDvcsDialog
extends DialogWrapper {
    private static final Pattern SSH_URL_PATTERN;
    private JPanel myRootPanel;
    private EditorComboBox myRepositoryURL;
    private TextFieldWithBrowseButton myParentDirectory;
    private JButton myTestButton;
    private JTextField myDirectoryName;
    private JLabel myRepositoryUrlLabel;
    @NotNull
    private String myTestURL;
    @Nullable
    private Boolean myTestResult;
    @NotNull
    private String myDefaultDirectoryName;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final String myVcsDirectoryName;
    @Nullable
    private final String myDefaultRepoUrl;

    public CloneDvcsDialog(@NotNull Project project, @NotNull String displayName, @NotNull String vcsDirectoryName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        if (vcsDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDirectoryName", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        this(project, displayName, vcsDirectoryName, null);
    }

    public CloneDvcsDialog(@NotNull Project project, @NotNull String displayName, @NotNull String vcsDirectoryName, @Nullable String defaultUrl) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        if (vcsDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDirectoryName", "com/intellij/dvcs/ui/CloneDvcsDialog", "<init>"));
        }
        super(project, true);
        this.myDefaultDirectoryName = "";
        this.myDefaultRepoUrl = defaultUrl;
        this.myProject = project;
        this.myVcsDirectoryName = vcsDirectoryName;
        this.$$$setupUI$$$();
        this.init();
        this.initListeners();
        this.setTitle(DvcsBundle.getString("clone.title"));
        this.myRepositoryUrlLabel.setText(DvcsBundle.message("clone.repository.url", displayName));
        this.setOKButtonText(DvcsBundle.getString("clone.button"));
    }

    @NotNull
    public String getSourceRepositoryURL() {
        String string = this.getCurrentUrlText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/CloneDvcsDialog", "getSourceRepositoryURL"));
        }
        return string;
    }

    public String getParentDirectory() {
        return this.myParentDirectory.getText();
    }

    public String getDirectoryName() {
        return this.myDirectoryName.getText();
    }

    private void initListeners() {
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(DvcsBundle.getString("clone.destination.directory.title"));
        fcd.setDescription(DvcsBundle.getString("clone.destination.directory.description"));
        fcd.setHideIgnored(false);
        this.myParentDirectory.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(fcd.getTitle(), fcd.getDescription(), (ComponentWithBrowseButton)this.myParentDirectory, this.myProject, fcd, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected VirtualFile getInitialFile() {
                VirtualFile file;
                String text = this.getComponentText();
                if (text.length() == 0 && (file = CloneDvcsDialog.this.myProject.getBaseDir()) != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        });
        com.intellij.ui.DocumentAdapter updateOkButtonListener = new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                CloneDvcsDialog.this.updateButtons();
            }
        };
        ((JTextField)this.myParentDirectory.getChildComponent()).getDocument().addDocumentListener((javax.swing.event.DocumentListener)updateOkButtonListener);
        String parentDir = this.getRememberedInputs().getCloneParentDir();
        if (StringUtil.isEmptyOrSpaces((String)parentDir)) {
            parentDir = ProjectUtil.getBaseDir();
        }
        this.myParentDirectory.setText(parentDir);
        this.myDirectoryName.getDocument().addDocumentListener((javax.swing.event.DocumentListener)updateOkButtonListener);
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloneDvcsDialog.this.test();
            }
        });
        this.setOKActionEnabled(false);
        this.myTestButton.setEnabled(false);
    }

    private void test() {
        this.myTestURL = this.getCurrentUrlText();
        boolean testResult = this.test(this.myTestURL);
        if (testResult) {
            Messages.showInfoMessage((Component)this.myTestButton, (String)DvcsBundle.message("clone.test.success.message", this.myTestURL), (String)DvcsBundle.getString("clone.test.connection.title"));
            this.myTestResult = Boolean.TRUE;
        } else {
            this.myTestResult = Boolean.FALSE;
        }
        this.updateButtons();
    }

    protected abstract boolean test(@NotNull String var1);

    @NotNull
    protected abstract DvcsRememberedInputs getRememberedInputs();

    private void updateButtons() {
        if (!this.checkRepositoryURL()) {
            return;
        }
        if (!this.checkDestination()) {
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private boolean checkDestination() {
        if (this.myParentDirectory.getText().length() == 0 || this.myDirectoryName.getText().length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return false;
        }
        File file = new File(this.myParentDirectory.getText(), this.myDirectoryName.getText());
        if (file.exists()) {
            this.setErrorText(DvcsBundle.message("clone.destination.exists.error", file));
            this.setOKActionEnabled(false);
            return false;
        }
        if (!file.getParentFile().exists()) {
            this.setErrorText(DvcsBundle.message("clone.parent.missing.error", file.getParent()));
            this.setOKActionEnabled(false);
            return false;
        }
        return true;
    }

    private boolean checkRepositoryURL() {
        String repository = this.getCurrentUrlText();
        if (repository.length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return false;
        }
        if (this.myTestResult != null && repository.equals(this.myTestURL)) {
            if (!this.myTestResult.booleanValue()) {
                this.setErrorText(DvcsBundle.getString("clone.test.failed.error"));
                this.setOKActionEnabled(false);
                return false;
            }
            return true;
        }
        try {
            if (new URI(repository).isAbsolute()) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (SSH_URL_PATTERN.matcher(repository).matches()) {
            return true;
        }
        try {
            File file = new File(repository);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    this.setErrorText(DvcsBundle.getString("clone.url.is.not.directory.error"));
                    this.setOKActionEnabled(false);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setErrorText(DvcsBundle.getString("clone.invalid.url"));
        this.setOKActionEnabled(false);
        return false;
    }

    @NotNull
    private String getCurrentUrlText() {
        String string = FileUtil.expandUserHome((String)this.myRepositoryURL.getText().trim());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/CloneDvcsDialog", "getCurrentUrlText"));
        }
        return string;
    }

    private void createUIComponents() {
        this.myRepositoryURL = new EditorComboBox("");
        DvcsRememberedInputs rememberedInputs = this.getRememberedInputs();
        ArrayList<String> urls = new ArrayList<String>(rememberedInputs.getVisitedUrls());
        if (this.myDefaultRepoUrl != null) {
            urls.add(0, this.myDefaultRepoUrl);
        }
        this.myRepositoryURL.setHistory((String[])ArrayUtil.toObjectArray(urls, String.class));
        this.myRepositoryURL.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                String url = CloneDvcsDialog.this.getCurrentUrlText();
                CloneDvcsDialog.this.myTestButton.setEnabled(url.length() != 0);
                if (CloneDvcsDialog.this.myDefaultDirectoryName.equals(CloneDvcsDialog.this.myDirectoryName.getText()) || CloneDvcsDialog.this.myDirectoryName.getText().length() == 0) {
                    CloneDvcsDialog.this.myDefaultDirectoryName = CloneDvcsDialog.defaultDirectoryName(url, CloneDvcsDialog.this.myVcsDirectoryName);
                    CloneDvcsDialog.this.myDirectoryName.setText(CloneDvcsDialog.this.myDefaultDirectoryName);
                }
                CloneDvcsDialog.this.updateButtons();
            }
        });
    }

    public void prependToHistory(@NotNull String item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/dvcs/ui/CloneDvcsDialog", "prependToHistory"));
        }
        this.myRepositoryURL.prependItem(item);
    }

    public void rememberSettings() {
        DvcsRememberedInputs rememberedInputs = this.getRememberedInputs();
        rememberedInputs.addUrl(this.getSourceRepositoryURL());
        rememberedInputs.setCloneParentDir(this.getParentDirectory());
    }

    @NotNull
    private static String defaultDirectoryName(@NotNull String url, @NotNull String vcsDirName) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/dvcs/ui/CloneDvcsDialog", "defaultDirectoryName"));
        }
        if (vcsDirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDirName", "com/intellij/dvcs/ui/CloneDvcsDialog", "defaultDirectoryName"));
        }
        String nonSystemName = url.endsWith("/" + vcsDirName) || url.endsWith(File.separator + vcsDirName) ? url.substring(0, url.length() - vcsDirName.length() - 1) : (url.endsWith(vcsDirName) ? url.substring(0, url.length() - vcsDirName.length()) : url);
        int i = nonSystemName.lastIndexOf(47);
        if (i == -1 && File.separatorChar != '/') {
            i = nonSystemName.lastIndexOf(File.separatorChar);
        }
        String string = i >= 0 ? nonSystemName.substring(i + 1) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/CloneDvcsDialog", "defaultDirectoryName"));
        }
        return string;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRepositoryURL;
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    static {
        String ch = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]";
        String host = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*";
        String path = "/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        String all2 = "(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        SSH_URL_PATTERN = Pattern.compile("(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRepositoryUrlLabel = jLabel = new JLabel();
        jLabel.setText("Repository URL");
        jLabel.setDisplayedMnemonic('R');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 1, 1, 3, 0, 1, 6, 1, null, null, null));
        EditorComboBox editorComboBox = this.myRepositoryURL;
        jPanel.add((Component)editorComboBox, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("clone.parent.dir"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParentDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("clone.dir.name"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("clone.test"));
        jPanel.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDirectoryName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 2, 1, 2, 0, 1, 6, 1, null, null, null));
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

