/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.RunnerMediator;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillableColoredProcessHandler
extends ColoredProcessHandler
implements KillableProcess {
    private static final Logger LOG = Logger.getInstance(KillableColoredProcessHandler.class);
    private static final Key<Boolean> MEDIATOR_KEY = Key.create((String)"KillableColoredProcessHandler.Mediator.Process");
    private boolean myShouldKillProcessSoftly;
    private boolean myMediatedProcess;

    public KillableColoredProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/KillableColoredProcessHandler", "<init>"));
        }
        super(commandLine);
        this.myShouldKillProcessSoftly = true;
        this.myMediatedProcess = false;
    }

    public KillableColoredProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/KillableColoredProcessHandler", "<init>"));
        }
        super(KillableColoredProcessHandler.mediate(commandLine, withMediator).createProcess(), commandLine.getCommandLineString(), commandLine.getCharset());
        this.myShouldKillProcessSoftly = true;
        this.myMediatedProcess = false;
        this.myMediatedProcess = withMediator && MEDIATOR_KEY.get((UserDataHolder)commandLine) == Boolean.TRUE;
    }

    public KillableColoredProcessHandler(@NotNull Process process, @Nullable String commandLine) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/KillableColoredProcessHandler", "<init>"));
        }
        super(process, commandLine);
        this.myShouldKillProcessSoftly = true;
        this.myMediatedProcess = false;
    }

    public KillableColoredProcessHandler(@NotNull Process process, @Nullable String commandLine, @NotNull Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/KillableColoredProcessHandler", "<init>"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/execution/process/KillableColoredProcessHandler", "<init>"));
        }
        super(process, commandLine, charset);
        this.myShouldKillProcessSoftly = true;
        this.myMediatedProcess = false;
    }

    private static GeneralCommandLine mediate(GeneralCommandLine commandLine, boolean withMediator) {
        if (withMediator && SystemInfo.isWindows) {
            boolean mediatorInjected = RunnerMediator.injectRunnerCommand(commandLine);
            MEDIATOR_KEY.set((UserDataHolder)commandLine, (Object)mediatorInjected);
        }
        return commandLine;
    }

    protected boolean shouldKillProcessSoftly() {
        return this.myShouldKillProcessSoftly;
    }

    public void setShouldKillProcessSoftly(boolean shouldKillProcessSoftly) {
        this.myShouldKillProcessSoftly = shouldKillProcessSoftly;
    }

    private boolean canKillProcessSoftly() {
        if (KillableColoredProcessHandler.processCanBeKilledByOS((Process)this.myProcess)) {
            if (SystemInfo.isWindows) {
                return this.myMediatedProcess;
            }
            if (SystemInfo.isUnix) {
                return true;
            }
        }
        return false;
    }

    protected void destroyProcessImpl() {
        try {
            this.myProcess.getOutputStream().flush();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void notifyProcessTerminated(int exitCode) {
        try {
            super.closeStreams();
        }
        finally {
            super.notifyProcessTerminated(exitCode);
        }
    }

    protected void doDestroyProcess() {
        boolean gracefulTerminationAttempted;
        boolean bl = gracefulTerminationAttempted = this.shouldKillProcessSoftly() && this.canKillProcessSoftly() && this.destroyProcessGracefully();
        if (!gracefulTerminationAttempted) {
            super.doDestroyProcess();
        }
    }

    protected boolean destroyProcessGracefully() {
        if (SystemInfo.isWindows && this.myMediatedProcess) {
            return RunnerMediator.destroyProcess(this.myProcess, true);
        }
        if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigIntToProcessTree((Process)this.myProcess);
        }
        return false;
    }

    @Override
    public boolean canKillProcess() {
        return KillableColoredProcessHandler.processCanBeKilledByOS((Process)this.getProcess());
    }

    @Override
    public void killProcess() {
        this.killProcessTree(this.getProcess());
    }

    public static KillableColoredProcessHandler create(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/KillableColoredProcessHandler", "create"));
        }
        return new KillableColoredProcessHandler(commandLine, true);
    }
}

