/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.SMStacktraceParserEx;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsGroup;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.config.Storage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerConsoleProperties
extends TestConsoleProperties
implements SMStacktraceParserEx {
    private final RunProfile myConfiguration;
    @NotNull
    private final String myTestFrameworkName;
    private final CompositeFilter myCustomFilter;
    private boolean myIdBasedTestTree;
    private boolean myPrintTestingStartedTime;

    public SMTRunnerConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        this(config.getProject(), (RunProfile)config, testFrameworkName, executor);
    }

    public SMTRunnerConsoleProperties(@NotNull Project project, @NotNull RunProfile config, @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        super((Storage)SMTRunnerConsoleProperties.getStorage(testFrameworkName), project, executor);
        this.myIdBasedTestTree = false;
        this.myPrintTestingStartedTime = true;
        this.myConfiguration = config;
        this.myTestFrameworkName = testFrameworkName;
        this.myCustomFilter = new CompositeFilter(project);
    }

    public SMTRunnerConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor, boolean printTestingStartedTime) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "<init>"));
        }
        this(config, testFrameworkName, executor);
        this.setPrintTestingStartedTime(printTestingStartedTime);
    }

    @NotNull
    private static Storage.PropertiesComponentStorage getStorage(String testFrameworkName) {
        Storage.PropertiesComponentStorage propertiesComponentStorage = new Storage.PropertiesComponentStorage(testFrameworkName + "Support.", PropertiesComponent.getInstance());
        if (propertiesComponentStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "getStorage"));
        }
        return propertiesComponentStorage;
    }

    @Override
    public RunProfile getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    @Nullable
    protected AnAction createImportAction() {
        return new ImportTestsGroup(this);
    }

    public boolean isIdBasedTestTree() {
        return this.myIdBasedTestTree;
    }

    public void setIdBasedTestTree(boolean idBasedTestTree) {
        this.myIdBasedTestTree = idBasedTestTree;
    }

    public boolean isPrintTestingStartedTime() {
        return this.myPrintTestingStartedTime;
    }

    public void setPrintTestingStartedTime(boolean printTestingStartedTime) {
        this.myPrintTestingStartedTime = printTestingStartedTime;
    }

    @Override
    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "getErrorNavigatable"));
        }
        if (stacktrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stacktrace", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "getErrorNavigatable"));
        }
        return this.getErrorNavigatable(location.getProject(), stacktrace);
    }

    @Override
    @Nullable
    public Navigatable getErrorNavigatable(final @NotNull Project project, @NotNull String stacktrace) {
        String[] lines;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "getErrorNavigatable"));
        }
        if (stacktrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stacktrace", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "getErrorNavigatable"));
        }
        if (this.myCustomFilter.isEmpty()) {
            return null;
        }
        int stacktraceLength = stacktrace.length();
        for (String line : lines = StringUtil.splitByLines((String)stacktrace)) {
            HyperlinkInfo info;
            Filter.Result result;
            try {
                result = this.myCustomFilter.applyFilter(line, stacktraceLength);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + this.myCustomFilter + " to '" + line + "'", t);
            }
            HyperlinkInfo hyperlinkInfo = info = result != null ? result.getFirstHyperlinkInfo() : null;
            if (info == null) continue;
            if (info instanceof FileHyperlinkInfo) {
                return ((FileHyperlinkInfo)info).getDescriptor();
            }
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    info.navigate(project);
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }
        return null;
    }

    public void addStackTraceFilter(Filter filter) {
        this.myCustomFilter.addFilter(filter);
    }

    @Nullable
    protected Navigatable findSuitableNavigatableForLine(@NotNull Project project, @NotNull VirtualFile file, int line) {
        PsiFile psi;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "findSuitableNavigatableForLine"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "findSuitableNavigatableForLine"));
        }
        Document doc = FileDocumentManager.getInstance().getDocument(file);
        PsiFile psiFile = psi = doc == null ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(doc);
        if (psi == null) {
            return null;
        }
        int offset = doc.getLineStartOffset(line);
        int endOffset = doc.getLineEndOffset(line);
        for (int i = offset + 1; i < endOffset; ++i) {
            PsiElement el = psi.findElementAt(i);
            if (el == null || el instanceof PsiWhiteSpace) continue;
            offset = el.getTextOffset();
            break;
        }
        return new OpenFileDescriptor(project, file, offset);
    }

    public boolean fixEmptySuite() {
        return false;
    }

    @Nullable
    public SMTestLocator getTestLocator() {
        return null;
    }

    @Nullable
    public TestProxyFilterProvider getFilterProvider() {
        return null;
    }

    @Nullable
    public AbstractRerunFailedTestsAction createRerunFailedTestsAction(ConsoleView consoleView) {
        return null;
    }

    @NotNull
    public String getTestFrameworkName() {
        String string = this.myTestFrameworkName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties", "getTestFrameworkName"));
        }
        return string;
    }
}

