/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.facet.impl.ui.FacetTreeModel;
import com.intellij.facet.impl.ui.ProjectConfigurableContext;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFacetsConfigurator
implements FacetsProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ProjectFacetsConfigurator");
    private final Map<Module, ModifiableFacetModel> myModifiableModels = new HashMap<Module, ModifiableFacetModel>();
    private final Map<Facet, FacetEditorImpl> myEditors = new LinkedHashMap<Facet, FacetEditorImpl>();
    private final Map<Module, FacetTreeModel> myTreeModels = new HashMap<Module, FacetTreeModel>();
    private final Map<FacetInfo, Facet> myInfo2Facet = new HashMap<FacetInfo, Facet>();
    private final Map<Facet, FacetInfo> myFacet2Info = new HashMap<Facet, FacetInfo>();
    private final Map<Module, UserDataHolder> mySharedModuleData = new HashMap<Module, UserDataHolder>();
    private final Set<Facet> myFacetsToDispose = new HashSet<Facet>();
    private final Set<Facet> myChangedFacets = new HashSet<Facet>();
    private final Set<Facet> myCreatedFacets = new HashSet<Facet>();
    private final StructureConfigurableContext myContext;
    private UserDataHolderBase myProjectData = new UserDataHolderBase();

    public ProjectFacetsConfigurator(StructureConfigurableContext context, ProjectFacetsConfigurator facetsConfigurator) {
        this.myContext = context;
        if (facetsConfigurator != null) {
            this.initFrom(facetsConfigurator);
        }
    }

    private void initFrom(ProjectFacetsConfigurator facetsConfigurator) {
        this.myFacet2Info.putAll(facetsConfigurator.myFacet2Info);
        this.myInfo2Facet.putAll(facetsConfigurator.myInfo2Facet);
        this.myTreeModels.putAll(facetsConfigurator.myTreeModels);
        this.myEditors.putAll(facetsConfigurator.myEditors);
    }

    public List<Facet> removeFacet(Facet facet) {
        FacetEditorImpl facetEditor;
        FacetInfo[] children;
        FacetTreeModel treeModel = this.getTreeModel(facet.getModule());
        FacetInfo facetInfo = this.myFacet2Info.get(facet);
        if (facetInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<Facet> removed = new ArrayList<Facet>();
        List<FacetInfo> childrenList = treeModel.getChildren(facetInfo);
        for (FacetInfo child : children = childrenList.toArray(new FacetInfo[childrenList.size()])) {
            Facet childInfo = this.myInfo2Facet.get(child);
            if (childInfo == null) continue;
            removed.addAll(this.removeFacet(childInfo));
        }
        treeModel.removeFacetInfo(facetInfo);
        this.getOrCreateModifiableModel(facet.getModule()).removeFacet(facet);
        this.myChangedFacets.remove(facet);
        if (this.myCreatedFacets.contains(facet)) {
            Disposer.dispose((Disposable)facet);
        }
        if ((facetEditor = this.myEditors.remove(facet)) != null) {
            facetEditor.disposeUIResources();
        }
        this.myFacet2Info.remove(facet);
        this.myInfo2Facet.remove(facetInfo);
        removed.add(facet);
        return removed;
    }

    public Facet createAndAddFacet(Module module, FacetType<?, ?> type, @Nullable Facet underlying) {
        Collection facets = this.getFacetsByType(module, type.getId());
        String facetName = type.getDefaultFacetName();
        int i = 2;
        while (this.facetExists(facetName, facets)) {
            facetName = type.getDefaultFacetName() + i;
            ++i;
        }
        Facet facet = FacetManager.getInstance((Module)module).createFacet(type, facetName, underlying);
        this.myCreatedFacets.add(facet);
        this.addFacetInfo(facet);
        this.getOrCreateModifiableModel(module).addFacet(facet);
        return facet;
    }

    private boolean facetExists(String facetName, Collection<? extends Facet> facets) {
        for (Facet facet : facets) {
            if (!this.getFacetName(facet).equals(facetName)) continue;
            return true;
        }
        return false;
    }

    public void addFacetInfo(Facet facet) {
        FacetInfo exiting = this.myFacet2Info.get(facet);
        if (exiting != null) {
            LOG.assertTrue(exiting.getName().equals(facet.getName()));
            LOG.assertTrue(exiting.getFacetType().equals(facet.getType()));
            LOG.assertTrue(exiting.getConfiguration().equals(facet.getConfiguration()));
            return;
        }
        FacetInfo info = new FacetInfo(facet.getType(), facet.getName(), facet.getConfiguration(), this.myFacet2Info.get(facet.getUnderlyingFacet()));
        this.myFacet2Info.put(facet, info);
        this.myInfo2Facet.put(info, facet);
        this.getTreeModel(facet.getModule()).addFacetInfo(info);
    }

    public void addFacetInfos(Module module) {
        Facet[] facets;
        for (Facet facet : facets = this.getFacetModel(module).getSortedFacets()) {
            this.addFacetInfo(facet);
        }
    }

    public void clearMaps() {
        this.myModifiableModels.clear();
        this.myEditors.clear();
        this.myTreeModels.clear();
        this.myInfo2Facet.clear();
        this.myFacet2Info.clear();
        this.myChangedFacets.clear();
        this.mySharedModuleData.clear();
    }

    private boolean isNewFacet(Facet facet) {
        ModifiableFacetModel model = this.myModifiableModels.get(facet.getModule());
        return model != null && model.isNewFacet(facet);
    }

    @NotNull
    public ModifiableFacetModel getOrCreateModifiableModel(Module module) {
        ModifiableFacetModel model = this.myModifiableModels.get(module);
        if (model == null) {
            model = FacetManager.getInstance((Module)module).createModifiableModel();
            this.myModifiableModels.put(module, model);
        }
        ModifiableFacetModel modifiableFacetModel = model;
        if (modifiableFacetModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ProjectFacetsConfigurator", "getOrCreateModifiableModel"));
        }
        return modifiableFacetModel;
    }

    @Nullable
    public FacetEditorImpl getEditor(Facet facet) {
        return this.myEditors.get(facet);
    }

    @NotNull
    public FacetEditorImpl getOrCreateEditor(Facet facet) {
        FacetEditorImpl editor = this.myEditors.get(facet);
        if (editor == null) {
            Facet underlyingFacet = facet.getUnderlyingFacet();
            FacetEditorContext parentContext = underlyingFacet != null ? this.getOrCreateEditor(underlyingFacet).getContext() : null;
            FacetEditorContext context = this.createContext(facet, parentContext);
            editor = new FacetEditorImpl(context, facet.getConfiguration());
            editor.getComponent();
            editor.reset();
            this.myEditors.put(facet, editor);
        }
        FacetEditorImpl facetEditorImpl = editor;
        if (facetEditorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ProjectFacetsConfigurator", "getOrCreateEditor"));
        }
        return facetEditorImpl;
    }

    protected FacetEditorContext createContext(@NotNull Facet facet, @Nullable FacetEditorContext parentContext) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/ProjectFacetsConfigurator", "createContext"));
        }
        Module module = facet.getModule();
        ModulesConfigurator modulesConfigurator = this.myContext.getModulesConfigurator();
        ModuleEditor moduleEditor = modulesConfigurator.getModuleEditor(module);
        if (moduleEditor == null) {
            LOG.error("ModuleEditor[" + module.getName() + "]==null: disposed = " + module.isDisposed() + ", is in model = " + Arrays.asList(modulesConfigurator.getModules()).contains(module));
        }
        ModuleConfigurationState state = moduleEditor.createModuleConfigurationState();
        return new MyProjectConfigurableContext(facet, parentContext, state);
    }

    private UserDataHolder getSharedModuleData(Module module) {
        UserDataHolder dataHolder = this.mySharedModuleData.get(module);
        if (dataHolder == null) {
            dataHolder = new UserDataHolderBase();
            this.mySharedModuleData.put(module, dataHolder);
        }
        return dataHolder;
    }

    @NotNull
    public FacetModel getFacetModel(Module module) {
        ModifiableFacetModel model = this.myModifiableModels.get(module);
        if (model != null) {
            ModifiableFacetModel modifiableFacetModel = model;
            if (modifiableFacetModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ProjectFacetsConfigurator", "getFacetModel"));
            }
            return modifiableFacetModel;
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        if (facetManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ProjectFacetsConfigurator", "getFacetModel"));
        }
        return facetManager;
    }

    public void commitFacets() {
        for (ModifiableFacetModel modifiableFacetModel : this.myModifiableModels.values()) {
            modifiableFacetModel.commit();
        }
        for (Map.Entry entry : this.myEditors.entrySet()) {
            ((FacetEditorImpl)((Object)entry.getValue())).onFacetAdded((Facet)entry.getKey());
        }
        this.myModifiableModels.clear();
        for (Facet facet : this.myChangedFacets) {
            Module module = facet.getModule();
            if (module.isDisposed()) continue;
            ((FacetManagerListener)module.getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged(facet);
        }
        this.myChangedFacets.clear();
    }

    public void resetEditors() {
        for (FacetEditorImpl editor : this.myEditors.values()) {
            editor.reset();
        }
    }

    public void applyEditors() throws ConfigurationException {
        for (Map.Entry<Facet, FacetEditorImpl> entry : this.myEditors.entrySet()) {
            FacetEditorImpl editor = entry.getValue();
            if (editor.isModified()) {
                this.myChangedFacets.add(entry.getKey());
            }
            editor.apply();
        }
    }

    public boolean isModified() {
        for (ModifiableFacetModel model : this.myModifiableModels.values()) {
            if (!model.isModified()) continue;
            return true;
        }
        for (FacetEditorImpl editor : this.myEditors.values()) {
            if (!editor.isModified()) continue;
            return true;
        }
        return false;
    }

    public FacetTreeModel getTreeModel(Module module) {
        FacetTreeModel treeModel = this.myTreeModels.get(module);
        if (treeModel == null) {
            treeModel = new FacetTreeModel();
            this.myTreeModels.put(module, treeModel);
        }
        return treeModel;
    }

    public FacetInfo getFacetInfo(Facet facet) {
        return this.myFacet2Info.get(facet);
    }

    public Facet getFacet(FacetInfo facetInfo) {
        return this.myInfo2Facet.get(facetInfo);
    }

    public void disposeEditors() {
        for (Facet facet : this.myFacetsToDispose) {
            Disposer.dispose((Disposable)facet);
        }
        this.myFacetsToDispose.clear();
        this.myCreatedFacets.clear();
        for (FacetEditorImpl editor : this.myEditors.values()) {
            editor.disposeUIResources();
        }
        this.myProjectData = null;
    }

    @NotNull
    public Facet[] getAllFacets(Module module) {
        Facet[] facetArray = this.getFacetModel(module).getAllFacets();
        if (facetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ProjectFacetsConfigurator", "getAllFacets"));
        }
        return facetArray;
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(Module module, FacetTypeId<F> type) {
        Collection collection = this.getFacetModel(module).getFacetsByType(type);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ProjectFacetsConfigurator", "getFacetsByType"));
        }
        return collection;
    }

    @Nullable
    public <F extends Facet> F findFacet(Module module, FacetTypeId<F> type, String name) {
        return (F)this.getFacetModel(module).findFacet(type, name);
    }

    private UserDataHolder getProjectData() {
        if (this.myProjectData == null) {
            this.myProjectData = new UserDataHolderBase();
        }
        return this.myProjectData;
    }

    public String getFacetName(Facet facet) {
        String newName;
        ModifiableFacetModel model = this.myModifiableModels.get(facet.getModule());
        if (model != null && (newName = model.getNewName(facet)) != null) {
            return newName;
        }
        return facet.getName();
    }

    public List<Facet> removeAllFacets(Module module) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        ModifiableFacetModel facetModel = this.getOrCreateModifiableModel(module);
        for (Facet facet : facetModel.getAllFacets()) {
            if (!this.myCreatedFacets.contains(facet)) {
                this.myFacetsToDispose.add(facet);
            }
            LOG.assertTrue(facet.getModule().equals(module), (Object)(module + " expected but " + facet.getModule() + " found"));
            facets.addAll(this.removeFacet(facet));
        }
        this.mySharedModuleData.remove(module);
        this.myModifiableModels.remove(module);
        return facets;
    }

    public boolean hasFacetOfType(Module module, @Nullable Facet parent, FacetTypeId<?> typeId) {
        FacetTreeModel treeModel = this.getTreeModel(module);
        FacetInfo parentInfo = this.getFacetInfo(parent);
        return treeModel.hasFacetOfType(parentInfo, typeId);
    }

    private class MyProjectConfigurableContext
    extends ProjectConfigurableContext {
        private final LibrariesContainer myContainer;

        public MyProjectConfigurableContext(Facet facet, FacetEditorContext parentContext, ModuleConfigurationState state) {
            super(facet, ProjectFacetsConfigurator.this.isNewFacet(facet), parentContext, state, ProjectFacetsConfigurator.this.getSharedModuleData(facet.getModule()), ProjectFacetsConfigurator.this.getProjectData());
            this.myContainer = LibrariesContainerFactory.createContainer(ProjectFacetsConfigurator.this.myContext);
        }

        @Override
        public LibrariesContainer getContainer() {
            return this.myContainer;
        }
    }
}

