/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchComponent;
import com.intellij.find.editorHeaderActions.EditorHeaderAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import java.util.Arrays;

public class RemoveOccurrenceAction
extends EditorHeaderAction
implements DumbAware {
    public RemoveOccurrenceAction(EditorSearchComponent editorSearchComponent) {
        super(editorSearchComponent);
        this.copyFrom(ActionManager.getInstance().getAction("UnselectPreviousOccurrence"));
        this.getTemplatePresentation().setIcon(AllIcons.Actions.RemoveMulticaret);
        this.registerShortcutsForComponent(Arrays.asList(this.getShortcutSet().getShortcuts()), editorSearchComponent.getSearchTextComponent());
    }

    public void actionPerformed(AnActionEvent e) {
        this.myEditorSearchComponent.removeOccurrence();
    }

    public void update(AnActionEvent e) {
        boolean isFind = !this.myEditorSearchComponent.getFindModel().isReplaceState();
        boolean hasMatches = this.myEditorSearchComponent.hasMatches();
        e.getPresentation().setVisible(isFind);
        e.getPresentation().setEnabled(isFind && hasMatches);
    }
}

