/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchComponent;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.editorHeaderActions.EditorHeaderAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class RestorePreviousSettingsAction
extends EditorHeaderAction
implements DumbAware {
    private final JComponent myShortcutHolder;
    private static final KeyboardShortcut SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null);

    public RestorePreviousSettingsAction(EditorSearchComponent editorSearchComponent, JComponent shortcutHolder) {
        super(editorSearchComponent);
        this.myShortcutHolder = shortcutHolder;
        this.registerShortcutsForComponent(Collections.singletonList(SHORTCUT), shortcutHolder);
    }

    public void actionPerformed(AnActionEvent e) {
        FindModel model = FindManager.getInstance((Project)e.getProject()).getPreviousFindModel();
        if (model != null) {
            this.myEditorSearchComponent.getFindModel().copyFrom(model);
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(e.getProject() != null && this.myEditorSearchComponent.getSearchTextComponent().getText().isEmpty() && FindManager.getInstance((Project)e.getProject()).getPreviousFindModel() != null);
    }

    public static String getAd() {
        return "Use " + KeymapUtil.getShortcutText((Shortcut)SHORTCUT) + " to restore previous find/replace settings";
    }
}

