/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchComponent;
import com.intellij.find.editorHeaderActions.EditorHeaderAction;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class ShowHistoryAction
extends EditorHeaderAction
implements DumbAware {
    private final JTextComponent myTextField;

    public ShowHistoryAction(JTextComponent textField, EditorSearchComponent editorSearchComponent) {
        super(editorSearchComponent);
        this.myTextField = textField;
        this.getTemplatePresentation().setIcon(IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/search.png", DarculaTextFieldUI.class, (boolean)true));
        String s = this.myTextField == this.myEditorSearchComponent.getSearchTextComponent() ? "Search" : "Replace";
        this.getTemplatePresentation().setDescription(s + " history");
        this.getTemplatePresentation().setText(s + " History");
        ArrayList<KeyboardShortcut> shortcuts = new ArrayList<KeyboardShortcut>();
        if (this.myTextField == this.myEditorSearchComponent.getSearchTextComponent()) {
            ContainerUtil.addAll(shortcuts, (Object[])ActionManager.getInstance().getAction("IncrementalSearch").getShortcutSet().getShortcuts());
        }
        shortcuts.add(new KeyboardShortcut(KeyStroke.getKeyStroke(72, 128), null));
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts.toArray(new Shortcut[shortcuts.size()])), this.myTextField);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(this.myEditorSearchComponent.getFindModel().isMultiline());
    }

    public void actionPerformed(AnActionEvent e) {
        this.myEditorSearchComponent.showHistory(false, this.myTextField);
    }
}

