/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindClassUsagesDialog;
import com.intellij.find.findUsages.FindMethodUsagesDialog;
import com.intellij.find.findUsages.FindPackageUsagesDialog;
import com.intellij.find.findUsages.FindThrowUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindVariableUsagesDialog;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.JavaNonCodeSearchElementDescriptionProvider;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFindUsagesHandler
extends FindUsagesHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findUsages.JavaFindUsagesHandler");
    protected static final String ACTION_STRING = FindBundle.message("find.super.method.warning.action.verb", new Object[0]);
    private final PsiElement[] myElementsToSearch;
    private final JavaFindUsagesHandlerFactory myFactory;

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull JavaFindUsagesHandlerFactory factory) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/find/findUsages/JavaFindUsagesHandler", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/find/findUsages/JavaFindUsagesHandler", "<init>"));
        }
        this(psiElement, PsiElement.EMPTY_ARRAY, factory);
    }

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull PsiElement[] elementsToSearch, @NotNull JavaFindUsagesHandlerFactory factory) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/find/findUsages/JavaFindUsagesHandler", "<init>"));
        }
        if (elementsToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToSearch", "com/intellij/find/findUsages/JavaFindUsagesHandler", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/find/findUsages/JavaFindUsagesHandler", "<init>"));
        }
        super(psiElement);
        this.myElementsToSearch = elementsToSearch;
        this.myFactory = factory;
    }

    @Override
    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            FindPackageUsagesDialog findPackageUsagesDialog = new FindPackageUsagesDialog(element, this.getProject(), this.myFactory.getFindPackageOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findPackageUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
            }
            return findPackageUsagesDialog;
        }
        if (element instanceof PsiClass) {
            FindClassUsagesDialog findClassUsagesDialog = new FindClassUsagesDialog(element, this.getProject(), this.myFactory.getFindClassOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findClassUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
            }
            return findClassUsagesDialog;
        }
        if (element instanceof PsiMethod) {
            FindMethodUsagesDialog findMethodUsagesDialog = new FindMethodUsagesDialog(element, this.getProject(), this.myFactory.getFindMethodOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findMethodUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
            }
            return findMethodUsagesDialog;
        }
        if (element instanceof PsiVariable) {
            FindVariableUsagesDialog findVariableUsagesDialog = new FindVariableUsagesDialog(element, this.getProject(), this.myFactory.getFindVariableOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findVariableUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
            }
            return findVariableUsagesDialog;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            FindThrowUsagesDialog findThrowUsagesDialog = new FindThrowUsagesDialog(element, this.getProject(), this.myFactory.getFindThrowOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, (FindUsagesHandler)this);
            if (findThrowUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
            }
            return findThrowUsagesDialog;
        }
        AbstractFindUsagesDialog abstractFindUsagesDialog = super.getFindUsagesDialog(isSingleFile, toShowInNewTab, mustOpenInNewTab);
        if (abstractFindUsagesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
        }
        return abstractFindUsagesDialog;
    }

    private static boolean askWhetherShouldSearchForParameterInOverridingMethods(@NotNull PsiElement psiElement, @NotNull PsiParameter parameter) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/find/findUsages/JavaFindUsagesHandler", "askWhetherShouldSearchForParameterInOverridingMethods"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/find/findUsages/JavaFindUsagesHandler", "askWhetherShouldSearchForParameterInOverridingMethods"));
        }
        return Messages.showOkCancelDialog((Project)psiElement.getProject(), (String)FindBundle.message("find.parameter.usages.in.overriding.methods.prompt", parameter.getName()), (String)FindBundle.message("find.parameter.usages.in.overriding.methods.title", new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    private static PsiElement[] getParameterElementsToSearch(@NotNull PsiParameter parameter, @NotNull PsiMethod method) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getParameterElementsToSearch"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getParameterElementsToSearch"));
        }
        PsiMethod[] overrides = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        for (int i = 0; i < overrides.length; ++i) {
            PsiElement navigationElement = overrides[i].getNavigationElement();
            if (!(navigationElement instanceof PsiMethod)) continue;
            overrides[i] = (PsiMethod)navigationElement;
        }
        ArrayList<PsiParameter> elementsToSearch = new ArrayList<PsiParameter>(overrides.length + 1);
        elementsToSearch.add(parameter);
        int idx = method.getParameterList().getParameterIndex(parameter);
        for (PsiMethod override : overrides) {
            PsiParameter[] parameters = override.getParameterList().getParameters();
            if (idx >= parameters.length) continue;
            elementsToSearch.add(parameters[idx]);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(elementsToSearch);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getParameterElementsToSearch"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray;
        PsiMethod method;
        PsiParameter parameter;
        PsiElement scope;
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiParameter && (scope = (parameter = (PsiParameter)element).getDeclarationScope()) instanceof PsiMethod && PsiUtil.canBeOverriden((PsiMethod)(method = (PsiMethod)scope))) {
            boolean hasOverridden;
            PsiClass aClass = method.getContainingClass();
            LOG.assertTrue(aClass != null);
            boolean bl = hasOverridden = OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
            if (hasOverridden && JavaFindUsagesHandler.askWhetherShouldSearchForParameterInOverridingMethods(element, parameter)) {
                PsiElement[] psiElementArray2 = JavaFindUsagesHandler.getParameterElementsToSearch(parameter, method);
                if (psiElementArray2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getPrimaryElements"));
                }
                return psiElementArray2;
            }
        }
        if (this.myElementsToSearch.length == 0) {
            PsiElement[] psiElementArray3 = new PsiElement[1];
            psiElementArray = psiElementArray3;
            psiElementArray3[0] = element;
        } else {
            psiElementArray = this.myElementsToSearch;
        }
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getPrimaryElements"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiElement[] getSecondaryElements() {
        PsiField field;
        PsiClass containingClass;
        PsiElement element = this.getPsiElement();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getSecondaryElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (element instanceof PsiField && (containingClass = (field = (PsiField)element).getContainingClass()) != null) {
            PsiMethod setter;
            String fieldName = field.getName();
            String propertyName = JavaCodeStyleManager.getInstance((Project)this.getProject()).variableNameToPropertyName(fieldName, VariableKind.FIELD);
            THashSet accessors = new THashSet();
            boolean isStatic = field.hasModifierProperty("static");
            PsiMethod getter = PropertyUtil.findPropertyGetterWithType((String)propertyName, (boolean)isStatic, (PsiType)field.getType(), (Iterator)ContainerUtil.iterate((Object[])containingClass.getMethods()));
            if (getter != null) {
                accessors.add(getter);
            }
            if ((setter = PropertyUtil.findPropertySetterWithType((String)propertyName, (boolean)isStatic, (PsiType)field.getType(), (Iterator)ContainerUtil.iterate((Object[])containingClass.getMethods()))) != null) {
                accessors.add(setter);
            }
            accessors.addAll(PropertyUtil.getAccessors((PsiClass)containingClass, (String)fieldName));
            if (!accessors.isEmpty()) {
                boolean doSearch;
                boolean containsPhysical = ContainerUtil.find((Iterable)accessors, (Condition)new Condition<PsiMethod>(){

                    public boolean value(PsiMethod psiMethod) {
                        return psiMethod.isPhysical();
                    }
                }) != null;
                boolean bl = doSearch = !containsPhysical || Messages.showOkCancelDialog((String)FindBundle.message("find.field.accessors.prompt", fieldName), (String)FindBundle.message("find.field.accessors.title", new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
                if (doSearch) {
                    THashSet elements = new THashSet();
                    for (PsiMethod accessor : accessors) {
                        ContainerUtil.addAll((Collection)elements, (Object[])SuperMethodWarningUtil.checkSuperMethods(accessor, ACTION_STRING));
                    }
                    PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)elements);
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getSecondaryElements"));
                    }
                    return psiElementArray;
                }
            }
        }
        PsiElement[] psiElementArray = super.getSecondaryElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getSecondaryElements"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            JavaPackageFindUsagesOptions javaPackageFindUsagesOptions = this.myFactory.getFindPackageOptions();
            if (javaPackageFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
            }
            return javaPackageFindUsagesOptions;
        }
        if (element instanceof PsiClass) {
            JavaClassFindUsagesOptions javaClassFindUsagesOptions = this.myFactory.getFindClassOptions();
            if (javaClassFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
            }
            return javaClassFindUsagesOptions;
        }
        if (element instanceof PsiMethod) {
            JavaMethodFindUsagesOptions javaMethodFindUsagesOptions = this.myFactory.getFindMethodOptions();
            if (javaMethodFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
            }
            return javaMethodFindUsagesOptions;
        }
        if (element instanceof PsiVariable) {
            JavaVariableFindUsagesOptions javaVariableFindUsagesOptions = this.myFactory.getFindVariableOptions();
            if (javaVariableFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
            }
            return javaVariableFindUsagesOptions;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            JavaThrowFindUsagesOptions javaThrowFindUsagesOptions = this.myFactory.getFindThrowOptions();
            if (javaThrowFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
            }
            return javaThrowFindUsagesOptions;
        }
        FindUsagesOptions findUsagesOptions = super.getFindUsagesOptions(dataContext);
        if (findUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
        }
        return findUsagesOptions;
    }

    protected Set<String> getStringsToSearch(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getStringsToSearch"));
        }
        return JavaFindUsagesHelper.getElementNames(element);
    }

    @Override
    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHandler", "processElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHandler", "processElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHandler", "processElementUsages"));
        }
        return JavaFindUsagesHelper.processElementUsages(element, options, processor);
    }

    @Override
    protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/find/findUsages/JavaFindUsagesHandler", "isSearchForTextOccurencesAvailable"));
        }
        return !isSingleFile && new JavaNonCodeSearchElementDescriptionProvider().getElementDescription(psiElement, NonCodeSearchDescriptionLocation.NON_JAVA) != null;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target, @NotNull SearchScope searchScope) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/find/findUsages/JavaFindUsagesHandler", "findReferencesToHighlight"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/findUsages/JavaFindUsagesHandler", "findReferencesToHighlight"));
        }
        if (target instanceof PsiMethod) {
            PsiMethod[] superMethods = ((PsiMethod)target).findDeepestSuperMethods();
            if (superMethods.length == 0) {
                Collection collection = MethodReferencesSearch.search((PsiMethod)((PsiMethod)target), (SearchScope)searchScope, (boolean)true).findAll();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "findReferencesToHighlight"));
                }
                return collection;
            }
            ArrayList<PsiReference> result = new ArrayList<PsiReference>();
            for (PsiMethod superMethod : superMethods) {
                result.addAll(MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)searchScope, (boolean)true).findAll());
            }
            ArrayList<PsiReference> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "findReferencesToHighlight"));
            }
            return arrayList;
        }
        Collection<PsiReference> collection = super.findReferencesToHighlight(target, searchScope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "findReferencesToHighlight"));
        }
        return collection;
    }
}

