/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SaveAndSyncHandlerImpl
extends SaveAndSyncHandler
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SaveAndSyncHandler.class);
    private final Runnable myIdleListener;
    private final PropertyChangeListener myGeneralSettingsListener;
    private final GeneralSettings mySettings;
    private final ProgressManager myProgressManager;
    private final SingleAlarm myRefreshDelayAlarm;
    private final AtomicInteger myBlockSaveOnFrameDeactivationCount;
    private final AtomicInteger myBlockSyncOnFrameActivationCount;
    private volatile long myRefreshSessionId;

    public SaveAndSyncHandlerImpl(@NotNull GeneralSettings generalSettings, @NotNull ProgressManager progressManager, @NotNull FrameStateManager frameStateManager, final @NotNull FileDocumentManager fileDocumentManager) {
        if (generalSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generalSettings", "com/intellij/ide/SaveAndSyncHandlerImpl", "<init>"));
        }
        if (progressManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressManager", "com/intellij/ide/SaveAndSyncHandlerImpl", "<init>"));
        }
        if (frameStateManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameStateManager", "com/intellij/ide/SaveAndSyncHandlerImpl", "<init>"));
        }
        if (fileDocumentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDocumentManager", "com/intellij/ide/SaveAndSyncHandlerImpl", "<init>"));
        }
        this.myRefreshDelayAlarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                if (SaveAndSyncHandlerImpl.this.canSyncOrSave()) {
                    SaveAndSyncHandlerImpl.this.refreshOpenFiles();
                }
                SaveAndSyncHandlerImpl.this.maybeRefresh(ModalityState.NON_MODAL);
            }
        }, 300, this);
        this.myBlockSaveOnFrameDeactivationCount = new AtomicInteger();
        this.myBlockSyncOnFrameActivationCount = new AtomicInteger();
        this.myRefreshSessionId = 0L;
        this.mySettings = generalSettings;
        this.myProgressManager = progressManager;
        this.myIdleListener = new Runnable(){

            @Override
            public void run() {
                if (SaveAndSyncHandlerImpl.this.mySettings.isAutoSaveIfInactive() && SaveAndSyncHandlerImpl.this.canSyncOrSave()) {
                    ((FileDocumentManagerImpl)fileDocumentManager).saveAllDocuments(false);
                }
            }
        };
        IdeEventQueue.getInstance().addIdleListener(this.myIdleListener, this.mySettings.getInactiveTimeout() * 1000);
        this.myGeneralSettingsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/SaveAndSyncHandlerImpl$3", "propertyChange"));
                }
                if ("inactiveTimeout".equals(e.getPropertyName())) {
                    IdeEventQueue eventQueue = IdeEventQueue.getInstance();
                    eventQueue.removeIdleListener(SaveAndSyncHandlerImpl.this.myIdleListener);
                    Integer timeout = (Integer)e.getNewValue();
                    eventQueue.addIdleListener(SaveAndSyncHandlerImpl.this.myIdleListener, timeout * 1000);
                }
            }
        };
        this.mySettings.addPropertyChangeListener(this.myGeneralSettingsListener);
        frameStateManager.addListener(new FrameStateListener(){

            public void onFrameDeactivated() {
                LOG.debug("save(): enter");
                if (SaveAndSyncHandlerImpl.this.canSyncOrSave()) {
                    SaveAndSyncHandlerImpl.this.saveProjectsAndDocuments();
                }
                LOG.debug("save(): exit");
            }

            public void onFrameActivated() {
                if (!ApplicationManager.getApplication().isDisposed() && SaveAndSyncHandlerImpl.this.mySettings.isSyncOnFrameActivation()) {
                    SaveAndSyncHandlerImpl.this.scheduleRefresh();
                }
            }
        });
    }

    public void dispose() {
        RefreshQueue.getInstance().cancelSession(this.myRefreshSessionId);
        this.mySettings.removePropertyChangeListener(this.myGeneralSettingsListener);
        IdeEventQueue.getInstance().removeIdleListener(this.myIdleListener);
    }

    private boolean canSyncOrSave() {
        return !LaterInvocator.isInModalContext() && !this.myProgressManager.hasModalProgressIndicator();
    }

    public void saveProjectsAndDocuments() {
        if (!ApplicationManager.getApplication().isDisposed() && this.mySettings.isSaveOnFrameDeactivation() && this.myBlockSaveOnFrameDeactivationCount.get() == 0) {
            SaveAndSyncHandlerImpl.doSaveDocumentsAndProjectsAndApp();
        }
    }

    public static void doSaveDocumentsAndProjectsAndApp() {
        LOG.debug("saving documents");
        FileDocumentManager.getInstance().saveAllDocuments();
        for (Project project : ProjectManagerEx.getInstanceEx().getOpenProjects()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("saving project: " + project);
            }
            project.save();
        }
        LOG.debug("saving application settings");
        ApplicationManager.getApplication().saveSettings();
    }

    public void scheduleRefresh() {
        this.myRefreshDelayAlarm.cancelAndRequest();
    }

    public void maybeRefresh(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/ide/SaveAndSyncHandlerImpl", "maybeRefresh"));
        }
        if (this.myBlockSyncOnFrameActivationCount.get() == 0 && this.mySettings.isSyncOnFrameActivation()) {
            RefreshQueue queue = RefreshQueue.getInstance();
            queue.cancelSession(this.myRefreshSessionId);
            RefreshSession session = queue.createSession(true, true, null, modalityState);
            session.addAllFiles(ManagingFS.getInstance().getLocalRoots());
            this.myRefreshSessionId = session.getId();
            session.launch();
        }
    }

    public void refreshOpenFiles() {
        ArrayList files = ContainerUtil.newArrayList();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (VirtualFile file : FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
                if (!(file instanceof NewVirtualFile)) continue;
                files.add(file);
            }
        }
        if (!files.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, false, null, (Collection)files);
        }
    }

    public void blockSaveOnFrameDeactivation() {
        LOG.debug("save blocked");
        this.myBlockSaveOnFrameDeactivationCount.incrementAndGet();
    }

    public void unblockSaveOnFrameDeactivation() {
        this.myBlockSaveOnFrameDeactivationCount.decrementAndGet();
        LOG.debug("save unblocked");
    }

    public void blockSyncOnFrameActivation() {
        LOG.debug("sync blocked");
        this.myBlockSyncOnFrameActivationCount.incrementAndGet();
    }

    public void unblockSyncOnFrameActivation() {
        this.myBlockSyncOnFrameActivationCount.decrementAndGet();
        LOG.debug("sync unblocked");
    }
}

