/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.DataManager;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartBrowserPanel {
    private JCheckBox myStartBrowserCheckBox;
    private JComponent myBrowserComboBox;
    private JCheckBox myStartJavaScriptDebuggerCheckBox;
    private TextFieldWithBrowseButton myUrlField;
    private BrowserSelector myBrowserSelector;
    private JPanel myRoot;

    public StartBrowserPanel() {
        this.$$$setupUI$$$();
        this.myStartJavaScriptDebuggerCheckBox.setVisible(JavaScriptDebuggerStarter.Util.hasStarters());
        this.myRoot.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                StartBrowserPanel.this.myRoot.removeAncestorListener((AncestorListener)((Object)this));
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)StartBrowserPanel.this.myRoot));
                if (project == null) {
                    DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

                        public void consume(DataContext context) {
                            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
                            if (project == null) {
                                project = ProjectManager.getInstance().getDefaultProject();
                            }
                            StartBrowserPanel.setupUrlField(StartBrowserPanel.this.myUrlField, project);
                        }
                    });
                } else {
                    StartBrowserPanel.setupUrlField(StartBrowserPanel.this.myUrlField, project);
                }
            }
        });
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myRoot;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/StartBrowserPanel", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public String getUrl() {
        String url = StringUtil.nullize((String)this.myUrlField.getText(), (boolean)true);
        if (url != null && !URLUtil.containsScheme((String)(url = url.trim()))) {
            return VirtualFileManager.constructUrl((String)"http", (String)url);
        }
        return url;
    }

    public void setUrl(@Nullable String url) {
        this.myUrlField.setText(url);
    }

    public boolean isSelected() {
        return this.myStartBrowserCheckBox.isSelected();
    }

    public void setSelected(boolean value) {
        this.myStartBrowserCheckBox.setSelected(value);
    }

    public JCheckBox getStartJavaScriptDebuggerCheckBox() {
        return this.myStartJavaScriptDebuggerCheckBox;
    }

    public BrowserSelector getBrowserSelector() {
        return this.myBrowserSelector;
    }

    private void createUIComponents() {
        this.myBrowserSelector = new BrowserSelector();
        this.myBrowserComboBox = this.myBrowserSelector.getMainComponent();
        if (UIUtil.isUnderAquaLookAndFeel()) {
            this.myBrowserComboBox.setBorder(new EmptyBorder(3, 0, 0, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Url virtualFileToUrl(@NotNull VirtualFile file, @NotNull Project project) {
        PsiFile psiFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/browsers/StartBrowserPanel", "virtualFileToUrl"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/browsers/StartBrowserPanel", "virtualFileToUrl"));
        }
        AccessToken token = ReadAction.start();
        try {
            psiFile = PsiManager.getInstance((Project)project).findFile(file);
        }
        finally {
            token.finish();
        }
        return WebBrowserServiceImpl.getDebuggableUrl((PsiElement)psiFile);
    }

    @NotNull
    public StartBrowserSettings createSettings() {
        StartBrowserSettings browserSettings = new StartBrowserSettings();
        browserSettings.setSelected(this.isSelected());
        browserSettings.setBrowser(this.myBrowserSelector.getSelected());
        browserSettings.setStartJavaScriptDebugger(this.myStartJavaScriptDebuggerCheckBox.isSelected());
        browserSettings.setUrl(this.getUrl());
        StartBrowserSettings startBrowserSettings = browserSettings;
        if (startBrowserSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/StartBrowserPanel", "createSettings"));
        }
        return startBrowserSettings;
    }

    public void setFromSettings(StartBrowserSettings settings) {
        this.setSelected(settings.isSelected());
        this.setUrl(settings.getUrl());
        this.myStartJavaScriptDebuggerCheckBox.setSelected(settings.isStartJavaScriptDebugger());
        this.myBrowserSelector.setSelected(settings.getBrowser());
    }

    public static void setupUrlField(@NotNull TextFieldWithBrowseButton field, final @NotNull Project project) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/ide/browsers/StartBrowserPanel", "setupUrlField"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/browsers/StartBrowserPanel", "setupUrlField"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return HtmlUtil.isHtmlFile(file) || StartBrowserPanel.virtualFileToUrl(file, project) != null;
            }
        };
        descriptor.setTitle(XmlBundle.message((String)"javascript.debugger.settings.choose.file.title", (Object[])new Object[0]));
        descriptor.setDescription(XmlBundle.message((String)"javascript.debugger.settings.choose.file.subtitle", (Object[])new Object[0]));
        descriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        field.addBrowseFolderListener(new TextBrowseFolderListener(descriptor, project){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/ide/browsers/StartBrowserPanel$3", "chosenFileToResultingText"));
                }
                if (chosenFile.isDirectory()) {
                    String string = chosenFile.getPath();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/StartBrowserPanel$3", "chosenFileToResultingText"));
                    }
                    return string;
                }
                Url url = StartBrowserPanel.virtualFileToUrl(chosenFile, project);
                String string = url == null ? chosenFile.getUrl() : url.toDecodedForm();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/StartBrowserPanel$3", "chosenFileToResultingText"));
                }
                return string;
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/XmlBundle").getString("start.browser.border.label.open.browser"), (int)0, (int)0, null, null));
        this.myUrlField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myStartBrowserCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setVerticalTextPosition(0);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/XmlBundle").getString("start.browser.checkbox.start.browser"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComponent jComponent = this.myBrowserComboBox;
        jPanel.add((Component)jComponent, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myStartJavaScriptDebuggerCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/XmlBundle").getString("start.browser.with.js.debugger"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

