/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProjectTreeBuilder
extends AbstractTreeBuilder {
    protected final Project myProject;

    public BaseProjectTreeBuilder(@NotNull Project project, @NotNull JTree tree, @NotNull DefaultTreeModel treeModel, @NotNull AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "<init>"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "<init>"));
        }
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "<init>"));
        }
        if (treeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeStructure", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "<init>"));
        }
        this.init(tree, treeModel, treeStructure, comparator, true);
        this.myProject = project;
    }

    @NotNull
    public AsyncResult<Object> revalidateElement(Object element) {
        final AsyncResult result = new AsyncResult();
        if (element instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)element;
            final Object value = node.getValue();
            final ActionCallback callback = new ActionCallback();
            final VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)ObjectUtils.tryCast((Object)value, PsiElement.class)));
            final FocusRequestor focusRequestor = IdeFocusManager.getInstance((Project)this.myProject).getFurtherRequestor();
            this.batch(new Progressive(){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/projectView/BaseProjectTreeBuilder$1", "run"));
                    }
                    final Ref target = new Ref();
                    BaseProjectTreeBuilder.this._select(value, virtualFile, false, (Condition<AbstractTreeNode>)Conditions.alwaysTrue(), callback, indicator, (Ref<Object>)target, focusRequestor, false);
                    callback.doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            result.setDone(target.get());
                        }
                    }).doWhenRejected(new Runnable(){

                        @Override
                        public void run() {
                            result.setRejected();
                        }
                    });
                }
            });
        } else {
            result.setRejected();
        }
        AsyncResult asyncResult = result;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "revalidateElement"));
        }
        return asyncResult;
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((AbstractTreeNode)nodeDescriptor).isAlwaysShowPlus();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getParentDescriptor() == null || ((AbstractTreeNode)nodeDescriptor).isAlwaysExpand();
    }

    protected final void expandNodeChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandNodeChildren"));
        }
        NodeDescriptor userObject = (NodeDescriptor)node.getUserObject();
        if (userObject == null) {
            return;
        }
        Object element = userObject.getElement();
        VirtualFile virtualFile = BaseProjectTreeBuilder.getFileToRefresh(element);
        super.expandNodeChildren(node);
        if (virtualFile != null) {
            virtualFile.refresh(true, false);
        }
    }

    private static VirtualFile getFileToRefresh(Object element) {
        Object object = element;
        if (element instanceof AbstractTreeNode) {
            object = ((AbstractTreeNode)element).getValue();
        }
        return object instanceof PsiDirectory ? ((PsiDirectory)object).getVirtualFile() : (object instanceof PsiFile ? ((PsiFile)object).getVirtualFile() : null);
    }

    @NotNull
    private static List<AbstractTreeNode> collectChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "collectChildren"));
        }
        int childCount = node.getChildCount();
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>(childCount);
        for (int i = 0; i < childCount; ++i) {
            AbstractTreeNode treeNode;
            TreeNode childAt = node.getChildAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)childAt;
            if (defaultMutableTreeNode.getUserObject() instanceof AbstractTreeNode) {
                treeNode = (AbstractTreeNode)defaultMutableTreeNode.getUserObject();
                result.add(treeNode);
                continue;
            }
            if (!(defaultMutableTreeNode.getUserObject() instanceof FavoritesTreeNodeDescriptor)) continue;
            treeNode = ((FavoritesTreeNodeDescriptor)((Object)defaultMutableTreeNode.getUserObject())).getElement();
            result.add(treeNode);
        }
        ArrayList<AbstractTreeNode> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "collectChildren"));
        }
        return arrayList;
    }

    @NotNull
    public ActionCallback select(Object element, VirtualFile file, boolean requestFocus) {
        ActionCallback actionCallback = this._select(element, file, requestFocus, (Condition<AbstractTreeNode>)Conditions.alwaysTrue());
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "select"));
        }
        return actionCallback;
    }

    public ActionCallback selectInWidth(Object element, boolean requestFocus, Condition<AbstractTreeNode> nonStopCondition) {
        return this._select(element, null, requestFocus, nonStopCondition);
    }

    @NotNull
    private ActionCallback _select(final Object element, final VirtualFile file, final boolean requestFocus, final Condition<AbstractTreeNode> nonStopCondition) {
        final ActionCallback result = new ActionCallback();
        final FocusRequestor requestor = IdeFocusManager.getInstance((Project)this.myProject).getFurtherRequestor();
        UiActivityMonitor.getInstance().addActivity(this.myProject, (UiActivity)new UiActivity.AsyncBgOperation("projectViewSelect"), this.getUpdater().getModalityState());
        this.cancelUpdate().doWhenDone(new Runnable(){

            @Override
            public void run() {
                BaseProjectTreeBuilder.this.batch(new Progressive(){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/projectView/BaseProjectTreeBuilder$2$1", "run"));
                        }
                        BaseProjectTreeBuilder.this._select(element, file, requestFocus, (Condition<AbstractTreeNode>)nonStopCondition, result, indicator, (Ref<Object>)null, requestor, false);
                        UiActivityMonitor.getInstance().removeActivity(BaseProjectTreeBuilder.this.myProject, (UiActivity)new UiActivity.AsyncBgOperation("projectViewSelect"));
                    }
                });
            }
        });
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "_select"));
        }
        return actionCallback;
    }

    private void _select(Object element, final VirtualFile file, final boolean requestFocus, final Condition<AbstractTreeNode> nonStopCondition, final ActionCallback result, final @NotNull ProgressIndicator indicator, final @Nullable Ref<Object> virtualSelectTarget, final FocusRequestor focusRequestor, final boolean isSecondAttempt) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "_select"));
        }
        AbstractTreeNode alreadySelected = this.alreadySelectedNode(element);
        final Runnable onDone = new Runnable(){

            @Override
            public void run() {
                if (requestFocus && virtualSelectTarget == null && BaseProjectTreeBuilder.this.getUi().isReady()) {
                    focusRequestor.requestFocus((Component)BaseProjectTreeBuilder.this.getTree(), true);
                }
                result.setDone();
            }
        };
        Condition<AbstractTreeNode> condition = new Condition<AbstractTreeNode>(){

            public boolean value(AbstractTreeNode abstractTreeNode) {
                return !result.isProcessed() && nonStopCondition.value((Object)abstractTreeNode);
            }
        };
        if (alreadySelected == null) {
            this.expandPathTo(file, (AbstractTreeNode)this.getTreeStructure().getRootElement(), element, condition, indicator, virtualSelectTarget).doWhenDone((Consumer)new Consumer<AbstractTreeNode>(){

                public void consume(AbstractTreeNode node) {
                    if (virtualSelectTarget == null) {
                        BaseProjectTreeBuilder.this.select(node, onDone);
                    } else {
                        onDone.run();
                    }
                }
            }).doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    if (isSecondAttempt) {
                        result.setRejected();
                    } else {
                        BaseProjectTreeBuilder.this._select(file, file, requestFocus, (Condition<AbstractTreeNode>)nonStopCondition, result, indicator, (Ref<Object>)virtualSelectTarget, focusRequestor, true);
                    }
                }
            });
        } else if (virtualSelectTarget == null && this.getTree().getSelectionPaths().length == 1) {
            this.select(alreadySelected, onDone);
        } else {
            onDone.run();
        }
    }

    private AbstractTreeNode alreadySelectedNode(Object element) {
        TreePath[] selectionPaths = this.getTree().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return null;
        }
        for (TreePath selectionPath : selectionPaths) {
            Object selected = selectionPath.getLastPathComponent();
            if (!BaseProjectTreeBuilder.elementIsEqualTo(selected, element)) continue;
            return (AbstractTreeNode)((DefaultMutableTreeNode)selected).getUserObject();
        }
        return null;
    }

    private static boolean elementIsEqualTo(Object node, Object element) {
        Object userObject;
        if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof ProjectViewNode) {
            ProjectViewNode projectViewNode = (ProjectViewNode)userObject;
            return projectViewNode.canRepresent(element);
        }
        return false;
    }

    @NotNull
    private AsyncResult<AbstractTreeNode> expandPathTo(final VirtualFile file, final @NotNull AbstractTreeNode root, final Object element, final @NotNull Condition<AbstractTreeNode> nonStopCondition, final @NotNull ProgressIndicator indicator, final @Nullable Ref<Object> target) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandPathTo"));
        }
        if (nonStopCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonStopCondition", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandPathTo"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandPathTo"));
        }
        final AsyncResult async = new AsyncResult();
        if (root.canRepresent(element)) {
            if (target == null) {
                this.expand(root, new Runnable(){

                    @Override
                    public void run() {
                        async.setDone((Object)root);
                    }
                });
            } else {
                target.set((Object)root);
                async.setDone((Object)root);
            }
            AsyncResult asyncResult = async;
            if (asyncResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandPathTo"));
            }
            return asyncResult;
        }
        if (root instanceof ProjectViewNode && file != null && !((ProjectViewNode)root).contains(file)) {
            async.setRejected();
            AsyncResult asyncResult = async;
            if (asyncResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandPathTo"));
            }
            return asyncResult;
        }
        if (target == null) {
            this.expand(root, new Runnable(){

                @Override
                public void run() {
                    indicator.checkCanceled();
                    DefaultMutableTreeNode rootNode = BaseProjectTreeBuilder.this.getNodeForElement(root);
                    if (rootNode != null) {
                        List kids = BaseProjectTreeBuilder.collectChildren(rootNode);
                        BaseProjectTreeBuilder.this.expandChild(kids, 0, (Condition<AbstractTreeNode>)nonStopCondition, file, element, (AsyncResult<AbstractTreeNode>)async, indicator, (Ref<Object>)target);
                    } else {
                        async.setRejected();
                    }
                }
            });
        } else if (indicator.isCanceled()) {
            async.setRejected();
        } else {
            DefaultMutableTreeNode rootNode = this.getNodeForElement(root);
            final ArrayList<AbstractTreeNode> kids = new ArrayList<AbstractTreeNode>();
            if (rootNode != null && this.getTree().isExpanded(new TreePath(rootNode.getPath()))) {
                kids.addAll(BaseProjectTreeBuilder.collectChildren(rootNode));
            } else {
                List<Object> list = Arrays.asList(this.getTreeStructure().getChildElements((Object)root));
                for (Object each : list) {
                    kids.add((AbstractTreeNode)each);
                }
            }
            this.yield(new Runnable(){

                @Override
                public void run() {
                    if (BaseProjectTreeBuilder.this.isDisposed()) {
                        return;
                    }
                    BaseProjectTreeBuilder.this.expandChild(kids, 0, (Condition<AbstractTreeNode>)nonStopCondition, file, element, (AsyncResult<AbstractTreeNode>)async, indicator, (Ref<Object>)target);
                }
            });
        }
        AsyncResult asyncResult = async;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandPathTo"));
        }
        return asyncResult;
    }

    private void expandChild(final @NotNull List<AbstractTreeNode> kids, int i, final @NotNull Condition<AbstractTreeNode> nonStopCondition, final VirtualFile file, final Object element, final @NotNull AsyncResult<AbstractTreeNode> async, final @NotNull ProgressIndicator indicator, final Ref<Object> virtualSelectTarget) {
        if (kids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kids", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandChild"));
        }
        if (nonStopCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonStopCondition", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandChild"));
        }
        if (async == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "async", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandChild"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "expandChild"));
        }
        while (i < kids.size()) {
            final AbstractTreeNode eachKid = kids.get(i);
            final boolean[] nodeWasCollapsed = new boolean[]{true};
            DefaultMutableTreeNode nodeForElement = this.getNodeForElement(eachKid);
            if (nodeForElement != null) {
                nodeWasCollapsed[0] = this.getTree().isCollapsed(new TreePath(nodeForElement.getPath()));
            }
            if (!nonStopCondition.value((Object)eachKid)) break;
            AsyncResult<AbstractTreeNode> result = this.expandPathTo(file, eachKid, element, nonStopCondition, indicator, virtualSelectTarget);
            result.doWhenDone((Consumer)new Consumer<AbstractTreeNode>(){

                public void consume(AbstractTreeNode abstractTreeNode) {
                    indicator.checkCanceled();
                    async.setDone((Object)abstractTreeNode);
                }
            });
            if (!result.isProcessed()) {
                final int next = i + 1;
                result.doWhenRejected(new Runnable(){

                    @Override
                    public void run() {
                        indicator.checkCanceled();
                        if (nodeWasCollapsed[0] && virtualSelectTarget == null) {
                            BaseProjectTreeBuilder.this.collapseChildren(eachKid, null);
                        }
                        BaseProjectTreeBuilder.this.expandChild(kids, next, (Condition<AbstractTreeNode>)nonStopCondition, file, element, (AsyncResult<AbstractTreeNode>)async, indicator, (Ref<Object>)virtualSelectTarget);
                    }
                });
                return;
            }
            if (result.isRejected()) {
                indicator.checkCanceled();
                if (nodeWasCollapsed[0] && virtualSelectTarget == null) {
                    this.collapseChildren(eachKid, null);
                }
                ++i;
                continue;
            }
            return;
        }
        async.setRejected();
    }

    protected boolean validateNode(Object child) {
        if (child == null) {
            return false;
        }
        if (child instanceof ProjectViewNode) {
            ProjectViewNode projectViewNode = (ProjectViewNode)child;
            return projectViewNode.validate();
        }
        return true;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        StatusBarProgress statusBarProgress = new StatusBarProgress();
        if (statusBarProgress == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/BaseProjectTreeBuilder", "createProgressIndicator"));
        }
        return statusBarProgress;
    }
}

