/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.actions.MoveModulesToGroupAction;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PlatformIcons;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleGroupNode
extends ProjectViewNode<ModuleGroup>
implements DropTargetNode {
    public ModuleGroupNode(Project project, ModuleGroup value, ViewSettings viewSettings) {
        super(project, (Object)value, viewSettings);
    }

    public ModuleGroupNode(Project project, Object value, ViewSettings viewSettings) {
        this(project, (ModuleGroup)value, viewSettings);
    }

    protected abstract AbstractTreeNode createModuleNode(Module var1) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    protected abstract ModuleGroupNode createModuleGroupNode(ModuleGroup var1);

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Collection<ModuleGroup> childGroups = ((ModuleGroup)this.getValue()).childGroups(this.getProject());
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (ModuleGroup moduleGroup : childGroups) {
            result.add((AbstractTreeNode)this.createModuleGroupNode(moduleGroup));
        }
        Collection<Module> modules = ((ModuleGroup)this.getValue()).modulesInGroup(this.getProject(), false);
        try {
            for (Module module : modules) {
                result.add(this.createModuleNode(module));
            }
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        ArrayList<AbstractTreeNode> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/ModuleGroupNode", "getChildren"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Collection<AbstractTreeNode> children = this.getChildren();
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (AbstractTreeNode each : children) {
            if (!(each instanceof ProjectViewNode)) continue;
            result.addAll(((ProjectViewNode)each).getRoots());
        }
        HashSet<VirtualFile> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/ModuleGroupNode", "getRoots"));
        }
        return hashSet;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/ModuleGroupNode", "contains"));
        }
        return this.someChildContainsFile(file, false);
    }

    public void update(PresentationData presentation) {
        String[] groupPath = ((ModuleGroup)this.getValue()).getGroupPath();
        presentation.setPresentableText(groupPath[groupPath.length - 1]);
        presentation.setIcon(PlatformIcons.CLOSED_MODULE_GROUP_ICON);
    }

    public String getTestPresentation() {
        return "Group: " + this.getValue();
    }

    public String getToolTip() {
        return IdeBundle.message((String)"tooltip.module.group", (Object[])new Object[0]);
    }

    public int getWeight() {
        return 0;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 1;
    }

    @Override
    public boolean canDrop(TreeNode[] sourceNodes) {
        List<Module> modules = ModuleGroupNode.extractModules(sourceNodes);
        return !modules.isEmpty();
    }

    @Override
    public void drop(TreeNode[] sourceNodes, DataContext dataContext) {
        List<Module> modules = ModuleGroupNode.extractModules(sourceNodes);
        MoveModulesToGroupAction.doMove(modules.toArray(new Module[modules.size()]), (ModuleGroup)this.getValue(), null);
    }

    @Override
    public void dropExternalFiles(PsiFileSystemItem[] sourceFileArray, DataContext dataContext) {
    }

    private static List<Module> extractModules(TreeNode[] sourceNodes) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (TreeNode sourceNode : sourceNodes) {
            Object userObject;
            if (!(sourceNode instanceof DefaultMutableTreeNode) || !((userObject = AbstractProjectViewPane.extractUserObject((DefaultMutableTreeNode)sourceNode)) instanceof Module)) continue;
            modules.add((Module)userObject);
        }
        return modules;
    }
}

