/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.EditorTextField;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class GenerateVisitorByHierarchyAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        PsiPackage aPackage;
        final Ref visitorNameRef = Ref.create((Object)"MyVisitor");
        final Ref parentClassRef = Ref.create(null);
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        final PsiNameHelper helper = PsiNameHelper.getInstance((Project)project);
        PackageChooserDialog dialog = new PackageChooserDialog("Choose Target Package and Hierarchy Root Class", project){

            protected ValidationInfo doValidate() {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                if (!helper.isQualifiedName((String)visitorNameRef.get())) {
                    return new ValidationInfo("Visitor class name is not valid");
                }
                if (parentClassRef.isNull()) {
                    return new ValidationInfo("Hierarchy root class should be specified");
                }
                if (((PsiClass)parentClassRef.get()).isAnnotationType() || ((PsiClass)parentClassRef.get()).isEnum()) {
                    return new ValidationInfo("Hierarchy root class should be an interface or a class");
                }
                return super.doValidate();
            }

            @Override
            protected JComponent createCenterPanel() {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)super.createCenterPanel(), "Center");
                panel.add((Component)this.createNamePanel(), "North");
                panel.add((Component)this.createBaseClassPanel(), "South");
                return panel;
            }

            private JComponent createNamePanel() {
                LabeledComponent labeledComponent = new LabeledComponent();
                labeledComponent.setText("Visitor class");
                final JTextField nameField = new JTextField((String)visitorNameRef.get());
                labeledComponent.setComponent((JComponent)nameField);
                nameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

                    protected void textChanged(javax.swing.event.DocumentEvent e) {
                        visitorNameRef.set((Object)nameField.getText());
                    }
                });
                return labeledComponent;
            }

            private JComponent createBaseClassPanel() {
                LabeledComponent labeledComponent = new LabeledComponent();
                labeledComponent.setText("Hierarchy root class");
                JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
                final PsiTypeCodeFragment codeFragment = factory.createTypeCodeFragment("", null, true, 1);
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)codeFragment);
                EditorTextField editorTextField = new EditorTextField(document, project, (FileType)StdFileTypes.JAVA);
                labeledComponent.setComponent((JComponent)((Object)editorTextField));
                editorTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

                    public void documentChanged(DocumentEvent e) {
                        parentClassRef.set(null);
                        try {
                            PsiType psiType = codeFragment.getType();
                            PsiClass psiClass = psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
                            parentClassRef.set((Object)psiClass);
                        }
                        catch (PsiTypeCodeFragment.IncorrectTypeException incorrectTypeException) {
                            // empty catch block
                        }
                    }
                });
                return labeledComponent;
            }
        };
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(e.getDataContext());
        if (element instanceof PsiPackage) {
            dialog.selectPackage(((PsiPackage)element).getQualifiedName());
        } else if (element instanceof PsiDirectory && (aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) != null) {
            dialog.selectPackage(aPackage.getQualifiedName());
        }
        dialog.show();
        if (dialog.getExitCode() != 0 || dialog.getSelectedPackage() == null || dialog.getSelectedPackage().getQualifiedName().length() == 0 || parentClassRef.isNull()) {
            return;
        }
        String visitorQName = GenerateVisitorByHierarchyAction.generateEverything(dialog.getSelectedPackage(), (PsiClass)parentClassRef.get(), (String)visitorNameRef.get());
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
        PsiClass visitorClass = JavaPsiFacade.getInstance((Project)project).findClass(visitorQName, GlobalSearchScope.projectScope((Project)project));
        if (ideView != null && visitorClass != null) {
            ideView.selectElement((PsiElement)visitorClass);
        }
    }

    public static String generateEverything(PsiPackage psiPackage, PsiClass rootClass, String visitorName) {
        String visitorQName = PsiNameHelper.getShortClassName((String)visitorName).equals(visitorName) ? psiPackage.getQualifiedName() + "." + visitorName : visitorName;
        PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage(rootClass.getProject(), StringUtil.getPackageName((String)visitorQName), null, false);
        GenerateVisitorByHierarchyAction.generateVisitorClass(visitorQName, rootClass, directory, (GlobalSearchScope)new PackageScope(psiPackage, false, false));
        return visitorQName;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PROJECT) != null);
    }

    private static void generateVisitorClass(final String visitorName, PsiClass baseClass, final PsiDirectory directory, GlobalSearchScope scope) {
        final THashMap classes = new THashMap();
        for (Object aClass : ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true).findAll()) {
            if (aClass.hasModifierProperty("abstract") != baseClass.hasModifierProperty("abstract")) continue;
            List implementors = ContainerUtil.findAll((Collection)ClassInheritorsSearch.search((PsiClass)aClass).findAll(), (Condition)new Condition<PsiClass>(){

                public boolean value(PsiClass psiClass) {
                    return !psiClass.hasModifierProperty("abstract");
                }
            });
            classes.put(aClass, (Object)new THashSet((Collection)implementors));
        }
        final THashMap pathMap = new THashMap();
        for (Object aClass : classes.keySet()) {
            LinkedHashSet<PsiClass> superClasses = new LinkedHashSet<PsiClass>();
            for (PsiClass superClass : aClass.getSupers()) {
                if (!superClass.isInheritor(baseClass, true)) continue;
                superClasses.add(superClass);
                Set superImplementors = (Set)classes.get((Object)superClass);
                if (superImplementors == null) continue;
                superImplementors.removeAll((Collection)classes.get(aClass));
            }
            if (superClasses.isEmpty()) {
                superClasses.add(baseClass);
            }
            pathMap.put(aClass, superClasses);
        }
        pathMap.put((Object)baseClass, Collections.emptySet());
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (Set implementors : classes.values()) {
            for (PsiClass psiClass : implementors) {
                psiFiles.add(psiClass.getContainingFile());
            }
        }
        Project project = baseClass.getProject();
        final PsiClass visitorClass = JavaPsiFacade.getInstance((Project)project).findClass(visitorName, GlobalSearchScope.projectScope((Project)project));
        if (visitorClass != null) {
            psiFiles.add(visitorClass.getContainingFile());
        }
        final int finalDetectedPrefix = GenerateVisitorByHierarchyAction.detectClassPrefix(classes.keySet()).length();
        new WriteCommandAction(project, PsiUtilCore.toPsiFileArray(psiFiles)){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/internal/GenerateVisitorByHierarchyAction$3", "run"));
                }
                if (visitorClass == null) {
                    String shortClassName = PsiNameHelper.getShortClassName((String)visitorName);
                    if (directory != null) {
                        PsiClass visitorClass2 = JavaDirectoryService.getInstance().createClass(directory, shortClassName);
                        GenerateVisitorByHierarchyAction.generateVisitorClass(visitorClass2, (Map)classes, (THashMap<PsiClass, Set<PsiClass>>)pathMap, finalDetectedPrefix);
                    }
                } else {
                    GenerateVisitorByHierarchyAction.generateVisitorClass(visitorClass, (Map)classes, (THashMap<PsiClass, Set<PsiClass>>)pathMap, finalDetectedPrefix);
                }
            }

            protected boolean isGlobalUndoAction() {
                return true;
            }
        }.execute();
    }

    @NotNull
    private static String detectClassPrefix(Collection<PsiClass> classes) {
        String detectedPrefix = "";
        SmartList range = new SmartList();
        for (PsiClass aClass : classes) {
            String className = aClass.getName();
            SelectWordUtil.addWordSelection(true, className, 0, (List<TextRange>)range);
            TextRange prefixRange = (TextRange)ContainerUtil.getFirstItem((List)range);
            if (prefixRange != null) {
                String prefix = prefixRange.substring(className);
                String string = detectedPrefix == "" ? prefix : (detectedPrefix = detectedPrefix.equals(prefix) ? detectedPrefix : null);
            }
            if (detectedPrefix != null) continue;
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/GenerateVisitorByHierarchyAction", "detectClassPrefix"));
            }
            return "";
        }
        String string = detectedPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/GenerateVisitorByHierarchyAction", "detectClassPrefix"));
        }
        return string;
    }

    private static void generateVisitorClass(PsiClass visitorClass, Map<PsiClass, Set<PsiClass>> classes, THashMap<PsiClass, Set<PsiClass>> pathMap, int classPrefix) throws Throwable {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)visitorClass.getProject()).getElementFactory();
        for (PsiClass psiClass : classes.keySet()) {
            PsiMethod method = elementFactory.createMethodFromText("public void accept(final " + visitorClass.getQualifiedName() + " visitor) { visitor.visit" + psiClass.getName().substring(classPrefix) + "(this); }", (PsiElement)psiClass);
            for (PsiClass implementor : classes.get(psiClass)) {
                GenerateVisitorByHierarchyAction.addOrReplaceMethod(method, implementor);
            }
        }
        THashSet visitedClasses = new THashSet();
        LinkedList<PsiClass> toProcess = new LinkedList<PsiClass>(classes.keySet());
        while (!toProcess.isEmpty()) {
            PsiClass psiClass = toProcess.removeFirst();
            if (!visitedClasses.add((Object)psiClass)) continue;
            Set pathClasses = (Set)pathMap.get((Object)psiClass);
            toProcess.addAll(pathClasses);
            StringBuilder methodText = new StringBuilder();
            methodText.append("public void visit").append(psiClass.getName().substring(classPrefix)).append("(final ").append(psiClass.getQualifiedName()).append(" o) {");
            boolean first = true;
            for (PsiClass pathClass : pathClasses) {
                if (first) {
                    first = false;
                } else {
                    methodText.append("// ");
                }
                methodText.append("visit").append(pathClass.getName().substring(classPrefix)).append("(o);\n");
            }
            methodText.append("}");
            PsiMethod method = elementFactory.createMethodFromText(methodText.toString(), (PsiElement)psiClass);
            GenerateVisitorByHierarchyAction.addOrReplaceMethod(method, visitorClass);
        }
    }

    private static void addOrReplaceMethod(PsiMethod method, PsiClass implementor) throws IncorrectOperationException {
        PsiMethod accept = implementor.findMethodBySignature(method, false);
        if (accept != null) {
            accept.replace((PsiElement)method);
        } else {
            GenerateMembersUtil.insertMembersAtOffset(implementor.getContainingFile(), implementor.getLastChild().getTextOffset(), Collections.singletonList(new PsiGenerationInfo<PsiMethod>(method)));
        }
    }
}

