/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.notification.EventLog;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ClickListener;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeNotificationArea
extends JLabel
implements CustomStatusBarWidget,
IconLikeCustomStatusBarWidget {
    public static final String WIDGET_ID = "Notifications";
    private StatusBar myStatusBar;

    public IdeNotificationArea() {
        UISettings.getInstance().addUISettingsListener(new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                IdeNotificationArea.this.updateStatus();
            }
        }, (Disposable)this);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/notification/impl/IdeNotificationArea$2", "onClick"));
                }
                EventLog.toggleLog(IdeNotificationArea.this.getProject(), null);
                return true;
            }
        }.installOn((Component)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(LogModel.LOG_MODEL_CHANGED, (Object)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeNotificationArea.this.updateStatus();
                    }
                });
            }
        });
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/notification/impl/IdeNotificationArea", "getPresentation"));
        }
        return null;
    }

    public void dispose() {
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/notification/impl/IdeNotificationArea", "install"));
        }
        this.myStatusBar = statusBar;
        this.updateStatus();
    }

    @Nullable
    private Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myStatusBar));
    }

    @NotNull
    public String ID() {
        if (WIDGET_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/IdeNotificationArea", "ID"));
        }
        return WIDGET_ID;
    }

    private void updateStatus() {
        Project project = this.getProject();
        ArrayList<Notification> notifications = EventLog.getLogModel(project).getNotifications();
        this.applyIconToStatusAndToolWindow(project, this.createIconWithNotificationCount(notifications));
        int count = notifications.size();
        this.setToolTipText(count > 0 ? String.format("%s notification%s pending", count, count == 1 ? "" : "s") : "No new notifications");
        this.myStatusBar.updateWidget(this.ID());
    }

    private void applyIconToStatusAndToolWindow(Project project, LayeredIcon icon) {
        if (UISettings.getInstance().HIDE_TOOL_STRIPES || UISettings.getInstance().PRESENTATION_MODE) {
            this.setVisible(true);
            this.setIcon((Icon)icon);
        } else {
            ToolWindow eventLog = EventLog.getEventLog(project);
            if (eventLog != null) {
                eventLog.setIcon((Icon)icon);
            }
            this.setVisible(false);
        }
    }

    private LayeredIcon createIconWithNotificationCount(ArrayList<Notification> notifications) {
        LayeredIcon icon = new LayeredIcon(2);
        Icon statusIcon = IdeNotificationArea.getPendingNotificationsIcon(AllIcons.Ide.Notifications, IdeNotificationArea.getMaximumType(notifications));
        icon.setIcon(statusIcon, 0);
        if (notifications.size() > 0) {
            icon.setIcon((Icon)new TextIcon(this, String.valueOf(notifications.size())), 1, statusIcon.getIconWidth() - 2, 0);
        }
        return icon;
    }

    public JComponent getComponent() {
        return this;
    }

    private static Icon getPendingNotificationsIcon(Icon defIcon, NotificationType maximumType) {
        if (maximumType != null) {
            switch (maximumType) {
                case WARNING: {
                    return AllIcons.Ide.Warning_notifications;
                }
                case ERROR: {
                    return AllIcons.Ide.Error_notifications;
                }
                case INFORMATION: {
                    return AllIcons.Ide.Info_notifications;
                }
            }
        }
        return defIcon;
    }

    @Nullable
    private static NotificationType getMaximumType(List<Notification> notifications) {
        NotificationType result = null;
        for (Notification notification : notifications) {
            if (NotificationType.ERROR == notification.getType()) {
                return NotificationType.ERROR;
            }
            if (NotificationType.WARNING == notification.getType()) {
                result = NotificationType.WARNING;
                continue;
            }
            if (result != null || NotificationType.INFORMATION != notification.getType()) continue;
            result = NotificationType.INFORMATION;
        }
        return result;
    }

    private static class TextIcon
    implements Icon {
        private final String myStr;
        private final JComponent myComponent;
        private final int myWidth;

        public TextIcon(JComponent component, @NotNull String str) {
            if (str == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/notification/impl/IdeNotificationArea$TextIcon", "<init>"));
            }
            this.myStr = str;
            this.myComponent = component;
            this.myWidth = this.myComponent.getFontMetrics(this.calcFont()).stringWidth(this.myStr) + 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TextIcon)) {
                return false;
            }
            TextIcon icon = (TextIcon)o;
            if (this.myWidth != icon.myWidth) {
                return false;
            }
            if (!this.myComponent.equals(icon.myComponent)) {
                return false;
            }
            return this.myStr.equals(icon.myStr);
        }

        public int hashCode() {
            int result = this.myStr.hashCode();
            result = 31 * result + this.myComponent.hashCode();
            result = 31 * result + this.myWidth;
            return result;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            UISettings.setupAntialiasing((Graphics)g);
            Font originalFont = g.getFont();
            Color originalColor = g.getColor();
            g.setFont(this.calcFont());
            g.setColor(UIUtil.getLabelForeground());
            g.drawString(this.myStr, x, y += this.getIconHeight() - g.getFontMetrics().getDescent());
            g.setFont(originalFont);
            g.setColor(originalColor);
        }

        private Font calcFont() {
            return this.myComponent.getFont().deriveFont(1).deriveFont((float)this.getIconHeight() * 3.0f / 5.0f);
        }

        @Override
        public int getIconWidth() {
            return this.myWidth;
        }

        @Override
        public int getIconHeight() {
            return AllIcons.Ide.Notifications.getIconHeight();
        }
    }
}

