/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.TransferToEDTQueue;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class TransferToPooledThreadQueue<T>
extends TransferToEDTQueue<T> {
    private final Executor myExecutor;

    public TransferToPooledThreadQueue(@NonNls @NotNull String name, @NotNull Condition<?> shutUpCondition, int maxUnitOfWorkThresholdMs, @NotNull Processor<T> processor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/application/impl/TransferToPooledThreadQueue", "<init>"));
        }
        if (shutUpCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shutUpCondition", "com/intellij/openapi/application/impl/TransferToPooledThreadQueue", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/application/impl/TransferToPooledThreadQueue", "<init>"));
        }
        super(name, processor, shutUpCondition, maxUnitOfWorkThresholdMs);
        this.myExecutor = new BoundedTaskExecutor((Executor)PooledThreadExecutor.INSTANCE, 1);
    }

    protected void schedule(@NotNull Runnable updateRunnable) {
        if (updateRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateRunnable", "com/intellij/openapi/application/impl/TransferToPooledThreadQueue", "schedule"));
        }
        this.myExecutor.execute(updateRunnable);
    }
}

