/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.ex.ComponentManagerEx;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class ServiceManagerImpl
implements BaseComponent {
    private static final Logger LOG = Logger.getInstance(ServiceManagerImpl.class);
    private static final ExtensionPointName<ServiceDescriptor> APP_SERVICES = new ExtensionPointName("com.intellij.applicationService");
    private static final ExtensionPointName<ServiceDescriptor> PROJECT_SERVICES = new ExtensionPointName("com.intellij.projectService");
    private ExtensionPointName<ServiceDescriptor> myExtensionPointName;
    private ExtensionPointListener<ServiceDescriptor> myExtensionPointListener;

    public ServiceManagerImpl() {
        this.installEP(APP_SERVICES, (ComponentManager)ApplicationManager.getApplication());
    }

    public ServiceManagerImpl(Project project) {
        this.installEP(PROJECT_SERVICES, (ComponentManager)project);
    }

    protected ServiceManagerImpl(boolean ignoreInit) {
    }

    protected void installEP(@NotNull ExtensionPointName<ServiceDescriptor> pointName, final @NotNull ComponentManager componentManager) {
        if (pointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointName", "com/intellij/openapi/components/impl/ServiceManagerImpl", "installEP"));
        }
        if (componentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "com/intellij/openapi/components/impl/ServiceManagerImpl", "installEP"));
        }
        LOG.assertTrue(this.myExtensionPointName == null, (Object)("Already called installEP with " + this.myExtensionPointName));
        this.myExtensionPointName = pointName;
        ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(pointName);
        final MutablePicoContainer picoContainer = (MutablePicoContainer)componentManager.getPicoContainer();
        this.myExtensionPointListener = new ExtensionPointListener<ServiceDescriptor>(){

            public void extensionAdded(@NotNull ServiceDescriptor descriptor, PluginDescriptor pluginDescriptor) {
                ComponentAdapter oldAdapter;
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/components/impl/ServiceManagerImpl$1", "extensionAdded"));
                }
                if (descriptor.overrides && (oldAdapter = picoContainer.unregisterComponent((Object)descriptor.getInterface())) == null) {
                    throw new RuntimeException("Service: " + descriptor.getInterface() + " doesn't override anything");
                }
                if (!ComponentManagerImpl.isComponentSuitableForOs(descriptor.os)) {
                    return;
                }
                if (!StringUtil.isEmpty((String)descriptor.getImplementation())) {
                    picoContainer.registerComponent((ComponentAdapter)new MyComponentAdapter(descriptor, pluginDescriptor, (ComponentManagerEx)componentManager));
                }
            }

            public void extensionRemoved(@NotNull ServiceDescriptor extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/components/impl/ServiceManagerImpl$1", "extensionRemoved"));
                }
                picoContainer.unregisterComponent((Object)extension.getInterface());
            }
        };
        extensionPoint.addExtensionPointListener(this.myExtensionPointListener);
    }

    public List<ServiceDescriptor> getAllDescriptors() {
        ServiceDescriptor[] extensions = (ServiceDescriptor[])Extensions.getExtensions(this.myExtensionPointName);
        return Arrays.asList(extensions);
    }

    public static void processAllImplementationClasses(@NotNull ComponentManagerImpl componentManager, @NotNull PairProcessor<Class<?>, PluginDescriptor> processor) {
        if (componentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "com/intellij/openapi/components/impl/ServiceManagerImpl", "processAllImplementationClasses"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/components/impl/ServiceManagerImpl", "processAllImplementationClasses"));
        }
        Collection adapters = componentManager.getPicoContainer().getComponentAdapters();
        if (adapters.isEmpty()) {
            return;
        }
        for (Object o : adapters) {
            Class<?> aClass;
            if (o instanceof MyComponentAdapter) {
                MyComponentAdapter adapter = (MyComponentAdapter)o;
                PluginDescriptor pluginDescriptor = adapter.myPluginDescriptor;
                try {
                    ComponentAdapter delegate = adapter.myDelegate;
                    if (delegate == null) {
                        ClassLoader classLoader = pluginDescriptor == null ? ServiceManagerImpl.class.getClassLoader() : pluginDescriptor.getPluginClassLoader();
                        aClass = Class.forName(adapter.myDescriptor.getImplementation(), false, classLoader);
                    } else {
                        aClass = delegate.getComponentImplementation();
                    }
                }
                catch (Throwable e) {
                    if (PlatformUtils.isIdeaUltimate()) {
                        LOG.error(e);
                        continue;
                    }
                    LOG.warn(e);
                    continue;
                }
                if (processor.process((Object)aClass, (Object)pluginDescriptor)) continue;
                break;
            }
            if (!(o instanceof ComponentAdapter) || o instanceof ExtensionComponentAdapter) continue;
            try {
                aClass = ((ComponentAdapter)o).getComponentImplementation();
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            PluginId pluginId = componentManager.getConfig(aClass);
            if (pluginId == null) continue;
            processor.process((Object)aClass, (Object)PluginManager.getPlugin(pluginId));
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        String string = this.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ServiceManagerImpl", "getComponentName"));
        }
        return string;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(this.myExtensionPointName);
        extensionPoint.removeExtensionPointListener(this.myExtensionPointListener);
    }

    public static boolean isUseReadActionToInitService() {
        return Registry.is((String)"use.read.action.to.init.service", (boolean)true);
    }

    private static class MyComponentAdapter
    implements AssignableToComponentAdapter {
        private ComponentAdapter myDelegate;
        private final ServiceDescriptor myDescriptor;
        private final PluginDescriptor myPluginDescriptor;
        private final ComponentManagerEx myComponentManager;
        private volatile Object myInitializedComponentInstance = null;

        public MyComponentAdapter(ServiceDescriptor descriptor, PluginDescriptor pluginDescriptor, ComponentManagerEx componentManager) {
            this.myDescriptor = descriptor;
            this.myPluginDescriptor = pluginDescriptor;
            this.myComponentManager = componentManager;
            this.myDelegate = null;
        }

        public String getComponentKey() {
            return this.myDescriptor.getInterface();
        }

        public Class getComponentImplementation() {
            return this.getDelegate().getComponentImplementation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Object getComponentInstance(@NotNull PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
            Object object;
            AccessToken readToken;
            boolean useReadActionToInitService;
            Object instance;
            block13: {
                if (container == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/openapi/components/impl/ServiceManagerImpl$MyComponentAdapter", "getComponentInstance"));
                }
                instance = this.myInitializedComponentInstance;
                if (instance != null) {
                    return instance;
                }
                useReadActionToInitService = ServiceManagerImpl.isUseReadActionToInitService();
                readToken = useReadActionToInitService ? ReadAction.start() : null;
                MyComponentAdapter myComponentAdapter = this;
                // MONITORENTER : myComponentAdapter
                instance = this.myInitializedComponentInstance;
                if (instance == null) break block13;
                Object object2 = instance;
                // MONITOREXIT : myComponentAdapter
                if (readToken == null) return object2;
                {
                    catch (Throwable throwable) {
                        if (readToken == null) throw throwable;
                        readToken.finish();
                        throw throwable;
                    }
                }
                readToken.finish();
                return object2;
            }
            ComponentAdapter delegate = this.getDelegate();
            if (!useReadActionToInitService && LOG.isDebugEnabled() && ApplicationManager.getApplication().isWriteAccessAllowed() && PersistentStateComponent.class.isAssignableFrom(delegate.getComponentImplementation())) {
                LOG.warn(new Throwable("Getting service from write-action leads to possible deadlock. Service implementation " + this.myDescriptor.getImplementation()));
            }
            AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Creating component '" + this.myDescriptor.getImplementation() + "'");
            try {
                instance = delegate.getComponentInstance(container);
                if (instance instanceof Disposable) {
                    Disposer.register((Disposable)this.myComponentManager, (Disposable)((Disposable)instance));
                }
                this.myComponentManager.initializeComponent(instance, true);
                this.myInitializedComponentInstance = instance;
                object = instance;
            }
            catch (Throwable throwable) {
                token.finish();
                throw throwable;
            }
            token.finish();
            // MONITOREXIT : myComponentAdapter
            if (readToken == null) return object;
            readToken.finish();
            return object;
        }

        @NotNull
        private synchronized ComponentAdapter getDelegate() {
            if (this.myDelegate == null) {
                Class<?> implClass;
                try {
                    ClassLoader classLoader = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
                    implClass = Class.forName(this.myDescriptor.getImplementation(), true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.myDelegate = new ConstructorInjectionComponentAdapter((Object)this.getComponentKey(), implClass, null, true);
            }
            ComponentAdapter componentAdapter = this.myDelegate;
            if (componentAdapter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ServiceManagerImpl$MyComponentAdapter", "getDelegate"));
            }
            return componentAdapter;
        }

        public void verify(PicoContainer container) throws PicoIntrospectionException {
            this.getDelegate().verify(container);
        }

        public void accept(PicoVisitor visitor) {
            visitor.visitComponentAdapter((ComponentAdapter)this);
        }

        public String getAssignableToClassName() {
            return this.myDescriptor.getInterface();
        }

        public String toString() {
            return "ServiceComponentAdapter[" + this.myDescriptor.getInterface() + "]: implementation=" + this.myDescriptor.getImplementation() + ", plugin=" + this.myPluginDescriptor;
        }
    }
}

