/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchFactory;
import com.intellij.openapi.diff.impl.patch.apply.ApplyTextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathsVerifier<BinaryType extends FilePatch> {
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    private final List<FilePatch> myPatches;
    private final Map<VirtualFile, MovedFileData> myMovedFiles;
    private final List<FilePath> myBeforePaths;
    private final List<VirtualFile> myCreatedDirectories;
    private final List<Pair<VirtualFile, ApplyTextFilePatch>> myTextPatches;
    private final List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> myBinaryPatches;
    private final List<VirtualFile> myWritableFiles;
    private final BaseMapper myBaseMapper;
    private ProjectLevelVcsManager myVcsManager;
    private final List<FilePatch> mySkipped;
    private DelayedPrecheckContext myDelayedPrecheckContext;
    private List<FilePath> myAddedPaths;
    private List<FilePath> myDeletedPaths;
    private boolean myIgnoreContentRootsCheck;

    public PathsVerifier(Project project, VirtualFile baseDirectory, List<FilePatch> patches, BaseMapper baseMapper) {
        this.myProject = project;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches;
        this.myBaseMapper = baseMapper;
        this.myMovedFiles = new HashMap<VirtualFile, MovedFileData>();
        this.myBeforePaths = new ArrayList<FilePath>();
        this.myCreatedDirectories = new ArrayList<VirtualFile>();
        this.myTextPatches = new ArrayList<Pair<VirtualFile, ApplyTextFilePatch>>();
        this.myBinaryPatches = new ArrayList<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>>();
        this.myWritableFiles = new ArrayList<VirtualFile>();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.mySkipped = new ArrayList<FilePatch>();
        this.myAddedPaths = new ArrayList<FilePath>();
        this.myDeletedPaths = new ArrayList<FilePath>();
    }

    public List<FilePath> getDirectlyAffected() {
        ArrayList<FilePath> affected = new ArrayList<FilePath>();
        this.addAllFilePath(this.myCreatedDirectories, affected);
        this.addAllFilePath(this.myWritableFiles, affected);
        affected.addAll(this.myBeforePaths);
        return affected;
    }

    public List<VirtualFile> getAllAffected() {
        VirtualFile parent;
        ArrayList<VirtualFile> affected = new ArrayList<VirtualFile>();
        affected.addAll(this.myCreatedDirectories);
        affected.addAll(this.myWritableFiles);
        for (VirtualFile file : this.myMovedFiles.keySet()) {
            parent = file.getParent();
            if (parent == null) continue;
            affected.add(parent);
        }
        for (FilePath path : this.myBeforePaths) {
            parent = path.getParentPath();
            if (parent == null) continue;
            affected.add(parent.getVirtualFile());
        }
        return affected;
    }

    private void addAllFilePath(Collection<VirtualFile> files, Collection<FilePath> paths) {
        for (VirtualFile file : files) {
            paths.add(VcsUtil.getFilePath((VirtualFile)file));
        }
    }

    public boolean nonWriteActionPreCheck() {
        ArrayList checkers = new ArrayList(this.myPatches.size());
        this.myDelayedPrecheckContext = new DelayedPrecheckContext(this.myProject);
        for (FilePatch patch : this.myPatches) {
            CheckPath checker = this.getChecker(patch);
            if (checker.canBeApplied(this.myDelayedPrecheckContext)) continue;
            this.revert(checker.getErrorMessage());
            return false;
        }
        Collection<FilePatch> skipped = this.myDelayedPrecheckContext.doDelayed();
        this.mySkipped.addAll(skipped);
        this.myPatches.remove(skipped);
        return true;
    }

    public List<FilePatch> getSkipped() {
        return this.mySkipped;
    }

    public boolean execute() {
        try {
            ArrayList<CheckPath> checkers = new ArrayList<CheckPath>(this.myPatches.size());
            for (FilePatch patch : this.myPatches) {
                CheckPath checker = this.getChecker(patch);
                checkers.add(checker);
            }
            for (CheckPath checker : checkers) {
                if (checker.check()) continue;
                this.revert(checker.getErrorMessage());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            this.revert(e.getMessage());
            return false;
        }
    }

    private CheckPath getChecker(FilePatch patch) {
        String beforeFileName = patch.getBeforeName();
        String afterFileName = patch.getAfterName();
        if (beforeFileName == null || patch.isNewFile()) {
            return new CheckAdded(patch);
        }
        if (afterFileName == null || patch.isDeletedFile()) {
            return new CheckDeleted(patch);
        }
        if (!beforeFileName.equals(afterFileName)) {
            return new CheckMoved(patch);
        }
        return new CheckModified(patch);
    }

    public Collection<FilePath> getToBeAdded() {
        return this.myAddedPaths;
    }

    public Collection<FilePath> getToBeDeleted() {
        return this.myDeletedPaths;
    }

    private void addPatch(FilePatch patch, VirtualFile file) {
        Pair patchPair = Pair.create((Object)file, (Object)ApplyFilePatchFactory.createGeneral(patch));
        if (patch instanceof TextFilePatch) {
            this.myTextPatches.add((Pair<VirtualFile, ApplyTextFilePatch>)Pair.create((Object)file, (Object)ApplyFilePatchFactory.create((TextFilePatch)patch)));
        } else {
            ApplyFilePatchBase applyBinaryPatch = patch instanceof BinaryFilePatch ? ApplyFilePatchFactory.create((BinaryFilePatch)patch) : ApplyFilePatchFactory.create((ShelveChangesManager.ShelvedBinaryFilePatch)patch);
            this.myBinaryPatches.add(Pair.create((Object)file, (Object)applyBinaryPatch));
        }
        this.myWritableFiles.add(file);
    }

    private String fileNotFoundMessage(String path) {
        return VcsBundle.message((String)"cannot.find.file.to.patch", (Object[])new Object[]{path});
    }

    private String fileAlreadyExists(String path) {
        return VcsBundle.message((String)"cannot.apply.file.already.exists", (Object[])new Object[]{path});
    }

    private void revert(String errorMessage) {
        PatchApplier.showError(this.myProject, errorMessage, true);
    }

    private VirtualFile createFile(VirtualFile parent, String name) throws IOException {
        return parent.createChildData(PatchApplier.class, name);
    }

    private static VirtualFile moveFile(VirtualFile file, VirtualFile newParent) throws IOException {
        file.move(FilePatch.class, newParent);
        return file;
    }

    @Nullable
    private VirtualFile makeSureParentPathExists(String[] pieces) throws IOException {
        VirtualFile child = this.myBaseDirectory;
        int size = pieces.length - 1;
        for (int i = 0; i < size; ++i) {
            String piece = pieces[i];
            if ("".equals(piece)) continue;
            if ("..".equals(piece)) {
                child = child.getParent();
                continue;
            }
            VirtualFile nextChild = child.findChild(piece);
            if (nextChild == null) {
                nextChild = VfsUtil.createDirectories((String)(child.getPath() + '/' + piece));
                this.myCreatedDirectories.add(nextChild);
            }
            child = nextChild;
        }
        return child;
    }

    public List<Pair<VirtualFile, ApplyTextFilePatch>> getTextPatches() {
        return this.myTextPatches;
    }

    public List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> getBinaryPatches() {
        return this.myBinaryPatches;
    }

    public List<VirtualFile> getWritableFiles() {
        return this.myWritableFiles;
    }

    public void doMoveIfNeeded(VirtualFile file) throws IOException {
        final MovedFileData movedFile = this.myMovedFiles.get(file);
        if (movedFile != null) {
            this.myBeforePaths.add(VcsUtil.getFilePath((VirtualFile)file));
            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                public VirtualFile compute() throws IOException {
                    return movedFile.doMove();
                }
            });
        }
    }

    public void setIgnoreContentRootsCheck(boolean ignoreContentRootsCheck) {
        this.myIgnoreContentRootsCheck = ignoreContentRootsCheck;
    }

    private static class DelayedPrecheckContext {
        private final Map<FilePath, FilePatch> mySkipDeleted;
        private final Map<FilePath, FilePatch> myOverrideExisting;
        private final List<FilePath> myOverridenPaths;
        private final Project myProject;

        private DelayedPrecheckContext(Project project) {
            this.myProject = project;
            this.myOverrideExisting = new HashMap<FilePath, FilePatch>();
            this.mySkipDeleted = new HashMap<FilePath, FilePatch>();
            this.myOverridenPaths = new LinkedList<FilePath>();
        }

        public void addSkip(FilePath path, FilePatch filePatch) {
            this.mySkipDeleted.put(path, filePatch);
        }

        public void addOverrideExisting(FilePatch patch, FilePath filePath) {
            if (!this.myOverrideExisting.containsKey(filePath)) {
                this.myOverrideExisting.put(filePath, patch);
            }
        }

        public Collection<FilePatch> doDelayed() {
            LinkedList<FilePatch> result = new LinkedList<FilePatch>();
            if (!this.myOverrideExisting.isEmpty()) {
                String title = "Overwrite Existing Files";
                Collection selected = AbstractVcsHelper.getInstance((Project)this.myProject).selectFilePathsToProcess(new ArrayList<FilePath>(this.myOverrideExisting.keySet()), "Overwrite Existing Files", "\nThe following files should be created by patch, but they already exist.\nDo you want to overwrite them?\n", "Overwrite Existing Files", "The following file should be created by patch, but it already exists.\nDo you want to overwrite it?\n{0}", VcsShowConfirmationOption.STATIC_SHOW_CONFIRMATION);
                if (selected != null) {
                    for (FilePath path : selected) {
                        this.myOverrideExisting.remove(path);
                    }
                }
                result.addAll(this.myOverrideExisting.values());
                if (selected != null) {
                    this.myOverridenPaths.addAll(selected);
                }
            }
            result.addAll(this.mySkipDeleted.values());
            return result;
        }

        public List<FilePath> getOverridenPaths() {
            return this.myOverridenPaths;
        }

        public Collection<FilePath> getAlreadyDeletedPaths() {
            return this.mySkipDeleted.keySet();
        }
    }

    public static interface BaseMapper {
        @Nullable
        public VirtualFile getFile(FilePatch var1, String var2);

        public FilePath getPath(FilePatch var1, String var2);
    }

    private static class MovedFileData {
        private final VirtualFile myNewParent;
        private final VirtualFile myCurrent;
        private final String myNewName;

        private MovedFileData(@NotNull VirtualFile newParent, @NotNull VirtualFile current, @NotNull String newName) {
            if (newParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$MovedFileData", "<init>"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$MovedFileData", "<init>"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$MovedFileData", "<init>"));
            }
            this.myNewParent = newParent;
            this.myCurrent = current;
            this.myNewName = newName;
        }

        public VirtualFile getCurrent() {
            return this.myCurrent;
        }

        public VirtualFile getNewParent() {
            return this.myNewParent;
        }

        public String getNewName() {
            return this.myNewName;
        }

        public VirtualFile doMove() throws IOException {
            boolean needMove;
            VirtualFile oldParent = this.myCurrent.getParent();
            boolean needRename = !Comparing.equal((String)this.myCurrent.getName(), (String)this.myNewName);
            boolean bl = needMove = !this.myNewParent.equals(oldParent);
            if (needRename) {
                File oldParentFile;
                File targetAfterRenameFile;
                if (needMove && (targetAfterRenameFile = new File(oldParentFile = VfsUtilCore.virtualToIoFile((VirtualFile)oldParent), this.myNewName)).exists() && this.myCurrent.exists()) {
                    this.performRenameWithConflicts(oldParentFile);
                    return this.myCurrent;
                }
                this.myCurrent.rename(PatchApplier.class, this.myNewName);
            }
            if (needMove) {
                this.myCurrent.move(PatchApplier.class, this.myNewParent);
            }
            return this.myCurrent;
        }

        private void performRenameWithConflicts(@NotNull File oldParent) throws IOException {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$MovedFileData", "performRenameWithConflicts"));
            }
            File tmpFileWithUniqueName = FileUtil.createTempFile((File)oldParent, (String)"tempFileToMove", null, (boolean)false);
            File newParentFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myNewParent);
            File destFile = new File(newParentFile, tmpFileWithUniqueName.getName());
            while (destFile.exists()) {
                destFile = new File(newParentFile, FileUtil.createTempFile((File)oldParent, (String)FileUtil.getNameWithoutExtension((String)destFile.getName()), null, (boolean)false).getName());
            }
            this.myCurrent.rename(PatchApplier.class, destFile.getName());
            this.myCurrent.move(PatchApplier.class, this.myNewParent);
            this.myCurrent.rename(PatchApplier.class, this.myNewName);
        }
    }

    private abstract class CheckPath {
        protected final String myBeforeName;
        protected final String myAfterName;
        protected final FilePatch myPatch;
        private String myErrorMessage;

        public CheckPath(FilePatch path) {
            this.myPatch = path;
            this.myBeforeName = path.getBeforeName();
            this.myAfterName = path.getAfterName();
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        public boolean canBeApplied(DelayedPrecheckContext context) {
            VirtualFile beforeFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myBeforeName);
            VirtualFile afterFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myAfterName);
            return this.precheck(beforeFile, afterFile, context);
        }

        protected abstract boolean precheck(VirtualFile var1, VirtualFile var2, DelayedPrecheckContext var3);

        protected abstract boolean check() throws IOException;

        protected boolean checkExistsAndValid(VirtualFile file, String name) {
            if (file == null) {
                this.setErrorMessage(PathsVerifier.this.fileNotFoundMessage(name));
                return false;
            }
            return this.checkModificationValid(file, name);
        }

        protected boolean checkModificationValid(VirtualFile file, String name) {
            if (ApplicationManager.getApplication().isUnitTestMode() && PathsVerifier.this.myIgnoreContentRootsCheck) {
                return true;
            }
            if (file == null || !this.inContent(file) || PathsVerifier.this.myVcsManager.getVcsRootFor(file) == null) {
                this.setErrorMessage("File to patch found outside content root: " + name);
                return false;
            }
            return true;
        }

        private boolean inContent(VirtualFile file) {
            return PathsVerifier.this.myVcsManager.isFileInContent(file);
        }
    }

    private class CheckMoved
    extends CheckPath {
        private CheckMoved(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (beforeFile == null) {
                this.setErrorMessage(PathsVerifier.this.fileNotFoundMessage(this.myBeforeName));
            } else if (afterFile != null) {
                this.setErrorMessage(PathsVerifier.this.fileAlreadyExists(afterFile.getPath()));
            }
            return beforeFile != null && afterFile == null;
        }

        @Override
        public boolean check() throws IOException {
            String[] pieces = RelativePathCalculator.split(this.myAfterName);
            VirtualFile afterFileParent = PathsVerifier.this.makeSureParentPathExists(pieces);
            if (afterFileParent == null) {
                this.setErrorMessage(PathsVerifier.this.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            VirtualFile beforeFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myBeforeName);
            if (!this.checkExistsAndValid(beforeFile, this.myBeforeName)) {
                return false;
            }
            PathsVerifier.this.myMovedFiles.put(beforeFile, new MovedFileData(afterFileParent, beforeFile, this.myPatch.getAfterFileName()));
            PathsVerifier.this.addPatch(this.myPatch, beforeFile);
            return true;
        }
    }

    private class CheckAdded
    extends CheckPath {
        private CheckAdded(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (afterFile != null) {
                context.addOverrideExisting(this.myPatch, VcsUtil.getFilePath((VirtualFile)afterFile));
            }
            return true;
        }

        @Override
        public boolean check() throws IOException {
            VirtualFile file;
            String[] pieces = RelativePathCalculator.split(this.myAfterName);
            VirtualFile parent = PathsVerifier.this.makeSureParentPathExists(pieces);
            if (parent == null) {
                this.setErrorMessage(PathsVerifier.this.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            String name = pieces[pieces.length - 1];
            File afterFile = new File(parent.getPath(), name);
            VirtualFile virtualFile = file = PathsVerifier.this.myDelayedPrecheckContext.getOverridenPaths().contains(VcsUtil.getFilePath((File)afterFile)) ? parent.findChild(name) : PathsVerifier.this.createFile(parent, name);
            if (file == null) {
                this.setErrorMessage(PathsVerifier.this.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            PathsVerifier.this.myAddedPaths.add(VcsUtil.getFilePath((VirtualFile)file));
            if (!this.checkExistsAndValid(file, this.myAfterName)) {
                return false;
            }
            PathsVerifier.this.addPatch(this.myPatch, file);
            return true;
        }
    }

    private class CheckDeleted
    extends CheckPath {
        protected CheckDeleted(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (beforeFile == null) {
                context.addSkip(PathsVerifier.this.myBaseMapper.getPath(this.myPatch, this.myBeforeName), this.myPatch);
            }
            return true;
        }

        @Override
        protected boolean check() throws IOException {
            VirtualFile beforeFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myBeforeName);
            if (!this.checkExistsAndValid(beforeFile, this.myBeforeName)) {
                return false;
            }
            PathsVerifier.this.addPatch(this.myPatch, beforeFile);
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)beforeFile.getParent(), (String)beforeFile.getName(), (boolean)beforeFile.isDirectory());
            if (this.myPatch.isDeletedFile() || this.myPatch.getAfterName() == null) {
                PathsVerifier.this.myDeletedPaths.add(filePath);
            }
            PathsVerifier.this.myBeforePaths.add(filePath);
            return true;
        }
    }

    private class CheckModified
    extends CheckDeleted {
        private CheckModified(FilePatch path) {
            super(path);
        }
    }
}

