/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModulesOrderEnumerator
extends OrderEnumeratorBase {
    private final Collection<? extends Module> myModules;

    public ModulesOrderEnumerator(@NotNull Project project, @NotNull Collection<? extends Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "<init>"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "<init>"));
        }
        super(null, project, null);
        this.myModules = modules;
    }

    @Override
    public void processRootModules(@NotNull Processor<Module> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "processRootModules"));
        }
        for (Module module : this.myModules) {
            processor.process((Object)module);
        }
    }

    public void forEach(@NotNull Processor<OrderEntry> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "forEach"));
        }
        this.myRecursivelyExportedOnly = false;
        THashSet processed2 = new THashSet();
        for (Module module : this.myModules) {
            this.processEntries(this.getRootModel(module), processor, (Set<Module>)processed2, true);
        }
    }

    @Override
    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "isRootModuleModel"));
        }
        return this.myModules.contains(rootModel.getModule());
    }
}

