/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProjectOrderEnumerator
extends OrderEnumeratorBase {
    private final Project myProject;

    public ProjectOrderEnumerator(Project project, OrderRootsCache rootsCache) {
        super(null, project, rootsCache);
        this.myProject = project;
    }

    @Override
    public void processRootModules(@NotNull Processor<Module> processor) {
        Module[] modules;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/ProjectOrderEnumerator", "processRootModules"));
        }
        for (Module each : modules = this.myModulesProvider != null ? this.myModulesProvider.getModules() : ModuleManager.getInstance((Project)this.myProject).getSortedModules()) {
            processor.process((Object)each);
        }
    }

    public void forEach(final @NotNull Processor<OrderEntry> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/ProjectOrderEnumerator", "forEach"));
        }
        this.myRecursively = false;
        this.myWithoutDepModules = true;
        final THashSet processed2 = new THashSet();
        this.processRootModules(new Processor<Module>(){

            public boolean process(Module module) {
                ProjectOrderEnumerator.this.processEntries(ProjectOrderEnumerator.this.getRootModel(module), (Processor<OrderEntry>)processor, (Set<Module>)processed2, true);
                return true;
            }
        });
    }

    @Override
    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ProjectOrderEnumerator", "isRootModuleModel"));
        }
        return true;
    }
}

