/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ModuleConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurableWrapper;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProviderEx;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.UIRootConfigurationAccessor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleEditor
implements Place.Navigator,
Disposable {
    private static final Logger LOG = Logger.getInstance(ModuleEditor.class);
    private static final ExtensionPointName<ModuleConfigurableEP> MODULE_CONFIGURABLES = ExtensionPointName.create((String)"com.intellij.moduleConfigurable");
    public static final String SELECTED_EDITOR_NAME = "selectedEditor";
    private final Project myProject;
    private JPanel myGenericSettingsPanel;
    private ModifiableRootModel myModifiableRootModel;
    private final ModulesProvider myModulesProvider;
    private String myName;
    private final Module myModule;
    protected final List<ModuleConfigurationEditor> myEditors;
    private ModifiableRootModel myModifiableRootModelProxy;
    private final EventDispatcher<ChangeListener> myEventDispatcher;
    @NonNls
    private static final String METHOD_COMMIT = "commit";
    private boolean myEditorsInitialized;
    protected History myHistory;
    private static Set<Class<?>> ourReportedDeprecatedClasses = new HashSet();

    public ModuleEditor(Project project, ModulesProvider modulesProvider, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/ModuleEditor", "<init>"));
        }
        this.myEditors = new ArrayList<ModuleConfigurationEditor>();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myProject = project;
        this.myModulesProvider = modulesProvider;
        this.myModule = module;
        this.myName = module.getName();
    }

    public void init(History history) {
        this.myHistory = history;
        for (ModuleConfigurationEditor each : this.myEditors) {
            if (!(each instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)each).setHistory(this.myHistory);
        }
        this.restoreSelectedEditor();
    }

    public abstract ProjectFacetsConfigurator getFacetsConfigurator();

    protected abstract JComponent createCenterPanel();

    @Nullable
    public abstract ModuleConfigurationEditor getSelectedEditor();

    public abstract void selectEditor(String var1);

    protected abstract void restoreSelectedEditor();

    @Nullable
    public abstract ModuleConfigurationEditor getEditor(@NotNull String var1);

    protected abstract void disposeCenterPanel();

    public void addChangeListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    @Nullable
    public Module getModule() {
        Module[] all2;
        for (Module each : all2 = this.myModulesProvider.getModules()) {
            if (each != this.myModule) continue;
            return this.myModule;
        }
        return this.myModulesProvider.getModule(this.myName);
    }

    public ModifiableRootModel getModifiableRootModel() {
        Module module;
        if (this.myModifiableRootModel == null && (module = this.getModule()) != null) {
            this.myModifiableRootModel = ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module)).getModifiableModel(new UIRootConfigurationAccessor(this.myProject));
        }
        return this.myModifiableRootModel;
    }

    public OrderEntry[] getOrderEntries() {
        if (this.myModifiableRootModel == null) {
            return ModuleRootManager.getInstance((Module)this.getModule()).getOrderEntries();
        }
        return this.myModifiableRootModel.getOrderEntries();
    }

    public ModifiableRootModel getModifiableRootModelProxy() {
        ModifiableRootModel rootModel;
        if (this.myModifiableRootModelProxy == null && (rootModel = this.getModifiableRootModel()) != null) {
            this.myModifiableRootModelProxy = (ModifiableRootModel)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ModifiableRootModel.class}, (InvocationHandler)new ModifiableRootModelInvocationHandler(rootModel));
        }
        return this.myModifiableRootModelProxy;
    }

    public ModuleRootModel getRootModel() {
        if (this.myModifiableRootModel != null) {
            return this.getModifiableRootModelProxy();
        }
        return ModuleRootManager.getInstance((Module)this.myModule);
    }

    public boolean isModified() {
        for (ModuleConfigurationEditor moduleElementsEditor : this.myEditors) {
            if (!moduleElementsEditor.isModified()) continue;
            return true;
        }
        return false;
    }

    private void createEditors(@Nullable Module module) {
        if (module == null) {
            return;
        }
        ModuleConfigurationState state = this.createModuleConfigurationState();
        for (ModuleConfigurationEditorProvider provider : ModuleEditor.collectProviders(module)) {
            Object[] editors = provider.createEditors(state);
            if (editors.length > 0 && provider instanceof ModuleConfigurationEditorProviderEx && ((ModuleConfigurationEditorProviderEx)provider).isCompleteEditorSet()) {
                this.myEditors.clear();
                ContainerUtil.addAll(this.myEditors, (Object[])editors);
                break;
            }
            ContainerUtil.addAll(this.myEditors, (Object[])editors);
        }
        for (Configurable moduleConfigurable : ComponentsPackage.getComponents((ComponentManager)module, Configurable.class)) {
            ModuleEditor.reportDeprecatedModuleEditor(moduleConfigurable.getClass());
            this.myEditors.add(new ModuleConfigurableWrapper(moduleConfigurable));
        }
        for (ModuleConfigurableEP extension : (ModuleConfigurableEP[])module.getExtensions(MODULE_CONFIGURABLES)) {
            Configurable configurable;
            if (!extension.canCreateConfigurable() || (configurable = (Configurable)extension.createConfigurable()) == null) continue;
            ModuleEditor.reportDeprecatedModuleEditor(configurable.getClass());
            this.myEditors.add(new ModuleConfigurableWrapper(configurable));
        }
    }

    private static void reportDeprecatedModuleEditor(Class<?> aClass) {
        if (ourReportedDeprecatedClasses.add(aClass)) {
            LOG.warn(aClass.getName() + " uses deprecated way to register itself as a module editor. " + ModuleConfigurationEditorProvider.class.getName() + " extension point should be used instead");
        }
    }

    private static ModuleConfigurationEditorProvider[] collectProviders(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/ModuleEditor", "collectProviders"));
        }
        ArrayList<ModuleConfigurationEditorProvider> result = new ArrayList<ModuleConfigurationEditorProvider>();
        result.addAll(ComponentsPackage.getComponents((ComponentManager)module, ModuleConfigurationEditorProvider.class));
        for (ModuleConfigurationEditorProvider component : result) {
            ModuleEditor.reportDeprecatedModuleEditor(component.getClass());
        }
        ContainerUtil.addAll(result, (Object[])Extensions.getExtensions((ExtensionPointName)ModuleConfigurationEditorProvider.EP_NAME, (AreaInstance)module));
        return result.toArray(new ModuleConfigurationEditorProvider[result.size()]);
    }

    public ModuleConfigurationState createModuleConfigurationState() {
        return new ModuleConfigurationStateImpl(this.myProject, this.myModulesProvider){

            @Override
            public ModifiableRootModel getRootModel() {
                return ModuleEditor.this.getModifiableRootModelProxy();
            }

            @Override
            public FacetsProvider getFacetsProvider() {
                return ModuleEditor.this.getFacetsConfigurator();
            }
        };
    }

    private JPanel createPanel() {
        this.getModifiableRootModel();
        this.getModifiableRootModelProxy();
        this.myGenericSettingsPanel = new ModuleEditorPanel();
        this.createEditors(this.getModule());
        if (!Registry.is((String)"ide.new.project.settings")) {
            JPanel northPanel = new JPanel(new GridBagLayout());
            this.myGenericSettingsPanel.add((Component)northPanel, "North");
        }
        JComponent component = this.createCenterPanel();
        this.myGenericSettingsPanel.add((Component)component, "Center");
        this.myEditorsInitialized = true;
        return this.myGenericSettingsPanel;
    }

    public JPanel getPanel() {
        if (this.myGenericSettingsPanel == null) {
            this.myGenericSettingsPanel = this.createPanel();
        }
        return this.myGenericSettingsPanel;
    }

    public void moduleCountChanged() {
        this.updateOrderEntriesInEditors(false);
    }

    private void updateOrderEntriesInEditors(boolean forceInitEditors) {
        if (this.getModule() != null) {
            if (this.myEditorsInitialized || forceInitEditors) {
                this.getPanel();
                for (ModuleConfigurationEditor myEditor : this.myEditors) {
                    myEditor.moduleStateChanged();
                }
            }
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).moduleStateChanged(this.getModifiableRootModelProxy());
        }
    }

    public void updateCompilerOutputPathChanged(String baseUrl, String moduleName) {
        if (this.myGenericSettingsPanel == null) {
            return;
        }
        for (ModuleConfigurationEditor myEditor : this.myEditors) {
            if (!(myEditor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)myEditor).moduleCompileOutputChanged(baseUrl, moduleName);
        }
    }

    public void dispose() {
        try {
            for (ModuleConfigurationEditor myEditor : this.myEditors) {
                myEditor.disposeUIResources();
            }
            this.myEditors.clear();
            this.disposeCenterPanel();
            if (this.myModifiableRootModel != null) {
                this.myModifiableRootModel.dispose();
            }
            this.myGenericSettingsPanel = null;
        }
        finally {
            this.myModifiableRootModel = null;
            this.myModifiableRootModelProxy = null;
        }
    }

    public ModifiableRootModel apply() throws ConfigurationException {
        try {
            for (ModuleConfigurationEditor editor : this.myEditors) {
                editor.saveData();
                editor.apply();
            }
            ModifiableRootModel modifiableRootModel = this.myModifiableRootModel;
            return modifiableRootModel;
        }
        finally {
            this.myModifiableRootModel = null;
            this.myModifiableRootModelProxy = null;
        }
    }

    public void canApply() throws ConfigurationException {
        for (ModuleConfigurationEditor editor : this.myEditors) {
            if (!(editor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)editor).canApply();
        }
    }

    public String getName() {
        return this.myName;
    }

    private static Object[] unwrapParams(Object[] params) {
        if (params == null || params.length == 0) {
            return params;
        }
        Object[] unwrappedParams = new Object[params.length];
        for (int idx = 0; idx < params.length; ++idx) {
            InvocationHandler invocationHandler;
            Object param = params[idx];
            if (param != null && Proxy.isProxyClass(param.getClass()) && (invocationHandler = Proxy.getInvocationHandler(param)) instanceof ProxyDelegateAccessor) {
                param = ((ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate();
            }
            unwrappedParams[idx] = param;
        }
        return unwrappedParams;
    }

    @Nullable
    public String getHelpTopic() {
        if (this.myEditors.isEmpty()) {
            return null;
        }
        ModuleConfigurationEditor selectedEditor = this.getSelectedEditor();
        return selectedEditor != null ? selectedEditor.getHelpTopic() : null;
    }

    public void setModuleName(String name) {
        this.myName = name;
    }

    public void setHistory(History history) {
    }

    private class ModuleEditorPanel
    extends JPanel
    implements DataProvider {
        public ModuleEditorPanel() {
            super(new BorderLayout());
        }

        public Object getData(String dataId) {
            if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                return ModuleEditor.this.getModule();
            }
            return null;
        }
    }

    public static interface ProxyDelegateAccessor {
        public Object getDelegate();
    }

    private class LibraryTableModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final LibraryTable.ModifiableModel myDelegateModel;

        LibraryTableModelInvocationHandler(LibraryTable.ModifiableModel delegateModel) {
            this.myDelegateModel = delegateModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = ModuleEditor.METHOD_COMMIT.equals(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                if (result instanceof Library[]) {
                    Library[] libraries = (Library[])result;
                    for (int idx = 0; idx < libraries.length; ++idx) {
                        Library library = libraries[idx];
                        libraries[idx] = (Library)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryEx.class}, (InvocationHandler)new LibraryInvocationHandler(library));
                    }
                }
                if (result instanceof Library) {
                    result = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryEx.class}, (InvocationHandler)new LibraryInvocationHandler((Library)result));
                }
                Object object2 = result;
                return object2;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateModel;
        }
    }

    private class LibraryModifiableModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final Library.ModifiableModel myDelegateModel;

        LibraryModifiableModelInvocationHandler(Library.ModifiableModel delegateModel) {
            this.myDelegateModel = delegateModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = ModuleEditor.METHOD_COMMIT.equals(method.getName());
            try {
                Object object2 = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                return object2;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateModel;
        }
    }

    private class LibraryInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final Library myDelegateLibrary;

        LibraryInvocationHandler(Library delegateLibrary) {
            this.myDelegateLibrary = delegateLibrary;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            try {
                Object result = method.invoke((Object)this.myDelegateLibrary, ModuleEditor.unwrapParams(params));
                if (result instanceof LibraryEx.ModifiableModelEx) {
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryEx.ModifiableModelEx.class}, (InvocationHandler)new LibraryModifiableModelInvocationHandler((Library.ModifiableModel)((LibraryEx.ModifiableModelEx)result)));
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateLibrary;
        }
    }

    private class LibraryTableInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final LibraryTable myDelegateTable;
        @NonNls
        private final Set<String> myCheckedNames = new HashSet<String>(Arrays.asList("removeLibrary"));

        LibraryTableInvocationHandler(LibraryTable table) {
            this.myDelegateTable = table;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = this.myCheckedNames.contains(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateTable, ModuleEditor.unwrapParams(params));
                if (result instanceof Library) {
                    Object object2 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{result instanceof LibraryEx ? LibraryEx.class : Library.class}, (InvocationHandler)new LibraryInvocationHandler((Library)result));
                    return object2;
                }
                if (result instanceof LibraryTable.ModifiableModel) {
                    Object object3 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryTableBase.ModifiableModelEx.class}, (InvocationHandler)new LibraryTableModelInvocationHandler((LibraryTable.ModifiableModel)result));
                    return object3;
                }
                if (result instanceof Library[]) {
                    Library[] libraries = (Library[])result;
                    for (int idx = 0; idx < libraries.length; ++idx) {
                        Library library = libraries[idx];
                        libraries[idx] = (Library)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{library instanceof LibraryEx ? LibraryEx.class : Library.class}, (InvocationHandler)new LibraryInvocationHandler(library));
                    }
                }
                Object object4 = result;
                return object4;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateTable;
        }
    }

    private class ModifiableRootModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final ModifiableRootModel myDelegateModel;
        @NonNls
        private final Set<String> myCheckedNames = new HashSet<String>(Arrays.asList("addOrderEntry", "addLibraryEntry", "addInvalidLibrary", "addModuleOrderEntry", "addInvalidModuleEntry", "removeOrderEntry", "setSdk", "inheritSdk", "inheritCompilerOutputPath", "setExcludeOutput", "replaceEntryOfType", "rearrangeOrderEntries"));

        ModifiableRootModelInvocationHandler(ModifiableRootModel model) {
            this.myDelegateModel = model;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = this.myCheckedNames.contains(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                if (result instanceof LibraryTable) {
                    Object object2 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryTable.class}, (InvocationHandler)new LibraryTableInvocationHandler((LibraryTable)result));
                    return object2;
                }
                Object object3 = result;
                return object3;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateModel;
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void moduleStateChanged(ModifiableRootModel var1);
    }
}

