/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.BackgroundTaskUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.actions.ShowNextChangeMarkerAction;
import com.intellij.openapi.vcs.actions.ShowPrevChangeMarkerAction;
import com.intellij.openapi.vcs.ex.CopyLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RollbackLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.ShowLineStatusRangeDiffAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusTrackerDrawing {
    private LineStatusTrackerDrawing() {
    }

    static TextAttributes getAttributesFor(final Range range) {
        return new TextAttributes(){

            public Color getErrorStripeColor() {
                return LineStatusTrackerDrawing.getDiffColor(range);
            }
        };
    }

    private static void paintGutterFragment(Editor editor, Graphics g, Rectangle r, Range range) {
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        Color gutterColor = LineStatusTrackerDrawing.getDiffGutterColor(range);
        Color borderColor = LineStatusTrackerDrawing.getDiffGutterBorderColor();
        int x = r.x + r.width - 3;
        int endX = gutter.getWhitespaceSeparatorOffset();
        int y = LineStatusTrackerDrawing.lineToY(editor, range.getLine1());
        int endY = LineStatusTrackerDrawing.lineToY(editor, range.getLine2());
        if (range.getInnerRanges() == null) {
            if (y != endY) {
                LineStatusTrackerDrawing.paintRect(g, gutterColor, borderColor, x, y, endX, endY);
            } else {
                LineStatusTrackerDrawing.paintTriangle(g, gutterColor, borderColor, x, endX, y);
            }
        } else if (y == endY) {
            LineStatusTrackerDrawing.paintTriangle(g, gutterColor, borderColor, x, endX, y);
        } else {
            int end;
            int start;
            List<Range.InnerRange> innerRanges = range.getInnerRanges();
            for (Range.InnerRange innerRange : innerRanges) {
                if (innerRange.getType() == 3) continue;
                start = LineStatusTrackerDrawing.lineToY(editor, innerRange.getLine1());
                end = LineStatusTrackerDrawing.lineToY(editor, innerRange.getLine2());
                LineStatusTrackerDrawing.paintRect(g, LineStatusTrackerDrawing.getDiffColor(innerRange), null, x, start, endX, end);
            }
            for (int i = 0; i < innerRanges.size(); ++i) {
                Range.InnerRange innerRange;
                innerRange = innerRanges.get(i);
                if (innerRange.getType() != 3) continue;
                if (i == 0) {
                    start = LineStatusTrackerDrawing.lineToY(editor, innerRange.getLine1());
                    end = LineStatusTrackerDrawing.lineToY(editor, innerRange.getLine2()) + 5;
                } else if (i == innerRanges.size() - 1) {
                    start = LineStatusTrackerDrawing.lineToY(editor, innerRange.getLine1()) - 5;
                    end = LineStatusTrackerDrawing.lineToY(editor, innerRange.getLine2());
                } else {
                    start = LineStatusTrackerDrawing.lineToY(editor, innerRange.getLine1()) - 3;
                    end = LineStatusTrackerDrawing.lineToY(editor, innerRange.getLine2()) + 3;
                }
                LineStatusTrackerDrawing.paintRect(g, LineStatusTrackerDrawing.getDiffColor(innerRange), null, x, start, endX, end);
            }
            LineStatusTrackerDrawing.paintRect(g, null, borderColor, x, y, endX, endY);
        }
    }

    private static int lineToY(@NotNull Editor editor, int line) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "lineToY"));
        }
        Document document = editor.getDocument();
        if (line >= DiffUtil.getLineCount(document)) {
            int y = LineStatusTrackerDrawing.lineToY(editor, DiffUtil.getLineCount(document) - 1);
            return y + editor.getLineHeight() * (line - DiffUtil.getLineCount(document) + 1);
        }
        return editor.logicalPositionToXY((LogicalPosition)editor.offsetToLogicalPosition((int)document.getLineStartOffset((int)line))).y;
    }

    private static void paintRect(@NotNull Graphics g, @Nullable Color color, @Nullable Color borderColor, int x1, int y1, int x2, int y2) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "paintRect"));
        }
        if (color != null) {
            g.setColor(color);
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)(x2 - 1), (int)y1);
            UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)x1, (int)(y2 - 1));
            UIUtil.drawLine((Graphics)g, (int)x1, (int)(y2 - 1), (int)(x2 - 1), (int)(y2 - 1));
        }
    }

    private static void paintTriangle(@NotNull Graphics g, @Nullable Color color, @Nullable Color borderColor, int x1, int x2, int y) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "paintTriangle"));
        }
        int size = 4;
        int[] xPoints = new int[]{x1, x1, x2};
        int[] yPoints = new int[]{y - size, y + size, y};
        if (color != null) {
            g.setColor(color);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawPolygon(xPoints, yPoints, xPoints.length);
        }
    }

    public static LineMarkerRenderer createRenderer(final Range range, final LineStatusTracker tracker) {
        return new ActiveGutterRenderer(){

            public void paint(Editor editor, Graphics g, Rectangle r) {
                LineStatusTrackerDrawing.paintGutterFragment(editor, g, r, range);
            }

            public void doAction(Editor editor, MouseEvent e) {
                e.consume();
                JComponent comp = (JComponent)e.getComponent();
                JLayeredPane layeredPane = comp.getRootPane().getLayeredPane();
                Point point = SwingUtilities.convertPoint(comp, ((EditorEx)editor).getGutterComponentEx().getWidth(), e.getY(), layeredPane);
                LineStatusTrackerDrawing.showActiveHint(range, editor, point, tracker);
            }

            public boolean canDoAction(MouseEvent e) {
                EditorGutterComponentEx gutter = (EditorGutterComponentEx)e.getComponent();
                return e.getX() > gutter.getLineMarkerFreePaintersAreaOffset();
            }
        };
    }

    public static void showActiveHint(@NotNull Range range, @NotNull Editor editor, @Nullable Point mousePosition, @NotNull LineStatusTracker tracker) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "showActiveHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "showActiveHint"));
        }
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "showActiveHint"));
        }
        final Disposable disposable = Disposer.newDisposable();
        List<DiffFragment> wordDiff = LineStatusTrackerDrawing.computeWordDiff(range, tracker);
        LineStatusTrackerDrawing.installEditorHighlighters(range, editor, tracker, wordDiff, disposable);
        Pair<JComponent, Integer> editorComponent = LineStatusTrackerDrawing.createEditorComponent(range, editor, tracker, wordDiff);
        ActionToolbar toolbar = LineStatusTrackerDrawing.buildToolbar(range, editor, tracker, disposable);
        toolbar.updateActionsImmediately();
        PopupPanel popupPanel = new PopupPanel(editor, toolbar, (JComponent)editorComponent.first, (Integer)editorComponent.second);
        LightweightHint hint = new LightweightHint(popupPanel);
        HintListener closeListener = new HintListener(){

            @Override
            public void hintHidden(EventObject event) {
                Disposer.dispose((Disposable)disposable);
            }
        };
        hint.addHintListener(closeListener);
        int line = editor.getCaretModel().getLogicalPosition().line;
        Point point = HintManagerImpl.getHintPosition(hint, editor, new LogicalPosition(line, 0), (short)2);
        if (mousePosition != null) {
            int lineHeight = editor.getLineHeight();
            int delta = (point.y - mousePosition.y) % lineHeight;
            if (delta < 0) {
                delta += lineHeight;
            }
            point.y = mousePosition.y + delta;
        }
        point.x -= popupPanel.getEditorTextOffset();
        int flags = 42;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, flags, -1, false, new HintHint(editor, point));
        if (!hint.isVisible()) {
            closeListener.hintHidden(null);
        }
    }

    @Nullable
    private static List<DiffFragment> computeWordDiff(@NotNull Range range, @NotNull LineStatusTracker tracker) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "computeWordDiff"));
        }
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "computeWordDiff"));
        }
        if (range.getType() != 1) {
            return null;
        }
        final CharSequence vcsContent = tracker.getVcsContent(range);
        final CharSequence currentContent = tracker.getCurrentContent(range);
        return BackgroundTaskUtil.tryComputeFast(new Function<ProgressIndicator, List<DiffFragment>>(){

            public List<DiffFragment> fun(ProgressIndicator indicator) {
                return ByWord.compare(vcsContent, currentContent, ComparisonPolicy.DEFAULT, indicator);
            }
        }, Registry.intValue((String)"diff.status.tracker.byword.delay"));
    }

    @NotNull
    private static ActionToolbar buildToolbar(@NotNull Range range, @NotNull Editor editor, @NotNull LineStatusTracker tracker, @NotNull Disposable parentDisposable) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "buildToolbar"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "buildToolbar"));
        }
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "buildToolbar"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "buildToolbar"));
        }
        DefaultActionGroup group = new DefaultActionGroup();
        final ShowPrevChangeMarkerAction localShowPrevAction = new ShowPrevChangeMarkerAction(tracker.getPrevRange(range), tracker, editor);
        final ShowNextChangeMarkerAction localShowNextAction = new ShowNextChangeMarkerAction(tracker.getNextRange(range), tracker, editor);
        final RollbackLineStatusRangeAction rollback = new RollbackLineStatusRangeAction(tracker, range, editor);
        final ShowLineStatusRangeDiffAction showDiff = new ShowLineStatusRangeDiffAction(tracker, range, editor);
        final CopyLineStatusRangeAction copyRange = new CopyLineStatusRangeAction(tracker, range);
        group.add((AnAction)localShowPrevAction);
        group.add((AnAction)localShowNextAction);
        group.add((AnAction)rollback);
        group.add((AnAction)showDiff);
        group.add((AnAction)copyRange);
        JComponent editorComponent = editor.getComponent();
        EmptyAction.setupAction((AnAction)localShowPrevAction, (String)"VcsShowPrevChangeMarker", (JComponent)editorComponent);
        EmptyAction.setupAction((AnAction)localShowNextAction, (String)"VcsShowNextChangeMarker", (JComponent)editorComponent);
        EmptyAction.setupAction((AnAction)rollback, (String)"Vcs.RollbackChangedLines", (JComponent)editorComponent);
        EmptyAction.setupAction((AnAction)showDiff, (String)"ChangesView.Diff", (JComponent)editorComponent);
        EmptyAction.setupAction((AnAction)copyRange, (String)"$Copy", (JComponent)editorComponent);
        final List actionList = ActionUtil.getActions((JComponent)editorComponent);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                actionList.remove((Object)localShowPrevAction);
                actionList.remove((Object)localShowNextAction);
                actionList.remove((Object)rollback);
                actionList.remove((Object)showDiff);
                actionList.remove((Object)copyRange);
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", (ActionGroup)group, true);
        if (actionToolbar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "buildToolbar"));
        }
        return actionToolbar;
    }

    private static void installEditorHighlighters(@NotNull Range range, @NotNull Editor editor, @NotNull LineStatusTracker tracker, @Nullable List<DiffFragment> wordDiff, @NotNull Disposable parentDisposable) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "installEditorHighlighters"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "installEditorHighlighters"));
        }
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "installEditorHighlighters"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "installEditorHighlighters"));
        }
        if (wordDiff == null) {
            return;
        }
        final ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        int currentStartShift = tracker.getCurrentTextRange(range).getStartOffset();
        for (DiffFragment fragment : wordDiff) {
            int currentStart = currentStartShift + fragment.getStartOffset2();
            int currentEnd = currentStartShift + fragment.getEndOffset2();
            TextDiffType type = DiffUtil.getDiffType(fragment);
            highlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, currentStart, currentEnd, type));
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                for (RangeHighlighter highlighter : highlighters) {
                    highlighter.dispose();
                }
            }
        });
    }

    @NotNull
    private static Pair<JComponent, Integer> createEditorComponent(@NotNull Range range, @NotNull Editor editor, @NotNull LineStatusTracker tracker, @Nullable List<DiffFragment> wordDiff) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "createEditorComponent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "createEditorComponent"));
        }
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "createEditorComponent"));
        }
        if (range.getType() == 2) {
            Pair pair = Pair.create(null, (Object)0);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "createEditorComponent"));
            }
            return pair;
        }
        DocumentEx doc = (DocumentEx)tracker.getVcsDocument();
        EditorEx uEditor = (EditorEx)EditorFactory.getInstance().createViewer((Document)doc, tracker.getProject());
        uEditor.setColorsScheme(editor.getColorsScheme());
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        EditorHighlighter highlighter = highlighterFactory.createEditorHighlighter(tracker.getProject(), LineStatusTrackerDrawing.getFileName(tracker.getDocument()));
        uEditor.setHighlighter(highlighter);
        if (wordDiff != null) {
            int vcsStartShift = tracker.getVcsTextRange(range).getStartOffset();
            for (DiffFragment fragment : wordDiff) {
                int vcsStart = vcsStartShift + fragment.getStartOffset1();
                int vcsEnd = vcsStartShift + fragment.getEndOffset1();
                TextDiffType type = DiffUtil.getDiffType(fragment);
                DiffDrawUtil.createInlineHighlighter(uEditor, vcsStart, vcsEnd, type);
            }
        }
        EditorFragmentComponent fragmentComponent = EditorFragmentComponent.createEditorFragmentComponent(uEditor, range.getVcsLine1(), range.getVcsLine2(), false, false);
        int leftBorder = fragmentComponent.getBorder().getBorderInsets((Component)fragmentComponent).left;
        EditorFactory.getInstance().releaseEditor((Editor)uEditor);
        Pair pair = Pair.create((Object)fragmentComponent, (Object)leftBorder);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "createEditorComponent"));
        }
        return pair;
    }

    private static String getFileName(Document document) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            return "";
        }
        return file.getName();
    }

    public static void moveToRange(Range range, Editor editor, LineStatusTracker tracker) {
        Document document = tracker.getDocument();
        int line = Math.min(range.getType() == 3 ? range.getLine2() : range.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
        int lastOffset = document.getLineStartOffset(line);
        editor.getCaretModel().moveToOffset(lastOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        LineStatusTrackerDrawing.showHint(range, editor, tracker);
    }

    public static void showHint(final Range range, final Editor editor, final LineStatusTracker tracker) {
        editor.getScrollingModel().runActionOnScrollingFinished(new Runnable(){

            @Override
            public void run() {
                LineStatusTrackerDrawing.showActiveHint(range, editor, null, tracker);
            }
        });
    }

    @Nullable
    private static Color getDiffColor(@NotNull Range.InnerRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "getDiffColor"));
        }
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        switch (range.getType()) {
            case 2: {
                return globalScheme.getColor(EditorColors.ADDED_LINES_COLOR);
            }
            case 3: {
                return globalScheme.getColor(EditorColors.DELETED_LINES_COLOR);
            }
            case 1: {
                return globalScheme.getColor(EditorColors.MODIFIED_LINES_COLOR);
            }
            case 0: {
                return globalScheme.getColor(EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getDiffColor(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "getDiffColor"));
        }
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        switch (range.getType()) {
            case 2: {
                return globalScheme.getAttributes(DiffColors.DIFF_INSERTED).getErrorStripeColor();
            }
            case 3: {
                return globalScheme.getAttributes(DiffColors.DIFF_DELETED).getErrorStripeColor();
            }
            case 1: {
                return globalScheme.getAttributes(DiffColors.DIFF_MODIFIED).getErrorStripeColor();
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getDiffGutterColor(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing", "getDiffGutterColor"));
        }
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        switch (range.getType()) {
            case 2: {
                return globalScheme.getColor(EditorColors.ADDED_LINES_COLOR);
            }
            case 3: {
                return globalScheme.getColor(EditorColors.DELETED_LINES_COLOR);
            }
            case 1: {
                return globalScheme.getColor(EditorColors.MODIFIED_LINES_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getDiffGutterBorderColor() {
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        return globalScheme.getColor(EditorColors.BORDER_LINES_COLOR);
    }

    private static class PopupPanel
    extends JPanel {
        private final JComponent myEditorComponent;
        private final int myEditorLeftBorder;

        public PopupPanel(final @NotNull Editor editor, @NotNull ActionToolbar toolbar, @Nullable JComponent editorComponent, int editorLeftBorder) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$PopupPanel", "<init>"));
            }
            if (toolbar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$PopupPanel", "<init>"));
            }
            super(new BorderLayout());
            this.setOpaque(false);
            this.myEditorComponent = editorComponent;
            this.myEditorLeftBorder = editorLeftBorder;
            Color background = ((EditorEx)editor).getBackgroundColor();
            Color foreground = editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBackground(background);
            boolean isEditorVisible = editorComponent != null;
            toolbarComponent.setBorder(new ColoredSideBorder(foreground, foreground, isEditorVisible ? null : foreground, foreground, 1));
            JPanel emptyPanel = new JPanel();
            emptyPanel.setOpaque(false);
            JPanel toolbarPanel = new JPanel(new BorderLayout());
            toolbarPanel.setOpaque(false);
            toolbarPanel.add((Component)toolbarComponent, "West");
            toolbarPanel.add((Component)emptyPanel, "Center");
            this.add((Component)toolbarPanel, "North");
            if (editorComponent != null) {
                this.add((Component)editorComponent, "Center");
            }
            MouseAdapter listener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }
            };
            emptyPanel.addMouseListener(listener);
        }

        private static void transferEvent(MouseEvent e, Editor editor) {
            editor.getContentComponent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, editor.getContentComponent()));
        }

        public int getEditorTextOffset() {
            return this.myEditorLeftBorder;
        }
    }
}

