/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class FilesForRefresh {
    private final List<File> myRecursively = new ArrayList<File>();
    private final List<File> myPoints = new ArrayList<File>();

    public void addPoint(File vf) {
        if (vf == null) {
            return;
        }
        this.myPoints.add(vf);
    }

    public void addRecursively(File vf) {
        if (vf == null) {
            return;
        }
        this.myRecursively.add(vf);
    }

    public void filter() {
        this.filterEqual(this.myRecursively);
        this.filterEqual(this.myPoints);
        ParentsFirstVFComparator comparator = new ParentsFirstVFComparator();
        Collections.sort(this.myRecursively, comparator);
        Iterator<File> iterator = this.myPoints.iterator();
        while (iterator.hasNext()) {
            File f = iterator.next();
            for (File recursive : this.myRecursively) {
                if (!VfsUtil.isAncestor((File)recursive, (File)f, (boolean)false)) continue;
                iterator.remove();
            }
        }
    }

    private void filterEqual(List<File> files) {
        HashSet<String> set = new HashSet<String>();
        for (File file : files) {
            set.add(file.getAbsolutePath());
        }
        files.clear();
        for (String s : set) {
            files.add(new File(s));
        }
    }

    public List<File> getRecursively() {
        return this.myRecursively;
    }

    public List<File> getPoints() {
        return this.myPoints;
    }

    private static class ParentsFirstVFComparator
    implements Comparator<File> {
        private ParentsFirstVFComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            if (Comparing.equal((String)o1.getAbsolutePath(), (String)o2.getAbsolutePath())) {
                return 0;
            }
            if (VfsUtil.isAncestor((File)o1, (File)o2, (boolean)true)) {
                return -1;
            }
            if (VfsUtil.isAncestor((File)o2, (File)o1, (boolean)true)) {
                return 1;
            }
            return 0;
        }
    }
}

