/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.NewRecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePopupAction;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ClickListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBSlidingPanel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlatWelcomeFrame
extends JFrame
implements IdeFrame {
    private final BalloonLayout myBalloonLayout;
    private final FlatWelcomeScreen myScreen;

    public FlatWelcomeFrame() {
        final JRootPane rootPane = this.getRootPane();
        this.myScreen = new FlatWelcomeScreen();
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane){

            @Override
            public void addNotify() {
                super.addNotify();
                rootPane.remove(this.getProxyComponent());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JBProtocolCommand.handleCurrentCommand();
                    }
                });
            }
        };
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        this.setContentPane(this.myScreen.getWelcomePanel());
        this.setTitle("Welcome to " + ApplicationNamesInfo.getInstance().getFullProductName());
        AppUIUtil.updateWindowIcon(this);
        int width = RecentProjectsManager.getInstance().getRecentProjectsActions(false).length == 0 ? 666 : 777;
        this.setSize((Dimension)JBUI.size((int)width, (int)460));
        this.setResizable(false);
        Point location = DimensionService.getInstance().getLocation("WELCOME_SCREEN", null);
        Rectangle screenBounds = ScreenUtil.getScreenRectangle((Point)(location != null ? location : new Point(0, 0)));
        this.setLocation(new Point(screenBounds.x + (screenBounds.width - this.getWidth()) / 2, screenBounds.y + (screenBounds.height - this.getHeight()) / 3));
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(Project project) {
                FlatWelcomeFrame.this.dispose();
            }
        });
        this.myBalloonLayout = new BalloonLayoutImpl(rootPane, (Insets)JBUI.insets((int)8));
        WelcomeFrame.setupCloseAction(this);
        MnemonicHelper.init((Component)this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)new Disposable(){

            public void dispose() {
                FlatWelcomeFrame.this.dispose();
            }
        });
    }

    @Override
    public void dispose() {
        FlatWelcomeFrame.saveLocation(this.getBounds());
        super.dispose();
        Disposer.dispose((Disposable)this.myScreen);
        WelcomeFrame.resetInstance();
    }

    private static void saveLocation(Rectangle location) {
        location.y = location.height / 2;
        Point middle = new Point(location.x + location.width / 2, location.y);
        DimensionService.getInstance().setLocation("WELCOME_SCREEN", middle, null);
    }

    public StatusBar getStatusBar() {
        return null;
    }

    public static Color getMainBackground() {
        return new JBColor(0xF7F7F7, 4540234);
    }

    public static Color getProjectsBackground() {
        return new JBColor((Color)Gray.xFF, (Color)Gray.x39);
    }

    public static Color getLinkNormalColor() {
        return new JBColor((Color)Gray._0, (Color)Gray.xBB);
    }

    public static Color getListSelectionColor(boolean hasFocus) {
        return hasFocus ? new JBColor(3700182, 4943535) : new JBColor((Color)Gray.xDD, (Color)Gray.x45);
    }

    public static Color getActionLinkSelectionColor() {
        return new JBColor(14411253, 4741237);
    }

    public static JBColor getSeparatorColor() {
        return new JBColor((Color)Gray.xEC, new Color(72, 75, 78));
    }

    public static boolean isUseProjectGroups() {
        return Registry.is((String)"welcome.screen.project.grouping.enabled");
    }

    private static Runnable createUsageTracker(final AnAction action) {
        return new Runnable(){

            @Override
            public void run() {
                UsageTrigger.trigger("welcome.screen." + ActionManager.getInstance().getId(action));
            }
        };
    }

    private static JLabel createArrow(final ActionLink link) {
        JLabel arrow = new JLabel(AllIcons.General.Combo3);
        arrow.setCursor(Cursor.getPredefinedCursor(12));
        arrow.setVerticalAlignment(3);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$5", "onClick"));
                }
                MouseEvent newEvent = MouseEventAdapter.convert((MouseEvent)e, (Component)link, (int)e.getX(), (int)e.getY());
                link.doClick((InputEvent)newEvent);
                return true;
            }
        }.installOn((Component)arrow);
        return arrow;
    }

    public BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    public Rectangle suggestChildFrameBounds() {
        return this.getBounds();
    }

    @Nullable
    public Project getProject() {
        return ProjectManager.getInstance().getDefaultProject();
    }

    public void setFrameTitle(String title) {
        this.setTitle(title);
    }

    public void setFileTitle(String fileTitle, File ioFile) {
        this.setTitle(fileTitle);
    }

    public IdeRootPaneNorthExtension getNorthExtension(String key) {
        return null;
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    public static void notifyFrameClosed(JFrame frame) {
        FlatWelcomeFrame.saveLocation(frame.getBounds());
    }

    public static Pair<JPanel, JBList> createActionGroupPanel(ActionGroup action, final JComponent parent, final Runnable backAction) {
        JPanel actionsListPanel = new JPanel(new BorderLayout());
        actionsListPanel.setBackground(FlatWelcomeFrame.getProjectsBackground());
        final JBList list = new JBList((Object[])action.getChildren(null));
        list.setBackground(FlatWelcomeFrame.getProjectsBackground());
        list.installCellRenderer((NotNullFunction)new NotNullFunction<AnAction, JComponent>(){
            final JLabel label = new JLabel();
            {
                this.label.setBorder((Border)JBUI.Borders.empty((int)3, (int)7));
            }

            @NotNull
            public JComponent fun(AnAction action) {
                this.label.setText(action.getTemplatePresentation().getText());
                Icon icon = action.getTemplatePresentation().getIcon();
                this.label.setIcon(icon);
                JLabel jLabel = this.label;
                if (jLabel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$6", "fun"));
                }
                return jLabel;
            }
        });
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)list, (boolean)true);
        pane.setBackground(FlatWelcomeFrame.getProjectsBackground());
        actionsListPanel.add((Component)pane, "Center");
        if (backAction != null) {
            JLabel back = new JLabel(AllIcons.Actions.Back);
            back.setBorder((Border)JBUI.Borders.empty((int)3, (int)7, (int)10, (int)7));
            back.setHorizontalAlignment(2);
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$7", "onClick"));
                    }
                    backAction.run();
                    return true;
                }
            }.installOn((Component)back);
            actionsListPanel.add((Component)back, "South");
        }
        final Ref selected = Ref.create();
        final JPanel main = new JPanel(new BorderLayout());
        main.add((Component)actionsListPanel, "West");
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object value;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (!selected.isNull()) {
                    main.remove((Component)selected.get());
                }
                if ((value = list.getSelectedValue()) instanceof AbstractActionWithPanel) {
                    JPanel panel = ((AbstractActionWithPanel)((Object)value)).createPanel();
                    panel.setBorder((Border)JBUI.Borders.empty((int)7, (int)10));
                    selected.set((Object)panel);
                    main.add((Component)selected.get());
                    for (JButton button : UIUtil.findComponentsOfType((JComponent)main, JButton.class)) {
                        if (button.getClientProperty("DefaultAction") != Boolean.TRUE) continue;
                        parent.getRootPane().setDefaultButton(button);
                        break;
                    }
                    main.revalidate();
                    main.repaint();
                }
            }
        };
        list.addListSelectionListener(selectionListener);
        if (backAction != null) {
            new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$9", "actionPerformed"));
                    }
                    backAction.run();
                }
            }.registerCustomShortcutSet(27, 0, (JComponent)main);
        }
        return Pair.create((Object)main, (Object)list);
    }

    public static class WelcomeScreenActionsPanel {
        private JPanel root;
        private JPanel actions;

        public WelcomeScreenActionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JPanel jPanel2;
            this.root = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.setOpaque(false);
            this.actions = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel.setOpaque(false);
            jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel2.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.root;
        }
    }

    private class FlatWelcomeScreen
    extends JPanel
    implements WelcomeScreen {
        private JBSlidingPanel mySlidingPanel;

        public FlatWelcomeScreen() {
            super(new BorderLayout());
            this.mySlidingPanel = new JBSlidingPanel();
            this.mySlidingPanel.add("root", (Component)this);
            this.setBackground(FlatWelcomeFrame.getMainBackground());
            if (RecentProjectsManager.getInstance().getRecentProjectsActions(false, FlatWelcomeFrame.isUseProjectGroups()).length > 0) {
                final JComponent recentProjects = this.createRecentProjects();
                this.add((Component)recentProjects, "West");
                final JList projectsList = (JList)UIUtil.findComponentOfType((JComponent)recentProjects, JList.class);
                if (projectsList != null) {
                    projectsList.getModel().addListDataListener(new ListDataListener(){

                        @Override
                        public void intervalAdded(ListDataEvent e) {
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent e) {
                            this.removeIfNeeded();
                        }

                        private void removeIfNeeded() {
                            if (RecentProjectsManager.getInstance().getRecentProjectsActions(false, FlatWelcomeFrame.isUseProjectGroups()).length == 0) {
                                FlatWelcomeScreen.this.remove(recentProjects);
                                FlatWelcomeScreen.this.revalidate();
                                FlatWelcomeScreen.this.repaint();
                            }
                        }

                        @Override
                        public void contentsChanged(ListDataEvent e) {
                            this.removeIfNeeded();
                        }
                    });
                    projectsList.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            projectsList.repaint();
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            projectsList.repaint();
                        }
                    });
                }
            }
            this.add((Component)this.createBody(), "Center");
        }

        public JComponent getWelcomePanel() {
            return this.mySlidingPanel;
        }

        private JComponent createBody() {
            NonOpaquePanel panel = new NonOpaquePanel((LayoutManager)new BorderLayout());
            panel.add((Component)this.createLogo(), (Object)"North");
            panel.add((Component)this.createActionPanel(), (Object)"Center");
            panel.add((Component)this.createSettingsAndDocs(), (Object)"South");
            return panel;
        }

        private JComponent createSettingsAndDocs() {
            NonOpaquePanel panel = new NonOpaquePanel((LayoutManager)new BorderLayout());
            NonOpaquePanel toolbar = new NonOpaquePanel();
            AnAction register = ActionManager.getInstance().getAction("Register");
            boolean registeredVisible = false;
            if (register != null) {
                AnActionEvent e = AnActionEvent.createFromAnAction((AnAction)register, null, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext((Component)this));
                register.update(e);
                Presentation presentation = e.getPresentation();
                if (presentation.isEnabled()) {
                    ActionLink registerLink = new ActionLink("Register", register);
                    registerLink.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
                    NonOpaquePanel button = new NonOpaquePanel((LayoutManager)new BorderLayout());
                    button.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
                    button.add((Component)registerLink);
                    this.installFocusable((JComponent)button, register, 38, 39, true);
                    NonOpaquePanel wrap = new NonOpaquePanel();
                    wrap.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
                    wrap.add((Component)button);
                    panel.add((Component)wrap, "West");
                    registeredVisible = true;
                }
            }
            toolbar.setLayout((LayoutManager)new BoxLayout((Container)toolbar, 0));
            toolbar.add((Component)this.createActionLink("Configure", "WelcomeScreen.Configure", AllIcons.General.GearPlain, !registeredVisible));
            toolbar.add((Component)this.createActionLink("Get Help", "WelcomeScreen.Documentation", null, false));
            panel.add((Component)toolbar, "East");
            panel.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)8, (int)11));
            return panel;
        }

        private JComponent createActionLink(String text, final String groupId, Icon icon, boolean focusListOnLeft) {
            final Ref ref = new Ref(null);
            AnAction action = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$3", "actionPerformed"));
                    }
                    ActionGroup configureGroup = (ActionGroup)ActionManager.getInstance().getAction(groupId);
                    PopupFactoryImpl.ActionGroupPopup popup = (PopupFactoryImpl.ActionGroupPopup)JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new IconsFreeActionGroup(configureGroup), e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, "WelcomeScreen");
                    popup.showUnderneathOfLabel((JLabel)ref.get());
                    UsageTrigger.trigger("welcome.screen." + groupId);
                }
            };
            ref.set((Object)new ActionLink(text, icon, action));
            ((ActionLink)ref.get()).setPaintUnderline(false);
            ((ActionLink)ref.get()).setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
            NonOpaquePanel panel = new NonOpaquePanel((LayoutManager)new BorderLayout());
            panel.setBorder((Border)JBUI.Borders.empty((int)4, (int)6, (int)4, (int)6));
            panel.add((Component)ref.get());
            panel.add((Component)FlatWelcomeFrame.createArrow((ActionLink)ref.get()), (Object)"East");
            this.installFocusable((JComponent)panel, action, 38, 40, focusListOnLeft);
            return panel;
        }

        private JComponent createActionPanel() {
            NonOpaquePanel actions = new NonOpaquePanel();
            actions.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
            actions.setLayout(new BoxLayout((Container)actions, 1));
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup quickStart = (ActionGroup)actionManager.getAction("WelcomeScreen.QuickStart");
            DefaultActionGroup group = new DefaultActionGroup();
            this.collectAllActions(group, quickStart);
            for (AnAction action : group.getChildren(null)) {
                Icon icon;
                JPanel button = new JPanel(new BorderLayout());
                button.setOpaque(false);
                button.setBorder((Border)JBUI.Borders.empty((int)8, (int)20));
                AnActionEvent e = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext((Component)this));
                action.update(e);
                Presentation presentation = e.getPresentation();
                if (!presentation.isVisible()) continue;
                String text = presentation.getText();
                if (text != null && text.endsWith("...")) {
                    text = text.substring(0, text.length() - 3);
                }
                if ((icon = presentation.getIcon()).getIconHeight() != JBUI.scale((int)16) || icon.getIconWidth() != JBUI.scale((int)16)) {
                    icon = JBUI.emptyIcon((int)16);
                }
                action = this.wrapGroups(action);
                ActionLink link = new ActionLink(text, icon, action, FlatWelcomeFrame.createUsageTracker(action));
                link.setPaintUnderline(false);
                link.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
                button.add((Component)link);
                if (action instanceof WelcomePopupAction) {
                    button.add((Component)FlatWelcomeFrame.createArrow(link), "East");
                }
                this.installFocusable(button, action, 38, 40, true);
                actions.add(button);
            }
            WelcomeScreenActionsPanel panel = new WelcomeScreenActionsPanel();
            panel.actions.add((Component)actions);
            return panel.root;
        }

        private AnAction wrapGroups(AnAction action) {
            if (action instanceof ActionGroup && ((ActionGroup)action).isPopup()) {
                final Pair<JPanel, JBList> panel = FlatWelcomeFrame.createActionGroupPanel((ActionGroup)action, (JComponent)this.mySlidingPanel, new Runnable(){

                    @Override
                    public void run() {
                        FlatWelcomeScreen.this.goBack();
                    }
                });
                final Runnable onDone = new Runnable(){

                    @Override
                    public void run() {
                        ListSelectionListener[] listeners;
                        JBList list = (JBList)panel.second;
                        ScrollingUtil.ensureSelectionExists((JList)list);
                        for (ListSelectionListener listener : listeners = (ListSelectionListener[])((DefaultListSelectionModel)list.getSelectionModel()).getListeners(ListSelectionListener.class)) {
                            listener.valueChanged(new ListSelectionEvent(list, list.getSelectedIndex(), list.getSelectedIndex(), true));
                        }
                        list.requestFocus();
                    }
                };
                final String name = action.getClass().getName();
                this.mySlidingPanel.add(name, (Component)panel.first);
                Presentation p = action.getTemplatePresentation();
                return new DumbAwareAction(p.getText(), p.getDescription(), p.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$6", "actionPerformed"));
                        }
                        FlatWelcomeScreen.this.mySlidingPanel.getLayout().swipe((Container)FlatWelcomeScreen.this.mySlidingPanel, name, JBCardLayout.SwipeDirection.FORWARD, onDone);
                    }
                };
            }
            return action;
        }

        protected void goBack() {
            this.mySlidingPanel.swipe("root", JBCardLayout.SwipeDirection.BACKWARD).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    FlatWelcomeScreen.this.mySlidingPanel.getRootPane().setDefaultButton(null);
                }
            });
        }

        private void collectAllActions(DefaultActionGroup group, ActionGroup actionGroup) {
            for (AnAction action : actionGroup.getChildren(null)) {
                if (action instanceof ActionGroup && !((ActionGroup)action).isPopup()) {
                    this.collectAllActions(group, (ActionGroup)action);
                    continue;
                }
                group.add(action);
            }
        }

        private JComponent createLogo() {
            NonOpaquePanel panel = new NonOpaquePanel((LayoutManager)new BorderLayout());
            ApplicationInfoEx app = ApplicationInfoEx.getInstanceEx();
            JLabel logo = new JLabel(IconLoader.getIcon((String)app.getWelcomeScreenLogoUrl()));
            logo.setBorder((Border)JBUI.Borders.empty((int)30, (int)0, (int)10, (int)0));
            logo.setHorizontalAlignment(0);
            panel.add((Component)logo, (Object)"North");
            JLabel appName = new JLabel(ApplicationNamesInfo.getInstance().getFullProductName());
            Font font = this.getProductFont();
            appName.setForeground(JBColor.foreground());
            appName.setFont(font.deriveFont(JBUI.scale((float)36.0f)).deriveFont(0));
            appName.setHorizontalAlignment(0);
            String appVersion = "Version " + app.getFullVersion();
            if (app.isEAP() && app.getBuild().getBuildNumber() < Integer.MAX_VALUE) {
                appVersion = appVersion + " (" + app.getBuild().asString() + ")";
            }
            JLabel version = new JLabel(appVersion);
            version.setFont(this.getProductFont().deriveFont(JBUI.scale((float)16.0f)));
            version.setHorizontalAlignment(0);
            version.setForeground((Color)Gray._128);
            panel.add((Component)appName);
            panel.add((Component)version, (Object)"South");
            panel.setBorder((Border)JBUI.Borders.emptyBottom((int)20));
            return panel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Font getProductFont() {
            String name = "/fonts/Roboto-Light.ttf";
            URL url = AppUIUtil.class.getResource(name);
            if (url == null) {
                Logger.getInstance(AppUIUtil.class).warn("Resource missing: " + name);
            } else {
                Font font;
                InputStream is = url.openStream();
                try {
                    font = Font.createFont(0, is);
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        Logger.getInstance(AppUIUtil.class).warn("Cannot load font: " + url, t);
                    }
                }
                is.close();
                return font;
            }
            return UIUtil.getLabelFont();
        }

        private JComponent createRecentProjects() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new NewRecentProjectPanel(this), "Center");
            panel.setBackground(FlatWelcomeFrame.getProjectsBackground());
            panel.setBorder((Border)new CustomLineBorder((Color)FlatWelcomeFrame.getSeparatorColor(), (Insets)JBUI.insetsRight((int)1)));
            return panel;
        }

        private void installFocusable(final JComponent comp, final AnAction action, final int prevKeyCode, final int nextKeyCode, final boolean focusListOnLeft) {
            comp.setFocusable(true);
            comp.setFocusTraversalKeysEnabled(true);
            comp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    JList list = (JList)UIUtil.findComponentOfType((JComponent)FlatWelcomeFrame.this.getComponent(), JList.class);
                    if (e.getKeyCode() == 10) {
                        ActionLink link;
                        InputEvent event = e;
                        if (e.getComponent() instanceof JComponent && (link = (ActionLink)UIUtil.findComponentOfType((JComponent)((JComponent)e.getComponent()), ActionLink.class)) != null) {
                            event = new MouseEvent((Component)link, 500, e.getWhen(), e.getModifiers(), 0, 0, 1, false, 1);
                        }
                        action.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)event, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext()));
                    } else if (e.getKeyCode() == prevKeyCode) {
                        FlatWelcomeScreen.this.focusPrev(comp);
                    } else if (e.getKeyCode() == nextKeyCode) {
                        FlatWelcomeScreen.this.focusNext(comp);
                    } else if (e.getKeyCode() == 37) {
                        if (focusListOnLeft) {
                            if (list != null) {
                                list.requestFocus();
                            }
                        } else {
                            FlatWelcomeScreen.this.focusPrev(comp);
                        }
                    } else if (e.getKeyCode() == 39) {
                        FlatWelcomeScreen.this.focusNext(comp);
                    }
                }
            });
            comp.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    comp.setOpaque(true);
                    comp.setBackground(FlatWelcomeFrame.getActionLinkSelectionColor());
                }

                @Override
                public void focusLost(FocusEvent e) {
                    comp.setOpaque(false);
                    comp.setBackground(FlatWelcomeFrame.getMainBackground());
                }
            });
        }

        protected void focusPrev(JComponent comp) {
            Component prev;
            FocusTraversalPolicy policy = FlatWelcomeFrame.this.getFocusTraversalPolicy();
            if (policy != null && (prev = policy.getComponentBefore(FlatWelcomeFrame.this, comp)) != null) {
                prev.requestFocus();
            }
        }

        protected void focusNext(JComponent comp) {
            Component next;
            FocusTraversalPolicy policy = FlatWelcomeFrame.this.getFocusTraversalPolicy();
            if (policy != null && (next = policy.getComponentAfter(FlatWelcomeFrame.this, comp)) != null) {
                next.requestFocus();
            }
        }

        public void setupFrame(JFrame frame) {
        }

        public void dispose() {
        }

        private class IconsFreeActionGroup
        extends ActionGroup {
            private final ActionGroup myGroup;

            public IconsFreeActionGroup(ActionGroup group) {
                super(group.getTemplatePresentation().getText(), group.getTemplatePresentation().getDescription(), null);
                this.myGroup = group;
            }

            public boolean isPopup() {
                return this.myGroup.isPopup();
            }

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] children = this.myGroup.getChildren(e);
                AnAction[] patched = new AnAction[children.length];
                for (int i = 0; i < children.length; ++i) {
                    patched[i] = this.patch(children[i]);
                }
                if (patched == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$IconsFreeActionGroup", "getChildren"));
                }
                return patched;
            }

            private AnAction patch(final AnAction child) {
                if (child instanceof ActionGroup) {
                    return new IconsFreeActionGroup((ActionGroup)child);
                }
                Presentation presentation = child.getTemplatePresentation();
                return new AnAction(presentation.getText(), presentation.getDescription(), null){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$IconsFreeActionGroup$1", "actionPerformed"));
                        }
                        child.actionPerformed(e);
                        UsageTrigger.trigger("welcome.screen." + e.getActionManager().getId(child));
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$IconsFreeActionGroup$1", "update"));
                        }
                        child.update(e);
                        e.getPresentation().setIcon(null);
                    }

                    public boolean isDumbAware() {
                        return child.isDumbAware();
                    }
                };
            }
        }
    }
}

