/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.List;

public class TypeEqualityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance((String)("#" + TypeEqualityConstraint.class.getName()));
    private PsiType myT;
    private PsiType myS;

    public TypeEqualityConstraint(PsiType t, PsiType s) {
        this.myT = t;
        this.myS = s;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        if (this.myT instanceof PsiWildcardType && this.myS instanceof PsiWildcardType) {
            PsiType tBound = ((PsiWildcardType)this.myT).getBound();
            PsiType sBound = ((PsiWildcardType)this.myS).getBound();
            if (tBound == null && sBound == null) {
                return true;
            }
            if (sBound == null && ((PsiWildcardType)this.myT).isExtends()) {
                constraints.add(new TypeEqualityConstraint(((PsiWildcardType)this.myS).getExtendsBound(), tBound));
                return true;
            }
            if (tBound == null && ((PsiWildcardType)this.myS).isExtends()) {
                constraints.add(new TypeEqualityConstraint(((PsiWildcardType)this.myT).getExtendsBound(), sBound));
                return true;
            }
            if (((PsiWildcardType)this.myT).isExtends() && ((PsiWildcardType)this.myS).isExtends() || ((PsiWildcardType)this.myT).isSuper() && ((PsiWildcardType)this.myS).isSuper()) {
                LOG.assertTrue(tBound != null);
                LOG.assertTrue(sBound != null);
                constraints.add(new TypeEqualityConstraint(tBound, sBound));
                return true;
            }
        }
        if (this.myT instanceof PsiWildcardType || this.myS instanceof PsiWildcardType) {
            return false;
        }
        if (session.isProperType(this.myT) && session.isProperType(this.myS)) {
            if (this.myT == null) {
                return this.myS == null || this.myS.equalsToText("java.lang.Object");
            }
            if (this.myS == null) {
                return true;
            }
            return Comparing.equal((Object)this.myT, (Object)this.myS);
        }
        InferenceVariable inferenceVariable = session.getInferenceVariable(this.myS);
        if (inferenceVariable != null) {
            inferenceVariable.addBound(this.myT, InferenceBound.EQ);
            return true;
        }
        inferenceVariable = session.getInferenceVariable(this.myT);
        if (inferenceVariable != null) {
            inferenceVariable.addBound(this.myS, InferenceBound.EQ);
            return true;
        }
        if (this.myT instanceof PsiClassType && this.myS instanceof PsiClassType) {
            PsiClassType.ClassResolveResult tResult = ((PsiClassType)this.myT).resolveGenerics();
            PsiClassType.ClassResolveResult sResult = ((PsiClassType)this.myS).resolveGenerics();
            PsiClass tClass = tResult.getElement();
            if (tClass != null && tClass.getManager().areElementsEquivalent((PsiElement)tClass, (PsiElement)sResult.getElement())) {
                PsiSubstitutor tSubstitutor = tResult.getSubstitutor();
                PsiSubstitutor sSubstitutor = sResult.getSubstitutor();
                for (PsiTypeParameter typeParameter : tClass.getTypeParameters()) {
                    PsiType tSubstituted = tSubstitutor.substitute(typeParameter);
                    PsiType sSubstituted = sSubstitutor.substituteWithBoundsPromotion(typeParameter);
                    if (tSubstituted == null || sSubstituted == null) continue;
                    constraints.add(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                }
                return true;
            }
        }
        if (this.myT instanceof PsiArrayType && this.myS instanceof PsiArrayType) {
            constraints.add(new TypeEqualityConstraint(((PsiArrayType)this.myT).getComponentType(), ((PsiArrayType)this.myS).getComponentType()));
            return true;
        }
        return false;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeEqualityConstraint that = (TypeEqualityConstraint)o;
        if (this.myS != null ? !this.myS.equals(that.myS) : that.myS != null) {
            return false;
        }
        return !(this.myT != null ? !this.myT.equals(that.myT) : that.myT != null);
    }

    public int hashCode() {
        int result = this.myT != null ? this.myT.hashCode() : 0;
        result = 31 * result + (this.myS != null ? this.myS.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myT.getPresentableText() + " == " + this.myS.getPresentableText();
    }
}

