/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsageCellRenderer;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class SliceLeafValueRootNode
extends SliceNode
implements MyColoredTreeCellRenderer {
    protected final List<SliceNode> myCachedChildren;

    public SliceLeafValueRootNode(@NotNull Project project, PsiElement leafExpression, SliceNode root, List<SliceNode> children, SliceAnalysisParams params) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/slicer/SliceLeafValueRootNode", "<init>"));
        }
        super(project, JavaSliceUsage.createRootUsage(leafExpression, params), root.targetEqualUsages);
        this.myCachedChildren = children;
    }

    @NotNull
    public Collection<SliceNode> getChildren() {
        List<SliceNode> list = this.myCachedChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceLeafValueRootNode", "getChildren"));
        }
        return list;
    }

    @Override
    protected void update(PresentationData presentation) {
    }

    @Override
    public String toString() {
        PsiElement element;
        Usage myLeafExpression = (Usage)this.getValue();
        String text = myLeafExpression instanceof UsageInfo2UsageAdapter ? ((element = ((UsageInfo2UsageAdapter)myLeafExpression).getUsageInfo().getElement()) == null ? "" : element.getText()) : "Other";
        return "Value: " + text;
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer, @NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/slicer/SliceLeafValueRootNode", "customizeCellRenderer"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/slicer/SliceLeafValueRootNode", "customizeCellRenderer"));
        }
        Usage usage = (Usage)this.getValue();
        renderer.append("Value: ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (usage instanceof UsageInfo2UsageAdapter) {
            PsiElement element = ((UsageInfo2UsageAdapter)usage).getElement();
            if (element == null) {
                renderer.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SliceUsageCellRenderer.ourInvalidAttributes);
            } else {
                SliceLeafValueRootNode.appendElementText((UsageInfo2UsageAdapter)usage, element, renderer);
            }
        } else {
            renderer.append("Other", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    private static void appendElementText(@NotNull UsageInfo2UsageAdapter usage, @NotNull PsiElement element, @NotNull SliceUsageCellRendererBase renderer) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/slicer/SliceLeafValueRootNode", "appendElementText"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceLeafValueRootNode", "appendElementText"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/slicer/SliceLeafValueRootNode", "appendElementText"));
        }
        PsiFile file = element.getContainingFile();
        ArrayList result = new ArrayList();
        ChunkExtractor.getExtractor((PsiFile)element.getContainingFile()).createTextChunks(usage, (CharSequence)file.getText(), element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset(), false, result);
        for (TextChunk chunk : result) {
            renderer.append(chunk.getText(), chunk.getSimpleAttributesIgnoreBackground());
        }
    }
}

