/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.actions.ViewStructureAction;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStructureTestFixture {
    private final PsiFile myFile;
    private FileStructurePopup myPopup;

    public FileStructureTestFixture(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/FileStructureTestFixture", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/FileStructureTestFixture", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/FileStructureTestFixture", "<init>"));
        }
        this.myFile = file;
        this.myPopup = ViewStructureAction.createPopup(project, (FileEditor)TextEditorProvider.getInstance().getTextEditor(editor));
        assert (this.myPopup != null);
        this.myPopup.createCenterPanel();
        this.getBuilder().getUi().getUpdater().setPassThroughMode(true);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myPopup);
    }

    @Nullable
    public FilteringTreeStructure.FilteringNode update() {
        final Ref nodeRef = new Ref();
        this.myPopup.getTreeBuilder().refilter().doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                FileStructureTestFixture.this.getStructure().rebuild();
                FileStructureTestFixture.this.updateTree();
                FileStructureTestFixture.this.getBuilder().updateFromRoot();
                TreeUtil.expandAll((JTree)FileStructureTestFixture.this.getTree());
                nodeRef.set((Object)FileStructureTestFixture.this.myPopup.selectPsiElement(FileStructureTestFixture.this.myPopup.getCurrentElement(FileStructureTestFixture.this.myFile)));
                FileStructureTestFixture.this.getBuilder().getUi().select(nodeRef.get(), null);
            }
        });
        return (FilteringTreeStructure.FilteringNode)nodeRef.get();
    }

    public Tree getTree() {
        return this.myPopup.getTree();
    }

    public FilteringTreeBuilder getBuilder() {
        return this.myPopup.getTreeBuilder();
    }

    public FileStructurePopup.MyTreeSpeedSearch getSpeedSearch() {
        return (FileStructurePopup.MyTreeSpeedSearch)this.myPopup.getSpeedSearch();
    }

    public void updateTree() {
        this.updateRecursively(this.getRootNode());
    }

    public FilteringTreeStructure getStructure() {
        FilteringTreeStructure structure = (FilteringTreeStructure)this.getBuilder().getTreeStructure();
        assert (structure != null);
        return structure;
    }

    public FilteringTreeStructure.FilteringNode getRootNode() {
        return this.getStructure().getRootElement();
    }

    public void updateRecursively(FilteringTreeStructure.FilteringNode node) {
        node.update();
        for (FilteringTreeStructure.FilteringNode child : node.children()) {
            this.updateRecursively(child);
        }
    }

    @NotNull
    public FileStructurePopup getPopup() {
        FileStructurePopup fileStructurePopup = this.myPopup;
        if (fileStructurePopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/FileStructureTestFixture", "getPopup"));
        }
        return fileStructurePopup;
    }
}

