/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.BaseToolManager;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolsGroup;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ToolsProcessor<T extends Tool>
extends BaseSchemeProcessor<ToolsGroup<T>> {
    @NonNls
    private static final String TOOL_SET = "toolSet";
    @NonNls
    private static final String TOOL = "tool";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SHOW_IN_MAIN_MENU = "showInMainMenu";
    @NonNls
    private static final String SHOW_IN_EDITOR = "showInEditor";
    @NonNls
    private static final String SHOW_IN_PROJECT = "showInProject";
    @NonNls
    private static final String SHOW_IN_SEARCH_POPUP = "showInSearchPopup";
    @NonNls
    private static final String DISABLED = "disabled";
    @NonNls
    private static final String USE_CONSOLE = "useConsole";
    @NonNls
    private static final String SHOW_CONSOLE_ON_STDOUT = "showConsoleOnStdOut";
    @NonNls
    private static final String SHOW_CONSOLE_ON_STDERR = "showConsoleOnStdErr";
    @NonNls
    private static final String SYNCHRONIZE_AFTER_EXECUTION = "synchronizeAfterRun";
    @NonNls
    private static final String EXEC = "exec";
    @NonNls
    private static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    @NonNls
    private static final String COMMAND = "COMMAND";
    @NonNls
    private static final String PARAMETERS = "PARAMETERS";
    @NonNls
    private static final String FILTER = "filter";
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";

    @NotNull
    public ToolsGroup<T> readScheme(@NotNull Element root) throws InvalidDataException, IOException, JDOMException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/tools/ToolsProcessor", "readScheme"));
        }
        if (!TOOL_SET.equals(root.getName())) {
            throw new InvalidDataException();
        }
        String attrName = root.getAttributeValue("name");
        String groupName = StringUtil.isEmpty((String)attrName) ? "External Tools" : attrName;
        ToolsGroup<T> result = this.createToolsGroup(groupName);
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication());
        for (Element element : root.getChildren(TOOL)) {
            T tool = this.createTool();
            this.readToolAttributes(element, tool);
            Element exec = element.getChild(EXEC);
            if (exec != null) {
                for (Object o1 : exec.getChildren(ELEMENT_OPTION)) {
                    Element optionElement = (Element)o1;
                    String name = optionElement.getAttributeValue("name");
                    String value = optionElement.getAttributeValue(ATTRIBUTE_VALUE);
                    if (WORKING_DIRECTORY.equals(name) && value != null) {
                        String replace = macroManager.expandPath(value).replace('/', File.separatorChar);
                        ((Tool)tool).setWorkingDirectory(replace);
                    }
                    if (COMMAND.equals(name)) {
                        ((Tool)tool).setProgram(macroManager.expandPath(BaseToolManager.convertString(value)));
                    }
                    if (!PARAMETERS.equals(name)) continue;
                    ((Tool)tool).setParameters(macroManager.expandPath(BaseToolManager.convertString(value)));
                }
            }
            for (Object o2 : element.getChildren(FILTER)) {
                Element childNode = (Element)o2;
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.readExternal(childNode);
                ((Tool)tool).addOutputFilter(filterInfo);
            }
            ((Tool)tool).setGroup(groupName);
            result.addElement(tool);
        }
        ToolsGroup<T> toolsGroup = result;
        if (toolsGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/ToolsProcessor", "readScheme"));
        }
        return toolsGroup;
    }

    protected void readToolAttributes(Element element, T tool) {
        ((Tool)tool).setName(BaseToolManager.convertString(element.getAttributeValue("name")));
        ((Tool)tool).setDescription(BaseToolManager.convertString(element.getAttributeValue(DESCRIPTION)));
        ((Tool)tool).setShownInMainMenu(Boolean.valueOf(element.getAttributeValue(SHOW_IN_MAIN_MENU)));
        ((Tool)tool).setShownInEditor(Boolean.valueOf(element.getAttributeValue(SHOW_IN_EDITOR)));
        ((Tool)tool).setShownInProjectViews(Boolean.valueOf(element.getAttributeValue(SHOW_IN_PROJECT)));
        ((Tool)tool).setShownInSearchResultsPopup(Boolean.valueOf(element.getAttributeValue(SHOW_IN_SEARCH_POPUP)));
        ((Tool)tool).setEnabled(Boolean.valueOf(element.getAttributeValue(DISABLED)) == false);
        ((Tool)tool).setUseConsole(Boolean.valueOf(element.getAttributeValue(USE_CONSOLE)));
        ((Tool)tool).setShowConsoleOnStdOut(Boolean.valueOf(element.getAttributeValue(SHOW_CONSOLE_ON_STDOUT)));
        ((Tool)tool).setShowConsoleOnStdErr(Boolean.valueOf(element.getAttributeValue(SHOW_CONSOLE_ON_STDERR)));
        ((Tool)tool).setFilesSynchronizedAfterRun(Boolean.valueOf(element.getAttributeValue(SYNCHRONIZE_AFTER_EXECUTION)));
    }

    protected abstract ToolsGroup<T> createToolsGroup(String var1);

    protected abstract T createTool();

    public Element writeScheme(@NotNull ToolsGroup<T> scheme) throws WriteExternalException {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/tools/ToolsProcessor", "writeScheme"));
        }
        Element groupElement = new Element(TOOL_SET);
        groupElement.setAttribute("name", scheme.getName());
        for (Tool tool : scheme.getElements()) {
            this.saveTool(tool, groupElement);
        }
        return groupElement;
    }

    private void saveTool(T tool, Element groupElement) {
        FilterInfo[] filters;
        Element element = new Element(TOOL);
        if (((Tool)tool).getName() != null) {
            element.setAttribute("name", ((Tool)tool).getName());
        }
        if (((Tool)tool).getDescription() != null) {
            element.setAttribute(DESCRIPTION, ((Tool)tool).getDescription());
        }
        this.saveToolAttributes(tool, element);
        Element taskElement = new Element(EXEC);
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication());
        Element option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", COMMAND);
        if (((Tool)tool).getProgram() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, macroManager.collapsePath(((Tool)tool).getProgram()));
        }
        option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", PARAMETERS);
        if (((Tool)tool).getParameters() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, macroManager.collapsePath(((Tool)tool).getParameters()));
        }
        option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", WORKING_DIRECTORY);
        if (((Tool)tool).getWorkingDirectory() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, macroManager.collapsePath(((Tool)tool).getWorkingDirectory()).replace(File.separatorChar, '/'));
        }
        element.addContent(taskElement);
        for (FilterInfo filter : filters = ((Tool)tool).getOutputFilters()) {
            Element filterElement = new Element(FILTER);
            filter.writeExternal(filterElement);
            element.addContent(filterElement);
        }
        groupElement.addContent(element);
    }

    protected void saveToolAttributes(T tool, Element element) {
        element.setAttribute(SHOW_IN_MAIN_MENU, Boolean.toString(((Tool)tool).isShownInMainMenu()));
        element.setAttribute(SHOW_IN_EDITOR, Boolean.toString(((Tool)tool).isShownInEditor()));
        element.setAttribute(SHOW_IN_PROJECT, Boolean.toString(((Tool)tool).isShownInProjectViews()));
        element.setAttribute(SHOW_IN_SEARCH_POPUP, Boolean.toString(((Tool)tool).isShownInSearchResultsPopup()));
        element.setAttribute(DISABLED, Boolean.toString(!((Tool)tool).isEnabled()));
        element.setAttribute(USE_CONSOLE, Boolean.toString(((Tool)tool).isUseConsole()));
        element.setAttribute(SHOW_CONSOLE_ON_STDOUT, Boolean.toString(((Tool)tool).isShowConsoleOnStdOut()));
        element.setAttribute(SHOW_CONSOLE_ON_STDERR, Boolean.toString(((Tool)tool).isShowConsoleOnStdErr()));
        element.setAttribute(SYNCHRONIZE_AFTER_EXECUTION, Boolean.toString(((Tool)tool).synchronizeAfterExecution()));
    }
}

