/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.messages.SheetMessage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.graphics.ShadowRenderer;
import org.jetbrains.annotations.NotNull;

public class SheetController {
    private static final Logger LOG = Logger.getInstance(SheetController.class);
    private static final int SHEET_MINIMUM_HEIGHT = 143;
    private static final String fontName = "Lucida Grande";
    private static final Font regularFont = new Font("Lucida Grande", 0, 10);
    private static final Font boldFont = new Font("Lucida Grande", 1, 12).deriveFont(1);
    private final DialogWrapper.DoNotAskOption myDoNotAskOption;
    private boolean myDoNotAskResult;
    private BufferedImage myShadowImage;
    private final JButton[] buttons;
    private JButton myDefaultButton;
    private JComponent myFocusedComponent;
    private JCheckBox doNotAskCheckBox = new JCheckBox();
    public static int SHADOW_BORDER = 5;
    private static final int RIGHT_OFFSET = 10 - SHADOW_BORDER;
    private static final int TOP_SHEET_PADDING = 20;
    private static final int GAP_BETWEEN_LINES = 10;
    private static final int LEFT_SHEET_PADDING = 35;
    private static final int LEFT_SHEET_OFFSET = 120;
    private static final int GAP_BETWEEN_BUTTONS = 5;
    private static final String SPACE_OR_LINE_SEPARATOR_PATTERN = "[\\s" + System.getProperty("line.separator") + "]+";
    public int SHEET_WIDTH = 400;
    public int SHEET_HEIGHT = 143;
    int SHEET_NC_WIDTH = this.SHEET_WIDTH + SHADOW_BORDER * 2;
    int SHEET_NC_HEIGHT = this.SHEET_HEIGHT + SHADOW_BORDER;
    private Icon myIcon = UIUtil.getInformationIcon();
    private String myResult;
    private final JPanel mySheetPanel;
    private final SheetMessage mySheetMessage;
    private final JEditorPane messageTextPane = new JEditorPane();
    private final Dimension messageArea = new Dimension(250, Short.MAX_VALUE);

    SheetController(SheetMessage sheetMessage, String title, String message, Icon icon, String[] buttonTitles, String defaultButtonTitle, DialogWrapper.DoNotAskOption doNotAskOption, String focusedButtonTitle) {
        if (icon != null) {
            this.myIcon = icon;
        }
        this.myDoNotAskOption = doNotAskOption;
        this.myDoNotAskResult = doNotAskOption != null && !doNotAskOption.isToBeShown();
        this.mySheetMessage = sheetMessage;
        this.buttons = new JButton[buttonTitles.length];
        this.myResult = null;
        int defaultButtonIndex = -1;
        int focusedButtonIndex = -1;
        for (int i = 0; i < this.buttons.length; ++i) {
            String buttonTitle = buttonTitles[i];
            this.buttons[i] = new JButton();
            this.buttons[i].setOpaque(false);
            this.handleMnemonics(i, buttonTitle);
            if (buttonTitle.equals(defaultButtonTitle)) {
                defaultButtonIndex = i;
            }
            if (!buttonTitle.equals(focusedButtonTitle) || focusedButtonTitle.equals("Cancel")) continue;
            focusedButtonIndex = i;
        }
        int n = defaultButtonIndex = focusedButtonIndex == defaultButtonIndex || defaultButtonTitle == null ? 0 : defaultButtonIndex;
        if (focusedButtonIndex != -1 && defaultButtonIndex != focusedButtonIndex) {
            this.myFocusedComponent = this.buttons[focusedButtonIndex];
        } else if (doNotAskOption != null) {
            this.myFocusedComponent = this.doNotAskCheckBox;
        } else if (this.buttons.length > 1) {
            this.myFocusedComponent = this.buttons[this.buttons.length - 1];
        }
        JButton jButton = this.myDefaultButton = defaultButtonIndex == -1 ? this.buttons[0] : this.buttons[defaultButtonIndex];
        if (this.myResult == null) {
            this.myResult = Messages.CANCEL_BUTTON;
        }
        this.mySheetPanel = this.createSheetPanel(title, message, this.buttons);
        this.initShadowImage();
    }

    private void initShadowImage() {
        BufferedImage mySheetStencil = GraphicsUtilities.createCompatibleTranslucentImage((int)this.SHEET_WIDTH, (int)this.SHEET_HEIGHT);
        Graphics2D g2 = mySheetStencil.createGraphics();
        g2.setColor((Color)new JBColor((Color)Gray._255, (Color)Gray._0));
        g2.fillRect(0, 0, this.SHEET_WIDTH, this.SHEET_HEIGHT);
        g2.dispose();
        ShadowRenderer renderer = new ShadowRenderer();
        renderer.setSize(SHADOW_BORDER);
        renderer.setOpacity(0.8f);
        renderer.setColor((Color)new JBColor((Color)JBColor.BLACK, (Color)Gray._10));
        this.myShadowImage = renderer.createShadow(mySheetStencil);
    }

    private void handleMnemonics(int i, String buttonTitle) {
        this.buttons[i].setName(buttonTitle);
        this.buttons[i].setText(buttonTitle);
        SheetController.setMnemonicsFromChar('&', this.buttons[i]);
        SheetController.setMnemonicsFromChar('_', this.buttons[i]);
    }

    private static void setMnemonicsFromChar(char mnemonicChar, JButton button) {
        String buttonTitle = button.getText();
        if (buttonTitle.indexOf(mnemonicChar) != -1) {
            button.setMnemonic(buttonTitle.charAt(buttonTitle.indexOf(mnemonicChar) + 1));
            button.setText(buttonTitle.replace(Character.toString(mnemonicChar), ""));
        }
    }

    void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                if (SheetController.this.myFocusedComponent != null) {
                    SheetController.this.myFocusedComponent.requestFocus();
                } else {
                    LOG.debug("My focused component is null for the next message: " + SheetController.this.messageTextPane.getText());
                }
            }
        });
    }

    JPanel getPanel(JDialog w) {
        w.getRootPane().setDefaultButton(this.myDefaultButton);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/messages/SheetController$2", "actionPerformed"));
                }
                if (e.getSource() instanceof JButton) {
                    SheetController.this.myResult = ((JButton)e.getSource()).getName();
                }
                SheetController.this.mySheetMessage.startAnimation(false);
            }
        };
        this.mySheetPanel.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 2);
        for (JButton button : this.buttons) {
            button.addActionListener(actionListener);
        }
        return this.mySheetPanel;
    }

    private static float getSheetAlpha() {
        return 0.95f;
    }

    private JPanel createSheetPanel(String title, String message, JButton[] buttons) {
        String[] words;
        JPanel sheetPanel = new JPanel(){

            @Override
            protected void paintComponent(@NotNull Graphics g2d) {
                if (g2d == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/intellij/ui/messages/SheetController$3", "paintComponent"));
                }
                Graphics2D g = (Graphics2D)g2d.create();
                super.paintComponent(g);
                g.setComposite(AlphaComposite.getInstance(3, SheetController.getSheetAlpha()));
                g.setColor((Color)new JBColor((Color)Gray._230, UIUtil.getPanelBackground()));
                Rectangle2D.Double dialog = new Rectangle2D.Double(SHADOW_BORDER, 0.0, SheetController.this.SHEET_WIDTH, SheetController.this.SHEET_HEIGHT);
                SheetController.this.paintShadow(g);
                if (UIUtil.isUnderDarcula()) {
                    g.fillRoundRect((int)((RectangularShape)dialog).getX(), (int)((RectangularShape)dialog).getY() - 5, (int)((RectangularShape)dialog).getWidth(), (int)(5.0 + ((RectangularShape)dialog).getHeight()), 5, 5);
                } else {
                    g.fill(dialog);
                }
                SheetController.this.paintShadowFromParent(g);
            }
        };
        sheetPanel.setOpaque(false);
        sheetPanel.setLayout(null);
        JPanel ico = new JPanel(){

            @Override
            protected void paintComponent(@NotNull Graphics g) {
                if (g == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/messages/SheetController$4", "paintComponent"));
                }
                super.paintComponent(g);
                SheetController.this.myIcon.paintIcon(this, g, 0, 0);
            }
        };
        JEditorPane headerLabel = new JEditorPane();
        headerLabel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        headerLabel.setFont(boldFont);
        headerLabel.setEditable(false);
        headerLabel.setContentType("text/html");
        headerLabel.setSize(250, Short.MAX_VALUE);
        headerLabel.setText(title);
        headerLabel.setSize(250, headerLabel.getPreferredSize().height);
        headerLabel.setOpaque(false);
        headerLabel.setFocusable(false);
        sheetPanel.add(headerLabel);
        headerLabel.repaint();
        this.messageTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.messageTextPane.setFont(regularFont);
        this.messageTextPane.setEditable(false);
        this.messageTextPane.setContentType("text/html");
        this.messageTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        URL url = he.getURL();
                        if (url != null) {
                            Desktop.getDesktop().browse(url.toURI());
                        } else {
                            LOG.warn("URL is null; HyperlinkEvent: " + he.toString());
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (URISyntaxException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
        FontMetrics fontMetrics = sheetPanel.getFontMetrics(regularFont);
        int widestWordWidth = 250;
        for (String word : words = message == null ? ArrayUtil.EMPTY_STRING_ARRAY : message.split(SPACE_OR_LINE_SEPARATOR_PATTERN)) {
            widestWordWidth = Math.max(fontMetrics.stringWidth(word), widestWordWidth);
        }
        this.messageTextPane.setSize(widestWordWidth, Short.MAX_VALUE);
        this.messageTextPane.setText(SheetController.handleBreaks(message));
        this.messageArea.setSize(widestWordWidth, this.messageTextPane.getPreferredSize().height);
        this.SHEET_WIDTH = Math.max(120 + widestWordWidth + RIGHT_OFFSET, this.SHEET_WIDTH);
        this.messageTextPane.setSize(this.messageArea);
        this.messageTextPane.setOpaque(false);
        this.messageTextPane.setFocusable(false);
        sheetPanel.add(this.messageTextPane);
        this.messageTextPane.repaint();
        ico.setOpaque(false);
        ico.setSize(new Dimension(AllIcons.Logo_welcomeScreen.getIconWidth(), AllIcons.Logo_welcomeScreen.getIconHeight()));
        ico.setLocation(35, 20);
        sheetPanel.add(ico);
        headerLabel.setLocation(120, 20);
        this.messageTextPane.setLocation(120, 20 + headerLabel.getPreferredSize().height + 10);
        this.SHEET_HEIGHT = 20 + headerLabel.getPreferredSize().height + 10 + this.messageArea.height + 10;
        if (this.myDoNotAskOption != null) {
            this.layoutDoNotAskCheckbox(sheetPanel);
        }
        this.layoutWithAbsoluteLayout(buttons, sheetPanel);
        int BOTTOM_SHEET_PADDING = 10;
        this.SHEET_HEIGHT += BOTTOM_SHEET_PADDING;
        if (this.SHEET_HEIGHT < 143) {
            this.SHEET_HEIGHT = 143;
            this.shiftButtonsToTheBottom(143 - this.SHEET_HEIGHT);
        }
        sheetPanel.setFocusCycleRoot(true);
        this.recalculateShadow();
        sheetPanel.setSize(this.SHEET_NC_WIDTH, this.SHEET_NC_HEIGHT);
        return sheetPanel;
    }

    private static String handleBreaks(String message) {
        return message.replaceAll("(\r\n|\n)", "<br/>");
    }

    private void shiftButtonsToTheBottom(int shiftDistance) {
        for (JButton b : this.buttons) {
            b.setLocation(b.getX(), b.getY() + shiftDistance);
        }
    }

    private void recalculateShadow() {
        this.SHEET_NC_WIDTH = this.SHEET_WIDTH + SHADOW_BORDER * 2;
        this.SHEET_NC_HEIGHT = this.SHEET_HEIGHT + SHADOW_BORDER;
    }

    private void layoutWithAbsoluteLayout(JButton[] buttons, JPanel sheetPanel) {
        this.layoutButtons(buttons, sheetPanel);
    }

    private void paintShadow(Graphics2D g2d) {
        g2d.setBackground((Color)new JBColor(new Color(255, 255, 255, 0), new Color(110, 110, 110, 0)));
        g2d.clearRect(0, 0, this.SHEET_NC_WIDTH, this.SHEET_HEIGHT);
        g2d.drawImage((Image)this.myShadowImage, 0, -SHADOW_BORDER, null);
        g2d.clearRect(SHADOW_BORDER, 0, this.SHEET_WIDTH, this.SHEET_HEIGHT);
    }

    private static float getShadowAlpha() {
        return UIUtil.isUnderDarcula() ? 0.85f : 0.35f;
    }

    private void paintShadowFromParent(Graphics2D g2d) {
        g2d.setComposite(AlphaComposite.getInstance(3, SheetController.getShadowAlpha()));
        g2d.drawImage((Image)this.myShadowImage, 0, -this.SHEET_HEIGHT - SHADOW_BORDER, null);
    }

    private void layoutButtons(JButton[] buttons, JPanel panel) {
        int buttonWidth = 0;
        this.SHEET_HEIGHT += 10;
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].repaint();
            buttons[i].setSize(buttons[i].getPreferredSize());
            buttonWidth += buttons[i].getWidth();
            if (i == buttons.length - 1) break;
            buttonWidth += 5;
        }
        int buttonsRowWidth = 120 + buttonWidth + RIGHT_OFFSET;
        this.messageTextPane.setSize(Math.max(this.messageTextPane.getWidth(), buttonWidth), this.messageTextPane.getHeight());
        this.SHEET_WIDTH = Math.max(buttonsRowWidth, this.SHEET_WIDTH);
        int buttonShift = RIGHT_OFFSET;
        for (JButton button : buttons) {
            Dimension size = button.getSize();
            button.setBounds(this.SHEET_WIDTH - (buttonShift += size.width), this.SHEET_HEIGHT, size.width, size.height);
            panel.add(button);
            buttonShift += 5;
        }
        this.SHEET_HEIGHT += buttons[0].getHeight();
    }

    private void layoutDoNotAskCheckbox(JPanel sheetPanel) {
        this.doNotAskCheckBox.setText(this.myDoNotAskOption.getDoNotShowMessage());
        this.doNotAskCheckBox.setSelected(!this.myDoNotAskOption.isToBeShown());
        this.doNotAskCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/messages/SheetController$6", "itemStateChanged"));
                }
                SheetController.this.myDoNotAskResult = e.getStateChange() == 1;
            }
        });
        this.doNotAskCheckBox.repaint();
        this.doNotAskCheckBox.setSize(this.doNotAskCheckBox.getPreferredSize());
        this.doNotAskCheckBox.setLocation(120, this.SHEET_HEIGHT);
        sheetPanel.add(this.doNotAskCheckBox);
        if (this.myFocusedComponent == null) {
            this.myFocusedComponent = this.doNotAskCheckBox;
        }
        this.SHEET_HEIGHT += this.doNotAskCheckBox.getHeight();
    }

    Image getStaticImage() {
        JFrame myOffScreenFrame = new JFrame();
        myOffScreenFrame.add(this.mySheetPanel);
        myOffScreenFrame.getRootPane().setDefaultButton(this.myDefaultButton);
        BufferedImage image = SystemInfo.isJavaVersionAtLeast((String)"1.7") ? UIUtil.createImage((int)this.SHEET_NC_WIDTH, (int)this.SHEET_NC_HEIGHT, (int)2) : GraphicsUtilities.createCompatibleTranslucentImage((int)this.SHEET_NC_WIDTH, (int)this.SHEET_NC_HEIGHT);
        Graphics2D g = image.createGraphics();
        this.mySheetPanel.paint(g);
        g.dispose();
        myOffScreenFrame.dispose();
        return image;
    }

    public boolean getDoNotAskResult() {
        return this.myDoNotAskResult;
    }

    public String getResult() {
        return this.myResult;
    }

    public void dispose() {
        this.mySheetPanel.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }
}

