/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementGenerator;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.elements.EdgePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.impl.print.elements.SimplePrintElementImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPrintElementGenerator
implements PrintElementGenerator {
    @NotNull
    protected final LinearGraph myLinearGraph;
    @NotNull
    protected final PrintElementManager myPrintElementManager;

    protected AbstractPrintElementGenerator(@NotNull LinearGraph linearGraph, @NotNull PrintElementManager printElementManager) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "<init>"));
        }
        if (printElementManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementManager", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "<init>"));
        }
        this.myLinearGraph = linearGraph;
        this.myPrintElementManager = printElementManager;
    }

    @Override
    @NotNull
    public Collection<PrintElementWithGraphElement> getPrintElements(int rowIndex) {
        RowElementType rowElementType;
        ArrayList<PrintElementWithGraphElement> result = new ArrayList<PrintElementWithGraphElement>();
        HashMap arrows = ContainerUtil.newHashMap();
        for (SimpleRowElement rowElement : this.getSimpleRowElements(rowIndex)) {
            if (rowElement.myType.equals((Object)RowElementType.NODE)) continue;
            arrows.put((GraphEdge)rowElement.myElement, rowElement);
        }
        if (rowIndex < this.myLinearGraph.nodesCount() - 1) {
            for (ShortEdge shortEdge : this.getDownShortEdges(rowIndex)) {
                rowElementType = RowElementType.NODE;
                if (arrows.get(shortEdge.myEdge) != null && RowElementType.DOWN_ARROW.equals((Object)((SimpleRowElement)arrows.get((Object)shortEdge.myEdge)).myType)) {
                    rowElementType = RowElementType.DOWN_ARROW;
                    arrows.remove(shortEdge.myEdge);
                }
                result.add(this.createEdgePrintElement(rowIndex, shortEdge, EdgePrintElement.Type.DOWN, !rowElementType.equals((Object)RowElementType.NODE)));
            }
        }
        if (rowIndex > 0) {
            for (ShortEdge shortEdge : this.getDownShortEdges(rowIndex - 1)) {
                rowElementType = RowElementType.NODE;
                if (arrows.get(shortEdge.myEdge) != null && RowElementType.UP_ARROW.equals((Object)((SimpleRowElement)arrows.get((Object)shortEdge.myEdge)).myType)) {
                    rowElementType = RowElementType.UP_ARROW;
                    arrows.remove(shortEdge.myEdge);
                }
                result.add(this.createEdgePrintElement(rowIndex, shortEdge, EdgePrintElement.Type.UP, !rowElementType.equals((Object)RowElementType.NODE)));
            }
        }
        for (SimpleRowElement arrow : arrows.values()) {
            result.add(new EdgePrintElementImpl(rowIndex, arrow.myPosition, arrow.myPosition, arrow.myType == RowElementType.UP_ARROW ? EdgePrintElement.Type.UP : EdgePrintElement.Type.DOWN, (GraphEdge)arrow.myElement, true, this.myPrintElementManager));
        }
        for (SimpleRowElement rowElement : this.getSimpleRowElements(rowIndex)) {
            if (!rowElement.myType.equals((Object)RowElementType.NODE)) continue;
            result.add(this.createSimplePrintElement(rowIndex, rowElement));
        }
        ArrayList<PrintElementWithGraphElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "getPrintElements"));
        }
        return arrayList;
    }

    private SimplePrintElementImpl createSimplePrintElement(int rowIndex, SimpleRowElement rowElement) {
        return new SimplePrintElementImpl(rowIndex, rowElement.myPosition, rowElement.myElement, this.myPrintElementManager);
    }

    private EdgePrintElementImpl createEdgePrintElement(int rowIndex, @NotNull ShortEdge shortEdge, @NotNull EdgePrintElement.Type type, @NotNull boolean hasArrow) {
        int positionInOtherRow;
        int positionInCurrentRow;
        if (shortEdge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortEdge", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "createEdgePrintElement"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "createEdgePrintElement"));
        }
        if (type == EdgePrintElement.Type.DOWN) {
            positionInCurrentRow = shortEdge.myUpPosition;
            positionInOtherRow = shortEdge.myDownPosition;
        } else {
            positionInCurrentRow = shortEdge.myDownPosition;
            positionInOtherRow = shortEdge.myUpPosition;
        }
        return new EdgePrintElementImpl(rowIndex, positionInCurrentRow, positionInOtherRow, type, shortEdge.myEdge, hasArrow, this.myPrintElementManager);
    }

    @Override
    @NotNull
    public PrintElementWithGraphElement toPrintElementWithGraphElement(@NotNull PrintElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "toPrintElementWithGraphElement"));
        }
        if (printElement instanceof PrintElementWithGraphElement) {
            PrintElementWithGraphElement printElementWithGraphElement = (PrintElementWithGraphElement)printElement;
            if (printElementWithGraphElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "toPrintElementWithGraphElement"));
            }
            return printElementWithGraphElement;
        }
        int rowIndex = printElement.getRowIndex();
        for (PrintElementWithGraphElement printElementWithGE : this.getPrintElements(rowIndex)) {
            if (!printElementWithGE.equals(printElement)) continue;
            PrintElementWithGraphElement printElementWithGraphElement = printElementWithGE;
            if (printElementWithGraphElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "toPrintElementWithGraphElement"));
            }
            return printElementWithGraphElement;
        }
        throw new IllegalStateException("Not found graphElement for this printElement: " + printElement);
    }

    @NotNull
    protected abstract Collection<ShortEdge> getDownShortEdges(int var1);

    @NotNull
    protected abstract Collection<SimpleRowElement> getSimpleRowElements(int var1);

    static enum RowElementType {
        NODE,
        UP_ARROW,
        DOWN_ARROW;

    }

    protected static class SimpleRowElement {
        @NotNull
        public final GraphElement myElement;
        @NotNull
        public final RowElementType myType;
        public final int myPosition;

        public SimpleRowElement(@NotNull GraphElement element, @NotNull RowElementType type, int position) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$SimpleRowElement", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$SimpleRowElement", "<init>"));
            }
            this.myElement = element;
            this.myPosition = position;
            this.myType = type;
        }
    }

    protected static class ShortEdge {
        @NotNull
        public final GraphEdge myEdge;
        public final int myUpPosition;
        public final int myDownPosition;

        public ShortEdge(@NotNull GraphEdge edge, int upPosition, int downPosition) {
            if (edge == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$ShortEdge", "<init>"));
            }
            this.myEdge = edge;
            this.myUpPosition = upPosition;
            this.myDownPosition = downPosition;
        }
    }
}

