/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CurrentBranchHighlighter
implements VcsLogHighlighter {
    private static final JBColor CURRENT_BRANCH_BG = new JBColor(new Color(228, 250, 255), new Color(63, 71, 73));
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogFilterUi myFilterUi;

    public CurrentBranchHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogFilterUi filterUi) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "<init>"));
        }
        if (filterUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterUi", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "<init>"));
        }
        this.myDataHolder = logDataHolder;
        this.myUiProperties = uiProperties;
        this.myFilterUi = filterUi;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitIndex, boolean isSelected) {
        if (isSelected || !this.myUiProperties.isHighlighterEnabled("CURRENT_BRANCH")) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsShortCommitDetails details = this.myDataHolder.getMiniDetailsGetter().getCommitDataIfAvailable(commitIndex);
        if (details != null && !(details instanceof LoadingDetails)) {
            Condition<Hash> condition;
            VcsLogProvider provider = this.myDataHolder.getLogProvider(details.getRoot());
            String currentBranch = provider.getCurrentBranch(details.getRoot());
            VcsLogBranchFilter branchFilter = this.myFilterUi.getFilters().getBranchFilter();
            if (currentBranch != null && (branchFilter == null || !this.isFilteredByCurrentBranch(currentBranch, branchFilter)) && (condition = this.myDataHolder.getContainingBranchesGetter().getContainedInBranchCondition(currentBranch, details.getRoot())).value(details.getId())) {
                VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.background((Color)CURRENT_BRANCH_BG);
                if (vcsCommitStyle == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "getStyle"));
                }
                return vcsCommitStyle;
            }
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "getStyle"));
        }
        return vcsCommitStyle;
    }

    private boolean isFilteredByCurrentBranch(@NotNull String currentBranch, @NotNull VcsLogBranchFilter branchFilter) {
        if (currentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBranch", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "isFilteredByCurrentBranch"));
        }
        if (branchFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchFilter", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "isFilteredByCurrentBranch"));
        }
        return branchFilter.getBranchNames().size() == 1 && currentBranch.equals(ContainerUtil.getFirstItem((Collection)branchFilter.getBranchNames()));
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "CURRENT_BRANCH";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogFilterUi filterUi) {
            if (logDataHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "createHighlighter"));
            }
            if (uiProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "createHighlighter"));
            }
            if (filterUi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterUi", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "createHighlighter"));
            }
            CurrentBranchHighlighter currentBranchHighlighter = new CurrentBranchHighlighter(logDataHolder, uiProperties, filterUi);
            if (currentBranchHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "createHighlighter"));
            }
            return currentBranchHighlighter;
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "getId"));
            }
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            if ("Current Branch" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "getTitle"));
            }
            return "Current Branch";
        }
    }
}

