/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.inheritance.ImplementedAtRuntimeCondition;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean existsMutualSubclass(PsiClass class1, final PsiClass class2, final boolean avoidExpensiveProcessing) {
        if (class1 instanceof PsiTypeParameter) {
            PsiClass[] superClasses;
            for (PsiClass superClass : superClasses = class1.getSupers()) {
                if (InheritanceUtil.existsMutualSubclass(superClass, class2, avoidExpensiveProcessing)) continue;
                return false;
            }
            return true;
        }
        if (class2 instanceof PsiTypeParameter) {
            return InheritanceUtil.existsMutualSubclass(class2, class1, avoidExpensiveProcessing);
        }
        String className = class1.getQualifiedName();
        if ("java.lang.Object".equals(className)) {
            return true;
        }
        String class2Name = class2.getQualifiedName();
        if ("java.lang.Object".equals(class2Name)) {
            return true;
        }
        if (class1.isInheritor(class2, true) || class2.isInheritor(class1, true)) {
            return true;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)class1.getProject());
        Query search = ClassInheritorsSearch.search((PsiClass)class1, (SearchScope)scope, (boolean)true, (boolean)true);
        final boolean[] result = new boolean[1];
        search.forEach((Processor)new Processor<PsiClass>(){
            AtomicInteger count = new AtomicInteger(0);

            public boolean process(PsiClass inheritor) {
                if (inheritor.equals(class2) || inheritor.isInheritor(class2, true) || avoidExpensiveProcessing && this.count.incrementAndGet() > 20) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    public static boolean hasImplementation(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/InheritanceUtil", "hasImplementation"));
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)aClass.getProject());
        if (aClass.isInterface() && FunctionalExpressionSearch.search((PsiClass)aClass, (SearchScope)scope).findFirst() != null) {
            return true;
        }
        for (ImplementedAtRuntimeCondition condition : (ImplementedAtRuntimeCondition[])ImplementedAtRuntimeCondition.EP_NAME.getExtensions()) {
            if (!condition.isImplementedAtRuntime(aClass)) continue;
            return true;
        }
        Query search = ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true, (boolean)true);
        return !search.forEach((Processor)new Processor<PsiClass>(){

            public boolean process(PsiClass inheritor) {
                return inheritor.isInterface() || inheritor.isAnnotationType() || inheritor.hasModifierProperty("abstract");
            }
        });
    }

    public static boolean hasOneInheritor(final PsiClass aClass) {
        final CountingProcessor processor = new CountingProcessor(2);
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)aClass.getUseScope(), (boolean)false).forEach((Processor)processor);
            }
        }, null);
        return processor.getCount() == 1;
    }

    public static class CountingProcessor
    implements Processor<PsiClass> {
        private final AtomicInteger myCount = new AtomicInteger(0);
        private final int myLimit;

        public CountingProcessor(int limit) {
            this.myLimit = limit;
        }

        public int getCount() {
            return this.myCount.get();
        }

        public boolean process(PsiClass aClass) {
            if (this.myCount.get() == this.myLimit) {
                return false;
            }
            this.myCount.incrementAndGet();
            return true;
        }
    }
}

