/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiProcessor;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\t\b)\t2\u000b^1uS\u000e4\u0015\u000e\\3IC:$G.\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*\u0001\"-^5mi&sw+\u001a2TKJ4XM\u001d\u0006\u0015/\u0016\u00147+\u001a:wKJ4\u0015\u000e\\3IC:$G.\u001a:\u000b\rqJg.\u001b;?\u00151\u00198/\u001b)s_\u000e,7o]8s\u00151\u00196/\u001b)s_\u000e,7o]8s\u0015\r\u00198/\u001b\u0006\nQ\u0006\u001c\u0018iY2fgNTaA]3tk2$(\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\b\u0005>|G.Z1o\u0015\u0019Yw\u000e\u001e7j]*9\u0001O]8dKN\u001c(\u0002\u00039bi\"LeNZ8\u000b\u0011A\u000bG\u000f[%oM>TAcY1o_:L7-\u00197SKF,Xm\u001d;QCRD'\u0002D\"iCJ\u001cV-];f]\u000e,'b\u00029s_*,7\r\u001e\u0006\b!J|'.Z2u\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'b\u0002:fcV,7\u000f\u001e\u0006\u0010\rVdG\u000e\u0013;uaJ+\u0017/^3ti*)a.\u001a;us*9\u0001.\u00198eY\u0016\u0014(\"B2pI\u0016\u001c'\u0002\u00025uiBTqa\u00195b]:,GNC\u0004DQ\u0006tg.\u001a7\u000b\u0019%\u001c8)^:u_6Dun\u001d;\u000b\t1\fgn\u001a\u0006\u000baJ|7-Z:t'NL'\u0002\u00024jY\u0016TA!\u00168ji\u0012\u0010!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0007\u0011\t\u0001\u0002\u0001\u0007\u0001\u000b\r!\u0011\u0001\u0003\u0002\r\u0001\u0015\u0011A!\u0001\u0005\u0005\u000b\r!)\u0001c\u0002\r\u0001\u0015\u0011AQ\u0001E\u0004\u000b\u0005Aa!\u0002\u0002\u0005\t!5Qa\u0001C\u0005\u0011\u0017a\u0001!B\u0001\t\u0010\u0015\u0019A1\u0002\u0005\b\u0019\u0001)!\u0001\"\u0003\t\f\u0015\u0019A!\u0001\u0005\n\u0019\u0001)1\u0001b\u0003\t\u00151\u0001Q!\u0001E\f\u000b\t!\u0001\u0002\u0003\u0007\u0006\u0005\u0011E\u0001\u0012D\u0003\u0003\t%A)\"B\u0002\u0005\u0014!YA\u0002A\u0003\u0002\u0011\u001b)!\u0001\"\u0006\t\u001d\u0015\u0011Aa\u0003E\u000f\u000b\t!9\u0002C\b\u0006\u0005\u0011a\u0001rD\u0003\u0004\t3AY\u0002\u0004\u0001\u0006\u0005\u0011Y\u0001\u0002E\u0003\u0004\t7A\t\u0003\u0004\u0001\u0006\u0005\u0011\t\u0001\"C\u0003\u0003\t\u0011A\u0019#\u0002\u0002\u0005\u001f!QQA\u0001C\n\u0011-)!\u0001\"\u0007\t\u001c\u0015\u0011A1\u0004E\u0011\u000b\r!Y\u0001C\n\r\u0001\u0011\tA2A\r\u0004\u000b\u0005A!\u0001\u0007\u0002.\u001b\u0011\tM\u0002G\u0002\"\t\u0015\t\u0001b\u0001G\u00011\r)6\u0001B\u0003\u0004\t\rI\u0011\u0001c\u0002.+\u0011\t\u0001\u0014BO\b\t\u0001AQ!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u00071\u0019\t6!\u0002C\u0005\u0013\u0005!\t!D\u0001\t\u000e5N\r\u0001B\u0006\u0019\u0011u=A\u0001\u0001E\t\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0001!h\u0004\u0005\u0001!MQbA\u0003\u0002\u0011\u001fAz\u0001UB\u0001;\u001f!\u0001\u0001#\u0006\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e\tQt\u0002\u0003\u0001\u00115i1!B\u0001\t\u001bai\u0001ka\u0001\u001e\u0010\u0011\u0001\u0001\u0002E\u0007\u0004\u000b\u0005Aa\u0002\u0007\bQ\u0007\tiz\u0001\u0002\u0001\t#5\u0019Q!\u0001\u0005\u00071\u0019\u00016QA\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004R\u0007=!\u0001\"C\u0001\u0005\u00025\t\u0001RD\u0007\u0002\u0011?i\u0011\u0001\u0003\t\u000e\u0003!\u0005R\"\u0001\u0005\u0012\u001b\u0005!\t!le\u0001\t\u0005A\"#h\u0004\u0005\u0001!\u0015RbA\u0003\u0002\u0011\u0015AR\u0001U\u0002\u0001;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\u0005Qt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u0015aQ\u0001kA\u0001\u001e\u0010\u0011\u0001\u0001\"D\u0007\u0004\u000b\u0005AQ\u0002G\u0007Q\u0007\u0007iz\u0001\u0002\u0001\t!5\u0019Q!\u0001\u0005\u000f19\u00016AAO\b\t\u0001A\u0011#D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0006\u0005\u001aQ!\u0001E\u00121G\t6a\u0004\u0003\u0013\u0013\u0005!\u0001!D\u0001\t\u000e5\t\u0001rD\u0007\u0002\u0011Ai\u0011\u0001#\t\u000e\u0003!\tR\"\u0001C\u0001k1)1\u0002Br\u00011\u000b\t3!B\u0001\t\u0004a\r\u0011kA\u0002\u0005\u0006%\tA\u0001\u0001"})
public final class StaticFileHandler
extends WebServerFileHandler {
    public static final /* synthetic */ KClass $kotlinClass;
    private SsiProcessor ssiProcessor;

    static {
        $kotlinClass = Reflection.createKotlinClass(StaticFileHandler.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalRequestPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, boolean isCustomHost) {
        block12: {
            File file;
            block11: {
                Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
                Intrinsics.checkParameterIsNotNull((Object)canonicalRequestPath, (String)"canonicalRequestPath");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                if (pathInfo.getIoFile() != null) break block11;
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                if (!virtualFile.isInLocalFileSystem()) break block12;
            }
            if ((file = pathInfo.getIoFile()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                file = new File(virtualFile.getPath());
            }
            File ioFile = file;
            String nameSequence = pathInfo.getName();
            if (StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtml") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".stm") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtm")) {
                this.processSsi(ioFile, canonicalRequestPath, project, request, channel, isCustomHost);
                return true;
            }
            if (this.hasAccess(ioFile)) {
                FileResponses.sendFile((HttpRequest)request, channel, ioFile);
                return true;
            }
            Responses.sendStatus(HttpResponseStatus.FORBIDDEN, channel, (HttpRequest)request);
            return true;
        }
        VirtualFile virtualFile = pathInfo.getFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile file = virtualFile;
        HttpResponse httpResponse = FileResponses.prepareSend((HttpRequest)request, channel, file.getTimeStamp(), file.getPath());
        if (httpResponse == null) return true;
        HttpResponse response = httpResponse;
        boolean keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)file.getLength());
        }
        channel.write((Object)response);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            channel.write((Object)new ChunkedStream(file.getInputStream()));
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (keepAlive) return true;
        future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processSsi(File file, CharSequence canonicalRequestPath, Project project, FullHttpRequest request, Channel channel, boolean isCustomHost) {
        boolean keepAlive;
        String path = PathUtilRt.getParentPath((String)((Object)canonicalRequestPath).toString());
        if (!isCustomHost) {
            path = KotlinPackage.substring((String)path, (int)(KotlinPackage.indexOf$default((String)path, (char)'/', (int)1, (boolean)false, (int)4) + 1));
        }
        if (this.ssiProcessor == null) {
            this.ssiProcessor = new SsiProcessor(false);
        }
        ByteBuf buffer = channel.alloc().ioBuffer();
        boolean releaseBuffer = true;
        try {
            HttpResponse httpResponse;
            long lastModified;
            SsiProcessor ssiProcessor = this.ssiProcessor;
            if (ssiProcessor == null) {
                Intrinsics.throwNpe();
            }
            if (FileResponses.prepareSend((HttpRequest)request, channel, lastModified = ssiProcessor.process(new SsiExternalResolver(project, (HttpRequest)request, path, file.getParentFile()), FileUtil.loadFile((File)file), file.lastModified(), new ByteBufUtf8Writer(buffer)), file.getPath()) == null) {
                return;
            }
            HttpResponse response = httpResponse;
            keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)buffer.readableBytes());
            }
            channel.write((Object)response);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                releaseBuffer = false;
                channel.write((Object)buffer);
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private final boolean hasAccess(File result) {
        return !result.isDirectory() && result.canRead() && !result.isHidden() && !KotlinPackage.startsWith$default((String)result.getName(), (String)".ht", (boolean)false, (int)2);
    }
}

