/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkListener;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.DebugProcessImpl$WhenMappings;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.SuspendContextImpl;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u000f )\u0001B)\u001a2vOB\u0013xnY3tg&k\u0007\u000f\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015!!WMY;hO\u0016\u0014(\"A\"\u000b\u0019Yk7i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0015\r|gN\\3di&|gNC\u0007Y\t\u0016\u0014Wo\u001a)s_\u000e,7o\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u0013a$WMY;hO\u0016\u0014(B\u0002\u001fj]&$hHC\u0004tKN\u001c\u0018n\u001c8\u000b\u001ba#UMY;h'\u0016\u001c8/[8o\u0015=)G-\u001b;peN\u0004&o\u001c<jI\u0016\u0014(\u0002\u0007-EK\n,xmZ3s\u000b\u0012LGo\u001c:t!J|g/\u001b3fe*QQM^1mk\u0006$\u0018n\u001c8\u000b)Ml\u0017M\u001d;Ti\u0016\u0004\u0018J\u001c;p\u0011\u0006tG\r\\3s\u0015UA6+\\1siN#X\r]%oi>D\u0015M\u001c3mKJT\u0001b\u001d;faBLgn\u001a\u0006\u0010Kb,7-\u001e;j_:\u0014Vm];mi*yQ\t_3dkRLwN\u001c*fgVdGOC\u0005fq\u0016\u001cW\u000f^5p]*\u0019rL\u0019:fC.\u0004x.\u001b8u\u0011\u0006tG\r\\3sg*)\u0011I\u001d:bs*11n\u001c;mS:T!\u0003\u0017\"sK\u0006\\\u0007o\\5oi\"\u000bg\u000e\u001a7fe*Y!M]3bWB|\u0017N\u001c;t\u0015qy&M]3bWB|\u0017N\u001c;IC:$G.\u001a:tI\u0011,G.Z4bi\u0016T!\u0002\u001d:pa\u0016\u0014H/[3t\u0015A\u0011V-\u00193P]2L\bK]8qKJ$\u0018P\u0003\fhKR|&M]3bWB|\u0017N\u001c;IC:$G.\u001a:t\u001559W\r^\"p]:,7\r^5p]*iB-[:bE2,Gi\u001c(piN#X\r]%oi>d\u0015N\u0019:be&,7OC\u0004C_>dW-\u00198\u000bA\u001d,G\u000fR5tC\ndW\rR8O_R\u001cF/\u001a9J]R|G*\u001b2sCJLWm\u001d\u0006!g\u0016$H)[:bE2,Gi\u001c(piN#X\r]%oi>d\u0015N\u0019:be&,7O\u0003\nhKR,\u00050Z2vi&|gNU3tk2$(bC5t\r>\u00148-Z*uKBTabZ3u\u0013N4uN]2f'R,\u0007O\u0003\btKRL5OR8sG\u0016\u001cF/\u001a9\u000b\u001b1\f7\u000f^\"bY24%/Y7f\u0015%\u0019\u0015\r\u001c7Ge\u0006lWM\u0003\thKRd\u0015m\u001d;DC2dgI]1nK*\u00012/\u001a;MCN$8)\u00197m\rJ\fW.\u001a\u0006\tY\u0006\u001cHo\u0015;fa*Q1\u000b^3q\u0003\u000e$\u0018n\u001c8\u000b\u0017\u001d,G\u000fT1tiN#X\r\u001d\u0006\fg\u0016$H*Y:u'R,\u0007O\u0003\u0013qe>\u001cWm]:Ce\u0016\f7\u000e]8j]R\u001cuN\u001c3ji&|gn]!u\u0013\u0012,7+\u001b3f\u0015\u001d:W\r\u001e)s_\u000e,7o\u001d\"sK\u0006\\\u0007o\\5oi\u000e{g\u000eZ5uS>t7/\u0011;JI\u0016\u001c\u0016\u000eZ3\u000bOM,G\u000f\u0015:pG\u0016\u001c8O\u0011:fC.\u0004x.\u001b8u\u0007>tG-\u001b;j_:\u001c\u0018\t^%eKNKG-\u001a\u0006\u0013e\u0016\fG\u000e\u0015:pG\u0016\u001c8\u000fS1oI2,'O\u0003\bQe>\u001cWm]:IC:$G.\u001a:\u000b\u000fA\u0014xnY3tg*)r-\u001a;SK\u0006d\u0007K]8dKN\u001c\b*\u00198eY\u0016\u0014(B\u0004:fa\u0016\fGo\u0015;fa&sGo\u001c\u0006\u000e\u0003R|W.[2C_>dW-\u00198\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\u0006d_:\u001cWO\u001d:f]RTa!\u0019;p[&\u001c'\"E4fiJ+\u0007/Z1u'R,\u0007/\u00138u_*qQO\u001d7U_\u001aKG.Z\"bG\",'\"D\"p]\u000e,(O]3oi6\u000b\u0007OC\u0002Ve2T1BV5siV\fGNR5mK*9q\u000e]3oCBL'b\u0001<gg*\tr-\u001a;Ve2$vNR5mK\u000e\u000b7\r[3\u000b\u0005Yl'B\u0001,n\u0015\u00159W\r\u001e,n\u0015E\u0011'/Z1la>Lg\u000e\u001e*fC\u000eDW\r\u001a\u0006\u000bEJ,\u0017m\u001b9pS:$(b\u0003-Ce\u0016\f7\u000e]8j]RTa#\u001a<bYV\fG/\u001a3M_\u001e,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0007'R\u0014\u0018N\\4\u000b\u001dM,8\u000f]3oI\u000e{g\u000e^3yi*y\u0001lU;ta\u0016tGmQ8oi\u0016DHOC\u0003ge\u0006lWM\u0003\u0003V]&$(\u0002\u00027b]\u001eTqc\u00195fG.\u001c\u0015M\u001c)fe\u001a|'/\\\"p[6\fg\u000eZ:\u000b\u0015\r|g\u000e^5ok\u00164VN\u0003\u0006ti\u0016\u0004\u0018i\u0019;j_:T\u0001d\u0019:fCR,'I]3bWB|\u0017N\u001c;IC:$G.\u001a:t\u0015M!wnR3u!J|7-Z:t\u0011\u0006tG\r\\3s\u0015U9W\r\u001e\"sK\u0006\\\u0007o\\5oi\"\u000bg\u000e\u001a7feNT\u0001eZ3u\u0007V\u0014(/\u001a8u'R\fG/\u001a%za\u0016\u0014H.\u001b8l\u0019&\u001cH/\u001a8fe*\t\u0002*\u001f9fe2Lgn\u001b'jgR,g.\u001a:\u000b\u000b)\fg/\u0019=\u000b\u000bM<\u0018N\\4\u000b\u000b\u00154XM\u001c;\u000b\u00119+H\u000e\\1cY\u0016T1\"\u00198o_R\fG/[8og*1r-\u001a;DkJ\u0014XM\u001c;Ti\u0006$X-T3tg\u0006<WMC\u0004O_RtU\u000f\u001c7\u000b%\u001d,G/\u00123ji>\u00148\u000f\u0015:pm&$WM\u001d\u0006\u001aO\u0016$Hj\\2bi&|gn\u001d$pe\n\u0013X-Y6q_&tGOC\bY\u0019&tWM\u0011:fC.\u0004x.\u001b8u\u0015myg\u000e\\=T_V\u00148-Z'baB,GM\u0011:fC.\u0004x.\u001b8ug*!A*[:u\u0015!aunY1uS>t'bF4fiNk\u0017M\u001d;Ti\u0016\u0004\u0018J\u001c;p\u0011\u0006tG\r\\3s\u0015QI7OV1mk\u0016\u001c8)^:u_6\u001cvN\u001d;fI*\u0011\u0012n\u001d,n'R,\u0007oT;u\u0007>\u0014(/Z2u\u0015E\u0001(o\\2fgN\u0014%/Z1la>Lg\u000e\u001e\u0006\u000f'V\u001c\b/\u001a8e\u0007>tG/\u001a=u\u0015=A8+^:qK:$7i\u001c8uKb$(BE*vgB,g\u000eZ\"p]R,\u0007\u0010^%na2T\u0001\u0006\u001d:pG\u0016\u001c8O\u0011:fC.\u0004x.\u001b8u\u0019><W\t\u001f9sKN\u001c\u0018n\u001c8B]\u0012\u001cVo\u001d9f]\u0012TaA]3tk6,'\u0002E:bm\u0016\u0014Vm]8mm\u0016$g)\u001b7f\u0015\r)(\u000f\u001c\u0006\u0005M&dWM\u0003\u0006tKR|e/\u001a:mCfT!c\u001d;beR4uN]2f'R,\u0007/\u00138u_*a1\u000f^1siB\u000bWo]5oO*i1\u000f^1siN#X\r]%oi>TAb\u001d;beR\u001cF/\u001a9PkRTQb\u001d;beR\u001cF/\u001a9Pm\u0016\u0014(bE;qI\u0006$X\rT1ti\u000e\u000bG\u000e\u001c$sC6,\u0007\u0014\u0002\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0019A!\u0001\u0005\u0001\u0019\u0001)!\u0001B\u0001\t\u0007\u0015\u0019AA\u0001E\u0003\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u0019\u0001\u0012B\u0003\u0003\t\u000fAQ!B\u0002\u0005\t!\u001dA\u0002A\u0003\u0004\t\u0011Ai\u0001\u0004\u0001\u0006\u0005\u0011!\u0001\u0002C\u0003\u0004\t\u0017Ay\u0001\u0004\u0001\u0006\u0005\u0011!\u00012C\u0003\u0004\t\u001bA\u0011\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001bC\u0003\u0004\t\u001fA)\u0002\u0004\u0001\u0006\u0005\u0011!\u0001RB\u0003\u0003\t\tA)!\u0002\u0002\u0005\f!=QA\u0001C\u0007\u0011%)!\u0001b\u0004\t\u0016\u0015\t\u0001\u0012D\u0003\u0004\t-AA\u0002\u0004\u0001\u0006\u0005\u0011!\u00012D\u0003\u0004\t1AQ\u0002\u0004\u0001\u0006\u0005\u0011Y\u0001RD\u0003\u0003\t5Aq\"\u0002\u0002\u0005\u0019!iQa\u0001\u0003\f\u0011Ea\u0001!B\u0002\u0005\u0003!)B\u0002A\u0003\u0003\t\u0005AQ#B\u0002\u0005\u0003!9B\u0002A\u0003\u0003\t\u0005Aq#\u0002\u0002\u0005\u0010!YRa\u0001\u0003\u0012\u0011ka\u0001!\u0002\u0002\u0005#!UR!\u0001\u0005\u001e\u000b\t!)\u0003c\u000f\u0006\u0005\u0011\u0019\u0002BH\u0003\u0003\tOAi$B\u0002\u0005)!eB\u0002A\u0003\u0003\tQAI$B\u0002\u0005(!\u0001C\u0002A\u0003\u0003\t\u000fAY$B\u0002\u0005-!\u0005C\u0002A\u0003\u0003\t\u000fA\u0019%\u0002\u0002\u0005/!\u0011Sa\u0001C\u0018\u0011\u0005b\u0001!\u0002\u0002\u0005(!\u0001Sa\u0001\u0003\u0002\u0011\u000fb\u0001!\u0002\u0002\u0005\u0003!\u001dSa\u0001\u0003\r\u0011\u0017b\u0001!B\u0002\u0005\u0017!5C\u0002A\u0003\u0003\t\u0011A\u0001&B\u0002\u00057!=C\u0002A\u0003\u0004\t-A\t\u0006\u0004\u0001\u0006\u0005\u0011a\u00012J\u0003\u0003\tKA\u0011&\u0002\u0002\u0005;!5SA\u0001\u0003\u001c\u0011\u001f*\u0011\u0001c\u0017\u0006\u0005\u0011u\u0002BL\u0003\u0003\t}Ai&B\u0002\u0005@!iC\u0002A\u0003\u0003\t\u0003Ay&B\u0002\u0005B!yC\u0002A\u0003\u0003\t\u007fAQ&B\u0002\u0005B!\u0005D\u0002A\u0003\u0004\t1A!\u0007\u0004\u0001\u0006\u0007\u0011Y\u0001b\r\u0007\u0001\u000b\r!\u0011\u0001c\u001a\r\u0001\u0015\u0011Aa\u0005\u00054\u000b\t!A\u0002\u0003\u001a\u0006\u0007\u0011\t\u0001B\u000e\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0015\u0006\u0007\u0011-\u0003b\u000e\u0007\u0001\u000b\t!\u0011\u0001\u0003\u001c\u0006\u0005\u0011-\u0003bN\u0003\u0003\tYA\t%\u0002\u0002\u00050!\tCa\u0005G\u0002+!!\u0001\u0001\u0003\u0002\u0016\u000b\u0015\t\u0001RA\u0005\u0002\t\u0007A*!G\u0002\u0006\u0003!%\u0001\u0014B\u0017\u001a\t\u0005$\u0001tC\u0011\u000b\u000b\u0005A9\"\u0003\u0004\n\u000b\u0015\t\u0001\u0012D\u0005\u0002\t\u0007AJ\u0002g\u0006%CU\u001b\u0011\"B\u0002\u0005\u001d%\t\u00012D\u0007\u0005\t?I!\u0001\u0003\b\r\u00025\nBa\u0019\u0003\u0019\u0007\u0005\"QA\u0001C\u0001\u0011\u0001a\u0002!V\u0002\t\u000b\r!1!C\u0001\t\u00135\u0019A\u0001E\u0005\u0002\u0011%i\u0003\u0004\"b\r1C\t3!B\u0001\t\u001eauAE\u0001\u0015\u0003+\u000eqQa\u0001C\u0011\u0013\u0005!\t!D\u0002\u0005$%\tA\u0011A\t\u0006\tII\u0011\u0001\u0002\u0001\u000e\u0003\u0011\u0005Q\u0006\u0004\u0003b\ta9\u0011eA\u0003\u0002\u0011\u0019Ab!V\u0002\u0005\u000b\r!q!C\u0001\t\u00145\nBA\u0019\u0003\u0019\u0015\u0005\"Q!\u0001\u0005\t\u0019\u0003A\u0002\"V\u0002\t\u000b\r!!\"C\u0001\t\u00165\u0019AQE\u0005\u0002\u0011+i\u0003\u0004\"b\r1M\t3!B\u0001\t\u001eauAE\u0001\u0015\u0003+\u000eqQa\u0001\u0003\u0014\u0013\u0005!\t!D\u0002\u0005(%\tA\u0011A\t\u0006\tQI\u0011\u0001\u0002\u0001\u000e\u0003\u0011\u0005Q&\u0007CC\u001aa%\u0012\u0005B\u0003\u0002\u0011=a\t\u0001G\b%\u0005!\u0012Qk\u0001\b\u0006\u0007\u0011%\u0012\"\u0001E\u0010\u001b\r!Y#C\u0001\t E)AAF\u0005\u0002\t\u0001i\u0011\u0001c\b.3\u0011\u0015M\u0002'\f\"\t\u0015\t\u0001\u0002\u0005G\u00011A!#\u0001\u000b\u0002V\u00079)1\u0001\"\f\n\u0003!\u0005Rb\u0001C\u0018\u0013\u0005A\t#E\u0003\u00051%\tA\u0001A\u0007\u0002\u0011Cic\u0003Bb\r1c\t3!B\u0001\t\u001eauQk\u0001\b\u0006\u0007\u0011E\u0012\"\u0001C\u0001\u001b\r!\u0011$C\u0001\u0005\u0002E)A1G\u0005\u0002\t\u0001i\u0011\u0001\"\u0001.\u001d\u0011\u0011G\u0001\u0007\u000e\"\t\u0015\t\u00012\u0005G\u00011G!#%V\u0002\u0005\u001b\r!9$C\u0001\t%5\u0002BA\u0019\u0003\u00199\u0005\u001aQ!\u0001E\u00151S)6\u0001C\u0003\u0004\tqI\u0011\u0001C\u000b\u000e\u0007\u0011y\u0012\"\u0001\u0005\u0016[=!\u0011\r\u0002M\tC\u0019)\u0011\u0001C\u0004\n\u0003\u0011\rA\u0012\u0001\r\b+\u000e!Qa\u0001C\t\u0013\u0005A!\"\f\u000e\u0005E\u0012Az$I\u0007\u0006\u0003!-\u0012\u0002B\u0005\u0004\u000b\u0005Ai\u0003'\f\n\t%\u0019Q!\u0001\u0005\u00191aAZ#V\u0002\t\u000b\r!y$C\u0001\t25\u0019AQI\u0005\u0002\u0011cic\u0002B2\u00051\r\nC!B\u0001\t31\u0005\u0001$\u0007\u0013$+\u000e!Qb\u0001\u0003%\u0013\u0005A\u0019$L\u0017\u0005\u0003a%S4\u0003\u0003\u0001\u0011\u0015jQ!B\u0001\t5%\tA1\u0001\r\u001b!\u000e\u0001Q\u0014\u0003\u0003\u0001\u0011\u0019jA!B\u0001\t61\u0005\u0001T\u0007)\u0004\u0002u=A\u0001\u0001\u0005(\u001b\r)\u0011\u0001c\u000e\u00198A\u001b\u0011!I\u0002\u0006\u0003!a\u0002\u0004H)\u0004\u0013\u0011%\u0013\"\u0001\u0003\u0001\u001b\u0005AI$D\u0001\t<5\t\u0001BHW\u000b\t\rA\u001a&I\u0002\u0006\u0003!u\u0001TD)\u0004\u0007\u0011M\u0013\"\u0001C\u0001[U!!\u0001\u0007\u0016\u001e\u0010\u0011\u0001\u0001RK\u0007\u0004\u000b\u0005A\u0001\u0003\u0007\tQ\u0007\u0001\t3!B\u0001\t9aa\u0012kA\u0003\u0005U%\tA\u0001A\u0007\u0002\u0011Ci+\u0003\u0002\n\u0019W\u0005RQ!\u0001E\f\u0013\u0019IQ!B\u0001\t\u001a%\tA1\u0001M\r1/\t6\u0001\u0002\u0003,\u0013\tAa\u0002$\u0001.\u0016\u0011Q\u0001tK\u0011\u0004\u000b\u0005A\u0019\u0003g\tR\u0007\r!9&C\u0001\t%5\u0016Ba\u0001\r-C))\u0011\u0001c\u0006\n\r%)Q!\u0001E\r\u0013\u0005!\u0019\u0001'\u0007\u0019\u0018E\u001bA\u0001\u0002\u0017\n\u0005!qA\u0012A\u0017\u000f\t\rAJ&)\u0004\u0006\u0003!\u0001C\u0012\u0001\r!#\u000e\tA!I)\u0004\u0007\u0011e\u0013\"\u0001E\"[5!1\u0001\u0007\u0019\"\f\u0015\t\u0001R\u0007M\u001b#\u000e\tAAI)\u0004\u0007\u0011\u0001\u0014\"\u0001E\u001e[+!1\u0001G\u0019\"\u0007\u0015\t\u0001B\u0002\r\u0007#\u000e\u0019A!M\u0005\u0002\u0011'ik\u0005B\n\u0019duMA\u0001\u0001\u0005&\u001b\u0015)\u0011\u0001#\u0012\n\u0003\u0011\r\u0001T\t)\u0004\u0001u=A\u0001\u0001E3\u001b\r)\u0011\u0001#\b\u0019\u001eA\u001b\t!\t\u0005\u0006\u0003!\u0019\u0013\u0002B\u0005\u0004\u000b\u0005A9\u0005g\u0012\u0019GE\u001bq\u0001b\u0019\n\u0003!!S\"\u0001E%\u001b\u0005!\t!l\u0007\u0005\u0007a!\u0014EB\u0003\u0002\u0011\u001dI\u0011\u0001b\u0001\r\u0002a9\u0011kA\u0002\u0005i%\t\u0001BCW\u000b\t\rAJ'I\u0002\u0006\u0003!u\u0001TD)\u0004\u0007\u0011%\u0014\"\u0001C\u0001[+!!\u0002G\u001b\"\u0007\u0015\t\u0001R\u0004M\u000f#\u000e\u0019A!N\u0005\u0002\t\u0003iC\u0006\u0002\u0002\u0019lu=A\u0001\u0001\u0005(\u001b\r)\u0011\u0001C\u0013\u0019KA\u001b\u0001!h\u0005\u0005\u0001!)S\"B\u0003\u0002\u0011iI\u0011\u0001b\u0001\u00195A\u001b\t!h\u0004\u0005\u0001!5TbA\u0003\u0002\u0011\u0019Bb\u0005U\u0002\u0002C\r)\u0011\u0001\u0003\u000f\u00199E\u001b\u0011\u0002b\u001b\n\u0003\u0011\u0001Q\"\u0001E'\u001b\u0005AI$D\u0001\tO5bC!\u0001M8;'!\u0001\u0001C\u0013\u000e\u000b\u0015\t\u0001BG\u0005\u0002\t\u0007A\"\u0004U\u0002\u0001;\u001f!\u0001\u0001#\u001c\u000e\u0007\u0015\t\u0001B\n\r'!\u000e\u0005Qt\u0002\u0003\u0001\u0011\u001dj1!B\u0001\tKa)\u0003kA\u0001\"\u0007\u0015\t\u0001\u0002\b\r\u001d#\u000eIAqN\u0005\u0002\t\u0001i\u0011\u0001#\u000f\u000e\u0003!9S\"\u0001E'[+!1\u0001\u0007\u001d\"\u0007\u0015\t\u0001\u0002\b\r\u001d#\u000e\u0019A\u0001O\u0005\u0002\t\u0001i{\u0004B\u0002\u0019ru=A\u0001\u0001\u0005:\u001b\r)\u0011\u0001#\f\u0019.A\u001b\u0001!h\u0004\u0005\u0001!MTbA\u0003\u0002\u0011aA\u0002\u0004UB\u0001C\r)\u0011\u0001\u0003\u000f\u00199E\u001bq\u0001\"\u001d\n\u0003\u0011\u0001Q\"\u0001E(\u001b\u0005A\u0001&,\u0006\u0005\u0005aQ\u0014eA\u0003\u0002\u0011qAB$U\u0002\u0004\tiJ\u0011\u0001\u0002\u0001.\u0016\u0011\u0019\u0001TO\u0011\u0004\u000b\u0005AA\u0004\u0007\u000fR\u0007\r!)(C\u0001\u0005\u00015VAa\u0001\r<C\r)\u0011\u0001\u0003\u000f\u00199E\u001b1\u0001B\u001e\n\u0003\u0011\u0001QV\u0003\u0003\u00041o\n3!B\u0001\t9aa\u0012kA\u0002\u0005x%\tA\u0001AW\u000b\t\rAB(I\u0002\u0006\u0003!a\u0002\u0004H)\u0004\u0007\u0011a\u0014\"\u0001\u0003\u0001[+!1\u0001'\u001f\"\u0007\u0015\t\u0001\u0002\b\r\u001d#\u000e\u0019A\u0011P\u0005\u0002\t\u0001i+\u0002B\u0001\u0019{\u0005\u001aQ!\u0001\u0005\u001d1q\t6a\u0001\u0003>\u0013\u0005!\u0001!Nk\u0001\u000bO\u0007Aa9\u0001\u0012\u0011\u0011\u0001\u0001BA\u000b\u0006\u000b\u0005A)!C\u0001\u0005\u0004a\u0015\u00014BO\b\t\u0001Aa!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001uEA\u0001\u0001\u0005\u0004\u001b\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0005i*\u0002\u0002\u0001\t\u001251Q!\u0001\u0005\b\u0013\u0005!\u0019\u0001$\u0001\u0019\u000fA\u001b\u0019!(\u0005\u0005\u0001!QQ\u0002B\u0003\u0002\u0011!a\t\u0001\u0007\u0005Q\u0007\t\t\u0013\"B\u0001\t\u0004%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\u0004E\u001bQ\u0002b\u0003\n\u0003\u0011\u0001Q\"\u0001E\t\u001b\u0005A\u0011\"D\u0001\t\u00145\t\u0001BC\u0007\u0002\u0011+\u0001"})
public abstract class DebugProcessImpl<C extends VmConnection<?>>
extends XDebugProcess {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final AtomicBoolean repeatStepInto;
    @Nullable
    private volatile StepAction lastStep;
    @Nullable
    private volatile CallFrame lastCallFrame;
    private volatile boolean isForceStep;
    private volatile boolean disableDoNotStepIntoLibraries;
    @NotNull
    private final ConcurrentMap<Url, VirtualFile> urlToFileCache;
    private boolean processBreakpointConditionsAtIdeSide;
    private final ReadOnlyProperty<? super Object, ? extends XBreakpointHandler<?>[]> _breakpointHandlers$delegate;
    @NotNull
    private final C connection;
    private final XDebuggerEditorsProvider editorsProvider;
    private final XSmartStepIntoHandler<?> smartStepIntoHandler;
    @Nullable
    private final ExecutionResult executionResult;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(DebugProcessImpl.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("_breakpointHandlers")};
    }

    @NotNull
    protected final AtomicBoolean getRepeatStepInto() {
        return this.repeatStepInto;
    }

    @Nullable
    protected final StepAction getLastStep() {
        return this.lastStep;
    }

    protected final void setLastStep(@Nullable StepAction stepAction) {
        this.lastStep = stepAction;
    }

    @Nullable
    protected final CallFrame getLastCallFrame() {
        return this.lastCallFrame;
    }

    protected final void setLastCallFrame(@Nullable CallFrame callFrame) {
        this.lastCallFrame = callFrame;
    }

    protected final boolean getIsForceStep() {
        return this.isForceStep;
    }

    protected final void setIsForceStep(boolean bl) {
        this.isForceStep = bl;
    }

    protected final boolean getDisableDoNotStepIntoLibraries() {
        return this.disableDoNotStepIntoLibraries;
    }

    protected final void setDisableDoNotStepIntoLibraries(boolean bl) {
        this.disableDoNotStepIntoLibraries = bl;
    }

    @NotNull
    protected final ConcurrentMap<Url, VirtualFile> getUrlToFileCache() {
        return this.urlToFileCache;
    }

    public final boolean getProcessBreakpointConditionsAtIdeSide() {
        return this.processBreakpointConditionsAtIdeSide;
    }

    public final void setProcessBreakpointConditionsAtIdeSide(boolean bl) {
        this.processBreakpointConditionsAtIdeSide = bl;
    }

    private final XBreakpointHandler<?>[] get_breakpointHandlers() {
        return (XBreakpointHandler[])this._breakpointHandlers$delegate.get((Object)this, $propertyMetadata[0]);
    }

    @Nullable
    protected final ProcessHandler getRealProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        return executionResult != null ? executionResult.getProcessHandler() : null;
    }

    @Nullable
    public final XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.smartStepIntoHandler;
    }

    @NotNull
    public final XBreakpointHandler<?>[] getBreakpointHandlers() {
        return this.get_breakpointHandlers();
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    @Nullable
    public final Vm getVm() {
        return ((VmConnection)this.connection).getVm();
    }

    @NotNull
    protected abstract XBreakpointHandler<?>[] createBreakpointHandlers();

    private final void updateLastCallFrame() {
        Object object = this.getVm();
        this.lastCallFrame = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null ? object.getTopFrame() : null;
    }

    public final boolean checkCanPerformCommands() {
        return this.getVm() != null;
    }

    public final boolean isValuesCustomSorted() {
        return true;
    }

    public final void startStepOver() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.OVER);
    }

    public final void startForceStepInto() {
        this.isForceStep = true;
        this.startStepInto();
    }

    public final void startStepInto() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.IN);
    }

    public final void startStepOut() {
        if (this.isVmStepOutCorrect()) {
            this.lastCallFrame = null;
        } else {
            this.updateLastCallFrame();
        }
        this.continueVm(StepAction.OUT);
    }

    protected boolean isVmStepOutCorrect() {
        return true;
    }

    public final void resume() {
        this.continueVm(StepAction.CONTINUE);
    }

    protected final void continueVm(@NotNull StepAction stepAction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stepAction), (String)"stepAction");
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContextManager<? extends CallFrame> suspendContextManager = vm.getSuspendContextManager();
        if (stepAction == StepAction.CONTINUE) {
            if (suspendContextManager.getContext() == null) {
                return;
            }
            this.lastStep = null;
            this.lastCallFrame = null;
            this.urlToFileCache.clear();
            this.disableDoNotStepIntoLibraries = false;
        } else {
            this.lastStep = stepAction;
        }
        suspendContextManager.continueVm(stepAction, 1);
    }

    protected final void setOverlay() {
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        vm.getSuspendContextManager().setOverlayMessage("Paused in debugger");
    }

    protected final void processBreakpoint(@NotNull SuspendContext suspendContext, @NotNull XBreakpoint<?> breakpoint, @NotNull SuspendContextImpl xSuspendContext) {
        String condition;
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)((Object)xSuspendContext), (String)"xSuspendContext");
        XExpression xExpression = breakpoint.getConditionExpression();
        String string = condition = xExpression != null ? xExpression.getExpression() : null;
        if (!this.processBreakpointConditionsAtIdeSide || condition == null) {
            this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
        } else {
            xSuspendContext.evaluateExpression(condition).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpoint.1.class);
                }

                protected void consume(@NotNull String evaluationResult, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)evaluationResult, (String)"evaluationResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    if (Intrinsics.areEqual((Object)"false", (Object)evaluationResult)) {
                        this.this$0.resume();
                    } else {
                        DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend$0(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpoint.2.class);
                }

                protected void consume(@NotNull Throwable failure, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend$0(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void processBreakpointLogExpressionAndSuspend(XBreakpoint<?> breakpoint, SuspendContextImpl xSuspendContext, SuspendContext suspendContext) {
        String logExpression;
        XExpression xExpression = breakpoint.getLogExpressionObject();
        String string = logExpression = xExpression != null ? xExpression.getExpression() : null;
        if (logExpression == null) {
            this.breakpointReached(breakpoint, null, xSuspendContext);
        } else {
            xSuspendContext.evaluateExpression(logExpression).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpointLogExpressionAndSuspend.1.class);
                }

                protected void consume(@NotNull String logResult, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached$1(this.this$0, this.$breakpoint, logResult, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, logExpression, xSuspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ String $logExpression;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpointLogExpressionAndSuspend.2.class);
                }

                protected void consume(@NotNull Throwable logResult, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached$1(this.this$0, this.$breakpoint, "Failed to evaluate expression: " + this.$logExpression, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$logExpression = $captured_local_variable$2;
                    this.$xSuspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void breakpointReached(XBreakpoint<?> breakpoint, String evaluatedLogExpression, XSuspendContext suspendContext) {
        if (this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, suspendContext)) {
            this.setOverlay();
        } else {
            this.resume();
        }
    }

    public final void startPausing() {
        ((VmConnection)this.connection).getVm().getSuspendContextManager().suspend().rejected((Consumer)new RejectErrorReporter(this.getSession(), "Cannot pause"));
    }

    @NotNull
    public final String getCurrentStateMessage() {
        return ((VmConnection)this.connection).getState().getMessage();
    }

    @Nullable
    public final HyperlinkListener getCurrentStateHyperlinkListener() {
        return ((VmConnection)this.connection).getState().getMessageLinkListener();
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        if (executionResult == null || (executionResult = executionResult.getProcessHandler()) == null) {
            executionResult = (ProcessHandler)new DefaultDebugProcessHandler(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(doGetProcessHandler.1.class);
                }

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return executionResult;
    }

    public final void saveResolvedFile(@NotNull Url url, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.urlToFileCache.putIfAbsent(url, file);
    }

    @NotNull
    public abstract List<Location> getLocationsForBreakpoint(@NotNull XLineBreakpoint<?> var1, boolean var2);

    @NotNull
    public final C getConnection() {
        return this.connection;
    }

    @Nullable
    protected final ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public DebugProcessImpl(@NotNull XDebugSession session, @NotNull C connection, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSmartStepIntoHandler<?> smartStepIntoHandler, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)editorsProvider, (String)"editorsProvider");
        super(session);
        this.connection = connection;
        this.editorsProvider = editorsProvider;
        this.smartStepIntoHandler = smartStepIntoHandler;
        this.executionResult = executionResult;
        this.repeatStepInto = new AtomicBoolean();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap<Url, VirtualFile>()");
        this.urlToFileCache = concurrentMap;
        this._breakpointHandlers$delegate = Delegates.INSTANCE$.lazy((Function0)new Function0<XBreakpointHandler<?>[]>(this){
            final /* synthetic */ DebugProcessImpl this$0;

            @NotNull
            public final XBreakpointHandler<?>[] invoke() {
                return this.this$0.createBreakpointHandlers();
            }
            {
                this.this$0 = debugProcessImpl;
                super(0);
            }
        });
        ((VmConnection)this.connection).addListener(new SocketConnectionListener(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(1.class);
            }

            @Override
            public void statusChanged(@NotNull ConnectionStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: 
                    case 2: {
                        if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ConnectionStatus.DETACHED)) && this.getRealProcessHandler() != null) {
                            this.getProcessHandler().detachProcess();
                        }
                        this.getSession().stop();
                        break;
                    }
                    case 3: {
                        this.getSession().reportError(status.getStatusText());
                        this.getSession().stop();
                        break;
                    }
                    default: {
                        this.getSession().rebuildViews();
                    }
                }
            }
        });
    }

    public static final /* synthetic */ void access$processBreakpointLogExpressionAndSuspend$0(DebugProcessImpl<C> $this, @NotNull XBreakpoint<?> breakpoint, @NotNull SuspendContextImpl xSuspendContext, @NotNull SuspendContext suspendContext) {
        super.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
    }

    public static final /* synthetic */ void access$breakpointReached$1(DebugProcessImpl<C> $this, @NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        super.breakpointReached(breakpoint, evaluatedLogExpression, suspendContext);
    }
}

