/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.LineBreakpointManager;

public final class LineBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<?>> {
    private final LineBreakpointManager lineBreakpointManager;
    private final boolean onlySourceMappedBreakpoints;

    public LineBreakpointHandler(@NotNull Class<? extends XLineBreakpointType<?>> breakpointTypeClass, LineBreakpointManager lineBreakpointManager, boolean onlySourceMappedBreakpoints) {
        if (breakpointTypeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointTypeClass", "org/jetbrains/debugger/LineBreakpointHandler", "<init>"));
        }
        super(breakpointTypeClass);
        this.lineBreakpointManager = lineBreakpointManager;
        this.onlySourceMappedBreakpoints = onlySourceMappedBreakpoints;
    }

    @NotNull
    public LineBreakpointManager getManager() {
        LineBreakpointManager lineBreakpointManager = this.lineBreakpointManager;
        if (lineBreakpointManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/LineBreakpointHandler", "getManager"));
        }
        return lineBreakpointManager;
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/debugger/LineBreakpointHandler", "registerBreakpoint"));
        }
        this.lineBreakpointManager.setBreakpoint(breakpoint, this.onlySourceMappedBreakpoints);
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean temporary) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/debugger/LineBreakpointHandler", "unregisterBreakpoint"));
        }
        this.lineBreakpointManager.removeBreakpoint(breakpoint, temporary);
    }
}

