/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Vm;
import org.jetbrains.util.concurrency.Promise;
import org.jetbrains.util.concurrency.PromiseKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"`\u000e))B*\u001b8f\u0005J,\u0017m\u001b9pS:$X*\u00198bO\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\tI\u0016\u0014WoZ4fe*\u0019\u0011I\\=\u000b\r-|G\u000f\\5o\u0015\u0019a\u0014N\\5u})\u0011a/\u001c\u0006\u0003-6TA\u0002Z3ck\u001e\u0004&o\\2fgNT\u0001\u0003R3ck\u001e\u0004&o\\2fgNLU\u000e\u001d7\u000b%%$W\rV8W[\n\u0013X-Y6q_&tGo\u001d\u0006\t)\"\u000b7\u000f['ba*\u0019qM\\;\u000b\u000bQ\u0014xN^3\u000b\u001fac\u0015N\\3Ce\u0016\f7\u000e]8j]RT1aY8n\u0015!Ig\u000e^3mY&T'\"\u0003=eK\n,xmZ3s\u0015-\u0011'/Z1la>Lg\u000e^:\u000b\u00175+H/\u00192mK2K7\u000f\u001e\u0006\u000b\u0005J,\u0017m\u001b9pS:$(\u0002\u00027pG.Taa\u00142kK\u000e$(\u0002\u00026bm\u0006TA\u0001\\1oO*A\"/\u001e8U_2{7-\u0019;j_:\u0014%/Z1la>Lg\u000e^:\u000b\u0011QC\u0015m\u001d5TKRT\u0011C^7U_&#WM\u0011:fC.\u0004x.\u001b8u\u0015!iU\u000f\u001c;j\u001b\u0006\u0004(\u0002B;uS2T!bY8oi\u0006Lg.\u001a:t\u0015Q9W\r\u001e,n)>LE-\u001a\"sK\u0006\\\u0007o\\5oi*9\"-\u001a4pe\u0016\u0014%/Z1la>Lg\u000e\u001e*f[>4X\r\u001a\u0006\u000bEJ,\u0017m\u001b9pS:$(b\u00023jg\u0006\u0014G.\u001a\u0006\b\u0005>|G.Z1o\u0015\u0011)f.\u001b;\u000b;\rdW-\u0019:Sk:$v\u000eT8dCRLwN\u001c\"sK\u0006\\\u0007o\\5oiNTAb\u0019:fCR,G+\u0019:hKRT\u0011C\u0019:fC.\u0004x.\u001b8u\u001b\u0006t\u0017mZ3s\u0015E\u0011%/Z1la>Lg\u000e^'b]\u0006<WM\u001d\u0006\tY>\u001c\u0017\r^5p]*AAj\\2bi&|gNC\u0006jgR+W\u000e]8sCJL(\u0002\u0005\"sK\u0006\\\u0007o\\5oiR\u000b'oZ3u\u0015I!wNU3n_Z,'I]3bWB|\u0017N\u001c;\u000b\u000fA\u0013x.\\5tK*Y1m\u001c8dkJ\u0014XM\\2z\u0015=!wNU;o)>dunY1uS>t'\u0002\u00039pg&$\u0018n\u001c8\u000b\u001fa\u001bv.\u001e:dKB{7/\u001b;j_:TA\u0001T5ti*yAm\\*fi\n\u0013X-Y6q_&tGO\u0003\rjg\u0006s\u0017PR5sgRd\u0015N\\3Ce\u0016\f7\u000e]8j]RT\u0001$[:Sk:$vnQ;sg>\u0014(I]3bWB|\u0017N\u001c;t\u0015Q\u0011X-\\8wK\u0006cGN\u0011:fC.\u0004x.\u001b8ug*\u0001\"/Z7pm\u0016\u0014%/Z1la>Lg\u000e\u001e\u0006\ni\u0016l\u0007o\u001c:befTQB];o)>dunY1uS>t'\"D:fi\n\u0013X-Y6q_&tGOC\u000ep]2L8k\\;sG\u0016l\u0015\r\u001d9fI\n\u0013X-Y6q_&tGo\u001d\u0006\nY>\u001c\u0017\r^5p]NTA#\u001e9eCR,\u0017\t\u001c7Ce\u0016\f7\u000e]8j]R\u001c\bZ\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0019A!\u0001\u0005\u0001\u0019\u0001)\u0011\u0001#\u0002\u0006\u0007\u0011\u0011\u0001B\u0001\u0007\u0001\u000b\r!\u0011\u0001\u0003\u0003\r\u0001\u0015\u0019A!\u0001\u0005\u0006\u0019\u0001)!\u0001B\u0001\t\t\u0015\u0011A!\u0001\u0005\u0006\u000b\u0005Ai!\u0002\u0002\u0005\u000b!9Qa\u0001C\u0006\u0011\u0019a\u0001!B\u0001\t\u0011\u0015\u0011AQ\u0002E\t\u000b\t!q\u0001C\u0005\u0006\u0005\u0011=\u00012C\u0003\u0004\t!Ay\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001B\u0003\u0007\u0001\u000b\r!\u0011\u0001#\u0006\r\u0001\u0015\u0011A1\u0002\u0005\u0007\u000b\u0005AA\"\u0002\u0002\u0005\u0016!eQa\u0001\u0003\f\u0011/a\u0001!\u0002\u0002\u0005\u0017!]Qa\u0001C\u0006\u00117a\u0001!\u0002\u0002\u0005\f!mQA\u0001\u0003\b\u0011=)!\u0001b\u0007\t \u0015\u0019AA\u0004E\u000f\u0019\u0001)!\u0001\u0002\b\t\u001e\u0015\u0019AA\u0001\u0005\u0013\u0019\u0001)1\u0001\u0002\u0002\t&1\u0001QA\u0001\u0003\t\u0011\u001f)1\u0001B\u0001\t*1\u0001Qa\u0001\u0003\u0002\u0011Wa\u0001!B\u0002\u0005\u0003!5B\u0002A\u0003\u0003\t\u0005Ai#\u0002\u0002\u0005\u0003!%RA\u0001\u0003\u0002\u0011W)!\u0001\"\u0001\t\u001f\u0015\u0011A\u0001\u0006\u0005\u0019\u000b\r!I\u0003c\f\r\u0001\u0015\u0011A\u0011\u0006E\u0018\u000b\r!y\u0001c\r\r\u0001\u0015\u0019AA\u0001\u0005\u001b\u0019\u0001)!\u0001\"\u0006\t\u001f\u0015\u0011Aa\u0006\u0005\u001b\u000b\t!y\u0001c\r\u0006\u0005\u0011\t\u0001R\u0003\u0003\u0014\u0019\u0007I2!B\u0001\t\u0006a\u0015QF\u0004\u0003b\ta%\u0011%B\u0003\u0002\u0011\u000fI\u0011\u0001b\u0001\u0019\bU\u001bA!B\u0002\u0005\n%\t\u0001\u0012B\u0017\u001e\t\u0005$\u00014B\u0011\u0015\u000b\u0005Aa!\u0003\u0004\n\u000b\u0015\t\u0001\u0012C\u0005\u0002\t\u0007A\n\"C\u0005\n\u0011\u0015\t\u0001\"C\u0005\u0005\u0013\r)\u0011\u0001c\u0005\u0019\u0014aI\u0001DB+\u0004\t\u0015\u0019A1B\u0005\u0002\u0011)iC\u0002B1\u00051-\t3!B\u0001\t\u0018a]Qk\u0001\u0003\u0006\u0007\u0011Y\u0011\"\u0001\u0005\r[E!\u0011\r\u0002\r\u000eC!)\u0011\u0001#\u0007\n\t%\u0019Q!\u0001E\n1'AJ\"V\u0002\u0005\u000b\r!Q\"C\u0001\t\u001b5bA!\u0019\u0003\u0019\b\u0005\u001aQ!\u0001\u0005\u00041\r)6\u0001B\u0003\u0004\t\u000fI\u0011\u0001\u0003\u0003.9\u0011\u0011G\u0001\u0007\b\"\u001f\u0015\t\u0001RD\u0005\u0005\u0013\r)\u0011\u0001c\u0005\u0019\u0014%1\u0011\"B\u0003\u0002\u0011#I\u0011\u0001b\u0001\u0019\u0012auQk\u0001\u0005\u0006\u0007\u0011q\u0011\"\u0001\u0005\u0010\u001b\r!\u0001#C\u0001\t\u001f5\u000eCA\u0003M\u0011;'!\u0001\u0001C\t\u000e\u000b\u0015\t\u0001\u0012C\u0005\u0002\t\u0007A\n\u0002U\u0002\u0001;\u001f!\u0001\u0001c\t\u000e\u0007\u0015\t\u0001r\u0004M\u0010!\u000e\u0005\u0011eA\u0003\u0002\u0011AA\u0002#U\u0002\b\tCI\u0011\u0001\u0002\u0001\u000e\u0003!\u0005R\"\u0001C\u0001[+!1\u0001G\n\"\u0007\u0015\t\u0001\u0002\u0005\r\u0011#\u000e\u0019AaE\u0005\u0002\t\u0001i{\u0007\u0002\n\u0019(uUA\u0001\u0001\u0005\u0012\u001b\u0019)\u0011\u0001#\u0005\n\u0003\u0011\rA\u0012\u0001M\t!\u000e\u0001Qt\u0002\u0003\u0001\u0011Qi1!B\u0001\t#a\t\u0002k!\u0001\u001e\u0010\u0011\u0001\u0001\"F\u0007\u0004\u000b\u0005A\u0019\u0003g\tQ\u0007\u0005iz\u0001\u0002\u0001\t-5\u0019Q!\u0001E\u00101?\u000161A\u0011\u0004\u000b\u0005A!\u0003\u0007\nR\u0007-!9#C\u0001\t&5\t\u0001\u0012E\u0007\u0002\u0011Mi\u0011\u0001c\n\u000e\u0003\u0011\u0005Qv\t\u0003\u00041]i\u001a\u0002\u0002\u0001\t#5)Q!\u0001E\t\u0013\u0005!\u0019\u0001'\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t$5\u0019Q!\u0001E\u00101?\u00016\u0011A\u0011\u0006\u000b\u0005AQ#C\u0001\u0005\u0004a)\u0012kA\u0004\u0005/%\t\u00012F\u0007\u0002\u0011Ci\u0011\u0001\"\u0001.5\u0011\u0011\u0002\u0014GO\b\t\u0001A\u0011$D\u0002\u0006\u0003!1\u0002D\u0006)\u0004\u0001\u0005BQ!\u0001E\u0017\u0013\u0011I1!B\u0001\t\u0014aM\u0001TF)\u0004\u000b\u0011E\u0012\"\u0001E\u0018\u001b\u0005A\u0001$L\u0017\u0005\u0005aURT\u0003\u0003\u0001\u0011Eia!B\u0001\t\u0012%\tA1\u0001G\u00011#\u00016\u0001AO\b\t\u0001AQ#D\u0002\u0006\u0003!\r\u00024\u0005)\u0004\u0002u=A\u0001\u0001\u0005\u0017\u001b\r)\u0011\u0001c\b\u0019 A\u001b\u0011!I\u0002\u0006\u0003!M\u00014C)\u0004\u0013\u0011U\u0012\"\u0001E\u0019\u001b\u0005A\t#D\u0001\t(5\tA\u0011A\u0017\u0016\t-A2$h\u0004\u0005\u0001!\tRbA\u0003\u0002\u0011'A\u001a\u0002U\u0002\u0001C\r)\u0011\u0001c\b\u0019 E\u001bQ\u0001B\u000e\n\u0003\u0011\u0005Q\"\u0001E\u0019[i!1\u0001g\u000e\u001e\u001a\u0011\u0001\u00012C\u0007\t\u000b\u0005Ai#\u0003\u0003\n\u0007\u0015\t\u00012\u0003M\n1[\u00016\u0001A\u0011\u0004\u000b\u0005Ay\u0002g\bR\u0007\u0015!9$C\u0001\u0005\u00025\t\u0001rFW\r\t\rAB$I\u0003\u0006\u0003!)\u0012\"\u0001C\u00021U\t6a\u0001\u0003\u001d\u0013\u0005AY#l\u0012\u0005\u0007aeR4\u0003\u0003\u0001\u0011EiQ!B\u0001\t\u0012%\tA1\u0001M\t!\u000e\u0001Qt\u0002\u0003\u0001\u0011ui1!B\u0001\t a}\u0001k!\u0001\"\u000b\u0015\t\u0001\"F\u0005\u0002\t\u0007AR#U\u0002\b\tsI\u0011\u0001c\u000b\u000e\u0003!\u0005R\"\u0001C\u0001[U!1\u0001g\u000f\u001e\u0010\u0011\u0001\u0001\"G\u0007\u0004\u000b\u0005Aa\u0003\u0007\fQ\u0007\u0001\t3!B\u0001\t!a\u0001\u0012kA\u0003\u0005<%\tA\u0001A\u0007\u0002\u0011ai\u001b\u0005B\u0002\u0019=uMA\u0001\u0001\u0005\u0012\u001b\u0015)\u0011\u0001#\u0005\n\u0003\u0011\r\u0001\u0014\u0003)\u0004\u0001u=A\u0001\u0001E\u001f\u001b\r)\u0011\u0001c\b\u0019 A\u001b\t!I\u0002\u0006\u0003!\u0001\u0002\u0004E)\u0004\u000f\u0011q\u0012\"\u0001\u0003\u0001\u001b\u0005A\t#D\u0001\u0005\u000256Ca\u0001\r\u001f;'!\u0001\u0001C\t\u000e\u000b\u0015\t\u0001\u0012C\u0005\u0002\t\u0007A\n\u0002U\u0002\u0001;3!\u0001\u0001C\u0010\u000e\u0011\u0015\t\u0001RF\u0005\u0005\u0013\r)\u0011\u0001c\t\u0019$a5\u0002k!\u0001\"\u0007\u0015\t\u0001\u0002\u0005\r\u0011#\u000e9AAH\u0005\u0002\t\u0001i\u0011\u0001#\t\u000e\u0003!=RV\u0003\u0003\u00041\u007f\t3!B\u0001\t!a\u0001\u0012kA\u0002\u0005@%\tA\u0001A\u001b$\u000b\t\"1\u001d\u0001\r\u0004;\u001f!\u0001\u0001c\u0002\u000e\u0007\u0015\t\u0001b\u0001\r\u0004!\u000e\u0001Q4\u0003\u0003\u0001\u0011\u0013iQ!B\u0001\t\b%\tA1\u0001M\u0004!\u000e\u0005\u0011eA\u0003\u0002\u0011\u0007A\u001a!U\u0002\b\t\rI\u0011\u0001\u0002\u0001\u000e\u0003!!Q\"\u0001E\u0005"})
public abstract class LineBreakpointManager {
    public static final /* synthetic */ KClass $kotlinClass;
    private final THashMap<XLineBreakpoint<?>, List<Breakpoint>> ideToVmBreakpoints;
    @NotNull
    private final MultiMap<Breakpoint, XLineBreakpoint<?>> vmToIdeBreakpoint;
    private final THashSet<Breakpoint> runToLocationBreakpoints;
    private final Object lock;
    private final Vm vm;
    private final DebugProcessImpl<?> debugProcess;

    static {
        $kotlinClass = Reflection.createKotlinClass(LineBreakpointManager.class);
    }

    @NotNull
    protected final MultiMap<Breakpoint, XLineBreakpoint<?>> getVmToIdeBreakpoint() {
        return this.vmToIdeBreakpoint;
    }

    public boolean isAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void setBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean onlySourceMappedBreakpoints) {
        List list;
        void lock;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Object object = this.lock;
        synchronized (lock) {
            list = (List)this.ideToVmBreakpoints.get(breakpoint);
        }
        List target = list;
        if (target == null) {
            this.setBreakpoint(breakpoint, this.debugProcess.getLocationsForBreakpoint(breakpoint, onlySourceMappedBreakpoints));
        } else {
            BreakpointManager breakpointManager = this.vm.getBreakpointManager();
            for (Breakpoint vmBreakpoint : target) {
                if (vmBreakpoint.getEnabled()) continue;
                vmBreakpoint.setEnabled(true);
                breakpointManager.flush(vmBreakpoint).rejected((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this, breakpoint){
                    final /* synthetic */ LineBreakpointManager this$0;
                    final /* synthetic */ XLineBreakpoint $breakpoint;

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        LineBreakpointManager.access$getDebugProcess$3(this.this$0).getSession().updateBreakpointPresentation(this.$breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, it.getMessage());
                    }
                    {
                        this.this$0 = lineBreakpointManager;
                        this.$breakpoint = xLineBreakpoint;
                        super(1);
                    }
                }));
            }
        }
    }

    @NotNull
    public final Promise<?> removeBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean temporary) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        boolean disable = temporary && this.vm.getBreakpointManager().getMuteMode() != BreakpointManager.MUTE_MODE.NONE;
        this.beforeBreakpointRemoved(breakpoint, disable);
        return this.doRemoveBreakpoint(breakpoint, disable);
    }

    protected void beforeBreakpointRemoved(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Promise<?> doRemoveBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        Breakpoint vmBreakpoint;
        Iterator iterator;
        void vmBreakpoints;
        void lock;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = KotlinPackage.emptySet();
        Object object = this.lock;
        synchronized (lock) {
            Object vmBreakpoint22;
            if (disable) {
                List list = (List)this.ideToVmBreakpoints.get(breakpoint);
                if (list == null) {
                    return PromiseKt.ResolvedPromise();
                }
                List list2 = list;
                Iterator iterator2 = list2.iterator();
                List list3 = list2;
                Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"list");
                vmBreakpoints.element = list3;
                while (iterator2.hasNext()) {
                    Breakpoint vmBreakpoint3 = (Breakpoint)iterator2.next();
                    if (this.getVmToIdeBreakpoint().get((Object)vmBreakpoint3).size() <= 1) continue;
                    iterator2.remove();
                }
            } else {
                List list = (List)this.ideToVmBreakpoints.remove(breakpoint);
                if (list == null) {
                    return PromiseKt.ResolvedPromise();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ideToVmBreakpoints.remov\u2026 return ResolvedPromise()");
                vmBreakpoints.element = list;
                if (!((List)((Collection)vmBreakpoints.element)).isEmpty()) {
                    for (Object vmBreakpoint22 : (Collection)vmBreakpoints.element) {
                        this.getVmToIdeBreakpoint().remove(vmBreakpoint22, breakpoint);
                        if (!this.getVmToIdeBreakpoint().containsKey(vmBreakpoint22)) continue;
                        return PromiseKt.ResolvedPromise();
                    }
                }
            }
            vmBreakpoint22 = Unit.INSTANCE$;
        }
        if (((Collection)vmBreakpoints.element).isEmpty()) {
            return PromiseKt.ResolvedPromise();
        }
        BreakpointManager breakpointManager = this.vm.getBreakpointManager();
        SmartList promises = new SmartList();
        if (disable) {
            iterator = ((Collection)vmBreakpoints.element).iterator();
            while (iterator.hasNext()) {
                vmBreakpoint = (Breakpoint)iterator.next();
                vmBreakpoint.setEnabled(false);
                promises.add(breakpointManager.flush(vmBreakpoint));
            }
            return Promise.Companion.all((Collection)promises);
        }
        iterator = ((Collection)vmBreakpoints.element).iterator();
        while (iterator.hasNext()) {
            vmBreakpoint = (Breakpoint)iterator.next();
            promises.add(breakpointManager.remove(vmBreakpoint));
        }
        return Promise.Companion.all((Collection)promises);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<? extends Location> locations) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull(locations, (String)"locations");
        if (locations.isEmpty()) {
            return;
        }
        SmartList vmBreakpoints = new SmartList();
        for (Location location : locations) {
            vmBreakpoints.add((Object)this.doSetBreakpoint(breakpoint, location, false));
        }
        Object object = this.lock;
        synchronized (object) {
            this.ideToVmBreakpoints.put(breakpoint, (Object)vmBreakpoints);
            for (Breakpoint vmBreakpoint : vmBreakpoints) {
                this.getVmToIdeBreakpoint().putValue((Object)vmBreakpoint, breakpoint);
            }
            Iterator iterator = Unit.INSTANCE$;
        }
    }

    @NotNull
    protected final Breakpoint doSetBreakpoint(@Nullable XLineBreakpoint<?> breakpoint, @NotNull Location location, boolean isTemporary) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        BreakpointManager breakpointManager = this.vm.getBreakpointManager();
        BreakpointTarget target = this.createTarget(breakpoint, breakpointManager, location, isTemporary);
        XLineBreakpoint<?> xLineBreakpoint = breakpoint;
        XExpression condition = xLineBreakpoint != null ? xLineBreakpoint.getConditionExpression() : null;
        XExpression xExpression = condition;
        return breakpointManager.setBreakpoint(target, location.getLine(), location.getColumn(), xExpression != null ? xExpression.getExpression() : null, Breakpoint.Companion.getEMPTY_VALUE(), true);
    }

    @NotNull
    protected abstract BreakpointTarget createTarget(@Nullable XLineBreakpoint<?> var1, @NotNull BreakpointManager var2, @NotNull Location var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runToLocation(@NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        List<Breakpoint> addedBreakpoints = this.doRunToLocation(position);
        if (addedBreakpoints.isEmpty()) {
            return;
        }
        Object lock = this.lock;
        synchronized (lock) {
            boolean bl = this.runToLocationBreakpoints.addAll((Collection)addedBreakpoints);
        }
        this.debugProcess.resume();
    }

    @NotNull
    protected abstract List<Breakpoint> doRunToLocation(@NotNull XSourcePosition var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunToCursorBreakpoints(@NotNull List<? extends Breakpoint> breakpoints) {
        Intrinsics.checkParameterIsNotNull(breakpoints, (String)"breakpoints");
        THashSet<Breakpoint> lock = this.runToLocationBreakpoints;
        synchronized (lock) {
            boolean bl = this.runToLocationBreakpoints.containsAll((Collection)breakpoints);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAllBreakpoints() {
        XLineBreakpoint[] xLineBreakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            Collection $receiver = this.ideToVmBreakpoints.keySet();
            Collection collection = $receiver;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection = collection;
            XLineBreakpoint[] xLineBreakpointArray2 = thisCollection.toArray(new XLineBreakpoint[thisCollection.size()]);
            if (xLineBreakpointArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            xLineBreakpointArray = (XLineBreakpoint[])((Object[])xLineBreakpointArray2);
        }
        XLineBreakpoint[] array = xLineBreakpointArray;
        for (int i = 0; i < array.length; ++i) {
            XLineBreakpoint breakpoint;
            XLineBreakpoint xLineBreakpoint = breakpoint = array[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint, (String)"breakpoint");
            this.removeBreakpoint(xLineBreakpoint, false);
            XLineBreakpoint xLineBreakpoint2 = breakpoint;
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint2, (String)"breakpoint");
            this.setBreakpoint(xLineBreakpoint2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Promise<?> removeAllBreakpoints() {
        Object lock = this.lock;
        synchronized (lock) {
            this.ideToVmBreakpoints.clear();
            this.getVmToIdeBreakpoint().clear();
            this.runToLocationBreakpoints.clear();
            Unit unit = Unit.INSTANCE$;
        }
        return this.vm.getBreakpointManager().removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearRunToLocationBreakpoints() {
        Breakpoint[] breakpoints;
        Object lock = this.lock;
        synchronized (lock) {
            if (this.runToLocationBreakpoints.isEmpty()) {
                return;
            }
            breakpoints = (Breakpoint[])this.runToLocationBreakpoints.toArray((Object[])new Breakpoint[this.runToLocationBreakpoints.size()]);
            this.runToLocationBreakpoints.clear();
        }
        Breakpoint[] breakpoints2 = breakpoints;
        BreakpointManager breakpointManager = this.vm.getBreakpointManager();
        for (int i = 0; i < breakpoints2.length; ++i) {
            Breakpoint breakpoint;
            Breakpoint breakpoint2 = breakpoint = breakpoints2[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)breakpoint2, (String)"breakpoint");
            breakpointManager.remove(breakpoint2);
        }
    }

    public LineBreakpointManager(@NotNull Vm vm, @NotNull DebugProcessImpl<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.vm = vm;
        this.debugProcess = debugProcess;
        this.ideToVmBreakpoints = new THashMap();
        MultiMap multiMap = MultiMap.createSmart();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.createSmart()");
        this.vmToIdeBreakpoint = multiMap;
        this.runToLocationBreakpoints = new THashSet();
        this.lock = new Object();
        this.vm.getBreakpointManager().addBreakpointListener(new BreakpointManager.BreakpointListener(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(1.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resolved(@NotNull Breakpoint breakpoint) {
                Collection collection;
                Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                Object lock = lock;
                synchronized (lock) {
                    collection = this.getVmToIdeBreakpoint().get((Object)breakpoint);
                }
                Collection breakpoints = collection;
                for (XLineBreakpoint ideBreakpoint : breakpoints) {
                    debugProcess.getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_verified_breakpoint, (String)null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void errorOccurred(@NotNull Breakpoint breakpoint, @Nullable String errorMessage) {
                Collection collection;
                void lock;
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                if (this.isAnyFirstLineBreakpoint(breakpoint)) {
                    return;
                }
                Object lock2 = lock;
                synchronized (lock2) {
                    bl = runToLocationBreakpoints.remove((Object)breakpoint);
                }
                if (bl) {
                    XDebugSession xDebugSession = debugProcess.getSession();
                    StringBuilder stringBuilder = new StringBuilder().append("Cannot run to cursor: ");
                    String string = errorMessage;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    xDebugSession.reportError(stringBuilder.append(string).toString());
                    return;
                }
                Object object = lock;
                synchronized (lock) {
                    collection = this.getVmToIdeBreakpoint().get((Object)breakpoint);
                }
                Collection breakpoints = collection;
                for (XLineBreakpoint ideBreakpoint : breakpoints) {
                    debugProcess.getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
                }
            }
        });
    }
}

