/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkListener;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.BrowserConnection;
import org.jetbrains.util.concurrency.AsyncPromise;
import org.jetbrains.util.concurrency.Promise;
import org.jetbrains.util.concurrency.PromiseKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"p\f)aa+\\\"p]:,7\r^5p]*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(\u0002\u00033fEV<w-\u001a:\u000b\u0015\r|gN\\3di&|gNC\u0001U\u0015\t1VN\u0003\u0006ESN\u0004xn]1cY\u0016T1aY8n\u0015!Ig\u000e^3mY&T'bB8qK:\f\u0007/\u001b\u0006\u0012\u0005J|wo]3s\u0007>tg.Z2uS>t'B\u0002\u001fj]&$hH\u0003\u0004dY>\u001cX\r\u001a\u0006\u000e\u0003R|W.[2C_>dW-\u00198\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\u0006d_:\u001cWO\u001d:f]RTa!\u0019;p[&\u001c'\u0002F2p]:,7\r^5p]\u0012K7\u000f]1uG\",'OC\bFm\u0016tG\u000fR5ta\u0006$8\r[3s\u0015a\u0019vnY6fi\u000e{gN\\3di&|g\u000eT5ti\u0016tWM\u001d\u0006\u0003S>T\u0001c]8dW\u0016$8i\u001c8oK\u000e$\u0018n\u001c8\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'B\u00053fEV<WI^3oi2K7\u000f^3oKJT!\u0003R3ck\u001e,e/\u001a8u\u0019&\u001cH/\u001a8fe*)r-\u001a;EK\n,x-\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014(B\u00033jgB\fGo\u00195fe*1q\u000e]3oK\u0012TA\"Q:z]\u000e\u0004&o\\7jg\u0016T1bY8oGV\u0014(/\u001a8ds*\u0019\u0011I\\=\u000b\r-|G\u000f\\5o\u0015\u0015\u0019H/\u0019;f\u0015=\tEo\\7jGJ+g-\u001a:f]\u000e,'bD\"p]:,7\r^5p]N#\u0018\r^3\u000b\u000fq\u001aX\r^\u0017@})\u0011a/\u001c\u0006\u0006O\u0016$h+\u001c\u0006\u0006g\u0016$h+\u001c\u0006\u0011C\u0012$G)\u001a2vO2K7\u000f^3oKJT\u0001\u0002\\5ti\u0016tWM\u001d\u0006\u0005+:LGOC\u0006bI\u0012d\u0015n\u001d;f]\u0016\u0014(\"B2m_N,'bB7fgN\fw-\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\rM$\u0018\r^;t\u0015A\u0019uN\u001c8fGRLwN\\*uCR,8O\u0003\u0003mC:<'B\u00043fi\u0006\u001c\u0007.\u00118e\u00072|7/\u001a\u0006\b!J|W.[:f\u0015\u001d!\u0017n\u001d9pg\u0016Ta\"\u001a=fGV$Xm\u00148Ti\u0006\u0014HO\u0003\u0005sk:t\u0017M\u00197f\u0015!\u0011VO\u001c8bE2,'\u0002C4fiN#\u0018\r^3\u000b\u0011M,Go\u0015;bi\u0016T1#\\3tg\u0006<W\rT5oW2K7\u000f^3oKJT\u0011\u0003S=qKJd\u0017N\\6MSN$XM\\3s\u0015\u0015Q\u0017M^1y\u0015\u0015\u0019x/\u001b8h\u0015\u0015)g/\u001a8u\u0015=\u0019H/\u0019:u!J|7-Z:tS:<'[\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\u0019A!\u0001\u0005\u0004\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u0019\u0001\u0012B\u0003\u0003\t\u000fAQ!B\u0002\u0005\t!\u001dA\u0002A\u0003\u0004\t\u0007AY\u0001\u0004\u0001\u0006\u0003!=QA\u0001C\u0006\u0011!)!\u0001\u0002\u0004\t\u0012\u0015\u0011AQ\u0002\u0005\n\u000b\r!q\u0001C\u0004\r\u0001\u0015\u0011Aa\u0002\u0005\b\u000b\t!9\u0001\u0003\u0005\u0006\u0007\u0011E\u0001B\u0003\u0007\u0001\u000b\t!\t\u0002C\u0006\u0006\u0005\u0011M\u0001rC\u0003\u0004\t)A)\u0002\u0004\u0001\u0006\u0005\u0011E\u0001BC\u0003\u0004\t\u0005AQ\u0002\u0004\u0001\u0006\u0005\u0011\t\u0001\"D\u0003\u0003\t\u0003A\u0001\"\u0002\u0002\u0005\u001a!}Qa\u0001\u0003\u000e\u0011=a\u0001!B\u0001\t\"\u0015\u0019AA\u0004\u0005\u0011\u0019\u0001)!\u0001B\u0007\t\u001f\u0015\u0019Aa\u0002E\u0012\u0019\u0001)1\u0001\u0002\u0006\t%1\u0001QA\u0001\u0003\b\u0011G)!\u0001B\u0001\t\u0007\u0015\u0019AA\u0004E\u0016\u0019\u0001)!\u0001\u0002\u0006\t\u0016\u0015\u0019AA\u0004E\u0018\u0019\u0001)1\u0001\u0002\u0006\t21\u0001QA\u0001C\u0006\u0011e)!\u0001b\n\t0\u0015\u0011AA\u0003E\u0019\u000b\r!Q\u0002\u0003\u000e\r\u0001\u0015\u0011A!\u0004\u0005\u001b\u000b\r!9\u0003\u0003\u000f\r\u0001\u0015\u0011Aq\u0005\u0005\u001d\u000b\t!!\u0002\u0003\n\u0006\u0003!uRA\u0001C\u0018\u0011})!\u0001\u0002\r\t@\u0015\u0019A\u0011\u0007\u0005\u001f\u0019\u0001)!\u0001\"\r\t=\u0011\u0019BBA\u000b\u0007\t\u0001A)!F\u0002\u0006\u0003!\u0015\u0001TA\r\u0004\u000b\u0005AI\u0001'\u0003\u001a\u0007\u0015\t\u0001\"\u0002\r\u0006[1!\u0011\r\u0002M\u0007C\r)\u0011\u0001c\u0004\u0019\u0010U\u001bA!B\u0002\u0005\u000e%\t\u0001\u0002C\u0017)\t\u0005$\u00014C\u0011 \u000b\u0005A\u0011\"\u0003\u0006\n\u0013\u0015\t\u0001R\u0003\t\r+\u0011)\u0011\u0001#\u0006\r\u0002aU\u0001T\u0003\t\r+=)\u0011\u0001C\u0005\n\u0015%IQ!\u0001E\u000b!1)B!B\u0001\t\u00161\u0005\u0001T\u0003M\u000b\u0019\u0003A\u0012\u0002G\u0005V\u0007\u0011)1\u0001b\u0005\n\u0003!YQ&\u0004\u0003c\tae\u0011eA\u0003\u0002\u0011/A:\u0002\n\u0012V\u0007\u0011i1\u0001b\u0007\n\u0003!aQ\u0006\u000b\u0003b\taq\u0011eH\u0003\u0002\u0011%I!\"C\u0005\u0006\u0003!]\u0001\u0003D\u000b\u0005\u000b\u0005A9\u0002$\u0001\u0019\u0018a]\u0001\u0003D\u000b\u0010\u000b\u0005A\u0011\"\u0003\u0006\n\u0013\u0015\t\u0001r\u0003\t\r+\u0011)\u0011\u0001c\u0006\r\u0002a]\u0001t\u0003G\u00011%A\u0012\"V\u0002\u0005\u000b\r!a\"C\u0001\t\u00175\u0012B!\u0019\u0003\u0019\u001e\u0005JQ!\u0001E\u000e\u0013\u0015IA!B\u0001\t\u001e1\u0005\u0001T\u0004M\u000e+\u000e!Qa\u0001C\u000f\u0013\u0005Aq\"L\f\u0005C\u0012A\u0012#\t\b\u0006\u0003!}\u0011BC\u0005\n\u000b\u0005A\u0001\u0003\u0005\u0007\u0016\t\u0015\t\u0001\u0002\u0005G\u00011AA\u0002\u0003g\bV\u0007\u0011)1\u0001B\t\n\u0003!\u0005R\u0016\nCD\u001aa\u0019R4\u0003\u0003\u0001\u0011KiQ!\u0002\u0002\u0005\u0002!\u0001A\u0012\u0001\u000f\u0001!\u000e\u0001\u0011%B\u0003\u0003\t\u0003A\u0001\u0001$\u0001\u001d\u0001\u0011\u001a\u0001FI+\u0004\u001d\u0015\u0019AaE\u0005\u0002\u0011Ei1\u0001b\n\n\u0003!\t\u0012#\u0002\u0003\u0015\u0013\u0005!\u0001!D\u0001\t#5*Ba\u0001M\u0015;\u001f!\u0001\u0001C\u000b\u000e\u0007\u0015\t\u0001r\u0003M\f!\u000e\u0001\u0011eA\u0003\u0002\u0011GA\u001a#U\u0002\u0006\tSI\u0011\u0001\u0002\u0001\u000e\u0003!aQ&\u0006\u0003\f1Yiz\u0001\u0002\u0001\t+5\u0019Q!\u0001E\u000b1+\u00016\u0001A\u0011\u0004\u000b\u0005A\u0019\u0003g\tR\u0007\u0015!a#C\u0001\u0005\u00015\t\u0001BEW!\t\rAj#(\u0005\u0005\u0001!9R\u0002B\u0003\u0002\u0011Ka\t\u0001'\nQ\u0007\u0001iz\u0001\u0002\u0001\t15\u0019Q!\u0001\u0005\u00141M\u00016\u0011A\u0011\u0004\u000b\u0005A\u0019\u0003g\tR\u0007\u001d!i#C\u0001\u0005\u00015\t\u0001\u0002F\u0007\u0002\u0011SiK\u0002B\u0006\u00194\u0005*Q!\u0001\u0005\u0016\u0013\u0005!\u0019\u0001G\u000bR\u0007\r!\u0019$C\u0001\t,5VAa\u0003M\u001bC\r)\u0011\u0001c\t\u0019$E\u001b1\u0001\"\u000e\n\u0003\u0011\u0001Q&\u0006\u0003\f1miz\u0001\u0002\u0001\t85\u0019Q!\u0001\u0005\u00171Y\u00016\u0001A\u0011\u0004\u000b\u0005A\u0019\u0003g\tR\u0007\u0015!1$C\u0001\u0005\u00015\t\u0001RFW\u0011\t-AJ$I\u0005\u0006\u0003!\u0001\u0002\u0003D\u000b\u0005\u000b\u0005A\u0001\u0003$\u0001\u0019!a\u0001\u0012kA\u0002\u0005:%\t\u0001bFW\r\t\u000fAj\"I\u0003\u0006\u0003!)\u0012\"\u0001C\u00021U\t6a\u0001C\u000f\u0013\u0005AY#\f\u0017\u0005\u0005aiRt\u0002\u0003\u0001\u0011ai1!B\u0001\t'a\u0019\u0002k\u0001\u0001\u001e\u0012\u0011\t\u0001bF\u0007\u0005\u000b\u0005A)\u0003$\u0001\u0019&A\u001b\t!(\u0005\u0005\u0003!mR\u0002B\u0003\u0002\u0011ea\t\u0001G\rQ\u0007\u0005\t3!B\u0001\t$a\r\u0012kA\u0005\u0005;%\tA\u0001A\u0007\u0002\u0011Si\u0011\u0001\u0003\u000b\u000e\u0003!MRV\u0003\u0003\u000b1\u0001\n3!B\u0001\t$a\r\u0012kA\u0002\u0005A%\tA\u0001A\u001b\u001a\u000ba!1\u001dA\t\u0007\t\u0001A)!F\u0002\u0006\u0003!\u0015\u0001T\u0001\r\u0007C%)\u0011\u0001\u0003\u0002\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002\u0001\u0007\u0002R\u0007\r!a!C\u0001\u0005\u0001\u0001"})
public abstract class VmConnection<T extends Vm>
implements Disposable,
BrowserConnection {
    public static final /* synthetic */ KClass $kotlinClass;
    private final AtomicReference<ConnectionState> state = new AtomicReference<ConnectionState>(new ConnectionState(ConnectionStatus.NOT_CONNECTED));
    private final EventDispatcher<DebugEventListener> dispatcher = EventDispatcher.create(DebugEventListener.class);
    private final EventDispatcher<SocketConnectionListener> connectionDispatcher = EventDispatcher.create(SocketConnectionListener.class);
    @Nullable
    private volatile T vm;
    private final AsyncPromise<Object> opened = new AsyncPromise();
    private final AtomicBoolean closed = new AtomicBoolean();

    static {
        $kotlinClass = Reflection.createKotlinClass(VmConnection.class);
    }

    @Nullable
    public final T getVm() {
        return this.vm;
    }

    protected final void setVm(@Nullable T t) {
        this.vm = t;
    }

    @Override
    public ConnectionState getState() {
        return this.state.get();
    }

    public final void addDebugListener(@NotNull DebugEventListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.dispatcher.addListener((EventListener)listener);
    }

    @NotNull
    public final Promise<?> opened() {
        return this.opened;
    }

    @Override
    public void executeOnStart(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        this.opened.done((Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(runnable){
            final /* synthetic */ Runnable $runnable;

            public final void invoke(@Nullable Object it) {
                this.$runnable.run();
            }
            {
                this.$runnable = runnable;
                super(1);
            }
        }));
    }

    protected final void setState(@NotNull ConnectionStatus status, @Nullable String message, @Nullable HyperlinkListener messageLinkListener) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        ConnectionState newState = new ConnectionState(status, message, messageLinkListener);
        ConnectionState oldState = this.state.getAndSet(newState);
        if (oldState == null || Intrinsics.areEqual((Object)((Object)oldState.getStatus()), (Object)((Object)status)) ^ true) {
            if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ConnectionStatus.CONNECTION_FAILED))) {
                String string = newState.getMessage();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newState.getMessage()");
                this.opened.setError(string);
            }
            ((SocketConnectionListener)this.connectionDispatcher.getMulticaster()).statusChanged(status);
        }
    }

    protected static /* synthetic */ void setState$default(VmConnection vmConnection, ConnectionStatus connectionStatus, String string, HyperlinkListener hyperlinkListener, int n) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            hyperlinkListener = null;
        }
        vmConnection.setState(connectionStatus, string, hyperlinkListener);
    }

    @Override
    public void addListener(@NotNull SocketConnectionListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.connectionDispatcher.addListener((EventListener)listener);
    }

    @NotNull
    protected final DebugEventListener getDebugEventListener() {
        DebugEventListener debugEventListener = (DebugEventListener)this.dispatcher.getMulticaster();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugEventListener, (String)"dispatcher.getMulticaster()");
        return debugEventListener;
    }

    protected void startProcessing() {
        this.opened.setResult(null);
    }

    public final void close(@Nullable String message, @NotNull ConnectionStatus status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (PromiseKt.getIsPending((Promise)this.opened)) {
            this.opened.setError("closed");
        }
        VmConnection.setState$default(this, status, message, null, 4);
        Disposer.dispose((Disposable)this, (boolean)false);
    }

    public void dispose() {
        this.vm = null;
    }

    @NotNull
    public Promise<?> detachAndClose() {
        Promise<?> callback;
        T currentVm;
        if (PromiseKt.getIsPending((Promise)this.opened)) {
            this.opened.setError("detached and closed");
        }
        if ((currentVm = this.vm) == null) {
            callback = PromiseKt.ResolvedPromise();
        } else {
            this.vm = null;
            callback = currentVm.getAttachStateManager().detach();
        }
        this.close(null, ConnectionStatus.DISCONNECTED);
        return callback;
    }
}

