/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.DelegatingHttpRequestHandlerBase;
import org.jetbrains.io.NettyUtil;

public final class SubServer
implements CustomPortServerManager.CustomPortService,
Disposable {
    private ChannelRegistrar channelRegistrar;
    private final CustomPortServerManager user;
    private final BuiltInServer server;

    public SubServer(@NotNull CustomPortServerManager user, @NotNull BuiltInServer server) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/io/SubServer", "<init>"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/io/SubServer", "<init>"));
        }
        this.user = user;
        this.server = server;
        user.setManager((CustomPortServerManager.CustomPortService)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(int port) {
        if (port == this.server.getPort() || port == -1) {
            return true;
        }
        if (this.channelRegistrar == null) {
            Disposer.register((Disposable)this.server, (Disposable)this);
            this.channelRegistrar = new ChannelRegistrar();
        }
        ServerBootstrap bootstrap = NettyUtil.nioServerBootstrap(this.server.getEventLoopGroup());
        Map xmlRpcHandlers = this.user.createXmlRpcHandlers();
        if (xmlRpcHandlers == null) {
            BuiltInServer.configureChildHandler(bootstrap, this.channelRegistrar, null);
        } else {
            final XmlRpcDelegatingHttpRequestHandler handler2 = new XmlRpcDelegatingHttpRequestHandler(xmlRpcHandlers);
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

                protected void initChannel(Channel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{SubServer.this.channelRegistrar});
                    NettyUtil.addHttpServerCodec(channel.pipeline());
                    channel.pipeline().addLast(new ChannelHandler[]{handler2});
                }
            });
        }
        try {
            bootstrap.localAddress((SocketAddress)(this.user.isAvailableExternally() ? new InetSocketAddress(port) : new InetSocketAddress(NetUtils.getLoopbackAddress(), port)));
            this.channelRegistrar.add(bootstrap.bind().syncUninterruptibly().channel());
            return true;
        }
        catch (Exception e) {
            try {
                NettyUtil.log(e, BuiltInServer.LOG);
            }
            finally {
                this.user.cannotBind(e, port);
            }
            return false;
        }
    }

    public boolean isBound() {
        return this.channelRegistrar != null && !this.channelRegistrar.isEmpty();
    }

    private void stop() {
        if (this.channelRegistrar != null) {
            this.channelRegistrar.close(false);
        }
    }

    public boolean rebind() {
        this.stop();
        return this.bind(this.user.getPort());
    }

    public void dispose() {
        this.stop();
        this.user.setManager(null);
    }

    @ChannelHandler.Sharable
    private static final class XmlRpcDelegatingHttpRequestHandler
    extends DelegatingHttpRequestHandlerBase {
        private final Map<String, Object> handlers;

        public XmlRpcDelegatingHttpRequestHandler(Map<String, Object> handlers) {
            this.handlers = handlers;
        }

        @Override
        protected boolean process(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) throws IOException {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/SubServer$XmlRpcDelegatingHttpRequestHandler", "process"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/SubServer$XmlRpcDelegatingHttpRequestHandler", "process"));
            }
            if (urlDecoder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/io/SubServer$XmlRpcDelegatingHttpRequestHandler", "process"));
            }
            if (this.handlers.isEmpty()) {
                return false;
            }
            return request.method() == HttpMethod.POST && XmlRpcServer.SERVICE.getInstance().process(urlDecoder.path(), request, context, this.handlers);
        }
    }
}

