/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.vfs.VirtualFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiConstants;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"W\b)qa)Y:u\u0007\u001eL'+Z9vKN$(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0003S>TqAZ1ti\u000e;\u0017NC\u0002B]fTaa[8uY&t'B\u0002\u001fj]&$hHC\u0005sKF,Xm\u001d;JI*\u0019\u0011J\u001c;\u000b\u0013\u0005dGn\\2bi>\u0014(\u0002\u0005\"zi\u0016\u0014UOZ!mY>\u001c\u0017\r^8s\u0015\u0015qW\r\u001e;z\u0015\u0019\u0011WO\u001a4fe*9!)\u001f;f\u0005V4'\u0002D4fiJ+\u0017/^3ti&#'\"C1eI\"+\u0017\rZ3s\u0015\rYW-\u001f\u0006\u0007'R\u0014\u0018N\\4\u000b\u000bY\fG.^3\u000b\u0019\rC\u0017M]*fcV,gnY3\u000b\tUs\u0017\u000e\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\u0002E<sSR,g)\u001b7f\u0011\u0016\fG-\u001a:t\u0015!\u0001\u0018\r\u001e5J]\u001a|'\u0002\u0003)bi\"LeNZ8\u000b!\t,\u0018\u000e\u001c;J]^+'mU3sm\u0016\u0014(\u0002F2b]>t\u0017nY1m%\u0016\fX/Z:u!\u0006$\bNC\u0006xe&$X\rS3bI\u0016\u0014(\u0002\u0002;za\u0016Ta\u0001\\3oORD'\u0002D<sSR,\u0007*Z1eKJ\u001c(b\u0002:fcV,7\u000f\u001e\u0006\u0010\rVdG\u000e\u0013;uaJ+\u0017/^3ti*9\u0001.\u00198eY\u0016\u0014(\"B2pI\u0016\u001c'\u0002\u00025uiBTQb\u00197jK:$8\t[1o]\u0016d'bB\"iC:tW\r\u001c\u0006\bG\"\fgN\\3m\u0015Q9(/\u001b;f)>\u001cVM\u001d<fe\u000eC\u0017M\u001c8fY*91m\u001c8uK:$(B\u00044bgR\u001cu-[\"iC:tW\r\u001c\u0006\n\u0007>l\u0007/\u00198j_:$\u001eA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\u0005A1!B\u0002\u0005\u0006!\u0015A\u0002A\u0003\u0004\t\u000bAI\u0001\u0004\u0001\u0006\u0003!\rQA\u0001\u0003\u0005\u0011\u0019)!\u0001\"\u0003\t\u000e\u0015\u0019A!\u0002E\u0006\u0019\u0001)!\u0001B\u0003\t\f\u0015\u0019A!\u0002\u0005\b\u0019\u0001)!\u0001B\u0003\t\u000f\u0015\u0019AQ\u0001\u0005\n\u0019\u0001)1\u0001\"\u0002\t\u00151\u0001Qa\u0001C\u0003\u0011+a\u0001!B\u0001\t\u0017\u0015\u0011A!\u0003E\f\u000b\t!\u0019\u0002C\u0005\u0006\u0005\u0011M\u0001BC\u0003\u0003\t\u0003AY\"B\u0002\u0005\u0017!iA\u0002A\u0003\u0003\t-AQ\"\u0002\u0002\u0005\n!\rRA\u0001C\r\u0011I)!\u0001B\u0007\t&\u0015\u0019A1\u0004\u0005\u0012\u0019\u0001)!\u0001\"\u0003\t)\u0015\u0019AQ\u0004E\u0014\u0019\u0001)!\u0001b\u0007\t#\u0015\u0011AQ\u0004E\u0014\t\ra!\u0001\u0005\f\u001a\u0007\u0015\t\u0001b\u0001\r\u0004;\u00031R&\u0004\u0003B\u001aa5\u0011\u0005B\u0003\u0002\u0011\u001ba\t\u0001'\u0004V\u0007\u0011)1\u0001\"\u0004\n\u0003!9Q\u0006\u0005\u0003d\ta!\u0011eA\u0003\u0002\u0011\u000fA:!V\u0002\t\u000b\r!A!C\u0001\u0005\u00065\u0019AqB\u0005\u0002\t\u000bi\u000b\u0005B\u0002\u0019\u0011u=A\u0001\u0001E\t\u001b\r)\u0011\u0001c\u0004\u0019\u0010A\u001b\u0001!(\u0005\u0005\u0001!MQ\u0002B\u0003\u0002\u0011!a\t\u0001\u0007\u0005Q\u0007\u0003\t3!B\u0001\t\u0012aE\u0011kA\u0004\u0005\u0011%\tA\u0001A\u0007\u0002\u0011)i\u0011\u0001#\u0006.@\u0011\u0019\u0001\u0004DO\b\t\u0001AI\"D\u0002\u0006\u0003!]\u0001t\u0003)\u0004\u0001u=A\u0001\u0001\u0005\u000f\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\t!I\u0002\u0006\u0003!E\u0001\u0014C)\u0004\u000f\u0011a\u0011\"\u0001\u0003\u0001\u001b\u0005AA\"D\u0001\t\u00165RC!\u0001M\u000f;\u001f!\u0001\u0001#\u0004\u000e\u0007\u0015\t\u0001R\u0002M\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u0011=i1!B\u0001\t\ba\u001d\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001rD\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0005\t3!B\u0001\t\u0012aE\u0011kA\u0005\u0005\u001e%\tA\u0001A\u0007\u0002\u0011\u001di\u0011\u0001\"\u0002\u000e\u0003\u0011\u0015Qv\b\u0003\u00041Aiz\u0001\u0002\u0001\t\"5\u0019Q!\u0001\u0005\u000f19\u00016\u0001AO\b\t\u0001A1#D\u0002\u0006\u0003!y\u0001d\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\t1#\t6a\u0002\u0003\u0011\u0013\u0005!\u0001!D\u0001\t 5\t\u0001\u0002EW!\t\rAJ#(\u0005\u0005\u0001!)R\u0002B\u0003\u0002\u0011\u001ba\t\u0001'\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t,5\u0019Q!\u0001\u0005\u00101=\u00016\u0011A\u0011\u0004\u000b\u0005A\t\u0002'\u0005R\u0007\u001d!I#C\u0001\u0005\u00015\t\u0001bB\u0007\u0002\u0011A)\u0014%\u0002\u0011\u0005G\u0004A:!h\u0004\u0005\u0001!!QbA\u0003\u0002\u0011\u000fA:\u0001U\u0002\u0001;\u001f!\u0001\u0001C\u0003\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u0005\u0011eA\u0003\u0002\u0011\tA\"!U\u0002\b\t\u000fI\u0011\u0001\u0002\u0001\u000e\u0003\u0011\u0015Q\"\u0001\u0005\u0007"})
public final class FastCgiRequest {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final int PARAMS = 4;
    private static final int BEGIN_REQUEST = 1;
    private static final int RESPONDER = 1;
    private static final int FCGI_KEEP_CONNECTION = 1;
    private static final int STDIN = 5;
    private static final int VERSION = 1;
    private ByteBuf buffer;
    private final int requestId;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(FastCgiRequest.class);
        Companion companion = Companion = new Companion(null);
        PARAMS = 4;
        BEGIN_REQUEST = 1;
        RESPONDER = 1;
        FCGI_KEEP_CONNECTION = 1;
        STDIN = 5;
        VERSION = 1;
    }

    public final void writeFileHeaders(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalRequestPath) {
        Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkParameterIsNotNull((Object)canonicalRequestPath, (String)"canonicalRequestPath");
        VirtualFile root = pathInfo.getRoot();
        this.addHeader("DOCUMENT_ROOT", root.getPath());
        this.addHeader("SCRIPT_FILENAME", pathInfo.getPath());
        this.addHeader("SCRIPT_NAME", canonicalRequestPath);
    }

    public final void addHeader(@NotNull String key, @Nullable CharSequence value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (value == null) {
            return;
        }
        int keyLength = key.length();
        int valLength = value.length();
        ByteBuf byteBuf = this.buffer;
        if (byteBuf == null) {
            Intrinsics.throwNpe();
        }
        this.writeHeader(byteBuf, FastCgiRequest.Companion.getPARAMS(), keyLength + valLength + (keyLength < 128 ? 1 : 4) + (valLength < 128 ? 1 : 4));
        if (keyLength < 128) {
            ByteBuf byteBuf2 = this.buffer;
            if (byteBuf2 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf2.writeByte(keyLength);
        } else {
            ByteBuf byteBuf3 = this.buffer;
            if (byteBuf3 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf3.writeByte(0x80 | keyLength >> 24);
            ByteBuf byteBuf4 = this.buffer;
            if (byteBuf4 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf4.writeByte(keyLength >> 16);
            ByteBuf byteBuf5 = this.buffer;
            if (byteBuf5 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf5.writeByte(keyLength >> 8);
            ByteBuf byteBuf6 = this.buffer;
            if (byteBuf6 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf6.writeByte(keyLength);
        }
        if (valLength < 128) {
            ByteBuf byteBuf7 = this.buffer;
            if (byteBuf7 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf7.writeByte(valLength);
        } else {
            ByteBuf byteBuf8 = this.buffer;
            if (byteBuf8 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf8.writeByte(0x80 | valLength >> 24);
            ByteBuf byteBuf9 = this.buffer;
            if (byteBuf9 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf9.writeByte(valLength >> 16);
            ByteBuf byteBuf10 = this.buffer;
            if (byteBuf10 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf10.writeByte(valLength >> 8);
            ByteBuf byteBuf11 = this.buffer;
            if (byteBuf11 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf11.writeByte(valLength);
        }
        ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)key);
        ByteBufUtilEx.writeUtf8(this.buffer, value);
    }

    public final void writeHeaders(@NotNull FullHttpRequest request, @NotNull Channel clientChannel) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)clientChannel, (String)"clientChannel");
        this.addHeader("REQUEST_URI", request.uri());
        this.addHeader("REQUEST_METHOD", request.method().name());
        SocketAddress socketAddress = clientChannel.remoteAddress();
        if (socketAddress == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress remote = (InetSocketAddress)socketAddress;
        this.addHeader("REMOTE_ADDR", remote.getAddress().getHostAddress());
        this.addHeader("REMOTE_PORT", Integer.toString(remote.getPort()));
        SocketAddress socketAddress2 = clientChannel.localAddress();
        if (socketAddress2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress local = (InetSocketAddress)socketAddress2;
        this.addHeader("SERVER_SOFTWARE", Responses.getServerHeaderValue());
        this.addHeader("SERVER_NAME", Responses.getServerHeaderValue());
        this.addHeader("SERVER_ADDR", local.getAddress().getHostAddress());
        this.addHeader("SERVER_PORT", Integer.toString(local.getPort()));
        this.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader("SERVER_PROTOCOL", request.protocolVersion().text());
        this.addHeader("CONTENT_TYPE", request.headers().getAsString((CharSequence)HttpHeaderNames.CONTENT_TYPE));
        this.addHeader("REDIRECT_STATUS", "200");
        String queryString = "";
        int queryIndex = KotlinPackage.indexOf$default((String)request.uri(), (char)'?', (int)0, (boolean)false, (int)6);
        if (queryIndex != -1) {
            queryString = KotlinPackage.substring((String)request.uri(), (int)(queryIndex + 1));
        }
        this.addHeader("QUERY_STRING", queryString);
        this.addHeader("CONTENT_LENGTH", String.valueOf(request.content().readableBytes()));
        Iterator iterator = KotlinPackage.iterator((Iterator)request.headers().iteratorAsString());
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)KotlinPackage.component1((Map.Entry)entry);
            String value = (String)KotlinPackage.component2((Map.Entry)entry);
            StringBuilder stringBuilder = new StringBuilder().append("HTTP_");
            String string = KotlinPackage.replace$default((String)key, (char)'-', (char)'_', (boolean)false, (int)4);
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
            this.addHeader(stringBuilder.append(KotlinPackage.toUpperCase((String)string, (Locale)locale)).toString(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToServerChannel(@Nullable ByteBuf content, @NotNull Channel fastCgiChannel) {
        block10: {
            Intrinsics.checkParameterIsNotNull((Object)fastCgiChannel, (String)"fastCgiChannel");
            if (fastCgiChannel.pipeline().first() == null) {
                throw (Throwable)new IllegalStateException("No handler in the pipeline");
            }
            boolean releaseContent = content != null;
            try {
                ByteBuf byteBuf = this.buffer;
                if (byteBuf == null) {
                    Intrinsics.throwNpe();
                }
                this.writeHeader(byteBuf, FastCgiRequest.Companion.getPARAMS(), 0);
                if (content != null) {
                    ByteBuf byteBuf2 = this.buffer;
                    if (byteBuf2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.writeHeader(byteBuf2, FastCgiRequest.Companion.getSTDIN(), content.readableBytes());
                }
                fastCgiChannel.write((Object)this.buffer);
                this.buffer = null;
                if (content != null) {
                    ByteBuf headerBuffer;
                    fastCgiChannel.write((Object)content);
                    releaseContent = false;
                    ByteBuf byteBuf3 = headerBuffer = fastCgiChannel.alloc().ioBuffer(FastCgiConstants.HEADER_LENGTH, FastCgiConstants.HEADER_LENGTH);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf3, (String)"headerBuffer");
                    this.writeHeader(byteBuf3, FastCgiRequest.Companion.getSTDIN(), 0);
                    fastCgiChannel.write((Object)headerBuffer);
                }
                if (!releaseContent) break block10;
                KotlinPackage.assert((content != null ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                if (releaseContent) {
                    KotlinPackage.assert((content != null ? 1 : 0) != 0);
                    ByteBuf byteBuf = content;
                    if (byteBuf == null) {
                        Intrinsics.throwNpe();
                    }
                    byteBuf.release();
                }
                throw throwable;
            }
            ByteBuf byteBuf = content;
            if (byteBuf == null) {
                Intrinsics.throwNpe();
            }
            byteBuf.release();
        }
        fastCgiChannel.flush();
    }

    private final void writeHeader(ByteBuf buffer, int type, int length) {
        buffer.writeByte(FastCgiRequest.Companion.getVERSION());
        buffer.writeByte(type);
        buffer.writeShort(this.requestId);
        buffer.writeShort(length);
        buffer.writeZero(2);
    }

    public final int getRequestId() {
        return this.requestId;
    }

    public FastCgiRequest(int requestId, @NotNull ByteBufAllocator allocator) {
        Intrinsics.checkParameterIsNotNull((Object)allocator, (String)"allocator");
        this.requestId = requestId;
        ByteBuf byteBuf = this.buffer = allocator.ioBuffer(4096);
        if (byteBuf == null) {
            Intrinsics.throwNpe();
        }
        this.writeHeader(byteBuf, FastCgiRequest.Companion.getBEGIN_REQUEST(), FastCgiConstants.HEADER_LENGTH);
        ByteBuf byteBuf2 = this.buffer;
        if (byteBuf2 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf2.writeShort(FastCgiRequest.Companion.getRESPONDER());
        ByteBuf byteBuf3 = this.buffer;
        if (byteBuf3 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf3.writeByte(FastCgiRequest.Companion.getFCGI_KEEP_CONNECTION());
        ByteBuf byteBuf4 = this.buffer;
        if (byteBuf4 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf4.writeZero(5);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"m\u0004)I1i\\7qC:LwN\u001c\u0006\u000f\r\u0006\u001cHoQ4j%\u0016\fX/Z:u\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT!![8\u000b\u000f\u0019\f7\u000f^\"hS*\u0019\u0011I\\=\u000b\r-|G\u000f\\5o\u00155\u0011UiR%O?J+\u0015+V#T)*\u0019\u0011J\u001c;\u000b!\u001d,GOQ#H\u0013:{&+R)V\u000bN#&\u0002\u0006$D\u000f&{6*R#Q?\u000e{eJT#D)&{eJC\fhKR45iR%`\u0017\u0016+\u0005kX\"P\u001d:+5\tV%P\u001d*1\u0001+\u0011*B\u001bNS\u0011bZ3u!\u0006\u0013\u0016)T*\u000b\u0013I+5\u000bU(O\t\u0016\u0013&\u0002D4fiJ+5\u000bU(O\t\u0016\u0013&\"B*U\t&s%\u0002C4fiN#F)\u0013(\u000b\u000fY+%kU%P\u001d*Qq-\u001a;W\u000bJ\u001b\u0016j\u0014(;\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)1\u0001b\u0001\t\u00021\u0001Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\b\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)1\u0001B\u0002\t\n1\u0001Aaq\u0001\r\u0006e\u0019Q!\u0001E\u00041\u000fi\u0013\u0003B1\u00151\u0011\t3!B\u0001\t\ta!QkA\u0005\u0006\t\u0011!\u0011\"\u0001C\u0003\u0019\u0003i1\u0001B\u0003\n\u0003\u0011\u0015Q&\u0005\u0003b)a-\u0011eA\u0003\u0002\u0011\u0011AB!V\u0002\n\u000b\u0011!Y!C\u0001\u0005\u00061\u0005Qb\u0001\u0003\u0007\u0013\u0005!)!L\t\u0005CRAj!I\u0002\u0006\u0003!!\u0001\u0004B+\u0004\u0013\u0015!AQB\u0005\u0002\t\u000ba\t!D\u0002\u0005\u000f%\tAQA\u0017\u0012\t\u0005$\u0002tB\u0011\u0004\u000b\u0005AA\u0001\u0007\u0003V\u0007%)A\u0001b\u0004\n\u0003\u0011\u0015A\u0012A\u0007\u0004\t!I\u0011\u0001\"\u0002.#\u0011\tG\u0003'\u0005\"\u0007\u0015\t\u0001\u0002\u0002\r\u0005+\u000eIQ\u0001\u0002C\t\u0013\u0005!)\u0001$\u0001\u000e\u0007\u0011I\u0011\"\u0001C\u0003[E!\u0011\r\u0006M\nC\r)\u0011\u0001\u0003\u0003\u0019\tU\u001b\u0011\"\u0002\u0003\u0005\u0014%\tAQ\u0001G\u0001\u001b\r!!\"C\u0001\u0005\u0006U\u0002\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final int getPARAMS() {
            return PARAMS;
        }

        private final int getBEGIN_REQUEST() {
            return BEGIN_REQUEST;
        }

        private final int getRESPONDER() {
            return RESPONDER;
        }

        private final int getFCGI_KEEP_CONNECTION() {
            return FCGI_KEEP_CONNECTION;
        }

        private final int getSTDIN() {
            return STDIN;
        }

        private final int getVERSION() {
            return VERSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

