/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader$WhenMappings;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MemberSignature;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureDeserializer;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.Flags;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ErrorReporter;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBinaryClassAnnotationAndConstantLoader<A, C, T>
implements AnnotationAndConstantLoader<A, C, T> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final MemoizedFunctionToNotNull<KotlinJvmBinaryClass, Storage<A, C>> storage;
    private final KotlinClassFinder kotlinClassFinder;
    private final ErrorReporter errorReporter;

    static {
        $kotlinClass = Reflection.createKotlinClass(AbstractBinaryClassAnnotationAndConstantLoader.class);
    }

    @Nullable
    protected abstract C loadConstant(@NotNull String var1, @NotNull Object var2);

    @Nullable
    protected abstract KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(@NotNull ClassId var1, @NotNull SourceElement var2, @NotNull List<A> var3);

    @NotNull
    protected abstract A loadTypeAnnotation(@NotNull ProtoBuf.Annotation var1, @NotNull NameResolver var2);

    private final KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotationIfNotSpecial(ClassId annotationClassId, SourceElement source, List<A> result) {
        if (JvmAnnotationNames.isSpecialAnnotation(annotationClassId, true)) {
            return null;
        }
        return this.loadAnnotation(annotationClassId, source, result);
    }

    @Override
    @NotNull
    public List<A> loadClassAnnotations(@NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver) {
        ClassId classId;
        Intrinsics.checkParameterIsNotNull(classProto, "classProto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        ClassId classId2 = classId = nameResolver.getClassId(classProto.getFqName());
        Intrinsics.checkExpressionValueIsNotNull(classId2, "classId");
        KotlinJvmBinaryClass kotlinClass = this.kotlinClassFinder.findKotlinClass(classId2);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading class annotations is not found: " + classId.asSingleFqName(), null);
            return KotlinPackage.listOf();
        }
        ArrayList result = new ArrayList(1);
        kotlinClass.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(this, result){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ AbstractBinaryClassAnnotationAndConstantLoader this$0;
            final /* synthetic */ ArrayList $result;

            static {
                $kotlinClass = Reflection.createKotlinClass(loadClassAnnotations.1.class);
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId, @NotNull SourceElement source) {
                Intrinsics.checkParameterIsNotNull(classId, "classId");
                Intrinsics.checkParameterIsNotNull(source, "source");
                return AbstractBinaryClassAnnotationAndConstantLoader.access$loadAnnotationIfNotSpecial$0(this.this$0, classId, source, this.$result);
            }

            public void visitEnd() {
            }
            {
                this.this$0 = $outer;
                this.$result = $captured_local_variable$1;
            }
        });
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<T> loadCallableAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind) {
        block7: {
            Object object;
            List<A> propertyAnnotations;
            block11: {
                block10: {
                    void $receiver;
                    MemberSignature sig;
                    MemberSignature fieldSignature;
                    block9: {
                        List<A> list;
                        block8: {
                            void $receiver2;
                            Intrinsics.checkParameterIsNotNull(container, "container");
                            Intrinsics.checkParameterIsNotNull(proto, "proto");
                            Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
                            Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
                            if (!Intrinsics.areEqual((Object)kind, (Object)AnnotatedCallableKind.PROPERTY)) break block7;
                            MemberSignature syntheticFunctionSignature = AbstractBinaryClassAnnotationAndConstantLoader.getPropertySignature$default(this, proto, nameResolver, false, true, 4);
                            fieldSignature = AbstractBinaryClassAnnotationAndConstantLoader.getPropertySignature$default(this, proto, nameResolver, true, false, 8);
                            list = syntheticFunctionSignature;
                            if (list == null) break block8;
                            MemberSignature memberSignature = list;
                            sig = (MemberSignature)$receiver2;
                            list = AbstractBinaryClassAnnotationAndConstantLoader.super.findClassAndLoadMemberAnnotations(container, proto, nameResolver, kind, sig, false);
                            if (list != null) break block9;
                        }
                        list = propertyAnnotations = KotlinPackage.listOf();
                    }
                    if ((object = fieldSignature) == null) break block10;
                    sig = object;
                    MemberSignature sig2 = (MemberSignature)$receiver;
                    object = AbstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations$default(this, container, proto, nameResolver, kind, sig2, false, 32);
                    if (object != null) break block11;
                }
                object = KotlinPackage.listOf();
            }
            Object fieldAnnotations = object;
            return this.loadPropertyAnnotations((List<? extends A>)propertyAnnotations, (List<? extends A>)fieldAnnotations);
        }
        MemberSignature memberSignature = this.getCallableSignature(proto, nameResolver, kind);
        if (memberSignature == null) {
            return KotlinPackage.listOf();
        }
        MemberSignature signature = memberSignature;
        return this.transformAnnotations(AbstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations$default(this, container, proto, nameResolver, kind, signature, false, 32));
    }

    @NotNull
    protected abstract List<T> loadPropertyAnnotations(@NotNull List<? extends A> var1, @NotNull List<? extends A> var2);

    @NotNull
    protected abstract List<T> transformAnnotations(@NotNull List<? extends A> var1);

    private final List<A> findClassAndLoadMemberAnnotations(ProtoContainer container, ProtoBuf.Callable proto, NameResolver nameResolver, AnnotatedCallableKind kind, MemberSignature signature, boolean seekForStaticFieldInOuter) {
        KotlinJvmBinaryClass kotlinClass = this.findClassWithAnnotationsAndInitializers(container, proto, nameResolver, kind, seekForStaticFieldInOuter);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading member annotations is not found: " + container.getFqName(nameResolver), null);
            return KotlinPackage.listOf();
        }
        List<Object> list = ((Storage)this.storage.invoke(kotlinClass)).getMemberAnnotations().get(signature);
        if (list == null) {
            list = KotlinPackage.listOf();
        }
        return list;
    }

    static /* synthetic */ List findClassAndLoadMemberAnnotations$default(AbstractBinaryClassAnnotationAndConstantLoader abstractBinaryClassAnnotationAndConstantLoader, ProtoContainer protoContainer, ProtoBuf.Callable callable, NameResolver nameResolver, AnnotatedCallableKind annotatedCallableKind, MemberSignature memberSignature, boolean bl, int n) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return abstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations(protoContainer, callable, nameResolver, annotatedCallableKind, memberSignature, bl);
    }

    @Override
    @NotNull
    public List<A> loadValueParameterAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.Callable callable, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind, @NotNull ProtoBuf.Callable.ValueParameter proto) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(callable, "callable");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        MemberSignature methodSignature = this.getCallableSignature(callable, nameResolver, kind);
        if (methodSignature != null && proto.hasExtension(JvmProtoBuf.index)) {
            MemberSignature paramSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(methodSignature, ((Number)proto.getExtension(JvmProtoBuf.index)).intValue());
            return AbstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations$default(this, container, callable, nameResolver, kind, paramSignature, false, 32);
        }
        return KotlinPackage.listOf();
    }

    @Override
    @NotNull
    public List<A> loadExtensionReceiverParameterAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.Callable callable, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(callable, "callable");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        if (!callable.hasReceiverType()) {
            return KotlinPackage.emptyList();
        }
        MemberSignature methodSignature = this.getCallableSignature(callable, nameResolver, kind);
        if (methodSignature != null) {
            MemberSignature paramSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(methodSignature, 0);
            return AbstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations$default(this, container, callable, nameResolver, kind, paramSignature, false, 32);
        }
        return KotlinPackage.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<A> loadTypeAnnotations(@NotNull ProtoBuf.Type type2, @NotNull NameResolver nameResolver) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Iterable $receiver2 = type2.getExtension(JvmProtoBuf.typeAnnotation);
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item;
            void var9_9 = destination;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull(v0, "it");
            A a = this.loadTypeAnnotation((ProtoBuf.Annotation)v0, nameResolver);
            var9_9.add(a);
        }
        return (List)destination;
    }

    @Override
    @Nullable
    public C loadPropertyConstant(@NotNull ProtoContainer container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        MemberSignature memberSignature = this.getCallableSignature(proto, nameResolver, AnnotatedCallableKind.PROPERTY);
        if (memberSignature == null) {
            return null;
        }
        MemberSignature signature = memberSignature;
        KotlinJvmBinaryClass kotlinClass = AbstractBinaryClassAnnotationAndConstantLoader.findClassWithAnnotationsAndInitializers$default(this, container, proto, nameResolver, AnnotatedCallableKind.PROPERTY, false, 16);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading property constant is not found: " + container.getFqName(nameResolver), null);
            return null;
        }
        return ((Storage)this.storage.invoke(kotlinClass)).getPropertyConstants().get(signature);
    }

    private final KotlinJvmBinaryClass findClassWithAnnotationsAndInitializers(ProtoContainer container, ProtoBuf.Callable proto, NameResolver nameResolver, AnnotatedCallableKind annotatedCallableKind, boolean seekForStaticFieldInOuter) {
        FqName packageFqName = container.getPackageFqName();
        if (packageFqName != null) {
            return this.findPackagePartClass(packageFqName, proto, nameResolver);
        }
        ProtoBuf.Class clazz = container.getClassProto();
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        ProtoBuf.Class classProto = clazz;
        ProtoBuf.Class.Kind classKind = Flags.CLASS_KIND.get(classProto.getFlags());
        ClassId classId = nameResolver.getClassId(classProto.getFqName());
        if (Intrinsics.areEqual(classKind, ProtoBuf.Class.Kind.CLASS_OBJECT) && this.isStaticFieldInOuter(proto) && seekForStaticFieldInOuter) {
            ClassId classId2 = classId.getOuterClassId();
            Intrinsics.checkExpressionValueIsNotNull(classId2, "classId.getOuterClassId()");
            return this.kotlinClassFinder.findKotlinClass(classId2);
        }
        if (Intrinsics.areEqual(classKind, ProtoBuf.Class.Kind.TRAIT) && Intrinsics.areEqual((Object)annotatedCallableKind, (Object)AnnotatedCallableKind.PROPERTY)) {
            if (proto.hasExtension(JvmProtoBuf.implClassName)) {
                FqName parentPackageFqName = classId.getPackageFqName();
                Name tImplName = nameResolver.getName(((Number)proto.getExtension(JvmProtoBuf.implClassName)).intValue());
                return this.kotlinClassFinder.findKotlinClass(new ClassId(parentPackageFqName, tImplName));
            }
            return null;
        }
        ClassId classId3 = classId;
        Intrinsics.checkExpressionValueIsNotNull(classId3, "classId");
        return this.kotlinClassFinder.findKotlinClass(classId3);
    }

    static /* synthetic */ KotlinJvmBinaryClass findClassWithAnnotationsAndInitializers$default(AbstractBinaryClassAnnotationAndConstantLoader abstractBinaryClassAnnotationAndConstantLoader, ProtoContainer protoContainer, ProtoBuf.Callable callable, NameResolver nameResolver, AnnotatedCallableKind annotatedCallableKind, boolean bl, int n) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return abstractBinaryClassAnnotationAndConstantLoader.findClassWithAnnotationsAndInitializers(protoContainer, callable, nameResolver, annotatedCallableKind, bl);
    }

    private final KotlinJvmBinaryClass findPackagePartClass(FqName packageFqName, ProtoBuf.Callable proto, NameResolver nameResolver) {
        if (proto.hasExtension(JvmProtoBuf.implClassName)) {
            Name implClassName = nameResolver.getName(((Number)proto.getExtension(JvmProtoBuf.implClassName)).intValue());
            return this.kotlinClassFinder.findKotlinClass(new ClassId(packageFqName, implClassName));
        }
        return null;
    }

    private final boolean isStaticFieldInOuter(ProtoBuf.Callable proto) {
        if (!proto.hasExtension(JvmProtoBuf.propertySignature)) {
            return false;
        }
        JvmProtoBuf.JvmPropertySignature propertySignature = proto.getExtension(JvmProtoBuf.propertySignature);
        return propertySignature.hasField() && propertySignature.getField().getIsStaticInOuter();
    }

    private final Storage<A, C> loadAnnotationsAndInitializers(KotlinJvmBinaryClass kotlinClass) {
        HashMap memberAnnotations = new HashMap();
        HashMap propertyConstants = new HashMap();
        kotlinClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(this, memberAnnotations, propertyConstants){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ AbstractBinaryClassAnnotationAndConstantLoader this$0;
            final /* synthetic */ HashMap $memberAnnotations;
            final /* synthetic */ HashMap $propertyConstants;

            static {
                $kotlinClass = Reflection.createKotlinClass(loadAnnotationsAndInitializers.1.class);
            }

            @Nullable
            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(@NotNull Name name, @NotNull String desc) {
                Intrinsics.checkParameterIsNotNull(name, "name");
                Intrinsics.checkParameterIsNotNull(desc, "desc");
                return new loadAnnotationsAndInitializers.AnnotationVisitorForMethod(this, MemberSignature.Companion.fromMethodNameAndDesc(name.asString() + desc));
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationVisitor visitField(@NotNull Name name, @NotNull String desc, @Nullable Object initializer) {
                C constant;
                Intrinsics.checkParameterIsNotNull(name, "name");
                Intrinsics.checkParameterIsNotNull(desc, "desc");
                MemberSignature signature = MemberSignature.Companion.fromFieldNameAndDesc(name, desc);
                if (initializer != null && (constant = this.this$0.loadConstant(desc, initializer)) != null) {
                    KotlinPackage.set(this.$propertyConstants, signature, constant);
                }
                return new loadAnnotationsAndInitializers.MemberAnnotationVisitor(this, signature);
            }
            {
                this.this$0 = $outer;
                this.$memberAnnotations = $captured_local_variable$1;
                this.$propertyConstants = $captured_local_variable$2;
            }
        });
        return new Storage(memberAnnotations, propertyConstants);
    }

    private final MemberSignature getPropertySignature(ProtoBuf.Callable proto, NameResolver nameResolver, boolean field, boolean synthetic) {
        if (!proto.hasExtension(JvmProtoBuf.propertySignature)) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature propertySignature = proto.getExtension(JvmProtoBuf.propertySignature);
        SignatureDeserializer deserializer = new SignatureDeserializer(nameResolver);
        if (field && propertySignature.hasField()) {
            Name name;
            JvmProtoBuf.JvmFieldSignature field2 = propertySignature.getField();
            String type2 = deserializer.typeDescriptor(field2.getType());
            Name name2 = name = nameResolver.getName(field2.getName());
            Intrinsics.checkExpressionValueIsNotNull(name2, "name");
            String string = type2;
            Intrinsics.checkExpressionValueIsNotNull(string, "type");
            return MemberSignature.Companion.fromFieldNameAndDesc(name2, string);
        }
        if (synthetic && propertySignature.hasSyntheticMethod()) {
            return deserializer.methodSignature(propertySignature.getSyntheticMethod());
        }
        return null;
    }

    static /* synthetic */ MemberSignature getPropertySignature$default(AbstractBinaryClassAnnotationAndConstantLoader abstractBinaryClassAnnotationAndConstantLoader, ProtoBuf.Callable callable, NameResolver nameResolver, boolean bl, boolean bl2, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return abstractBinaryClassAnnotationAndConstantLoader.getPropertySignature(callable, nameResolver, bl, bl2);
    }

    private final MemberSignature getCallableSignature(ProtoBuf.Callable proto, NameResolver nameResolver, AnnotatedCallableKind kind) {
        SignatureDeserializer deserializer = new SignatureDeserializer(nameResolver);
        switch (AbstractBinaryClassAnnotationAndConstantLoader$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                if (!proto.hasExtension(JvmProtoBuf.methodSignature)) break;
                return deserializer.methodSignature(proto.getExtension(JvmProtoBuf.methodSignature));
            }
            case 2: {
                if (!proto.hasExtension(JvmProtoBuf.propertySignature)) break;
                return deserializer.methodSignature(proto.getExtension(JvmProtoBuf.propertySignature).getGetter());
            }
            case 3: {
                if (!proto.hasExtension(JvmProtoBuf.propertySignature)) break;
                return deserializer.methodSignature(proto.getExtension(JvmProtoBuf.propertySignature).getSetter());
            }
            case 4: {
                return this.getPropertySignature(proto, nameResolver, true, true);
            }
        }
        return null;
    }

    public AbstractBinaryClassAnnotationAndConstantLoader(@NotNull StorageManager storageManager, @NotNull KotlinClassFinder kotlinClassFinder, @NotNull ErrorReporter errorReporter) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(kotlinClassFinder, "kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull(errorReporter, "errorReporter");
        this.kotlinClassFinder = kotlinClassFinder;
        this.errorReporter = errorReporter;
        this.storage = storageManager.createMemoizedFunction(new Function1<KotlinJvmBinaryClass, Storage<A, C>>(this){
            final /* synthetic */ AbstractBinaryClassAnnotationAndConstantLoader this$0;

            @NotNull
            public final Storage<A, C> invoke(@NotNull KotlinJvmBinaryClass kotlinClass) {
                Intrinsics.checkParameterIsNotNull(kotlinClass, "kotlinClass");
                return AbstractBinaryClassAnnotationAndConstantLoader.access$loadAnnotationsAndInitializers$2(this.this$0, kotlinClass);
            }
            {
                this.this$0 = abstractBinaryClassAnnotationAndConstantLoader;
                super(1);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor access$loadAnnotationIfNotSpecial$0(AbstractBinaryClassAnnotationAndConstantLoader<A, C, T> $this, @NotNull ClassId annotationClassId, @NotNull SourceElement source, @NotNull List<A> result) {
        return super.loadAnnotationIfNotSpecial(annotationClassId, source, result);
    }

    @NotNull
    public static final /* synthetic */ Storage<A, C> access$loadAnnotationsAndInitializers$2(AbstractBinaryClassAnnotationAndConstantLoader<A, C, T> $this, @NotNull KotlinJvmBinaryClass kotlinClass) {
        return super.loadAnnotationsAndInitializers(kotlinClass);
    }

    private static final class Storage<A, C> {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Map<MemberSignature, ? extends List<? extends A>> memberAnnotations;
        @NotNull
        private final Map<MemberSignature, ? extends C> propertyConstants;

        static {
            $kotlinClass = Reflection.createKotlinClass(Storage.class);
        }

        @NotNull
        public final Map<MemberSignature, List<? extends A>> getMemberAnnotations() {
            return this.memberAnnotations;
        }

        @NotNull
        public final Map<MemberSignature, C> getPropertyConstants() {
            return this.propertyConstants;
        }

        public Storage(@NotNull Map<MemberSignature, ? extends List<? extends A>> memberAnnotations, @NotNull Map<MemberSignature, ? extends C> propertyConstants) {
            Intrinsics.checkParameterIsNotNull(memberAnnotations, "memberAnnotations");
            Intrinsics.checkParameterIsNotNull(propertyConstants, "propertyConstants");
            this.memberAnnotations = memberAnnotations;
            this.propertyConstants = propertyConstants;
        }
    }
}

