/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.jps.build.JpsJsModuleUtils;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilderModuleScriptGenerator;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"3\u0006)\u0001\"\n]:Kg6{G-\u001e7f+RLGn\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*\u0019!\u000e]:\u000b\u000b\t,\u0018\u000e\u001c3\u000b\u0007\u0005s\u0017P\u0003\u0010hKR$U\r]3oI\u0016t7-_'pIVdWm]!oIN{WO]2fg*1A/\u0019:hKRT\u0011#T8ek2,')^5mIR\u000b'oZ3u\u0015-Ign\u0019:f[\u0016tG/\u00197\u000b\rI,7/\u001e7u\u0015-iU\u000f^1cY\u0016d\u0015n\u001d;\u000b\rM#(/\u001b8h\u0015\u0011)f.\u001b;\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\u0003MSN$(bD4fi2K'M]1ss\u001aKG.Z:\u000b=\u001d,G\u000fT5ce\u0006\u0014\u0018PR5mKN\fe\u000e\u001a#fa\u0016tG-\u001a8dS\u0016\u001c(\"D4fi>+H\u000f];u\r&dWMC\u0005pkR\u0004X\u000f\u001e#je*!a)\u001b7f\u0015\tIwN\u0003\u0006n_\u0012,H.\u001a(b[\u0016TA\u0001\\1oO*\tr-\u001a;PkR\u0004X\u000f^'fi\u00064\u0015\u000e\\3\u001b\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0002\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!A\u0001C\u0003\u0006\u0007\u0011%\u0001\u0012\u0002\u0007\u0001\u000b\r!1\u0001\u0003\u0004\r\u0001\u0015\u0019Aa\u0001E\u0007\u0019\u0001)1\u0001B\u0002\t\u000f1\u0001QA\u0001C\u0005\u0011\u0013)\u0011\u0001c\u0004\u0006\u0005\u0011=\u0001\u0002C\u0003\u0003\t!A\t\"B\u0002\u0005\u0007!EA\u0002A\u0003\u0003\t\u001fA9\"B\u0002\u0005\u0014!YA\u0002A\u0003\u0003\t'A1\"\u0002\u0002\u0005\u0010!eQA\u0001\u0003\f\u0011\u001b!1-\u0001G\u00033\r)\u0011\u0001c\u0002\u0019\b5&Ca\u0001M\u0004;\u001f!\u0001\u0001\u0003\u0003\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0001Q\u0014\u0004\u0003\u0001\u0011\u0017i\u0001\"B\u0001\t\f%!\u0011bA\u0003\u0002\u0011\u0019Ab\u0001g\u0003Q\u0007\u0003\t3!B\u0001\t\u000ea5\u0011kA\u0004\u0005\b%\tA\u0001A\u0007\u0002\u0011\u001di\u0011\u0001#\u0005.J\u0011\u0019\u0001$CO\b\t\u0001AA!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001ueA\u0001\u0001E\u0006\u001b!)\u0011\u0001c\u0003\n\t%\u0019Q!\u0001\u0005\u00071\u0019AZ\u0001UB\u0001C\r)\u0011\u0001#\u0004\u0019\u000eE\u001bq\u0001B\u0005\n\u0003\u0011\u0001Q\"\u0001\u0005\b\u001b\u0005A\t\"\f\u000e\u0005\u0007aMQt\u0002\u0003\u0001\u0011\u0011i1!B\u0001\t\u000ba)\u0001k\u0001\u0001\"\u0011\u0015\t\u0001\"C\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0004\u0019\raI\u0011kA\u0003\u0005\u0014%\t\u0001\u0012C\u0007\u0002\u0011\u001di{\u0004b\u0002\u0019\u0015u=A\u0001\u0001E\u000b\u001b\r)\u0011\u0001\u0003\u0006\u0019\u0015A\u001b\u0001!h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011\u0019Ab\u0001UB\u0001C\r)\u0011\u0001\u0003\u0006\u0019\u0015E\u001bq\u0001\u0002\u0006\n\u0003!UQ\"\u0001E\u000b\u001b\u0005A9\"l\u0010\u0005\baiQt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u0015aQ\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002D\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0003\t3!B\u0001\t\u0015aQ\u0011kA\u0004\u0005\u001b%\t\u0001RC\u0007\u0002\u0011+i\u0011\u0001c\u00066\u0001\u0001"})
public final class JpsJsModuleUtils {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final JpsJsModuleUtils INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(JpsJsModuleUtils.class);
        new JpsJsModuleUtils();
    }

    @NotNull
    public final List<String> getLibraryFilesAndDependencies(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        ArrayList result = new ArrayList();
        this.getLibraryFiles(target, result);
        this.getDependencyModulesAndSources(target, result);
        return result;
    }

    public final void getLibraryFiles(@NotNull ModuleBuildTarget target, @NotNull List<String> result) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        Set libraries = JpsUtils.getAllDependencies(target).getLibraries();
        for (JpsLibrary library : libraries) {
            for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                String path = JpsPathUtil.urlToPath((String)root.getUrl());
                if (KotlinPackage.startsWith$default((String)path, (String)(KotlinJavascriptMetadataUtils.INSTANCE$.getVFS_PROTOCOL() + "://"), (boolean)false, (int)2)) continue;
                String string = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                result.add(string);
            }
        }
    }

    public final void getDependencyModulesAndSources(@NotNull ModuleBuildTarget target, @NotNull List<String> result) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        JpsUtils.getAllDependencies(target).processModules((Consumer)new Consumer<JpsModule>(target, result){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ ModuleBuildTarget $target;
            final /* synthetic */ List $result;

            static {
                $kotlinClass = Reflection.createKotlinClass(getDependencyModulesAndSources.1.class);
            }

            public void consume(@NotNull JpsModule module) {
                File outputDir;
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                if (Intrinsics.areEqual((Object)module, (Object)this.$target.getModule()) || Intrinsics.areEqual((Object)module.getModuleType(), (Object)JpsJavaModuleType.INSTANCE) ^ true) {
                    return;
                }
                ModuleBuildTarget moduleBuildTarget = new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION);
                File file = outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(moduleBuildTarget);
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
                String string = module.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.getName()");
                File metaInfoFile = JpsJsModuleUtils.getOutputMetaFile(file, string);
                String string2 = metaInfoFile.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"metaInfoFile.getAbsolutePath()");
                this.$result.add(string2);
            }
            {
                this.$target = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }
        });
    }

    @platformStatic
    @NotNull
    public static final File getOutputFile(@NotNull File outputDir, @NotNull String moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        return new File(outputDir, moduleName + KotlinJavascriptMetadataUtils.INSTANCE$.getJS_EXT());
    }

    @platformStatic
    @NotNull
    public static final File getOutputMetaFile(@NotNull File outputDir, @NotNull String moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        return new File(outputDir, moduleName + KotlinJavascriptMetadataUtils.INSTANCE$.getMETA_JS_SUFFIX());
    }

    JpsJsModuleUtils() {
        INSTANCE$ = this;
    }
}

